/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.5 $ $Date: 1997/10/13 11:39:58 $
*/

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <Xm/XmAll.h>

#include "opttick.h"
#include "server.h"
#include "status.h"

/* Globals */
static SERVER_STRUCT **serv_data;
static int serv_num = 0;
static int serv_cur;
static int serv_cur_type;

#if 0
static QUERY_STRUCT *news_data;
#endif

static char *proxy_serv;
static int proxy_port;

/*
** Proxy management
*/
void setProxy (char *where, char *port)
{
  if (proxy_serv)
    XtFree(proxy_serv);

  if (where)
    proxy_serv = XtNewString (where);
  else
    proxy_serv = NULL;
  proxy_port = strtol (port, NULL, 10);
}

void getProxy (char **where, int *port)
{
  *where = proxy_serv;
  *port = proxy_port;
}

/*
** Quote server management
*/

/* How many servers in database */
int numServer()
{
  return (serv_num);
}

/* Which server are we using */
void setCurServer (int which)
{
  serv_cur = which;
}

int getCurServer ()
{
  return (serv_cur);
}

/* Which server type are we using */
void setServerType (int which)
{
  if (which >= 0 && which < serv_data[serv_cur]->num_types)
    serv_cur_type = which;
}

char *getServerTitle (int which)
{
  if (which >=0 && which < serv_num)
    return (serv_data[which]->title);
  else
    return (NULL);
}

/* How many servers in database */
int numServerType()
{
  return (serv_data[serv_cur]->num_types);
}

/* Get a server characteristic */
char *getServer (int what)
{
  if (what >= 0 && what < NUM_QUERY_VALUES )
    return (serv_data[serv_cur]->types[serv_cur_type]->values[what]);
  else
    return (NULL);
}

#define SERV_TYPES (serv_data[serv_num-1]->types)
#define SERV_NUM_TYPES (serv_data[serv_num-1]->num_types)
#define SERV_CUR_TYPE (serv_data[serv_num-1]->types[SERV_NUM_TYPES-1])

/* Read all there is to know of servers from X resources */
int readServerDatabase( Widget Toplevel, char *appname)
{
  XrmDatabase	db = XtScreenDatabase(XtScreenOfObject(Toplevel));
  XrmQuark      class[6], name[6];
  XrmValue      value;
  XrmRepresentation type;

  /* Don't constrain these arrays and toupper seg faults in Linux
     static binary (but not the dynamic mind you) gcc 2.7.2 libc 5.2.18 */

#if 0
  char *npropnames[] = { "url", "headlines" };
#endif
  /* propnames must match order in server.h and names in Xquote.ad */
  char spropnames[2][6] = { "title", "type" };
  char qpropnames[16][7] = { "title", "url", "price", "change", "volume", 
	                     "dailyl", "dailyh", "exdiv", "52l", "52h", "pe",
			     "div", "yield", "date", "time", "name" };

  char *servers, *nextserver;
  char *types, *typeend, *nexttype, *nextend;
  int field;

  class[0] = XrmStringToQuark("Xquote");
  class[1] = XrmStringToQuark("ServerList");
  class[2] = NULLQUARK;

  name[0] = XrmStringToQuark(appname);
  name[1] = XrmStringToQuark("serverList");
  name[2] = NULLQUARK;

  /*
  ** Data server(s)
  */

  /* Get the list of servers */
  XrmQGetResource ( db, name, class, &type, &value);
  servers = XtNewString (value.addr);

  /* Set up for resource fetch */
  class[1] = XrmStringToQuark("Server");
  name[1] = XrmStringToQuark("server");
  /* when fetching query strings, these are the end */
  class[5] = NULLQUARK;
  name[5] = NULLQUARK;

  nextserver = strtok( servers, ",");
  while (nextserver) {

    /* Add new server structure */
    serv_num++;
    serv_data = (SERVER_STRUCT **) XtRealloc ( (char *)serv_data, serv_num *
		                            sizeof(SERVER_STRUCT *) );
    serv_data[serv_num-1] = (SERVER_STRUCT *) 
	                    XtCalloc ( 1, sizeof(SERVER_STRUCT) );

    name[2] = XrmStringToQuark (nextserver);
    nextserver[0] = toupper ( nextserver[0] );
    class[2] = XrmStringToQuark (nextserver);
    class[4] = NULLQUARK;
    name[4] = NULLQUARK;

    /* Option menu title */
    field = 0;
    spropnames[field][0] = toupper ( spropnames[field][0] );
    class[3] = XrmStringToQuark (spropnames[field]);
    spropnames[field][0] = tolower ( spropnames[field][0] );
    name[3] = XrmStringToQuark (spropnames[field]);
    XrmQGetResource (db, name, class, &type, &value);

    serv_data[serv_num-1]->title = XtNewString (value.addr);
    serv_data[serv_num-1]->num_types = 0;
    serv_data[serv_num-1]->types = (QUERY_STRUCT **)NULL;

    /* How many types */
    field = 1;
    spropnames[field][0] = toupper ( spropnames[field][0] );
    class[3] = XrmStringToQuark (spropnames[field]);
    spropnames[field][0] = tolower ( spropnames[field][0] );
    name[3] = XrmStringToQuark (spropnames[field]);
    XrmQGetResource (db, name, class, &type, &value);

    types = XtNewString (value.addr);
    typeend = types + strlen(types);

    /* First type */
    nexttype = types;
    nextend = strchr (nexttype, ',');
    if (nextend)
      *nextend = '\0';

    while (nexttype) {

      name[3] = XrmStringToQuark (nexttype);
      nexttype[0] = toupper ( nexttype[0] );
      class[3] = XrmStringToQuark (nexttype);
      serv_data[serv_num-1]->num_types++;

      /* Add new type to server */
      SERV_TYPES = (QUERY_STRUCT **) XtRealloc ( (char *)SERV_TYPES,
                   SERV_NUM_TYPES * sizeof(QUERY_STRUCT *) );
      SERV_CUR_TYPE = (QUERY_STRUCT *) XtCalloc ( 1, sizeof (QUERY_STRUCT));

      /* Fill in server fields */
      for (field = 0; field < NUM_QUERY_VALUES; field++) {
        qpropnames[field][0] = toupper ( qpropnames[field][0] );
        class[4] = XrmStringToQuark (qpropnames[field]);
        qpropnames[field][0] = tolower ( qpropnames[field][0] );
        name[4] = XrmStringToQuark (qpropnames[field]);
        XrmQGetResource (db, name, class, &type, &value);

        serv_data[serv_num-1]->types[SERV_NUM_TYPES-1]->values[field] = 
		XtNewString (value.addr);
      }

      nexttype = nextend +1; 
      if (nexttype <= types || nexttype >= typeend)
	break;

      nextend = strchr (nexttype, ',');
      if (nextend)
        *nextend = '\0';
      else
        nextend = nexttype + strlen(nexttype);
    }

    XtFree (types);
    nextserver = strtok (NULL, ",");
  }
  XtFree (servers);

#if 0
  /* 
  ** News server 
  */
  news_data = (QUERY_STRUCT *) XtCalloc ( 1, sizeof(QUERY_STRUCT) );

  class[1] = XrmStringToQuark("News");
  class[2] = NULLQUARK;
  name[1] = XrmStringToQuark("news");
  name[2] = NULLQUARK;

  field = 0;
  npropnames[field][0] = toupper ( npropnames[field][0] );
  class[3] = XrmStringToQuark( npropnames[field] );
  npropnames[field][0] = tolower ( npropnames[field][0] );
  name[3] = XrmStringToQuark( npropnames[field] );

  XrmQGetResource (db, name, class, &type, &value);
  news_data->values[URL] = XtNewString (value.addr);

  field = 1;
  npropnames[field][0] = toupper ( npropnames[field][0] );
  class[3] = XrmStringToQuark( npropnames[field] );
  npropnames[field][0] = tolower ( npropnames[field][0] );
  name[3] = XrmStringToQuark( npropnames[field] );

  XrmQGetResource (db, name, class, &type, &value);
  news_data->values[PRICE] = XtNewString (value.addr);
#endif

  return (serv_num);
}

/* ARGSUSED */
void serverCB (Widget w, XtPointer menu_pos, XtPointer call_data)
{
  int server = (int)menu_pos;

  if ( serv_cur != server && tickGetNum() ) {
    strcpy (errmsg, 
            "Network server changed with ticker symbols present.\n"
            "Unless server type names and order are identical\n"
            "you must remove and add the ticker symbols again.");
    write_status (errmsg, WARN);
  }
             
  setCurServer( server );
  tickMakeTypeMenu();
}
