/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.3 $ $Date: 1997/10/18 13:38:25 $
*/

#include <stdlib.h>
#include <string.h>

#include <Xm/XmAll.h>

#include "opttick.h"
#include "pixmap.h"
#include "server.h"
#include "status.h"
#include "tape.h"
#include "xquote.h"
#include "xutil.h"

/* Externs */
extern Widget Toplevel;

/* Globals */
static Widget checkbox;  /* toggles of current state */
static int state = 0;    /* state of detail toggle buttons */

/*
** Detail option support
*/

/* Set which detail variables are selected. */
void detailSetState( int which )
{
  WidgetList children;
  int numChild = 0;
  int i;

  if (checkbox)
    XtVaGetValues ( checkbox, XmNchildren, &children,
  		              XmNnumChildren, &numChild,
  		    NULL);
  for (i=0; i < numChild; i++)
    XmToggleButtonSetState ( children[i], 
		             (which & (1 << i))?XmSET:XmUNSET, 
			     False);
  state = which;
}

/* Non-zero if state variable 'which' is selected, otherwise entire state. */
int detailGetState( int which )
{
  if (which == -1)
    return (state);
  else
    return (state & (1 << which));
}

/* Change main window detail values to match net data */
void detailUpdateMainWindow ()
{
  extern Widget Container, Scroll;
  Widget NewContainer;

  Widget Item, Pix;
  char name[12];
  XmString TickString;
  XmString details[NUM_QUERY_VALUES];
  int num_details = 0;
  Pixmap pixmap;

  int i, j, count;

  if (!Container)
    return;

  AllowShellResize (Toplevel, ALLOW);

  NewContainer = XtVaCreateWidget ("Container", xmRowColumnWidgetClass, 
                                   Scroll, NULL );
  XtVaSetValues (Scroll, XmNworkWindow, NewContainer, NULL);

  if ( (count = tickGetNum()) )
    XtVaSetValues ( NewContainer, XmNnumColumns, count, NULL);

  for (i=0; i < count; i++) {
    /*
    ** Fill in detail information.
    */
    QUERY_STRUCT *data;

    data = tickGetDetail(i);
    TickString = XmStringCreateLocalized ( tickGetName(i) );

    if (!data || data->values[CHANGE] == NULL)
      pixmap = GetPixmap( PERROR, NORMAL);
    else if (strchr (data->values[CHANGE], '-'))
      pixmap = GetPixmap( PDOWN, NORMAL);
    else
      pixmap = GetPixmap( PUP, NORMAL);

    /* Loop over selected detail info filling it in */
    num_details = 0;
    for (j=PRICE; j < NUM_QUERY_VALUES; j++) {
      char tmp[13] = "N/A";

      if ( detailGetState(j-PRICE) ) {
        if (data && data->values[j]) {
	  if ( j == VOLUME || j == EXDIV || j == DATE || j == TIME || 
	       j == NAME )
	    sprintf ( tmp, "%-.12s", data->values[j]);
	  else
	    sprintf ( tmp, "%.12s", data->values[j]);
	}
  	details[num_details++] = XmStringCreateLocalized (tmp);
      }
    }

    /*
    ** Create an icon gadget.
    */
    sprintf( name, "form_%d", i);
    Item  = XtVaCreateWidget ( name, 
                               xmFormWidgetClass, NewContainer, 
                               XmNnavigationType, XmNONE,
                               NULL);

    /* Label showing up, down, or error */
    sprintf( name, "pix_%d", i);
    Pix = XtVaCreateManagedWidget ( name,
                         xmLabelWidgetClass, Item,
                         XmNlabelType,  XmPIXMAP,
                         XmNlabelPixmap, pixmap,
                         XmNtraversalOn, False,
                         XmNleftAttachment, XmATTACH_FORM,
                         XmNtopAttachment, XmATTACH_FORM,
                         XmNbottomAttachment, XmATTACH_FORM,
                         NULL);

    /* Label describing text info */
    sprintf( name, "label_%d", i);
    XtVaCreateManagedWidget ( name,
                         xmLabelWidgetClass, Item,
                         XmNlabelString, TickString,
                         XmNtraversalOn, False,
                         XmNleftAttachment, XmATTACH_WIDGET,
                         XmNleftWidget, Pix,
                         XmNtopAttachment, XmATTACH_FORM,
                         XmNbottomAttachment, XmATTACH_FORM,
                         NULL);
    XtManageChild (Item);
    XmStringFree (TickString);

    sprintf( name, "detail_%d", i);
    for (j = 0; j < num_details; j++) {
      XtVaCreateManagedWidget ( name,
                      xmLabelWidgetClass, NewContainer,
                      XmNtraversalOn, False,
                      XmNrecomputeSize, False, 
		      XmNlabelString, details[j],
		      NULL);
      XmStringFree ( details[j] );
    }
  }

  XtManageChild (NewContainer);
  XtUnmanageChild (Container);
  XtDestroyWidget (Container);
  Container = NewContainer;

  /*
  ** Align heading and container sizes
  */
  {
    extern Widget Heading;
    WidgetList children;
    Widget hchild, cchild, scrollbar;
    Dimension hwidth, cwidth, shadowWidth;

    if (num_details && count) {

      XtVaGetValues ( Container, XmNchildren, &children, NULL);
      cchild = children[0];
      XtVaGetValues ( cchild, XmNwidth, &cwidth, NULL);
      XtVaGetValues ( Heading, XmNchildren, &children, NULL);
      hchild = children[0];
      XtVaGetValues ( hchild, XmNwidth, &hwidth, NULL);

      if ( cwidth > hwidth )
        XtVaSetValues ( hchild, XmNwidth,cwidth, XmNrecomputeSize,False, NULL);
      else
        XtVaSetValues ( cchild, XmNwidth, hwidth, NULL);
    }

    /* No horizontal scrollbars */
    XtVaGetValues ( Container, XmNwidth, &cwidth, NULL);
    XtVaGetValues ( Scroll, 
                    XmNshadowThickness, &shadowWidth, 
                    XmNverticalScrollBar, &scrollbar,
                    NULL);
    cwidth += 2*shadowWidth;
    if ( XtIsManaged(scrollbar) ) {
      XtVaGetValues (Scroll, XmNspacing, &hwidth, NULL);
      cwidth += hwidth;
      XtVaGetValues (scrollbar, XmNwidth, &hwidth, NULL);
      cwidth += hwidth;
      XtVaGetValues (scrollbar, XmNhighlightThickness, &hwidth, NULL);
      cwidth += 2*hwidth;
    }
    XtVaSetValues ( Scroll, XmNwidth, cwidth, NULL);
  }
  AllowShellResize (Toplevel, DISALLOW);
}


void detailSetHeading ( XmStringTable headings, int num_headings )
{
  extern Widget Heading;
  WidgetList children;
  int numChildren;

  int i;

  if (!Heading)
    return;

  AllowShellResize (Toplevel, ALLOW);

  XtVaGetValues (Heading, XmNchildren, &children,
		          XmNnumChildren, &numChildren,
		 NULL);
  XtVaSetValues (Heading, XmNcolumns, num_headings, NULL);

  for (i=0; i < num_headings; i++) {
    /* Create or reuse an item. */
    if (numChildren == 0) {
      XtVaCreateManagedWidget ( "Detail",
          xmLabelWidgetClass, Heading,
	  XmNlabelString, headings[i],
          NULL);
    } else {
      XtVaSetValues ( children[i], XmNlabelString, headings[i], NULL);
      XtManageChild (children[i]);
      numChildren--;
    }
  }

  /* Kill off any extras */
  for (; numChildren > 0; numChildren--, i++)
    XtUnmanageChild (children[i]);

  AllowShellResize (Toplevel, DISALLOW);
}


/* Change main window detail list to match state */
void detailAddMainWindow ()
{
  extern Widget checkbox;
  WidgetList children;
  int numChild;

  XmStringTable headings;
  int num_headings = 0;
  int i;

  AllowShellResize (Toplevel, ALLOW);

  /*
  ** Get detail box labels
  */
  XtVaGetValues ( checkbox, XmNchildren, &children,
		            XmNnumChildren, &numChild,
		  NULL);
  headings = (XmStringTable) XtMalloc ( (numChild+1) * sizeof (XmString) );
  if (headings == (XmStringTable) NULL )
    write_status ("Could not allocate memory, detail list not changed.", ERR);

  headings[num_headings++] =  XmStringCreateLocalized ("Ticker");
  for (i=0; i < numChild; i++) {
    if ( state & (1<<i) )
      XtVaGetValues ( children[i], 
                      XmNlabelString, &(headings[num_headings++]),
                      NULL);
  }

  /*
  ** Apply them
  */
  if (num_headings)
    detailSetHeading ( headings, num_headings );
  XtFree ( (char *)headings);

  /*
  ** Update main window detail info
  */
  detailUpdateMainWindow ();

  AllowShellResize (Toplevel, ALLOW);
}


/* Remember or restore toggle button states */

/* ARGSUSED */
void procDetail (Widget w, int which, XtPointer call_data)
{
  int oldstate = state;

  int i, numchild;
  Widget parent;
  WidgetList children;

  XtVaGetValues ( w, XmNuserData, &parent, NULL);
  XtVaGetValues ( parent, 
                  XmNnumChildren, &numchild,
                  XmNchildren, &children, 
                  NULL);

  switch (which) {

    case 0: /* Ok */
            XtPopdown (GetTopShell(w));

            /* Save toggle settings */
            for (i = 0; i < numchild; i++) {
              if (XmToggleButtonGadgetGetState (children[i]))
                state |= (1<<i);
              else
                state &= ~(1<<i);
            }

            if (state != oldstate)
              detailAddMainWindow ();

            break;

    case 1: /* Cancel */
            XtPopdown (GetTopShell(w));

            /* Restore toggle settings */
            for (i = 0; i < numchild; i++) {
              if (state & (1<<i))
                XmToggleButtonGadgetSetState (children[i], XmSET, False);
              else
                XmToggleButtonGadgetSetState (children[i], XmUNSET, False);
            }
            break;

    default: break;
  }
}

/* Create the detail dialog, but don't manage it */
Widget createDetailDialog () 
{
  Widget dialog;
  char *buttons[] = { "button_0", "button_1"};
  char name[10];
  Widget form, pane, button;
  Dimension width, height, border;
  int num;

  dialog = XtVaCreatePopupShell( "OptionDetail",
                              xmDialogShellWidgetClass,
                              GetTopShell(Toplevel),
			      XmNmappedWhenManaged, False,
                              NULL );
  pane = XtVaCreateWidget ( "DetailPane", xmPanedWindowWidgetClass,
                              dialog,
                              XmNsashWidth, 1,
                              XmNsashHeight, 1,
                              NULL );
  checkbox = XmVaCreateSimpleCheckBox ( pane,"DetailCheckBox", NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
			      XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              XmVaCHECKBUTTON, NULL, NULL, NULL, NULL,
                              NULL );
  XtManageChild (checkbox);

  for (num = 0; num < 14; num++) {
    sprintf (name, "button_%d", num);
    if ( (state & (1 << num)) && (button = XtNameToWidget( checkbox, name )) )
      XmToggleButtonGadgetSetState ( button, True, False);
  }


  /* Buttons to add ok and cancel */
  form = XtVaCreateWidget ( "ButForm", xmFormWidgetClass, pane, NULL );
  for (num=0; num < XtNumber(buttons); num++) {
    button = XtVaCreateManagedWidget ( buttons[num],
                             xmPushButtonWidgetClass, form,
                              XmNtopAttachment, XmATTACH_FORM,
                              XmNbottomAttachment, XmATTACH_FORM,
                              XmNleftAttachment, XmATTACH_POSITION,
                              XmNrightAttachment, XmATTACH_POSITION,
                              XmNshowAsDefault, (num==0)?True:False,
                              XmNdefaultButtonShadowThickness, 1,
                              XmNuserData, checkbox,
                              NULL );
    XtAddCallback ( button, XmNactivateCallback,
                    (XtCallbackProc) procDetail, (XtPointer) num );
  }
  XtManageChild (form);
  XtManageChild (pane);

  /* Prevent pane from changing size */
  XtVaGetValues ( dialog,
                  XmNwidth, &width,
                  XmNheight, &height,
	          XmNborderWidth, &border,
                  NULL );

  XtVaSetValues ( dialog,
                  XmNminWidth,  width +  border,
                  XmNmaxWidth,  width +  border,
                  XmNminHeight, height + border,
                  XmNmaxHeight, height + border,
                  NULL );
 return (dialog);
}
