/*
 *   xmmix - Motif(tm) Audio Mixer
 *
 *   Copyright (C) 1994-1996  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __RESOURCE_H__
#define __RESOURCE_H__

#ifndef LINT
static char *_resource_h_ident_ = "@(#)resource.h	3.2 96/07/14";
#endif

#define XmcdNdevice			"device"
#define XmcdCDevice			"Device"
#define XmcdNdemoMode			"demoMode"
#define XmcdCDemoMode			"DemoMode"
#define XmcdNdebugMode			"debugMode"
#define XmcdCDebugMode			"DebugMode"
#define XmcdNhelpPath			"helpPath"
#define XmcdCHelpPath			"HelpPath"
#define XmcdNautoLoadOnStartUp		"autoLoadOnStartUp"
#define XmcdCAutoLoadOnStartUp		"AutoLoadOnStartUp"
#define XmcdNresetOnExit		"resetOnExit"
#define XmcdCResetOnExit		"ResetOnExit"


STATIC XtResource	resources[] = {
	{
		XmcdNdevice, XmcdCDevice,
		XmRString, sizeof(String),
		XtOffsetOf(appdata_t, device), XmRImmediate,
		(XtPointer) "/dev/mixer",
	},
	{
		XmcdNdemoMode, XmcdCDemoMode,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(appdata_t, demo), XmRImmediate,
		(XtPointer) False,
	},
	{
		XmcdNdebugMode, XmcdCDebugMode,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(appdata_t, debug), XmRImmediate,
		(XtPointer) False,
	},
	{
		XmcdNhelpPath, XmcdCHelpPath,
		XmRString, sizeof(String),
		XtOffsetOf(appdata_t, helppath), XmRImmediate,
		(XtPointer) "/usr/lib/X11/xmmix.hlp",
	},
	{
		XmcdNautoLoadOnStartUp, XmcdCAutoLoadOnStartUp,
		XmRString, sizeof(String),
		XtOffsetOf(appdata_t, autoload), XmRImmediate,
		(XtPointer) "",
	},
	{
		XmcdNresetOnExit, XmcdCResetOnExit,
		XmRBoolean, sizeof(Boolean),
		XtOffsetOf(appdata_t, exitreset), XmRImmediate,
		(XtPointer) False,
	},
};


STATIC XrmOptionDescRec	options[] = {
	{ "-dev",	"*device",	XrmoptionSepArg,	NULL   },
	{ "-demo",	"*demoMode",	XrmoptionNoArg,		"True" },
	{ "-debug",	"*debugMode",	XrmoptionNoArg,		"True" },
	{ "-autoload",	"*autoLoadOnStartUp", XrmoptionSepArg,	NULL   },
	{ "-exitreset",	"*resetOnExit",	XrmoptionNoArg,		"True" },
};


STATIC String		fallbacks[] = {
	"*menuBar*fontList: -*-helvetica-medium-r-*--12-120-*",
	"*helpForm*fontList: -*-helvetica-medium-r-*--12-120-*",
	"*fileSelectionBox*XmText*fontList: fixed",
	"*fileSelectionBox*XmTextField*fontList: fixed",
	"*fileSelectionBox*XmList*fontList: fixed",
	"*fileSelectionBox*fontList: -*-helvetica-medium-r-*--12-120-*",
	"*aboutDialog*fontList: -*-times-bold-i-*--24-240-*=chset1, -*-times-bold-i-*--12-120-*=chset2, -*-helvetica-medium-r-*--10-100-*=chset3, fixed",
	"*fontList: -*-helvetica-medium-r-*--10-100-*",
	"*XmToggleButton*highlightThickness: 1",
	"*highlightThickness: 1",
	"*defaultButtonShadowThickness: 0",
	"*borderWidth: 0",
	"*indicatorSize: 11",
	"*recomputeSize: True",
	"*defaultPosition: True",
	"*labelType: STRING",
	"*keyboardFocusPolicy: EXPLICIT",
	"*foreground: Black",
	"*background: White",
	NULL,
};

#endif	/* __RESOURCE_H__ */

