#!/bin/sh
#
# @(#)start.sh	6.6 00/01/14
# Startup wrapper script for xmcd, cda and related programs.
# This script is used to setup the basic startup environment,
# and allows network sharing of xmcd files under different
# platforms and architectures.
#
#    xmcd  - Motif(tm) CD Audio Player
#    cda   - Command-line CD Audio Player
#
#    Copyright (C) 1993-2000  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
PATH=${PATH}:/sbin:/usr/sbin:/bin:/usr/bin:/etc
export PATH

if [ -z "$XMCD_LIBDIR" ]
then
	XMCD_LIBDIR=/usr/lib/X11/xmcd
	export XMCD_LIBDIR
fi

XFILESEARCHPATH=$XMCD_LIBDIR/%T/%N%S:$XFILESEARCHPATH
XUSERFILESEARCHPATH=$HOME/.xmcdcfg/%N%S:$XUSERFILESEARCHPATH
XKEYSYMDB=$XMCD_LIBDIR/app-defaults/XKeysymDB

PROG=`(basename $0) 2>/dev/null`

SYS=`(uname -s) 2>/dev/null | sed -e 's/\//_/g' -e 's/-/_/g' -e 's/[ 	]/_/g'`
MACH=`(uname -m) 2>/dev/null | sed -e 's/\//_/g' -e 's/-/_/g' -e 's/[ 	]/_/g'`
REL=`(uname -r) 2>/dev/null | sed -e 's/\//_/g' -e 's/-/_/g' -e 's/[ 	]/_/g'`

# Platform-specific handling
if [ "$SYS" = FreeBSD ]
then
	# Differentiate between FreeBSD versions
	REL=`echo "$REL" | sed 's/\..*$//'`
	SYS=${SYS}_${REL}
elif [ "$SYS" = SunOS ]
then
	# Differentiate between SunOS 4.x and Solaris
	case "$REL" in
	4.*)
		;;
	5.*)
		SYS=Solaris
		;;
	*)
		SYS=Solaris
		;;
	esac
elif [ -x /bin/i386 -o -x /sbin/i386 ] && i386
then
	case "$REL" in
	3.2)
		# SCO UNIX/Open Desktop
		if (uname -X | fgrep "Release = 3.2") >/dev/null 2>&1
		then
			SYS=SCO_SV
		fi
		;;
	4.*)
		# UNIX SVR4.x
		SYS=${SYS}_${REL}
		;;
	5)
		# UNIX SVR5
		SYS=${SYS}_${REL}
		;;
	5.*)
		# UNIX SVR5.x
		SYS=${SYS}_${REL}
		;;
	*)
		;;
	esac
fi

export XFILESEARCHPATH XUSERFILESEARCHPATH XKEYSYMDB

exec $XMCD_LIBDIR/bin-${SYS}-${MACH}/$PROG ${1+"$@"}
