/*
 * xmail - X window system interface to the mail program
 *
 * Copyright 1990,1991,1992 by National Semiconductor Corporation
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of National Semiconductor Corporation not
 * be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * NATIONAL SEMICONDUCTOR CORPORATION MAKES NO REPRESENTATIONS ABOUT THE
 * SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS"
 * WITHOUT EXPRESS OR IMPLIED WARRANTY.  NATIONAL SEMICONDUCTOR CORPORATION
 * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO
 * EVENT SHALL NATIONAL SEMICONDUCTOR CORPORATION BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Michael C. Wagnitz - National Semiconductor Corporation
 *
 */


#include "defs.h"

/* HelpText.c */

extern String		Autograph_Info[];
extern String		Copy_Info[];
extern String		Default_Status_Info;
extern String		Delete_Info[];
extern String		Deliver_Info[];
extern String		Folder_Info[];
extern String		Hold_Info[];
extern String		NewMail_Info[];
extern String		Print_Info[];
extern String		Quit_Info[];
extern String		Read_Info[];
extern String		Reply_Info[];
extern String		Save_Info[];
extern String		Send_Info[];
extern String		SendMail_Info[];

extern String		Abort_Help;
extern String		Bcc_Help;
extern String		Cancel_Help;
extern String		Cc_Help;
extern String		Copy_Help;
extern String		Delete_Help;
extern String		Deliver_Help;
extern String		File_Help;
extern String		Folder_Help;
extern String		Hold_Help;
extern String		Index_Help;
extern String		NewMail_Help;
extern String		Print_Help;
extern String		Quit_Help;
extern String		Read_Help;
extern String		ReEdit_Help;
extern String		Reply_Help;
extern String		Save_Help;
extern String		Send_Help;
extern String		Sign_Help;
extern String		sign_Help;
extern String		Status_Help;
extern String		Subject_Help;
extern String		Text_Help;
extern String		Text2_Help;
extern String		Title_Help;
extern String		To_Help;

/* actions.c */

extern void		initfoldir(void);		/* initialize foldir value */
extern int		str_compare(char **s1, char **s2);		/* for qsort of folder names */
extern void	CheckInsert(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* for the file window */
extern void		EraseIt(Widget w, XawTextPosition i, XawTextPosition pos);		/* delete requested buf data */
extern void	DeleteChar(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* for deletes (file window) */
extern void	DeleteLine(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* in the file window */
extern void	DeleteWord(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* also in the file window */
extern void	DoCmd(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* effect specified command */
extern void	DoDone(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* complete message delivery */
extern void	DoNothing(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* dummy action routine */
extern void	DoReply(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* invoke reply callback */
extern void	DoSave(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* invoke the save callback */
extern void	DoSelected(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* DoCmd w/ selected message */
extern void	Folder(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* execute folder command */
extern void	Iconify(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* iconification request */
extern void	MyNotify(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* invokes callbacks w/ param */
extern void	NextField(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* warps pointer to data fld */
extern void	PrintMsg(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* send mail to the printer */
extern void	Quit(Widget w, XEvent *event, String *params, Cardinal *num_params);			/* termination procedure */
extern void	SetAliases(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* menu list of alias names */
extern void		SetNewness(Widget parent, char *path);		/* hilite folders w/ new data */
extern void	SetFolders(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* create a list of folders */
extern void	SetMenu(Widget parent, XEvent *event, String *params, Cardinal *num_params);		/* Position set_menu popup */
extern void	SetPopup(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* Position relative to owner */
extern void	SetSelect(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* reposition select mark */
extern void	ShowHelp(Widget w, XEvent *event, String *params, Cardinal *num_params);		/* Position help & popup text */

/* callbacks.c */

extern void		Autograph();		/* adds Signature to message */
#if defined(sun) || defined(SVR4)
extern void		endDelivery();		/* catch delivery completion */
#else
extern int		endDelivery();		/* catch delivery completion */
#endif

extern int		DoCopy();		/* folder copy mail delivery */
extern void	Done(Widget, XtPointer, XtPointer);		/* completes mail delivery */
extern void	DoIt(Widget, XtPointer, XtPointer);		/* callback do specified cmd */
extern void	DoPrint(Widget, XtPointer, XtPointer);		/* callback printer execution */
extern void	DoQuit(Widget, XtPointer, XtPointer);		/* callback termination func */
extern void	DoSet(Widget, XtPointer, XtPointer);		/* callback to toggle options */
extern void	DoWith(Widget, XtPointer, XtPointer);		/* do cmd with arguments */
extern void	DropIt(Widget, XtPointer, XtPointer);		/* destroy Folder popup list */
extern void	GetAliasName(Widget, Widget, XtPointer);	/* retrieve alias name */
extern void	GetFolderName(Widget, XtPointer, XtPointer);	/* retrieve folder name */
extern void	ReEdit(Widget, XtPointer, XtPointer);		/* re-edit the mail message */
extern void	Reply(Widget, XtPointer, XtPointer);		/* use msg author and subject */
extern void	Save(Widget, XtPointer, XtPointer);		/* callback save routine */
extern void	SetNewmail(Widget, XtPointer, XtPointer);	/* highlight when new mail */
extern void	UnsetNewmail(Widget, XtPointer, XtPointer);	/* remove newmail highlight */

/* callMail.c */

extern void		callMail();		/* fork child, exec mail */

/* confirm.c */

extern Bool		Confirm(char *prompt);		/* Confirm destructive acts */

/* directory.c */

extern void		SetDirectory();		/* create folder files list */

/* environs.c */

extern char		*GetMailEnv(String item);		/* get value from mail env */
extern char		*GetMailrc(char *item);		/* get mailrc item value */
extern char		*alias(char *name);		/* get mailrc alias value */

/* handler.c */

extern int 		In_System_Folder(void);	/* boolean test of folder */
extern void	        icon_handler(Widget w, XtPointer client_data, XEvent *event, Boolean *);		/* handle iconify changes */
extern int 		index_handler(int msg_num, int undeleting);	/* highlight the msg number */
extern void 		info_handler(Widget w, XtPointer client_data, XEvent *event, 
			Boolean *);		/* change content of status */
extern int 		file_handler(void);		/* handle change of folder */

/* mail.c */

extern void	warp_handler(Widget w, XtPointer client_data, XEvent *event, 
		             Boolean *);		/* warp cursor AFTER mapping */
extern char		*extract_of(char **p);		/* get header info from buf */
#if defined(sun) || defined(SVR4)
extern void 		endEdits();		/* catch exit of edit child */
#else
extern int 		endEdits(int signum);		/* catch exit of edit child */
#endif
extern void 		editMail(void);		/* create/compose a message */
extern void 		readMail(XtPointer client_data, int *source, XtInputId *id);		/* get data from mail pipe */
extern void		makeHeading(Widget parent, String label_string, Widget *left, Widget *above, String info, String help_text);		/* message header windows */
extern void		makeButton(Widget parent, String label, XtCallbackProc CBProc, String CBData, String info, String help_text);		/* message completion buttons */
extern void 		sendMail(Widget parent);		/* used by Send/Reply cmds */
extern void 		writeMail(char *s);		/* send data to mail pipe */

/* parser.c */

extern void		parser_init(void);		/* compile patterns */
extern int		match(PatternRecPtr patternTable, char *string);		/* eval command or output */
extern void		parse(String msg);		/* parse mail output */
extern char		*QueryMail(char *cmd);		/* ask mail for info */

/* utils.c */

extern void 		Bell(String msg);			/* disp. error and sound bell */
extern int		figureWidth(XFontStruct *font);		/* get figure width for font */
extern void 		markIndex(char *s);		/* add/replace index marker */
extern int 		SelectionNumber(int undeleting);	/* get number of selected msg */
extern void		SetCursor(int waiting);		/* change between wait & norm */
extern void 		SetXY(Widget target, Widget reference, int X_offset, int Y_offset);		/* set widget x/y coordinates */
extern XawTextPosition	TextGetLastPos(Widget w);	/* get last pos of text */
extern void		UpdateTitleBar(char *msg);	/* file name and msg count */
extern void 		writeText(char *buf);		/* write text to buffer */
extern void 		writeTo(Widget w, char *data, int do_append);		/* send text data to window */

/* windows.c */

extern void		AddHelpText(Widget parent, String text);		/* Add help popup to window */
extern void		AddMenuWindow(Widget parent, String action, menuList_p *list, String *info_text);	/* Add menu popup to window */
extern void		AddButton(Widget parent, String name, String action, String command, menuList_p *list, String *info_text, String help_text);		/* Add command to window */
extern void		CreateButtons(Widget parent);	/* make the command buttons */
extern void		CreateCommandPanel(Widget parent);	/* form for command buttons */
extern void		CreateFileWindow(Widget parent);	/* a text input window */
extern void		CreateFolderButton(Widget parent);	/* a special command button */
extern void		CreateHelpWindow(Widget parent);	/* the help window base */
extern void		CreateIndexWindow(Widget parent);	/* a text input window */
extern void		CreateStatusWindow(Widget parent);	/* a text output window */
extern void 		CreateSubWindows(Widget parent);	/* all subwindows of xmail */
extern void		CreateTextWindow(Widget parent);	/* another text window */
extern void		CreateTitleBar(Widget parent);	/* a text output window */
extern Widget		CreateInputWindow(Widget parent, String name);	/* To, Subject, Cc, and Bcc */
extern void		ParseIconGeometry(String str, Cardinal *x, Cardinal *y);	/* Parse icon geometry */

/* xmail.c */

extern void		initialize(void);		/* main initialization code */
extern int		mailoptions(void);		/* sets up call to mail pgm */

/* extern functions */

extern char	*strchr(const char *, int), *strrchr(const char *, int);

/* extern variables */

extern Atom	wmDeleteWindow;		/* for WM_DELETE_WINDOW property */
extern Boolean	In_Bogus_Mail_File;	/* in bogus folder when we're iconic */
extern Boolean	Waiting;		/* TRUE when we set the busy cursor */
extern Pixmap	hatch;			/* cross_weave, to indicate new mail */
extern Widget	toplevel; 		/* top level shell widget	*/
extern Window	WaitCursorWindow;

extern AliasRecPtr	*aliases;	/* array of mail alias strings	*/
extern helpText		*HelpList;
extern XmailResources	XMail;		/* XMail application resources */

extern int	mail_fd;		/* descriptor to mail process i/o */

extern int	mailargc;		/* counter passed to mail child	*/
extern int	RootWidth, RootHeight;
extern int	mailpid;		/* mail process id */
extern int	Highlighted;		/* state of 'Newmail' highlighting */
extern int	mailInputId;		/* Identity of the XtAddInput call */

extern char	HOME[BUFSIZ];		/* home directory of user       */
extern char	Command[BUFSIZ];	/* xmail command string		*/
extern char 	InReply[BUFSIZ];	/* reply reference string	*/
extern char 	tmpName[BUFSIZ];	/* message temporary filename	*/
extern char	otherBuf[BUFSIZ];	/* bucket for non-addressee names */
extern char	foldir[BUFSIZ];		/* name of the folder directory */
extern char 	lastFolder[BUFSIZ];	/* previous folder's title-bar	*/
extern char	*mailargv[8];		/* array passed to mail child	*/

/* global.h */
