/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#define util_file
#include "util.h"
#include "pixmaps.h"
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

#ifdef XPM
#include <X11/xpm.h>
#endif

/********************************************************************************
 * events abarbeiten
 ********************************************************************************/
void do_events(Widget top, XtAppContext app_c)
{
  XEvent event;
  XFlush(XtDisplay(top));
  while(XtAppPending(app_c)){
    XtAppNextEvent(app_c,&event);
    XtDispatchEvent(&event);
  }
}


void CreatePixmaps(Widget top, Pixmaps *pix)
{
  Pixel background;
  XtVaGetValues(top, XmNbackground , &background, NULL);
#ifdef XPM
  (void)XpmCreatePixmapFromData(XtDisplay(top),
                                RootWindowOfScreen(XtScreen(top)),
                                logo_xpm,
                                &((*pix).logo_pixmap),
                                NULL,NULL);
#else
  (*pix).logo_pixmap=
    XCreatePixmapFromBitmapData(XtDisplay(top),
				RootWindowOfScreen(XtScreen(top)),
				logo_bits,
				logo_width,
				logo_height,
				BlackPixelOfScreen(XtScreen(top)),
				WhitePixelOfScreen(XtScreen(top)),
				DefaultDepthOfScreen(XtScreen(top)));
#endif
  (*pix).save_pixmap=
    XCreatePixmapFromBitmapData(XtDisplay(top),
				RootWindowOfScreen(XtScreen(top)),
				save_bits,
				save_width,
				save_height,
				BlackPixelOfScreen(XtScreen(top)),
				background,
				DefaultDepthOfScreen(XtScreen(top)));
  (*pix).new_pixmap=
    XCreatePixmapFromBitmapData(XtDisplay(top),
				RootWindowOfScreen(XtScreen(top)),
				new_bits,
				new_width,
				new_height,
				BlackPixelOfScreen(XtScreen(top)),
				background,
				DefaultDepthOfScreen(XtScreen(top)));
  (*pix).delete_pixmap=
    XCreatePixmapFromBitmapData(XtDisplay(top),
				RootWindowOfScreen(XtScreen(top)),
				delete_bits,
				delete_width,
				delete_height,
				BlackPixelOfScreen(XtScreen(top)),
				background,
				DefaultDepthOfScreen(XtScreen(top)));
  (*pix).exit_pixmap=
    XCreatePixmapFromBitmapData(XtDisplay(top),
				RootWindowOfScreen(XtScreen(top)),
				exit_bits,
				exit_width,
				exit_height,
				BlackPixelOfScreen(XtScreen(top)),
				background,
				DefaultDepthOfScreen(XtScreen(top)));
  (*pix).question_pixmap=
    XCreatePixmapFromBitmapData(XtDisplay(top),
				RootWindowOfScreen(XtScreen(top)),
				question_bits,
				question_width,
				question_height,
				BlackPixelOfScreen(XtScreen(top)),
				background,
				DefaultDepthOfScreen(XtScreen(top)));
}

