/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#ifdef SCOPE
#undef SCOPE
#endif
#ifdef shadow_file
#define SCOPE 
#else
#define SCOPE extern
#endif
#ifndef shadow_h_included
#define shadow_h_included


#define NUM_SHADOWS 3       /* maximum number of shadows */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <Xm/Label.h>
#include <stdio.h>
#include <stdlib.h>

class shadow_t;

/********************************************************************************
 * class shadow_t  -  draws a shadow for any widget
 * each shadow consists of a popupshell with a label widget as drawing area
 * root-window background is copied into label and a grey stipple pixmap
 * is drawn over the backround image.
 * only a given number of shadows (NUM_SHADOWS) can occur on the screen the
 * same time.
 ********************************************************************************/

class shadow_t{
 public:
  shadow_t(Widget);
  ~shadow_t();

  void draw(Widget, int, int);   /* draws indexed shadow of widget with offset */
  void del(int);                 /* deletes indexed shadow from screen         */

 private:
  Widget    shadow_[NUM_SHADOWS];        /* popupshell for each shadow        */
  Widget    shadow_drw_[NUM_SHADOWS];    /* labelwidget in popupshell         */
  Widget    toplevel_;                   /* contains toplevel widget          */
  int       numflag_[NUM_SHADOWS];       /* shadow created already ?          */
  char      stipple_bits_[2];            /* xbitmap for stipple pixmap        */
  Pixmap    stipple_;                    /* stipple pixmap for shadow, grey50 */
  GC        gc_;                         /* gc for drawing shadow             */
  XGCValues val_;                        /* gcvalues for gc                   */
  int       flag_;                       /* indicates first call of shadow    */
};
  
SCOPE shadow_t *shadow;

#endif
