/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#include <time.h>
#include <malloc.h>


#ifdef SCOPE
#undef SCOPE
#endif
#ifdef adr_file
#define SCOPE
#undef  EXT
#else
#define SCOPE extern
#define EXT
#endif


#ifndef adr_h_included
#define adr_h_included

class address_t;
class dir_t;


/********************************************************************************
 * container class for all addresses
 ********************************************************************************/
class dir_t{
public:
  dir_t();                                 /* constructor                 */
  ~dir_t();                                /* destuctor                   */
  
  /* writing */
  void add_addr(address_t *);              /* add address                 */
  void add_addr(unsigned int, address_t *);/* add address                 */
  void add_addr(char *);                   /* add address                 */
  void add_addr(unsigned int, char *);     /* add address                 */
  void kill_addr(int *);                   /* delete address completely   */
  void kill_addr(address_t *);             /* delete address completely   */
  void load_addr(char *);                  /* load addresses from file    */
			    
  /* reading */
  address_t *addr(int)const;               /* get indexed address         */
  unsigned int num_addr(void)const;        /* number of addresses         */
  void save_addr(char *)const;             /* save addresses in file      */
  int search(char *, int index=-1)const;   /* search for string in all    */
  address_t *next(int *)const;             /* returns next address        */
  address_t *prev(int *)const;             /* returns prev address        */
  address_t *next(address_t *)const;       /* returns next address        */
  address_t *prev(address_t *)const;       /* returns prev address        */
  int changed(void)const;                  /* returns 1 if changed        */
  
private:
  address_t **addresses_;
  unsigned int num_addr_;                  /* number of addresses         */
  unsigned int max_addr_;                  /* number of allocated ptrs    */
};

/********************************************************************************
 * contains info for one address
 ********************************************************************************/
class address_t{
public:
  address_t();                             /* constructor                 */
  ~address_t();                            /* destructor                  */
  
  /* writing */
  void addr(char *);                       /* set address                 */
  void deleted(unsigned short);            /* set deleted-mark            */
  void changed(unsigned short);            /* set changed-mark            */
  
  /* reading */
  char *addr(void)const;                   /* get address                 */
  unsigned short deleted(void);            /* return deleted-status       */
  unsigned short changed(void);            /* return changed-status       */
  
private:
  char *data_;                             /* all address data            */
  time_t time_last_change_;                /* date of last change         */
  time_t time_created_;                    /* date of creation            */
  unsigned int  data_length_;              /* length of data              */
  unsigned int  key_start_;                /* start index of key  in data */
  unsigned int  key_end_;                  /* end index of key in data    */
  unsigned short deleted_;                 /* deleted-mark                */
  unsigned short changed_;
  dir_t *parent_;                          /* pointer to container        */
};


SCOPE dir_t book;                          /* address-book container      */

#endif
