#include "include.h"  
/*#include <time.h>*/

#include "var1.h"


static struct {
	XPoint pts [MAXCOULEURS][MAXPOINTS];
	int    nbre[MAXCOULEURS];
} points;


extern void initialiser_couleurs();  
extern void Entrer_taille();   
extern void init_fractal();
extern void initx();
extern void Entrer_taille_postcript();
extern int calcul2();
extern int calcul3();
extern void resize();
extern void calculBG();
extern void rafraichir();

static int compteur_postcript=0; /*Pour aller a la ligne */
static int compteur_postcript2=0;/* Pour les fins de lignes */
static int compteur2=0;
static int ligne_postcript=0;
static int tampon_postcript=0;
static int exposant_postcript=0;
static FILE *fichier; 
 
/*********************************************************************************************************/
int pow2(i)
int i;
{
int j,k=1;

for (j=0;j!=i;j++) 
	k*=2;
return(k);
}
	                  
/*********************************************************************************************************/
                   
void ecrire(chaine)   
char *chaine;     
{                  
int ecran;
                             
XSetForeground(XtDisplay(racine),gcontext,bpx2);      /* a modifier ? */
XFillRectangle(XtDisplay(racine),XtWindow(message),gcontext,0,0,MESSAGE_L,MESSAGE_H);
XFillRectangle(XtDisplay(racine),pix_message,gcontext,0,0,MESSAGE_L,MESSAGE_H);
/*XClearWindow(XtDisplay(racine),XtWindow(message));*/
/*XClearWindow(XtDisplay(racine),XtWindow(pixmap));*/
/*XSetForeground(XtDisplay(racine),gcontext,coul_for);*/
XSetForeground(XtDisplay(racine),gcontext,wpx2);
XDrawString(XtDisplay(racine),XtWindow(message),gcontext,10,18,chaine,strlen(chaine));
XDrawString(XtDisplay(racine),pix_message,gcontext,10,18,chaine,strlen(chaine));
}
 
/******************************************************************************************************************************/

void ecrire_bibli(nom)
char *nom;
{

int                     len;
FILE                    *fichierdisque;  
char			temp[4];
                                                
if ((fichierdisque = fopen("FractBibli","a"))==NULL)
{
   perror(CP[140]);
}

strcpy(toto,nom);                                      
len=strlen(toto);
strcpy(temp,toto[len-4]);
if (!strcmp(temp,".ppm")) toto[len-4]='/0'; 	
/*if (strcmp(temp,".gif")) 	
	strcat(toto,".gif");*/	/* Add .gif if missing */

fprintf(fichierdisque,"# Path and name of the associated GIF file (if exists)\n");
fprintf(fichierdisque,"NAME    :%s\n",toto);
fprintf(fichierdisque,"# Coordinates\n");
fprintf(fichierdisque,"LEFT    :");
fprintf(fichierdisque,FORMAT,z0.re);
fprintf(fichierdisque,"\nTOP     :");
fprintf(fichierdisque,FORMAT,z0.im);
fprintf(fichierdisque,"\nRIGHT   :");
fprintf(fichierdisque,FORMAT,z1.re);
fprintf(fichierdisque,"\nBOTTOM  :");
fprintf(fichierdisque,FORMAT,z1.im);
fprintf(fichierdisque,"\n");
fprintf(fichierdisque,"# Iterations\n");
fprintf(fichierdisque,"ITER    :%d\n",iter);
fprintf(fichierdisque,"# Image size\n");
fprintf(fichierdisque,"WIDTH   :%d\n",largeur);
fprintf(fichierdisque,"HEIGHT  :%d\n",hauteur);
fprintf(fichierdisque,"# Fractal type (see fractal_type.h)\n");
fprintf(fichierdisque,"TYPE    :%d\n",genre);
fprintf(fichierdisque,"# Display\n");
fprintf(fichierdisque,"DISPLAY :%d\n",type_dessin);
fprintf(fichierdisque,"# Bailout\n");
fprintf(fichierdisque,"BAILOUT :%.16e\n",bailout);
fprintf(fichierdisque,"# Complex parameter\n");
fprintf(fichierdisque,"C1.RE   :");
fprintf(fichierdisque,FORMAT,cz.re);
fprintf(fichierdisque,"\nC1.IM   :");
fprintf(fichierdisque,FORMAT,cz.im); 
fprintf(fichierdisque,"\n");
fprintf(fichierdisque,"# Integer parameter\n");
fprintf(fichierdisque,"N1      :%d\n",ip);  
fprintf(fichierdisque,"# Logarithmic palette on/off\n");
fprintf(fichierdisque,"LOGPAL  :%d\n",palettelog);  
fprintf(fichierdisque,"# Palette name\n");
fprintf(fichierdisque,"PALETTE :%s\n",nompalette);  
fprintf(fichierdisque,"\n\n");
                                   
fclose(fichierdisque); 
}             

/*********************************************************************************/

void sauvparam(nom)
char *nom;
{

int                    i,n,ncoul,r,g,b,num;
FILE                    *fichierdisque;  
char			nom_tab[30];     


if ((fichierdisque = fopen(nom,"a"))==NULL)
{
   perror(CP[140]);
}
                
fprintf(fichierdisque,"# Path and name of the associated GIF file (if exists)\n");
fprintf(fichierdisque,"NAME    :%s\n",nom);
fprintf(fichierdisque,"# Coordinates\n");
fprintf(fichierdisque,"LEFT    :");
fprintf(fichierdisque,FORMAT,z0.re);
fprintf(fichierdisque,"\nTOP     :");
fprintf(fichierdisque,FORMAT,z0.im);
fprintf(fichierdisque,"\nRIGHT   :");
fprintf(fichierdisque,FORMAT,z1.re);
fprintf(fichierdisque,"\nBOTTOM  :");
fprintf(fichierdisque,FORMAT,z1.im);
fprintf(fichierdisque,"\n");
fprintf(fichierdisque,"# Iterations\n");
fprintf(fichierdisque,"ITER    :%d\n",iter);
fprintf(fichierdisque,"# Image size\n");
fprintf(fichierdisque,"WIDTH   :%d\n",largeur);
fprintf(fichierdisque,"HEIGHT  :%d\n",hauteur);
fprintf(fichierdisque,"# Fractal type (see fractal_type.h)\n");
fprintf(fichierdisque,"TYPE    :%d\n",genre);
fprintf(fichierdisque,"# Display\n");
fprintf(fichierdisque,"DISPLAY :%d\n",type_dessin);
fprintf(fichierdisque,"# Bailout\n");
fprintf(fichierdisque,"BAILOUT :%.16e\n",bailout);
fprintf(fichierdisque,"# Complex parameter\n");
fprintf(fichierdisque,"C1.RE   :");
fprintf(fichierdisque,FORMAT,cz.re);
fprintf(fichierdisque,"\nC1.IM   :");
fprintf(fichierdisque,FORMAT,cz.im); 
fprintf(fichierdisque,"\n");
fprintf(fichierdisque,"# Integer parameter\n");
fprintf(fichierdisque,"N1      :%d\n",ip);  
fprintf(fichierdisque,"# Logarithmic palette on/off\n");
fprintf(fichierdisque,"LOGPAL  :%d\n",palettelog);  
fprintf(fichierdisque,"# Palette name\n");
fprintf(fichierdisque,"PALETTE :%s\n",nompalette);  
                                   
fclose(fichierdisque); 
}             


/*********************************************************************************/

/*void lire_bibli(nom,z0re,z0im,z1re,z1im,fiter,larg,haut,fgenre,ftype_dessin,bail,czre,czim,fip)
char *nom;
FLOAT_SIZE *z0re;
FLOAT_SIZE *z0im;
FLOAT_SIZE *z1re;
FLOAT_SIZE *z1im;
int *fiter;
int *larg;
int *haut;
int *fgenre;
int *ftype_dessin;
double *bail;
FLOAT_SIZE *czre;
FLOAT_SIZE *czim;
int *fip;*/



/*********************************************************************************/

int lire_bibli(nom)
char *nom;
{
int                     i,j;
FILE                    *fichierdisque;  
signed char		s[512];
int			len;
char			commande[9];
char			valeur[250];
int			temp;
int 			OK=FALSE;

pt_en_cours=0;
                                                
if ((fichierdisque = fopen("FractBibli","r"))==NULL)
{
   perror(CP[140]);
   exit(1);
} 

                                     
while (fgets(s,sizeof(s),fichierdisque))
	{
	if (s[0]=='#') continue;	/* commentaire */
	if (s[0]=='\n') continue;
	len=strlen(s);
	if (s[8]!=':')
		{
		printf(CP[188]);
		printf("\n%s\n",s);
		exit(1);
		}
	strncpy(commande,s,8);
	commande[8]='\0';
	for (i=9;i<len-1;i++)
		valeur[i-9]=s[i];
	valeur[len-10]='\0';	/* Permet de se debarasser du \n */
	if (!strcmp(commande,"NAME    "))
		{
		if (!strcmp(nom,valeur))
			{
			OK=TRUE;
			break;
			}
		else continue;
		}
}

if (!OK)
		{
		printf(CP[188]);
		return(FALSE);
		}

while (fgets(s,sizeof(s),fichierdisque))
	{
	if (s[0]=='#') continue;	/* commentaire */
	if (s[0]=='\n') continue;
	len=strlen(s);
	if (s[8]!=':')
		{
		printf(CP[188]);
		printf("\n%s\n",s);
		exit(1);
		}
	strncpy(commande,s,8);
	commande[8]='\0';
	for (i=9;i<=len;i++)
		valeur[i-9]=s[i];
	if (!strcmp(commande,"NAME    "))
		break;
	if (!strcmp(commande,"LEFT    "))
		sscanf(valeur,FORMAT_LECTURE,&z0.re);
	if (!strcmp(commande,"TOP     "))
		sscanf(valeur,FORMAT_LECTURE,&z0.im);
	if (!strcmp(commande,"RIGHT   "))
		sscanf(valeur,FORMAT_LECTURE,&z1.re);
	if (!strcmp(commande,"BOTTOM  "))
		sscanf(valeur,FORMAT_LECTURE,&z1.im);
	if (!strcmp(commande,"ITER    "))
		sscanf(valeur,"%d",&iter);
	if (!strcmp(commande,"WIDTH   "))
		sscanf(valeur,"%d",&largeur);
	if (!strcmp(commande,"HEIGHT  "))
		sscanf(valeur,"%d",&hauteur);
	if (!strcmp(commande,"TYPE    "))
		sscanf(valeur,"%d",&genre);
	if (!strcmp(commande,"DISPLAY "))
		sscanf(valeur,"%d",&type_dessin);
	if (!strcmp(commande,"BAILOUT "))
		sscanf(valeur,"%le",&bailout);
	if (!strcmp(commande,"C1.RE   "))
		sscanf(valeur,FORMAT_LECTURE,&cz.re);
	if (!strcmp(commande,"C1.IM   "))
		sscanf(valeur,FORMAT_LECTURE,&cz.im);
	if (!strcmp(commande,"N1      "))
		sscanf(valeur,"%d",&ip);
	if (!strcmp(commande,"LOGPAL  "))
		{
		sscanf(valeur,"%d",&temp);
		if (temp)
			palettelog=TRUE;
		else
			palettelog=FALSE;
		}
	if (!strcmp(commande,"PALETTE "))
		{
		sscanf(nompalette,"%d",valeur);
		ChargePalette();
		}
}

                                   
fclose(fichierdisque);
return(TRUE); 
}

/*********************************************************************************/

void load_param(nom)
char *nom;
{

int                     i,j;
FILE                    *fichierdisque;  
signed char		s[512];
int			len;
char			commande[9];
char			valeur[250];
int			temp;

if ((fichierdisque = fopen(nom,"r"))==NULL)
{
   perror(CP[140]);
}

while (fgets(s,sizeof(s),fichierdisque))
	{
	if (s[0]=='#') continue;	/* commentaire */
	if (s[0]=='\n') continue;
	len=strlen(s);
	if (s[8]!=':')
		{
		printf(CP[188]);
		printf("\n%s\n",s);
		exit(1);
		}
	strncpy(commande,s,8);
	commande[8]='\0';
	for (i=9;i<=len;i++)
		valeur[i-9]=s[i];
	if (!strcmp(commande,"LEFT    "))
		sscanf(valeur,FORMAT_LECTURE,&z0.re);
	if (!strcmp(commande,"TOP     "))
		sscanf(valeur,FORMAT_LECTURE,&z0.im);
	if (!strcmp(commande,"RIGHT   "))
		sscanf(valeur,FORMAT_LECTURE,&z1.re);
	if (!strcmp(commande,"BOTTOM  "))
		sscanf(valeur,FORMAT_LECTURE,&z1.im);
	if (!strcmp(commande,"ITER    "))
		sscanf(valeur,"%d",&iter);
	if (!strcmp(commande,"WIDTH   "))
		sscanf(valeur,"%d",&largeur);
	if (!strcmp(commande,"HEIGHT  "))
		sscanf(valeur,"%d",&hauteur);
	if (!strcmp(commande,"TYPE    "))
		sscanf(valeur,"%d",&genre);
	if (!strcmp(commande,"DISPLAY "))
		sscanf(valeur,"%d",&type_dessin);
	if (!strcmp(commande,"BAILOUT "))
		sscanf(valeur,"%le",&bailout);
	if (!strcmp(commande,"C1.RE   "))
		sscanf(valeur,FORMAT_LECTURE,&cz.re);
	if (!strcmp(commande,"C1.IM   "))
		sscanf(valeur,FORMAT_LECTURE,&cz.im);
	if (!strcmp(commande,"N1      "))
		sscanf(valeur,"%d",&ip);
	if (!strcmp(commande,"LOGPAL  "))
		{
		sscanf(valeur,"%d",&temp);
		if (temp)
			palettelog=TRUE;
		else
			palettelog=FALSE;
		}
	if (!strcmp(commande,"PALETTE "))
		{
		sscanf(valeur,"%d",nompalette);
		ChargePalette();
		}
}
                                  
fclose(fichierdisque); 
ecrire(CP[189]);
}


/*********************************************************************************/

void erreur_couleur()
{
printf("Erreur couleur\n");
}

/*********************************************************************************/

void definir_couleur(i)  
int i;
{                  
int j;

if (!palettelog) {
	couleur=i;
	for (j=i;j>=MAXCOULEURS;j-=MAXCOULEURS) {couleur-=MAXCOULEURS;}
	if (i==iter) couleur=bpx;  
}
else {        
	for (j=0;j<255;j++) {
		if ((i<palog[j+1])&&(i>=palog[j])) break;  }    
	couleur=j;
	if (i==iter) couleur=bpx;  
}
	
}

/*******************************************************************************************************************************/

static void save_ppm1()   /* sauvegarde de l'image au format PPM - initialisation */
{
	         
/*printf("%s\n",nomPPM);*/  
if ((fichier = fopen(nomPPM,"w"))==NULL)
		{
		perror(CP[170]);}   

fprintf(fichier,"P6\n");               
fprintf(fichier,"%d %d\n",largeur,hauteur);    
fprintf(fichier,"255\n");
}

/*******************************************************************************************************************************/

static void save_ppm2(i)
int i;		              /* sauvegarde PPM - point par point */


{
fprintf(fichier,"%c%c%c",rouge[i],vert[i],bleu[i]);   
} 



/**************************************************************************************/


static void save_postcript1()   /* sauvegarde de l'image au format Postcript - initialisation */
{
int larg,haut,paslarge=FALSE;
int var;


compteur_postcript=0;
compteur_postcript2=0;
tampon_postcript=0;
exposant_postcript=3;
largeur_postcript=largeur;
hauteur_postcript=hauteur;
if (largeur_postcript>=hauteur_postcript) 
	{larg=largeur_postcript;
	haut=hauteur_postcript;}
else { larg=hauteur_postcript;
	haut=largeur_postcript;}
	         
if ((double)larg>1.41*haut) paslarge=TRUE;

if ((fichier = fopen(nomPostcript,"w"))==NULL)
		{
		perror(CP[170]);}   

fprintf(fichier,"%%!PS-Adobe-2.0 EPSF-2.0\n");               
fprintf(fichier,"%%%%Title: /users/promo_95/guerin/im4.ps\n");               
fprintf(fichier,"%%%%Creator: XFractal_Explorer v1.1 - by N. GUERIN\n");               
fprintf(fichier,"%%%%BoundingBox: 3 57 592 793\n");               
fprintf(fichier,"%%%%Pages: 1\n");               
fprintf(fichier,"%%%%DocumentFonts:\n");               
fprintf(fichier,"%%%%EndComments\n");               
fprintf(fichier,"%%%%EndProlog\n\n");               
fprintf(fichier,"%%%%Page: 1 1\n\n");               
fprintf(fichier,"%% remember original state\n");               
fprintf(fichier,"/origstate save def\n\n");               
fprintf(fichier,"%% build a temporary dictionary\n");               
fprintf(fichier,"20 dict begin\n\n");               
fprintf(fichier,"%% define string to hold a scanline's worth of data\n"); 
if (type_postcript==NOIR) ligne_postcript=ceil(largeur/8.0);
if (type_postcript==GRIS) ligne_postcript=largeur;
fprintf(fichier,"/pix %d string def\n\n",ligne_postcript);             
fprintf(fichier,"%% print in landscape mode\n");               
fprintf(fichier,"90 rotate 0 -595 translate\n\n");               
fprintf(fichier,"%% lower left corner\n");               
if (paslarge) {
	fprintf(fichier,"12 %d translate\n\n",(int)(298-(412*haut)/larg));  }             
else 	{	
	fprintf(fichier,"%d 6 translate\n\n",(int)(425-290*larg/haut)); }
fprintf(fichier,"%% size of image (on paper, in 1/72inch coords)\n");               
if (paslarge)
	fprintf(fichier,"825.00000 %f scale\n\n",825.0*(double)haut/larg);   /*  3.7 /pixel ????*/           
else 	fprintf(fichier,"%f 580.00000 scale\n\n",580.0*(double)larg/haut);  
if (type_postcript==NOIR) var=1;
if (type_postcript==GRIS) var=8; 
fprintf(fichier,"%d %d %d			%% dimensions of data\n",larg,haut,var);               
fprintf(fichier,"[%d 0 0 -%d 0 %d]		%% mapping matrix\n",larg,haut,haut);               
fprintf(fichier,"{currentfile pix readhexstring pop}\n");               
fprintf(fichier,"image\n");             
}

/*******************************************************************************************************************************/

static void save_postcript2(val)
int val;		              /* appelee apres chaque point */

{
if (type_postcript==GRIS) {
	if (compteur_postcript>=72) {
		compteur_postcript=0;
		fprintf(fichier,"\n");
	}
	val=255-val;
	if (val<16) fprintf(fichier,"0%x",val); else fprintf(fichier,"%x",val);
	compteur_postcript+=2;
	}
if (type_postcript==NOIR) {
/*	if ((val!=0)&&(val!=1)) printf("erreur couleur!\n");*/
	compteur_postcript2++;
	tampon_postcript+=val*pow2(exposant_postcript);
/*	if (tampon_postcript>15) printf("erreur tampon!\n");*/
	exposant_postcript--;
	if (exposant_postcript==-1) {
		exposant_postcript=3;
		fprintf(fichier,"%x",tampon_postcript); 
		tampon_postcript=0;
		compteur_postcript++;
		if (compteur_postcript>=72) {
			compteur_postcript=0;
			fprintf(fichier,"\n");
			}
		}
	}
} 



/*******************************************************************************************************************************/

static void save_postcript3() /*appelee a la fin de chaque ligne */
		             
{
if ((type_postcript==NOIR)&&(exposant_postcript!=3)) {
	exposant_postcript=3;
	fprintf(fichier,"%x",tampon_postcript);
	tampon_postcript=0;
	}
if ((type_postcript==NOIR)&&(compteur_postcript2<8*(int)ceil(largeur/8.0))) fprintf(fichier,"0");
fprintf(fichier,"\n");
compteur_postcript=0;
compteur_postcript2=0;
}



/*******************************************************************************************************************************/

static void save_postcript4()
{
fprintf(fichier,"\nshowpage\n\n");               
fprintf(fichier,"%% stop using temporary dictionary\n");               
fprintf(fichier,"end\n\n");               
fprintf(fichier,"%% restore original state\n");               
fprintf(fichier,"origstate restore\n\n");               
fprintf(fichier,"%%%%Trailer\n");               
fclose(fichier);
sauvPostcript=FALSE;
} 



/*******************************************************************************************************************************/

XRectangle rectmaker(p,large)
XPoint p;
int large;
{
XRectangle rect;
rect.x=p.x;
rect.y=p.y;
rect.width=large;
rect.height=large;
return (rect);
}

/*************************************************************************************/

void vider_tampons(bloc)
int bloc;
{
static XRectangle rectangles[MAXPOINTS];
int k,l;

for (k=0;k<MAXCOULEURS;k++){
	if (points.nbre[k]){
		XSetForeground(XtDisplay(racine),gcontext,k);
		if (bloc==1){
			if (!tache_de_fond) XDrawPoints(XtDisplay(racine),XtWindow(toile),gcontext,
					points.pts[k],points.nbre[k],CoordModeOrigin);
			XDrawPoints(XtDisplay(racine),pixmap,gcontext,    
					points.pts[k],points.nbre[k],CoordModeOrigin);
			}
		else
			{               
			for (l=0;l<maxpts;l++) {  
				rectangles[l]=rectmaker(points.pts[k][l],bloc);
				}
			if (!tache_de_fond) XFillRectangles(XtDisplay(racine),XtWindow(toile),gcontext,
					rectangles,points.nbre[k]);
			XFillRectangles(XtDisplay(racine),pixmap,gcontext,    
					rectangles,points.nbre[k]);
			}    
		points.nbre[k]=0;
		}
	}
}	    
			
/*******************************************************************************************************************************/

void trace_point(i,j,bloc,stopper_calc)   
int i,j,bloc;                          
int *stopper_calc;  
{ 
XEvent ev;
static XRectangle rectangles[MAXPOINTS];
int k;                       


if (tampon) {
	if (points.nbre[couleur] == maxpts-1){  
		/* Tampon plein */
		XSetForeground(XtDisplay(racine),gcontext,couleur);
		if (bloc==1){       
			if (!tache_de_fond) XDrawPoints(XtDisplay(racine),XtWindow(toile),gcontext,
					points.pts[couleur],points.nbre[couleur],CoordModeOrigin);
			XDrawPoints(XtDisplay(racine),pixmap,gcontext,    
					points.pts[couleur],points.nbre[couleur],CoordModeOrigin);
			}
		else
			{               
			for (k=0;k<maxpts;k++) {  
				rectangles[k]=rectmaker(points.pts[couleur][k],bloc);
				}
			if (!tache_de_fond) XFillRectangles(XtDisplay(racine),XtWindow(toile),gcontext,
					rectangles,points.nbre[couleur]);
			XFillRectangles(XtDisplay(racine),pixmap,gcontext,    
					rectangles,points.nbre[couleur]);
			}   
		points.nbre[couleur]=0;     
        	}
	points.pts[couleur][points.nbre[couleur]].x=i;
	points.pts[couleur][points.nbre[couleur]].y=j;
	points.nbre[couleur]+=1;  
	}
else    {
	XSetForeground(XtDisplay(racine),gcontext,couleur);
	if (bloc==1){
/*	if (!tache_de_fond) XFillRectangle(XtDisplay(racine),XtWindow(toile),gcontext,i,j,1,1);*/
	if (!tache_de_fond) XDrawPoint(XtDisplay(racine),XtWindow(toile),gcontext,i,j);    /* ATTENTION */
	XDrawPoint(XtDisplay(racine),pixmap,gcontext,i,j);     /* A MODIFIER si bug */
/*	if (!tache_de_fond) XFillRectangle(XtDisplay(racine),XtWindow(toile),gcontext,i,j,1,1);
	XFillRectangle(XtDisplay(racine),pixmap,gcontext,i,j,1,1);*/
	}
	else
	{
	if (!tache_de_fond) XFillRectangle(XtDisplay(racine),XtWindow(toile),gcontext,i,j,bloc,bloc);
	XFillRectangle(XtDisplay(racine),pixmap,gcontext,i,j,bloc,bloc);
	}
}

if (gestion_ev) {
/*if (XtPending()) {
	XtNextEvent(&ev);
	XtDispatchEvent(&ev);
	}    
}*/
	if ((!tache_de_fond)&&(XEventsQueued(XtDisplay(racine),QueuedAfterReading)!=0)){
		XNextEvent(XtDisplay(racine),&ev);
		if (ev.type==DestroyNotify){
			XtDestroyWidget(racine);
			}
		if (ev.type==Expose){
			XFlush(XtDisplay(racine));
			XCopyArea(XtDisplay(racine),pixmap,XtWindow(toile),gcontext,0,0,largeur,hauteur,0,0); 
			}
		if ((ev.type==ButtonPress)&&(ev.xbutton.button==2)){
			XFlush(XtDisplay(racine));
			*stopper_calc=TRUE;         
			if (tampon) vider_tampons(bloc);
			}      
		if ((ev.type==ButtonPress)&&(ev.xbutton.button==3)){
			XFlush(XtDisplay(racine));
			if (tampon) vider_tampons(bloc);
			}    
		/* Pas utile sur hpux */  
		/*if (ev.type==LeaveNotify) {
			XUninstallColormap(XtDisplay(racine),cmap);      
		if (ev.type==EnterNotify) {
			XInstallColormap(XtDisplay(racine),cmap);
			}   */
		}     
	}     
}
	                


/*******************************************************************************************************************************/
void test(w,donnees,appels) 
Widget w;
XtPointer donnees,appels;
{
int i,j;   
complex z;
FLOAT_SIZE pasx,pasy;

	  
pasx=(z1.re-z0.re)/largeur;
pasy=(z0.im-z1.im)/hauteur;

		for(j=0;j<hauteur;++j){
			for(i=0;i<largeur;++i){
				z.re=z0.re+i*pasx;
				z.im=z0.im-j*pasy;
				definir_couleur(calcul2(z));
				trace_point(i,j,1);

					
			}   
		}
	
}
/**************************************************************************************************/
double MSetDist(z)    /* Distance Estimator - Mandelbrot */
complex z;
{
int i,it;
double x,y,x2,y2;
double temp;
double xder,yder;
double xorbit[2000],yorbit[2000];
double dist;
int huge;
int flag;
double overflow=1E308;

x=y=x2=y2=0.0;
dist=0;
xorbit[0]=yorbit[0]=0;
huge=100000;
for (it=0;(it<iter)&&((x2+y2)<huge);it++) {
	temp=x2-y2+z.re;
	y=2*x*y+z.im;
	x=temp;
	x2=x*x;
	y2=y*y;
	xorbit[it]=x;
	yorbit[it]=y;
}
if ((x2+y2)>huge) {
	xder=yder=0.0;
	flag=FALSE;
	for (i=0;((i<it)&&(!flag));i++) {
		temp=2*(xorbit[i]*xder-yorbit[i]*yder)+1;
		yder=2*(yorbit[i]*xder+xorbit[i]*yder);
		xder=temp;
		if (max(fabs(xder),fabs(yder))>overflow) flag=TRUE;
	}
/*	printf("%f ",max(fabs(xder),fabs(yder)));*/
/*	printf("%d ",flag);*/
	if (!flag) {
		dist=log(x2+y2)*sqrt(x2+y2)/sqrt(xder*xder+yder*yder);}
}
/*if (dist!=0.0) printf("%f\n",dist);*/
return (dist);
}


/**************************************************************************************************/
void calcul(w,donnees,appels)    /* Procedure de calcul */
Widget w;
XtPointer donnees,appels;
{
int i,j,bloc;   
complex z;
lcomplex lz;
FLOAT_SIZE pasx,pasy;
int hauteur2;
int superlarge;
int larg1,larg2;
int hau1,hau2;
int sym=0;                                   
int pourcent=0;
char numero[LONG_MAX];      
int stopper_calc=FALSE;
char nom_fichier[LONG_MAX];        
int iterations;                                        
int bloc_buffer;           
long itmax,itmin;                                         
double coef;
char GIFtexte[LONG_MAX];
double param;
FLOAT_SIZE lparam;
complex pt_courant;
long repere=0; /* Pour permettre de reprendre le calcul */
double dist;
double threshold; /* Distance Estimator Variable */
/*clock_t debut,fin,duree;*/
char toto[LONG_MAX];

if (calcul_virtuel) {
	calculBG();
	return;
}
/*if (!exist_shell2) resize();*/
	    
XSetFunction(XtDisplay(racine),gcontext,GXcopy);   
ecrire(CP[167]);

calcul_en_cours=TRUE;
stopper_calc=FALSE;         
bloc_buffer=bloc0;
/*debut=clock();*/

/* On efface */
if ((pt_en_cours==0)&&(!tache_de_fond)) {
	XSetForeground(XtDisplay(racine),gcontext,bpx2);
	XFillRectangle(XtDisplay(racine),XtWindow(toile),gcontext,0,0,largeur,hauteur); 
	XFillRectangle(XtDisplay(racine),pixmap,gcontext,0,0,largeur,hauteur); 
}

/*Preliminaires*/
/* On veut une image proportionnelle */
if (((z1.re-z0.re)/(z0.im-z1.im))>((FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur)) {
	lparam=(z0.im-z1.im)/2+z1.im;
	z1.im=lparam-(z1.re-z0.re)*(FLOAT_SIZE)hauteur/(FLOAT_SIZE)largeur/2.0;
	z0.im=lparam+(z1.re-z0.re)*(FLOAT_SIZE)hauteur/(FLOAT_SIZE)largeur/2.0;
	}

if (((z1.re-z0.re)/(z0.im-z1.im))<((FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur)) {
	lparam=(z1.re-z0.re)/2+z0.re;
	z1.re=lparam+(z0.im-z1.im)*(FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur/2.0;
	z0.re=lparam-(z0.im-z1.im)*(FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur/2.0;
	}

pasx=(z1.re-z0.re)/largeur;
pasy=(z0.im-z1.im)/hauteur;                       
 
/*XtSetSensitive(tableau,FALSE);*/                      
/* Palette logarithmique ? => premier passage */
if ((palettelog)&&(pt_en_cours==0)&&(type_dessin==NORMAL)) {                   
	itmax=0;
	itmin=320000;
	if (!tache_de_fond) ecrire(CP[168]);
	for(j=0;j<hauteur;j+=8){
		for(i=0;i<largeur;i+=8){
			if (use_long_double) {
				lz.re=z0.re+i*pasx;
				lz.im=z0.im-j*pasy;
				iterations=calcul3(lz);}
			else {
				z.re=(double)(z0.re+i*pasx);
				z.im=(double)(z0.im-j*pasy);
				iterations=calcul2(z);}
			if (iterations>itmax) itmax=iterations;
			if (iterations<itmin) itmin=iterations;
		}	
	}      
	if (itmax<MAXCOULEURS) {
		palettelog=FALSE;
		} 
		else{        
		/*printf("iterations %d %d\n",itmin,itmax);*/
		coef=exp(log((double)itmax/(double)(itmin+1))/(double)(255));
/*	coef=pow((double)(itmax/(itmin+1)),(double)(-255));     */
		/*printf("coef %f\n",coef);*/
		palog[0]=0;        
		palog[1]=itmin;      
		palog[255]=itmax;                                  
		for (i=2;i<255;i++) {
			palog[i]=floor(palog[i-1]*coef+0.5);
			if (palog[i]<=palog[i-1]) palog[i]=palog[i-1]+1;   
			if (palog[i]>=itmax) palog[i]=itmax-255+i;
			/*printf("%d %d\n",i,palog[i]);*/
		}
		if (!tache_de_fond) ecrire(CP[169]);
		/*printf("%d %d\n",palog[254],palog[255]);*/
	}
}	
/*for (i=0;i!=256;i++) {
	printf("%d\n",palog[i]);} */

/* Prise en compte de la symetrie ? */
if  ((symetrie==1) && ((z1.im*z0.im<0))) 
	sym=1;
if  ( (symetrie==2) && (z0.re<0.) && (z1.re>0.) && (z0.im>0.) && (z1.im<0.) )
	sym=2;  
        
/*if (sauviter) {          
	hau1=(int)(hauteur*(z0.im/(z0.im-z1.im)));
	hau2=(int)(hauteur*(-z1.im/(z0.im-z1.im)));
	larg1=(int)(largeur*(-z0.re/(z1.re-z0.re)));
	larg2=(int)(largeur*(z1.re/(z1.re-z0.re)));
	strcpy(nom_fichier,"iter.xfe");      
	if ((fichier = fopen(nom_fichier,"w"))==NULL)
		{perror(CP[170]);}   
	fprintf(fichier,"%d\n",sym);
	fprintf(fichier,"%d\n",bloc0);
	fprintf(fichier,"%d\n",iter);
	fprintf(fichier,"%d %d\n",largeur,hauteur);
	fprintf(fichier,"%d %d\n",hau1,hau2);
	fprintf(fichier,"%d %d\n",larg1,larg2);
}*/

if (type_dessin==ESTIMATEUR) {
	threshold=1E-5*delta*(z1.re-z0.re)/(largeur-1);
	bloc_buffer=bloc0;
	bloc0=1;
}

if (sauvPPM) {
	pt_en_cours=0;
	save_ppm1();    
	sym=0;     
	bloc_buffer=bloc0;
	bloc0=1;}


if (sauvPostcript) {
	pt_en_cours=0;
	save_postcript1();  
	sym=0;    
	bloc_buffer=bloc0;
	/*tampon=FALSE;*/
	bloc0=1;}

if (tache_de_fond) {
	bloc_buffer=bloc0;
	bloc0=1;}


repere=0;

if (sym==0){
	for(bloc=bloc0;bloc>=1;bloc/=2){
		for(j=0;j<hauteur;j+=bloc){
			for(i=0;i<largeur;i+=bloc){
			if ((bloc0==1)|| (bloc==8) || (i%(bloc*2) !=0) || (j%(bloc*2)!=0) ) {
				repere++;
				if (repere>pt_en_cours) {
					z.re=(double)(z0.re+i*pasx);
					z.im=(double)(z0.im-j*pasy);
					if (type_dessin==ESTIMATEUR) {	
						dist=MSetDist(z);
						if (dist>threshold) {couleur=1;} 
							else {couleur=0;}
						}
					if (type_dessin==NORMAL) {
						if (use_long_double) {
							lz.re=z0.re+i*pasx;
							lz.im=z0.im-j*pasy;
							iterations=calcul3(lz);}
						else iterations=calcul2(z);
						definir_couleur(iterations);
						if (sauviter) fprintf(fichier,"%d ",iterations);
						}
					if (sauvPPM) save_ppm2(couleur);
					if (sauvPostcript) save_postcript2(couleur);
					/*if (!sauvPostcript) */ trace_point(i,j,bloc,&stopper_calc); 
					}
				}	
			if (stopper_calc) break;
			}    
		if  (sauvPostcript) save_postcript3(); 
		if (bloc==1) {pourcent=(j*75)/hauteur+25;}
		else if (bloc==2) {pourcent=(j*12)/hauteur+6;}
		else if (bloc==4) {pourcent=(j*3)/hauteur+1;}
		else {pourcent=0;}    
		if (bloc_buffer==1) pourcent=(j*100)/hauteur;
			
		sprintf(numero,"%d %% %s",pourcent,CP[171]);
		if ((repere>pt_en_cours)&&(!tache_de_fond)) ecrire(numero);
		if (stopper_calc) break;
		}  
	if (stopper_calc) break;
	if (tampon) vider_tampons(bloc);
	}
/*printf("%ld\n",repere);*/
	if (!stopper_calc) pt_en_cours=0;
}
if (sym==1){
	hau1=(int)(hauteur*(z0.im/(z0.im-z1.im)));
	hau2=(int)(hauteur*(-z1.im/(z0.im-z1.im)));
	hauteur2=max(hau1,hau2);

	for(bloc=bloc0;bloc>=1;bloc/=2){
		for(j=0;j<=hauteur2;j+=bloc){
			for(i=0;i<largeur;i+=bloc){   
			if ((bloc0==1)|| (bloc==8) || (i%(bloc*2) !=0) || (j%(bloc*2)!=0) ) {
				repere++;
				if (repere>pt_en_cours) {
					z.re=(double)(z0.re+i*pasx);
					z.im=(double)(j*pasy);
					if (type_dessin==ESTIMATEUR) {	
						dist=MSetDist(z);
						if (dist>threshold) couleur=1; else couleur=0;
						}
					if (type_dessin==NORMAL) {
						if (use_long_double) {
							lz.re=z0.re+i*pasx;
							lz.im=j*pasy;
							iterations=calcul3(lz);}
						else iterations=calcul2(z);
						if (sauviter) fprintf(fichier,"%d ",iterations);
						definir_couleur(iterations);
						}
					if (j<=hau1) trace_point(i,hau1-j,bloc,&stopper_calc);
					if (j<=hau2) trace_point(i,j+hau1,bloc,&stopper_calc);
					}
				}
			if (stopper_calc) break;
			}   
		if (stopper_calc) break;
		if (bloc==1) {pourcent=(j*75)/hauteur2+25;}
		else if (bloc==2) {pourcent=(j*12)/hauteur2+6;}
		else if (bloc==4) {pourcent=(j*3)/hauteur2+1;}
		else {pourcent=0;}
		if (bloc_buffer==1) pourcent=(j*100)/hauteur2;

		sprintf(numero,"%d %% %s",pourcent,CP[171]);
		if ((repere>pt_en_cours)&&(!tache_de_fond)) ecrire(numero);
		}     
	if (stopper_calc) break;
	if (tampon) vider_tampons(bloc);
	}
	if (!stopper_calc) pt_en_cours=0;
}
if (sym==2){
	hau1=(int)(hauteur*(z0.im/(z0.im-z1.im)));
	hau2=(int)(hauteur*(-z1.im/(z0.im-z1.im)));
	larg1=(int)(largeur*(-z0.re/(z1.re-z0.re)));
	larg2=(int)(largeur*(z1.re/(z1.re-z0.re)));
	superlarge=max(larg1,larg2);
	hauteur2=max(hau1,hau2);
	for(bloc=bloc0;bloc>=1;bloc/=2){
		for(j=0;j<=hauteur2;j+=bloc){
			for(i=-superlarge;i<=superlarge;i+=bloc){
			if ((bloc0==1)|| (bloc==8) || (i%(bloc*2) !=0) || (j%(bloc*2)!=0) ) {
				repere++;
				if (repere>pt_en_cours) {
					if ((j<=hau1)&&( ((i<=0)&&(-i<=larg1)) ||((i>=0)&&(i<=larg2)))){
						z.re=(double)(i*pasx);
						z.im=(double)(j*pasy);
						if (type_dessin==ESTIMATEUR) {								
							dist=MSetDist(z);
							if (dist>threshold) couleur=1; else couleur=0;
							}
						if (type_dessin==NORMAL) {	
							if (use_long_double) {
								lz.re=i*pasx;
								lz.im=j*pasy;
								iterations=calcul3(lz);}
							else iterations=calcul2(z);
							if (sauviter) fprintf(fichier,"%d ",iterations);
							definir_couleur(iterations);
							}
						if (!tache_de_fond) trace_point(i+larg1,hau1-j,bloc,&stopper_calc);
					if ((j<=hau2)&&( ((i<=0)&&(-i<=larg2))||((i>=0)&&(i<=larg1)))){
						trace_point(-i+larg1,hau1+j,bloc,&stopper_calc);}
					}
					else{
						if ((j<=hau2)&&( ((i<=0)&&(-i<=larg2))||((i>=0)&&(i<=larg1)))){		
							if (type_dessin==ESTIMATEUR) {								
								dist=MSetDist(z);
								if (dist>threshold) couleur=1; else couleur=0;
								}
							if (type_dessin==NORMAL) {	
								if (use_long_double) {
									lz.re=i*pasx;
									lz.im=j*pasy;
									iterations=calcul3(lz);}
								else iterations=calcul2(z);
								if (sauviter) fprintf(fichier,"%d ",iterations);
								definir_couleur(iterations);
								}
							if (!tache_de_fond) trace_point(-i+larg1,hau1+j,bloc,&stopper_calc);}
							}
					}
				}
			if (stopper_calc) break;
			}   
		if (stopper_calc) break;
		if (bloc==1) {pourcent=(j*75)/hauteur2+25;}
		else if (bloc==2) {pourcent=(j*12)/hauteur2+6;}
		else if (bloc==4) {pourcent=(j*3)/hauteur2+1;}
		else {pourcent=0;}
		if (bloc_buffer==1) pourcent=(j*100)/hauteur2;

		sprintf(numero,"%d %% %s",pourcent,CP[171]);
		if ((repere>pt_en_cours)&&(!tache_de_fond)) ecrire(numero);
		}
	if (stopper_calc) break;
	if (tampon) vider_tampons(bloc);
	}
	pt_en_cours=0;
	if (!stopper_calc) pt_en_cours=0;
}

if (sauviter) fclose(fichier);   
if  (sauvPostcript) save_postcript4();  
if (sauvPPM) {
	sauvPPM=FALSE;
	fclose(fichier);  
	ecrire(CP[172]); 
	ecrire_bibli(nomPPM);
	}    
calcul_en_cours=FALSE;   
pt_en_cours=repere;
/*printf("%d\n",pt_en_cours);*/
/*fin=clock();*/
/*sprintf(toto,"%s %ld s",CP[173],(long)((fin-debut)/(CLOCKS_PER_SEC)));*/
sprintf(toto,"%s",CP[173]);
if ((bipbip)&&(!tache_de_fond)) XBell(XtDisplay(racine),100);  
if (!tache_de_fond) ecrire(toto);  
bloc0=bloc_buffer;
}     

/**************************************************************************************************/
void calculBG()    /* Procedure de calcul en tache de fond */
{
int i,j,bloc;   
complex z;
FLOAT_SIZE pasx,pasy;
char nom_fichier[10];        
int iterations;                                        
char GIFtexte[300];
long itmin,itmax;
double coef;
FLOAT_SIZE param;
lcomplex lz;
double dist;
double threshold;
	                                        
/*Preliminaires*/
/* On veut une image proportionnelle */
if (((z1.re-z0.re)/(z0.im-z1.im))>((FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur)) {
	param=(z0.im-z1.im)/2+z1.im;
	z1.im=param-(z1.re-z0.re)*(FLOAT_SIZE)hauteur/(FLOAT_SIZE)largeur/2.0;
	z0.im=param+(z1.re-z0.re)*(FLOAT_SIZE)hauteur/(FLOAT_SIZE)largeur/2.0;
	}

if (((z1.re-z0.re)/(z0.im-z1.im))<((FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur)) {
	param=(z1.re-z0.re)/2+z0.re;
	z1.re=param+(z0.im-z1.im)*(FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur/2.0;
	z0.re=param-(z0.im-z1.im)*(FLOAT_SIZE)largeur/(FLOAT_SIZE)hauteur/2.0;
	}

pasx=(z1.re-z0.re)/largeur;
pasy=(z0.im-z1.im)/hauteur;                       
 
/*XtSetSensitive(tableau,FALSE);*/                      
/* Palette logarithmique ? => premier passage */
if (palettelog) {                   
	itmax=0;
	itmin=320000;
	for(j=0;j<hauteur;j+=8){
		for(i=0;i<largeur;i+=8){
			if (use_long_double) {
				lz.re=z0.re+i*pasx;
				lz.im=z0.im-j*pasy;
				iterations=calcul3(lz);}
			else {
				z.re=(double)(z0.re+i*pasx);
				z.im=(double)(z0.im-j*pasy);
				iterations=calcul2(z);}
			if (iterations>itmax) itmax=iterations;
			if (iterations<itmin) itmin=iterations;
		}	
	}      
	if (itmax<MAXCOULEURS) {
		palettelog=FALSE;
		} 
		else{        
		printf("iterations %d %d\n",itmin,itmax);
		coef=exp(log((double)itmax/(double)(itmin+1))/(double)(255));
/*	coef=pow((double)(itmax/(itmin+1)),(double)(-255));     */
		printf("coef %f\n",coef);
		palog[0]=0;        
		palog[1]=itmin;      
		palog[255]=itmax;                                  
		for (i=2;i<255;i++) {
			palog[i]=floor(palog[i-1]*coef+0.5);
			if (palog[i]<=palog[i-1]) palog[i]=palog[i-1]+1;   
			if (palog[i]>=itmax) palog[i]=itmax-255+i;
			/*printf("%d %d\n",i,palog[i]);*/
		}
		/*ecrire("Palette calculee");*/
		printf("%d %d %d %d\n",palog[252],palog[253],palog[254],palog[255]);
	}
}
/*if (sauviter) {          
	strcpy(nom_fichier,"iter.xfe");      
	if ((fichier = fopen(nom_fichier,"w"))==NULL)
		{perror(CP[170]);}   
	fprintf(fichier,"%d\n",iter);
	fprintf(fichier,"%d %d\n",largeur,hauteur);
}*/

if (sauvPPM) {
	save_ppm1(); }  
 
if (sauvPostcript) {
	save_postcript1();    
}
if (type_dessin==ESTIMATEUR) {
	threshold=1E-5*delta*(z1.re-z0.re)/(largeur-1);
	}  

/* boucle de calcul */ 	    
for(j=0;j<hauteur;j++){
	for(i=0;i<largeur;i++){
		z.re=(double)(z0.re+i*pasx);
		z.im=(double)(z0.im-j*pasy);
		if (type_dessin==ESTIMATEUR) {	
			dist=MSetDist(z);
			if (dist>threshold) couleur=1; 
				else couleur=0;
			}
		if (type_dessin==NORMAL) {
			if (use_long_double) {
				lz.re=z0.re+i*pasx;
				lz.im=z0.im-j*pasy;
				iterations=calcul3(lz);}
			else iterations=calcul2(z);
			definir_couleur(iterations);
			if (sauviter) fprintf(fichier,"%d ",iterations);
			}
		if (sauvPPM) save_ppm2(couleur);
		if (sauvPostcript) save_postcript2(couleur);
	}       
	if  (sauvPostcript) save_postcript3();  
}

if  (sauvPostcript) save_postcript4(); 
if (sauviter) fclose(fichier);   
if (sauvPPM) {
	sauvPPM=FALSE;
	fclose(fichier);  
	ecrire_bibli(nomPPM);
	}    
if (sauvGIF) {     
	sauvGIF=FALSE; 
	}
exit(0);
return;
}     




/*********************************************************************************************************/


void init()
{
use_long_double=FALSE;
bailout=4.0;
delta=1.0;
coul_for=255;
coul_back=0;  
type_postcript=NOIR;
tache_de_fond=FALSE;
initcoord=FALSE;
sauvPPM=FALSE;
sauvGIF=FALSE; 
sauvPostcript=FALSE;
calcul_en_cours=FALSE;   
calcul_virtuel=FALSE;
nbre_cycles=3;
sens_cycle=1;
	maxpts=200;
	tampon=TRUE;
	gestion_ev=TRUE;
	bipbip=FALSE;
	bloc0=8;
	sauviter=FALSE;   
	type_dessin=NORMAL;    
	palettelog=FALSE;

	/*palette_en_cours=FALSE;*/

	znull.im=0;
	znull.re=0;	
	lznull.im=0;
	lznull.re=0;
	cz.re=0.0;
	cz.im=0.0;
	z0.re=z0.im=z1.re=z1.im=0.0;
	ip=0;	

	iter=250;               
	largeur=640;
	hauteur=512;
	
	pt_en_cours=0;

	genre=MANDELBROT;      
	       
	calcul_en_cours=FALSE;
	sprintf(nompalette,"%s/defaut.cmap",PALETTE_DIR);
	
}

/*********************************************************************************************************/


void init_texte(signed char *lang) /* Routine tiree de GNUchess */
{
  FILE *constfile;
  signed char s[512];
  signed char sl[5];
  int len, entry;
  signed char *p, *q;
  constfile = fopen ("xfe.lang", "r");

  if (!constfile)
    {
      printf ("NO LANGFILE\n");
      exit (1);
    }
  while (fgets (s, sizeof (s), constfile))
    {
      if (s[0] == '!') continue;
      len = strlen (s);
      for (q = &s[len]; q > &s[8]; q--) if (*q == '}') break;
      if (q == &s[8])
	{
	  printf ("{ error in constfile\n");
	  exit (1);
	}
      *q = '\0';
      if (s[3] != ':' || s[7] != ':' || s[8] != '{')
	{
	  printf ("Langfile format error %s\n", s);
	  exit (1);
	}
      s[3] = s[7] = '\0';
      if (lang == NULL)
	{
	  lang = sl;
	  strcpy (sl, &s[4]);
	}
      if (strcmp (&s[4], lang))
	continue;
      entry = atoi (s);
      if (entry < 0 || entry >= CPSIZE)
	{
	  printf ("Langfile number error\n");
	  exit (1);
	}
      for (q = p = &s[9]; *p; p++)
	{
	  if (*p != '\\')
	    {
	      *q++ = *p;
	    }
	  else if (*(p + 1) == 'n')
	    {
	      *q++ = '\n';
	      p++;
	    }
	}
      *q = '\0';
      if (entry < 0 || entry > 255)
	{
	  printf ("Langfile error %d\n", entry);
	  exit (0);
	}
 /*     CP[entry] = (signed char *) malloc ((unsigned) strlen (&s[9]) + 1);*/
      CP[entry] = (char *) malloc ((unsigned) strlen (&s[9]) + 1);
      if (CP[entry] == NULL)
	{
	  perror ("malloc");
	  exit (0);
	}
      strcpy (CP[entry], &s[9]);

    }
  fclose (constfile);
}


/**********************************************************************************************************/

void rafraichir(w,client,appel)
Widget w;
XtPointer client; 
XmDrawingAreaCallbackStruct *appel;
{                         
	/*XExposeEvent *evt = (XExposeEvent*) appel->event;     

	XCopyArea(XtDisplay(w),pixmap,XtWindow(toile),gcontext,evt->x,evt->y,evt->width,evt->height,evt->x,evt->y);*/
        
	XCopyArea(XtDisplay(w),pixmap,XtWindow(toile),gcontext,0,0,largeur,hauteur,0,0); 
} 


/*********************************************************************************************************/

void rafraichir_mes(w,client,appel)
Widget w;
XtPointer client; 
XmDrawingAreaCallbackStruct *appel;
{                         
	XCopyArea(XtDisplay(w),pix_message,XtWindow(message),gcontext,0,0,MESSAGE_L,MESSAGE_H,0,0); 
} 

/*********************************************************************************************************/


void map(w,client,appel)
Widget w;
XtPointer client,appel; 
{
XInstallColormap(XtDisplay(racine),cmap);                         
} 
/*********************************************************************************************************/

void unmap(w,client,appel)
Widget w;
XtPointer client,appel; 
{                         
XUninstallColormap(XtDisplay(racine),cmap);                         
} 

/*********************************************************************************************************/

void detruire(w,client,appel)
Widget w;
XtPointer client,appel; 
{                         
XtDestroyWidget(racine);                         
} 

/*********************************************************************************************************/

/*void Change_palette(w,client,appel)
Widget w;
XtPointer client,appel; 
{       
if (palette_en_cours==FALSE) {    
	XSetWindowColormap(XtDisplay(racine),XtWindow(racine),cmap); 
	ecrire(CP[174]); }
else {
	XSetWindowColormap(XtDisplay(racine),XtWindow(racine),pal_def); 
	ecrire(CP[175]); }
palette_en_cours=!palette_en_cours;
} */


/*****************************************************************************************************/

void efface()                                                                                              
{  
/* On efface tout */
XSetForeground(XtDisplay(racine),gcontext,bpx2);
XFillRectangle(XtDisplay(racine),pixmap,gcontext,0,0,largeur,hauteur);  
XFillRectangle(XtDisplay(racine),XtWindow(toile),gcontext,0,0,largeur,hauteur);  
/*printf("Efface! largeur:%d  hauteur:%d\n",largeur,hauteur);*/
}

/**********************************************************************************/

void resize()                                                                                              
{                                             
int nargs;
Arg argu[20];
char toto[100];

pt_en_cours=0;
/*printf("resize\n");*/

if ((largeur>LARGEUR_MAX)||(hauteur>HAUTEUR_MAX)) {
	ecrire(CP[176]);
	calcul_virtuel=TRUE;
	return;
}   
else  	calcul_virtuel=FALSE;          
/* Le chargement d'image ne marche qu'avec des tailles + larges que hautes */

XtDestroyWidget(toile);
XtDestroyWidget(shell2);


/*****************/
/* Fenetre Image */
/*****************/

nargs=0;    
XtSetArg(argu[nargs],XmNwidth,largeur); nargs++;
XtSetArg(argu[nargs],XmNheight,hauteur); nargs++; 
XtSetArg(argu[nargs],XmNdeleteResponse, XmDO_NOTHING);nargs++;
shell2=XtCreateApplicationShell("Fenetre",topLevelShellWidgetClass,argu,nargs);
/*XtAddCallback(shell2,XtNdestroyCallback,exist,NULL);*/


/* Initialisation des ressources */
nargs=0;    
XtSetArg(argu[nargs],XmNwidth,largeur); nargs++;
XtSetArg(argu[nargs],XmNheight,hauteur); nargs++; 
XtSetArg(argu[nargs],XmNx,0);nargs++;
XtSetArg(argu[nargs],XmNy,0);nargs++;
XtSetArg(argu[nargs],XmNmarginHeight,0);nargs++;
XtSetArg(argu[nargs],XmNmarginWidth,0);nargs++;
toile=XtCreateManagedWidget("toile",xmDrawingAreaWidgetClass,shell2,argu,nargs);
/* toile=XmCreateDrawingArea(shell2,"toile",argu,nargs);   */
XtAddCallback(toile,XmNexposeCallback,rafraichir,NULL);
XtMoveWidget(toile,0,50);

XtManageChild(toile);   
XtRealizeWidget(shell2);
    
/* on remplace l'ancien pixmap */
XFreePixmap (XtDisplay(racine),pixmap);  
/*XtFree(pixmap);*/
/*printf("avant malloc\n");
/*pixmap=XtMalloc(largeur*hauteur);
printf("apres malloc\n");*/

pixmap= XCreatePixmap(XtDisplay(racine),
                           DefaultRootWindow(XtDisplay(racine)),
                           largeur,hauteur, 
                           DefaultDepthOfScreen(XtScreen(racine)));
 
sprintf(toto,"%s: %d  %s: %d",CP[113],largeur,CP[114],hauteur);
ecrire(toto);
free(toto);
XSetWindowColormap(XtDisplay(shell2),XtWindow(shell2),cmap);  
efface();
}  
/**********************************************************************************/

void display_window()                                                                                              
{                                             
int nargs;
Arg argu[20];
char toto[100];

pt_en_cours=0;
/*printf("resize\n");*/


/*****************/
/* Fenetre Image */
/*****************/

nargs=0;    
XtSetArg(argu[nargs],XmNwidth,largeur); nargs++;
XtSetArg(argu[nargs],XmNheight,hauteur); nargs++; 
XtSetArg(argu[nargs],XmNdeleteResponse, XmDO_NOTHING);nargs++;
shell2=XtCreateApplicationShell("Fenetre",topLevelShellWidgetClass,argu,nargs);
/*XtAddCallback(shell2,XtNdestroyCallback,exist,NULL);*/


/* Initialisation des ressources */
nargs=0;    
XtSetArg(argu[nargs],XmNwidth,largeur); nargs++;
XtSetArg(argu[nargs],XmNheight,hauteur); nargs++; 
XtSetArg(argu[nargs],XmNx,0);nargs++;
XtSetArg(argu[nargs],XmNy,0);nargs++;
XtSetArg(argu[nargs],XmNmarginHeight,0);nargs++;
XtSetArg(argu[nargs],XmNmarginWidth,0);nargs++;
toile=XtCreateManagedWidget("toile",xmDrawingAreaWidgetClass,shell2,argu,nargs);
/* toile=XmCreateDrawingArea(shell2,"toile",argu,nargs);   */
XtAddCallback(toile,XmNexposeCallback,rafraichir,NULL);
XtMoveWidget(toile,0,50);

XtManageChild(toile);   
XtRealizeWidget(shell2);
    
/* on remplace l'ancien pixmap */
XFreePixmap (XtDisplay(racine),pixmap);  
/*XtFree(pixmap);*/
/*printf("avant malloc\n");
/*pixmap=XtMalloc(largeur*hauteur);
printf("apres malloc\n");*/

pixmap= XCreatePixmap(XtDisplay(racine),
                           DefaultRootWindow(XtDisplay(racine)),
                           largeur,hauteur, 
                           DefaultDepthOfScreen(XtScreen(racine)));
 
sprintf(toto,"%s: %d  %s: %d",CP[113],largeur,CP[114],hauteur);
ecrire(toto);
free(toto);
XSetWindowColormap(XtDisplay(shell2),XtWindow(shell2),cmap);  
efface();
}  
  
/**********************************************************************************************************/

main(argc,argv)
int argc;
char **argv;  
{      
int ecran;
int *nargs;
Arg argu[20];
int i;
signed char *Lang = "fra";
char option[256];
char toto[256]; 


init();   

if ((!strcmp(*(argv+1),"-help"))||(!strcmp(*(argv+1),"-h"))||(!strcmp(*(argv+1),"?")))
	{ 
	printf("\n");
	printf("	XFractal_Explorer v1.0\n");
	printf("	======================\n");
	printf("				Nicolas GUERIN 1994\n");
	printf("usage:\n");
	printf("xfe [-lang (eng/fra)] \n"); 
	printf("    [-type (mandel/julia/newton/mandellambda/lambda/noel1/noel2/spider/phoenix)] \n"); 
	printf("    [-size width height] \n");
	printf("    [-iter n] \n");
	printf("    [-const Re(c) Im(c)] \n");
	printf("    [-int n] \n");
	printf("    [-coord left up right down] \n");
	printf("    [-logpalette] \n");
	printf("    [-estimator] \n");
	printf("    [-nobuffer] \n");
	printf("    [-palette filename.cmap] \n");
	printf("\n");
	exit(0); 
	} 
   
i=1; 
/* Si ca ne marche pas, essayer i=0 ... */
while (i<argc-1) 
  { 
    strcpy(option,*(argv+i)); i++; 
    
    if (!strcmp(option,"-lang")) 
    { 
      sscanf(*(argv+i),"%s",Lang); 
      i++; 
    } 

    if (!strcmp(option,"-type")) 
    { 
      sscanf(*(argv+i),"%s",toto); 
      i++; 
	if (!strcmp(toto,"mandel")) genre=MANDELBROT;
	if (!strcmp(toto,"julia")) genre=JULIA ;
	if (!strcmp(toto,"newton")) genre=NEWTON;
	if (!strcmp(toto,"mandellambda")) genre=MANDELLAMBDA;
	if (!strcmp(toto,"lambda")) genre=LAMBDA;
	if (!strcmp(toto,"noel1")) genre=NOEL1;
	if (!strcmp(toto,"noel2")) genre=NOEL2;
	if (!strcmp(toto,"spider")) genre=SPIDER;
	if (!strcmp(toto,"phoenix")) genre=PHOENIX;
    } 

    if (!strcmp(option,"-iter")) 
    { 
      sscanf(*(argv+i),"%d",&iter); 
      i++; 
    } 

    if (!strcmp(option,"-size")) 
    { 
      sscanf(*(argv+i),"%d",&largeur); 
      i++; 
      sscanf(*(argv+i),"%d",&hauteur); 
      i++; 
    } 


    if (!strcmp(option,"-coord")) 
    { 
      sscanf(*(argv+i),"%Le",&z0.re); 
      i++; 
      sscanf(*(argv+i),"%Le",&z0.im); 
      i++; 
      sscanf(*(argv+i),"%Le",&z1.re); 
      i++; 
      sscanf(*(argv+i),"%Le",&z1.im); 
      i++; 
	initcoord=TRUE;
    } 

    if (!strcmp(option,"-const")) 
    { 
      sscanf(*(argv+i),"%Le",&cz.re); 
      i++; 
      sscanf(*(argv+i),"%Le",&cz.im); 
      i++; 
    } 

    if (!strcmp(option,"-int")) 
    { 
      sscanf(*(argv+i),"%d",&ip); 
      i++; 
    } 

    if (!strcmp(option,"-logpalette")) 
    { 
	palettelog=TRUE;
    } 

    if (!strcmp(option,"-nobuffer")) 
    { 
	tampon=FALSE;
    } 

    if (!strcmp(option,"-estimator")) 
    { 
	type_dessin=ESTIMATEUR;
    } 
    if (!strcmp(option,"-palette")) 
    { 
      sscanf(*(argv+i),"%s",nompalette); 
      i++;
    }
} 

/*printf("XFractal_Explorer V1.0\n");  */
racine=XtInitialize(argv[0],"Fractal",NULL,0,&argc,argv); 

/*nargs=0;    
XtSetArg(argu[nargs],XmNwidth,300); nargs++;
XtSetArg(argu[nargs],XmNheight,300); nargs++; 
XtCreateManagedWidget("XFE 1.1",widgetClass,racine,argu,nargs);*/

ecran=DefaultScreen(XtDisplay(racine));
bpx2=BlackPixel(XtDisplay(racine),ecran);
wpx2=WhitePixel(XtDisplay(racine),ecran);

/* initialise le tampon */
for (i=0; i<MAXCOULEURS;i++) points.nbre[i]=0;

init_texte(Lang);       
init_fractal(genre);    
initx();       
initialiser_couleurs();                

XtRealizeWidget(racine);   
/*XtRealizeWidget(shell2); */  
   

/*XSetWindowColormap(XtDisplay(shell2),XtWindow(shell2),cmap); */
display_window(); 
ecrire(CP[73]);
XtMainLoop();
}
		
