/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 * XFMail pgp interface
 * Thomas Pundt <pundtt@math.uni-muenster.de>
 * Gennady B. Sorokopud <gena@NetVision.net.il>
 *
 */

/* $Id: pgp.c,v 2.8 1997/12/08 16:21:03 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <dialogs.h>
#include "configform.h"

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

static char *phrase = NULL;	/* scrambled passphrase 	   */
static int pgpext;		/* PGP exit status */
static FD_config_pgp *pgp_obj;
static FD_Lookup_PGPId *form_lookup_pgpid = NULL;

typedef struct _pgp_keylist {
char *userid;
unsigned long keyid;
} pgp_keylist;

#define	PGP_ENC_START	"-----BEGIN PGP MESSAGE-----"
#define	PGP_SIG_START	"-----BEGIN PGP SIGNED MESSAGE-----"
#define	PGP_KEY_START	"-----BEGIN PGP PUBLIC KEY BLOCK-----"

#define NORMAL		1
#define KEYRING		2
#define HTTP		4

void PGP_Mime_Call(FL_OBJECT *obj, long param)
{
}

void PGP_Prog_Call(FL_OBJECT *obj, long param)
{
}

void PGP_User_Call(FL_OBJECT *obj, long param)
{
}

void
cb_input_passphrase(FL_OBJECT *obj,long param)
{
}

void
PGP_Timer_Call(FL_OBJECT *obj,long param)
{
 if (phrase) {
	free(phrase);
	phrase = NULL;
	     }
}

void
pgp_cleanup(struct _proc_info *pinfo)
{
 pgpext = pinfo->status;
}

void
scramble(string)
char *string;
{
unsigned char *p;
 
   if (!string)
        return;
 
   p = (unsigned char *)string;
   while (*p != '\0')   {
    if (*p != 0xaa)
        *p = *p ^ 0xaa;
        p++;
                        }
 
   return;
}

void
init_pgpargs(pargs)
struct pgpargs *pargs;
{
 pargs->userid = NULL;
 pargs->recp = NULL;
 pargs->passphrase = NULL;
 pargs->msg = NULL;
}

char* input_passphrase()
{
char *rphrase;
FD_Passphrase *pass;

 if (phrase)
	goto retp;

 pass=create_form_Passphrase();

 fl_show_form(pass->Passphrase,FL_PLACE_MOUSE,FL_TRANSIENT,"Input Passphrase");
 fl_do_only_forms();
 phrase = strdup((char *)fl_get_input(pass->Input_Passphrase));
 scramble(phrase);
 if (pgp_timer)
	fl_set_timer(pgp_timer, b_getcfg_int(conf_name, "pgptimer", 120)*60+1); 
 fl_hide_form(pass->Passphrase);
 fl_free_form(pass->Passphrase);
 fl_free(pass);

retp:
 rphrase = strdup(phrase);
 scramble(rphrase);

 return rphrase;
}      

void
pgp_init(struct _proc_info *pinfo)
{
  putenv("PGPPASSFD=0"); /* see pgp/doc/appnote.doc */
}

int
pgp_fetch_key_from_http(char *host, unsigned int keyid)
{
  int sock, n, res = 0, keyfound = 0;
  char buf[256], kfile[256], pbuf[32];
  FILE *kfd;

  if ((sock = host_connect(host, "11371", NULL)) == -1)
    return -1;

  /* HKP (Horowitz Key Protocol) */
  sprintf(buf, "GET /pks/lookup?op=get&exact=on&search=0x%X HTTP/1.0\n", keyid);
  strcat(buf, "User-Agent: XFMail (Unix)\n\r\n\r");
  if (send(sock, buf, strlen(buf), 0) == -1)
    return -1;

  strcpy(kfile, get_temp_file("pgphttp"));
  if ((kfd = fopen(kfile, "w")) == NULL) {
    display_msg(MSG_WARN, "PGP keyserver (HKP)", "Can not create temp. file %-.64s", kfile);
    host_disconnect(&sock);
    return -1;				 }

  *pbuf = '\0';
  do {
    if ((n = my_check_io_forms(sock, 0)) < 0)	{
	if (n == -2)
		display_msg(MSG_WARN, "PGP keyserver (HKP)","transfer aborted");
	res = -1;
	break;					}

    if ((n = recv(sock, buf, 255, 0)) == -1)	{
	display_msg(MSG_WARN, "PGP keyserver (HKP)", "recv() failed");
	res = -1;
	break;					}

    if (n > 0)	{
	fwrite(buf, n, 1, kfd);
	buf[n] = '\0';
	if (!keyfound)	{
	 if (strstr(buf, "BEGIN PGP"))	{
		keyfound = 1;
		*pbuf = '\0';
		continue;		}
	 else	{
	  strncat(pbuf, buf, 10);
	  if (strstr(pbuf, "BEGIN PGP")){
		keyfound = 1;
		*pbuf = '\0';
		continue;		}
	  strcpy(pbuf, buf + (n > 10 ? n - 10 : n));
		}
			}
		}
  } while(n > 0);

  host_disconnect(&sock);
  fclose(kfd);

  if ((res == 0) && (keyfound == 0))	{
	display_msg(MSG_WARN, "PGP keyserver (HKP)", "Key 0x%X was not found in public keyring(s) and on server %s", keyid, host);
	unlink(kfile);  
	return -1;			}

  if (res == 0)	{
   if (pgp_action(kfile, EXTKEY, NULL) == -1) {
	unlink(kfile);  
	return -1;			      }
		}

  display_msg(MSG_MSG, "PGP keyserver (HKP)", "Fetched PGP public key 0x%X from %s", keyid, host);
  unlink(kfile);  
  return res;
}

static char*
get_pgp_command_line(int mode, struct pgpargs *pgpargs, char *inbuf, int try)
{
  char args[1024];
  char pubring[255]="";
  const char pgpparm[]="+language=en +verbose=1 +clearsig=on";
  char *pgpprg;
  struct _mail_addr *addr;
  struct _abook_entry *entry;

  if (!(try&NORMAL) && (try&KEYRING))
    sprintf(pubring, "+pubring=%s", b_getcfg_str(conf_name,"pgpkeyring",""));

  pgpprg = strdup(b_getcfg_str(conf_name, "pgp", _PATH_PGP));
  if (pgpargs && (pgpargs->userid == NULL))	{
    if ((mode & (SIGN|SIGNFL)) && pgpargs->msg && pgpargs->msg->header->From) {
      addr = pgpargs->msg->header->From;
      if (addr->pgpid == NULL)	{
        if ((entry = find_addr(addr)) != NULL)
		addr = entry->addr;
				}
      if (addr->pgpid && *addr->pgpid && strncmp(addr->pgpid, "0x", 2))
	display_msg(MSG_WARN, "PGP", "Invalid PGP Id: %s", addr->pgpid);
      else
        pgpargs->userid = addr->pgpid;
									      }
    if (pgpargs->userid == NULL)
	pgpargs->userid = b_getcfg_str(conf_name, "pgpuser", user_n);
						}

  if ((mode&ENCODE) && (mode&SIGN))
    sprintf(args, "%s %s +batchmode -fate %s -su %s ", pgpprg, pgpparm, pgpargs->recp, pgpargs->userid);
  else
  if (mode&ENCODE)
    sprintf(args, "%s %s -fate %s", pgpprg, pgpparm, pgpargs->recp);
  else
  if (mode&SIGN)
    sprintf(args, "%s %s +batchmode -fatsu %s ", pgpprg, pgpparm, pgpargs->userid);

  if (mode&SIGNFL)	{
    sprintf(args, "%s %s +batchmode -fatbsu %s", pgpprg, pgpparm, pgpargs->userid);
    if (pgpargs->recp == NULL)	{
	free(pgpprg);
	return NULL;		}
			}
    
  if (mode&(DECODE|VERIFY))
    sprintf(args, "%s %s +batchmode %s -f", pgpprg, pgpparm, pubring);

  if (mode&EXTKEY)
    sprintf(args, "%s %s +batchmode -f -ka", pgpprg, pgpparm);

  if (mode&ADDKEY)
    sprintf(args, "%s %s -f -kxa %s", pgpprg, pgpparm, pgpargs->recp);

  if (mode&VRFYFL)
    sprintf(args, "%s %s +batchmode %s %s %s", 
            pgpprg, pgpparm, pubring, pgpargs->recp, inbuf);

  free(pgpprg);
  return strdup(args);
}


/*
 *      inbuf: file with text to encode/decode
 *       mode: ENCODE|SIGN or DECODE
 *       recp: if mode&(ENCODE|SIGN), the list of recipient(s)
 * passphrase: if mode==DECODE, or mode==SIGN, the pass phrase
 * see also "pgp/doc/appnote.doc"
 */

int
pgp_action(char *inbuf, int mode, struct pgpargs *pgpargs)
{
  char buf[1024];
  char nfile[64];
  char *args, *p, *q, *r;
  int n, move_result = 0, errfd;
  int try=NORMAL, tries=0;
  unsigned int keyid = 0;
  struct _proc_info pinfo;
  FILE *file;
  struct stat sb;

  strcpy(nfile, (mode&SIGNFL) ? pgpargs->recp : get_temp_file("pgp"));

  while (try) {
  n = 0;
  move_result = 1;
  init_pinfo(&pinfo);
  pinfo.handle = pgp_cleanup;
  pinfo.init = pgp_init;
  pinfo.fd_in[0]=pinfo.fd_out[0]=pinfo.fd_err[0]=0;

  /* init pgp exit status */
  pgpext = -100;

  if (!(try & (NORMAL|KEYRING)) && (try & HTTP)) {
    if (pgp_fetch_key_from_http(b_getcfg_str(conf_name,"pgpkeyserver","pgp5.ai.mit.edu"), keyid) == -1) {
	/* if we can not find signature during decode - still procede */
	if (mode & DECODE)
		break;
	unlink(nfile);
	return -1;      }
						 }

  if (!(args = get_pgp_command_line(mode, pgpargs, inbuf, try))) {
	/* if we can not find signature during decode - still procede */
	if (mode & DECODE)
		break;
	unlink(nfile);
	return -1;						 }

  if (try & NORMAL)
	try &= ~NORMAL;
  else
  if (try & KEYRING)
	try &= ~KEYRING;
  else
  if (try & HTTP)
	try &= ~HTTP;
  
  if(exec_child(args,&pinfo) == -1) {
    free(args);
    pgp_cleanup(&pinfo);
    if (pinfo.fd_in[1] > 0)
	close(pinfo.fd_in[1]);
    if (pinfo.fd_out[0] > 0)
	close(pinfo.fd_out[0]);
    if (pinfo.fd_err[0] > 0)
	close(pinfo.fd_err[0]);

    unlink(nfile);
    return -1;			    }

  free(args);
  
  /* first line of stdin must contain passphrase */
  if(pgpargs && pgpargs->passphrase && (mode&(DECODE|SIGN|SIGNFL)))
    write(pinfo.fd_in[1],pgpargs->passphrase,strlen(pgpargs->passphrase));
  write(pinfo.fd_in[1],"\n",1);

  if (mode&VRFYFL)
	errfd = pinfo.fd_out[0];
  else 	{
   if ((file = fopen(inbuf,"r")) != NULL) {
    while((n = fread(buf,1,1023,file)) > 0)
     write(pinfo.fd_in[1],buf,n);
    close(pinfo.fd_in[1]);
    pinfo.fd_in[1] = -1;
    fclose(file);			  }

  if ((file=fopen(nfile,"w")) != NULL) 	{
   while((n=read(pinfo.fd_out[0],buf,1023))>0)
    fwrite(buf,1,n,file);
   close(pinfo.fd_out[0]);
   pinfo.fd_out[0] = -1;
   fclose(file);			}

  errfd = pinfo.fd_err[0];
	}

  while((n=read(errfd,buf,1023)) > 0) {
    buf[n] = '\0';
    p = strstr(buf, "Current");
    if (p)
	p = strchr(p, '\n');
    if (p && *p)
	p++;

    if (p && *p) {
     while ((q = strchr(p, '\n')) != NULL) {
	*q = '\0';
	if (strlen(p))
	 display_msg(MSG_LOG, "PGP", p);
	*q = '\n';
	p = q + 1;
					   }
     if (strlen(p))
      display_msg(MSG_LOG, "PGP", p);
		}

    if((p=strstr(buf,"Good signature")) ||
       (p=strstr(buf,"WARNING:"))) {
	if (strlen(p) > 255)
		p[255] = '\0';
	if (strstr(p, "Can't find the right public key")) {}
	else
	if ((q = strchr(p, '\n')) != NULL) 	{
		*q = '\0';
		q++;
      		display_msg(MSG_MSG,p,q);	}
	else
		display_msg(MSG_MSG,"PGP messsage (see Log for more details)",p);
				  }
    if((p=strstr(buf,"ERROR:")) ||
       (p=strstr(buf,"Error:")) ||
       (p=strstr(buf,"You do not have the secret key")) ||
       (p=strstr(buf,"Key matching expected")) ||
       (p=strstr(buf,"Encryption error")) ) {
	/* if we decoding encoded and signed message */
        /* but no public key could be found - still show the results */
	if (!(mode&DECODE) && !strstr(buf,"Key matching expected"))
        	move_result=0;

	if (strstr(buf,"Key matching expected")) {
		char keystr[9];
		if (!tries)	{
			if (b_getcfg_int(conf_name,"pgpusekeyring",0))
				try |= KEYRING;
			if (b_getcfg_int(conf_name,"pgpusehttp",0))
				try |= HTTP;
				}
		strncpy(keystr,p+29,8);
		keystr[8]='\0';
		keyid=strtoul(keystr,NULL,16);
		if ((tries == 0) &&
			!(try & KEYRING) &&
			!(try & HTTP))
			display_msg(MSG_WARN, "PGP", "Can not find key %s in public keyring", keystr);
		if (tries > 0)
			display_msg(MSG_WARN, "PGP", "Can not find key %s in both public and additional keyrings", keystr);
		p = NULL;
						}
	if (p) {
	 if ((q = strchr(p, '\n')) != NULL) 	{
		*q++ = '\0';
		if ((r = strchr(q, '\n')) != NULL)
			*r = '\0';
		while ((*q < 32) && (*q != '\0'))
			q++;
		while ((*p < 32) && (*p != '\0'))
			p++;
		if (strlen(q) > 80)
			q[80] = '\0';
		if (strlen(p) > 80)
			p[80] = '\0';
      		display_msg(MSG_WARN,p,q);	}
	 else	{
		while ((*p < 32) && (*p != '\0'))
			p++;
		if (strlen(p) > 80)
			p[80] = '\0';
		display_msg(MSG_WARN,"PGP Error (See Log for more details)",p);
		}
	      }
	/* forget the pass phrase */
      if((mode&(DECODE|SIGN|SIGNFL)) && p &&
	strstr(p, "pass phrase"))
	PGP_Timer_Call(NULL, 0);
    }
  }
  
  close(pinfo.fd_err[0]);
  if (pinfo.fd_out[0] != -1)
	close(pinfo.fd_out[0]);
  if (pinfo.fd_in[1] != -1)
	close(pinfo.fd_in[1]);

  check_extprocs();
  for (n=0; (pgpext == -100) && (n < 5); n++) 	{
	check_extprocs();
	sleep(1);				}

  if (pgpext == -100) 	{	/* pgp is still running */
	display_msg(MSG_WARN, "PGP", "Stuck PGP process");
	if (pinfo.pid > 0)
		kill(pinfo.pid, SIGKILL);	/* nuke it */
	move_result = 0;
			}
  else /* pgp exit status was not 0 and not 1 (??) */
   if ((pgpext != 0) && (pgpext != 1)) 	{
	display_msg(MSG_WARN, "PGP", "PGP terminated with status %d", pgpext);
	move_result = 0;
			}

  tries++;
  }

  if(move_result) {
    if (mode&VRFYFL)
	return 0;

    if (mode&SIGNFL)
	return 0;

    if (stat(nfile, &sb) == -1)
	return -1;

    if (sb.st_size == 0) {
	display_msg(MSG_WARN, "PGP", "PGP produced no output");
	unlink(nfile);
	return -1;	 }

    if (do_move(nfile,inbuf) != 0) {
	unlink(nfile);
	return -1;		   }

    return 0;
  } else
    unlink(nfile);

  return -1;
}

int
is_pgp(file)
char *file;
{
FILE *pfd;
char buf[255];

 if ((pfd = fopen(file, "r")) == NULL)
	return -1;

 while (fgets(buf, 255, pfd)) 	{
  strip_newline(buf);
  if (!*buf)
	continue;

  if (!strcmp(buf, PGP_ENC_START)) {
	fclose(pfd);
	return 1;		   }

  if (!strcmp(buf, PGP_SIG_START)) {
	fclose(pfd);
	return 2;		   }

  if (!strcmp(buf, PGP_KEY_START)) {
	fclose(pfd);
	return 3;		   }

  fclose(pfd);
  return 0;
				}

 fclose(pfd);
 return 0;
}

int
pgp_decode_file(file)
char *file;
{
int res;
struct pgpargs pgpargs;

  init_pgpargs(&pgpargs);
  pgpargs.passphrase=input_passphrase();
 
  if ((res = pgp_action(file, DECODE, &pgpargs)) != 0)
        display_msg(MSG_WARN, "reply", "Failed to decode PGP message");
 
  if (pgpargs.passphrase)
        free(pgpargs.passphrase);

  return res;
}

void
PGP_Conf_Lookup_CB(FL_OBJECT *obj, long data)  
{
  int keyid;
  char buf[12];
  keyid=PGP_Lookup_PGPId(b_getcfg_str(conf_name,"from",""),
                         pgp_obj->config_pgp);
  if (keyid) {
    sprintf(buf,"0x%X",keyid);
    fl_set_input(pgp_obj->PGP_User,buf);
  }
}

void
pgp_conf(int set_default, FD_config_pgp *form)
{
 pgp_obj = form;

 fl_clear_choice(pgp_obj->PGP_Mime);
 fl_addto_choice(pgp_obj->PGP_Mime, "Text");
 fl_addto_choice(pgp_obj->PGP_Mime, "application/pgp");
 fl_addto_choice(pgp_obj->PGP_Mime, "Multipart");
 fl_set_choice(pgp_obj->PGP_Mime, b_getcfg_int_default(conf_name, "pgpmime", 0, set_default) + 1);

 fl_set_input(pgp_obj->PGP_Prog, b_getcfg_str_default(conf_name, "pgp", _PATH_PGP, set_default));
 fl_set_input(pgp_obj->PGP_Keyring, b_getcfg_str_default(conf_name, "pgpkeyring", "", set_default));
 fl_set_input(pgp_obj->PGP_KeyServer, b_getcfg_str_default(conf_name, "pgpkeyserver", "", set_default));
 fl_set_input(pgp_obj->PGP_User, b_getcfg_str_default(conf_name, "pgpuser", user_n, set_default));
 fl_set_button(pgp_obj->PGP_Sign, b_getcfg_int_default(conf_name, "pgpsign", 0, set_default));
 fl_set_button(pgp_obj->PGP_Use_Keyring, b_getcfg_int_default(conf_name, "pgpusekeyring", 0, set_default));
 fl_set_button(pgp_obj->PGP_Use_HTTP, b_getcfg_int_default(conf_name, "pgpusehttp", 0, set_default));
 fl_set_counter_value(pgp_obj->PGP_Timer_Count, (double)b_getcfg_int_default(conf_name, "pgptimer", 120, set_default));
}

void
handle_pgp_input(FD_config_pgp *form)
{
 pgp_obj = form;
 b_putcfg_str(conf_name, "pgp", (char *)fl_get_input(pgp_obj->PGP_Prog));
 b_putcfg_str(conf_name, "pgpkeyring", (char *)fl_get_input(pgp_obj->PGP_Keyring));
 b_putcfg_str(conf_name, "pgpkeyserver", (char *)fl_get_input(pgp_obj->PGP_KeyServer));
 b_putcfg_str(conf_name, "pgpuser", (char *)fl_get_input(pgp_obj->PGP_User));
 b_putcfg_int(conf_name, "pgpmime", fl_get_choice(pgp_obj->PGP_Mime) - 1);
 b_putcfg_int(conf_name, "pgpsign", fl_get_button(pgp_obj->PGP_Sign));
 b_putcfg_int(conf_name, "pgpusekeyring", fl_get_button(pgp_obj->PGP_Use_Keyring));
 b_putcfg_int(conf_name, "pgpusehttp", fl_get_button(pgp_obj->PGP_Use_HTTP));
 b_putcfg_int(conf_name, "pgptimer", (int)fl_get_counter_value(pgp_obj->PGP_Timer_Count));
}

int
cancel_form_lookup_cb(FL_FORM *obj, void *data)
{
  return FL_IGNORE;
}

int     
compare_pgpkeys(entry1, entry2)
struct _pgp_keylist *entry1, *entry2;
{
 return strcasecmp(entry1->userid, entry2->userid);
}

unsigned long
PGP_Lookup_PGPId(const char *name, FL_FORM *form)
{
  int i = 0, keyids_size = 100, line, w, h;
  char buf[1024], *userid, geom[16], keyfile[255];
  proc_info pinfo;
  FILE *in;
  unsigned long keyid;
  struct _pgp_keylist *keylist;
  FL_OBJECT *obj;
  
  if (form_lookup_pgpid)
    return 0;

  strcpy(keyfile, get_temp_file("pgpkeys"));
  sprintf(buf, "%s +batchmode +language=en -kv",
				b_getcfg_str(conf_name, "pgp", _PATH_PGP));
  init_pinfo(&pinfo);
  pinfo.ofd = open(keyfile, O_WRONLY|O_CREAT, 00600);
  pinfo.wait = WAIT_BG;

 /* unset PGPPASSFD , otherwise it will hang! */
#ifdef	HAVE_UNSETENV
  unsetenv("PGPPASSFD");
#else
  Unsetenv("PGPPASSFD");
#endif

  if (exec_child(buf,&pinfo) == -1)	{
    unlink(keyfile);
    return 0;				}

  check_extprocs();
  /* 
   * This routine heavily depends on the format of the output of
   * "pgp +language=en -kv":
   * 1. read all lines not beginning with "pub " (usually 7 lines)
   */
  if ((in = fopen(keyfile,"r")) == NULL) {
	display_msg(MSG_WARN, "PGP", "Can not read key list\n");
	unlink(keyfile);
	return 0;			 }

  do {
    if (!fgets(buf, 1024, in))	{
      display_msg(MSG_WARN, "PGP", "Invalid key list\n");
      fclose(in);
      unlink(keyfile);
      return 0;			}
  } while (strncmp(buf, "pub ", 4));

  form_lookup_pgpid = create_form_Lookup_PGPId();
  fl_set_form_atclose(form_lookup_pgpid->Lookup_PGPId, cancel_form_lookup_cb, NULL);

  fl_freeze_form(form_lookup_pgpid->Lookup_PGPId);

  fl_set_object_label(form_lookup_pgpid->PGP_Lookup, name);
  fl_set_object_lstyle(form_lookup_pgpid->PGP_Lookup, supp_charsets[def_charset].font_style);
  fl_set_object_lsize(form_lookup_pgpid->PGP_Lookup, supp_charsets[def_charset].font_size);

  fl_set_object_label(form_lookup_pgpid->PGP_selected_id, "");
  fl_set_object_lstyle(form_lookup_pgpid->PGP_selected_id, supp_charsets[def_charset].font_style);
  fl_set_object_lsize(form_lookup_pgpid->PGP_selected_id, supp_charsets[def_charset].font_size);

  fl_set_browser_fontstyle(form_lookup_pgpid->PGP_Lookup_Browser, supp_charsets[def_charset].font_style);
  fl_set_browser_fontsize(form_lookup_pgpid->PGP_Lookup_Browser, supp_charsets[def_charset].font_size);
  fl_clear_browser(form_lookup_pgpid->PGP_Lookup_Browser);

  /*
   * 2. interpret all following lines not beginning with a digit (this
   *    is the last line!) as keys.
   * Every key's id starts at column 11, the user id at column 31.
   * Additional user id's belonging to the same key again start at
   * column 31, but don't have a key id.
   */
  keylist = (struct _pgp_keylist *)malloc(keyids_size * sizeof(struct _pgp_keylist));
  keyid = 0;
  do {
    if (buf[10] != ' ')
	keyid = strtoul(buf+10,NULL,16);
    if ((userid = strchr(buf + 30,'\n')) != NULL)
      *userid = '\0';
    userid = buf + 30;
    
    if (i == keyids_size)						{
      keyids_size += keyids_size;
      keylist = (struct _pgp_keylist *)realloc(keylist,
			keyids_size * sizeof(struct _pgp_keylist));	}

    if (keylist == NULL)
	break;
    keylist[i].userid = strdup(userid);
    keylist[i].keyid = keyid;
    i++;
  } while(fgets(buf, 1024, in) && !isdigit(buf[0]));

  fclose(in);
  unlink(keyfile);

  qsort(keylist, i, sizeof(struct _pgp_keylist),
        (int(*)(const void*, const void*))compare_pgpkeys);

  for (line = 0; line < i; line++)
   fl_add_browser_line(form_lookup_pgpid->PGP_Lookup_Browser, keylist[line].userid);

  fl_unfreeze_form(form_lookup_pgpid->Lookup_PGPId);
  fl_deactivate_form(form);
  b_setcfg_flags("pgpgeom", CF_NOTCHANGED);
  w = 350;
  h = 400;
  sscanf(b_getcfg_str(conf_name, "pgpgeom", ""), "%d %d", &w, &h);
  fl_set_form_minsize(form_lookup_pgpid->Lookup_PGPId, 350, 400);
  fl_set_form_size(form_lookup_pgpid->Lookup_PGPId, w, h);
  fl_show_form(form_lookup_pgpid->Lookup_PGPId, 
               FL_PLACE_FREE, FL_FULLBORDER, "Lookup PGP Id");

  line = 0;
  for(;;) {
    obj = fl_do_forms();
    keyid = 0;
    if (obj == form_lookup_pgpid->PGP_Lookup_Browser)	{
      if ((line == fl_get_browser(form_lookup_pgpid->PGP_Lookup_Browser)) &&
         (fl_get_timer(form_lookup_pgpid->PGP_Lookup_Timer) > 0.0))	{
        keyid = keylist[line-1].keyid;
        break;								}
      line = fl_get_browser(form_lookup_pgpid->PGP_Lookup_Browser);
      sprintf(buf,"0x%X", (unsigned int)keylist[line-1].keyid);
      fl_set_object_label(form_lookup_pgpid->PGP_selected_id,buf);
      fl_set_timer(form_lookup_pgpid->PGP_Lookup_Timer, 0.4);
							}
    if (obj == form_lookup_pgpid->PGP_Lookup_Ok) {
      keyid = line ? keylist[line-1].keyid : 0;
      break;					 }
    if (obj == form_lookup_pgpid->PGP_Lookup_Cancel)	{
      keyid = 0;
      break;						}
	  }

  for (line = 0; line < i; line++)
	free(keylist[line].userid);
  free(keylist);

  sprintf(geom, "%d %d", form_lookup_pgpid->Lookup_PGPId->w, form_lookup_pgpid->Lookup_PGPId->h);
  b_putcfg_str(conf_name, "pgpgeom", geom);

  fl_hide_form(form_lookup_pgpid->Lookup_PGPId);
  fl_free_form(form_lookup_pgpid->Lookup_PGPId);
  form_lookup_pgpid = NULL;
  fl_activate_form(form);
  return keyid;
}

char *
get_pgp_recp(msg)
struct _mail_msg *msg;
{
static char recp[1024];
struct _mail_addr *ptr = NULL;
struct _abook_entry *entry;
int i;

  *recp = '\0'; 
   
  for (i = 0; i <= 1; i++) {
    if (i == 0)      
      ptr = msg->header->To;
    if (i == 1)
      ptr = msg->header->Cc;
    while (ptr)         {
     if (!ptr->pgpid || !strlen(ptr->pgpid))
       if ((entry = find_addr(ptr)))
         if ((entry->addr->pgpid) && strlen(entry->addr->pgpid)) {
           if ((strlen(entry->addr->pgpid) + strlen(recp) + 1) >= sizeof(recp))
             break;
           strcat(recp,entry->addr->pgpid);
           goto nextitem;
         }
     if (ptr->pgpid && strlen(ptr->pgpid)) {
       if ((strlen(ptr->pgpid) + strlen(recp) + 1) >= sizeof(recp))
        break;
       strcat(recp,ptr->pgpid);
     } else {
       if ((strlen(ptr->addr) + strlen(recp) + 1) >= sizeof(recp))
        break;
       strcat(recp,ptr->addr);
     }
nextitem:
     strcat(recp," ");
     ptr=ptr->next_addr;
                }
  }

 return *recp ? recp : NULL;
}

int
pgp_encode_rfc2015(msg, mode)
struct _mail_msg *msg;
int mode;
{
struct _mime_msg *mime;
struct _head_field *fld;
struct pgpargs pgpargs;
char efile[255], vfile[255], buf[255];
FILE *efd;

 init_pgpargs(&pgpargs);
 if (msg->flags & PGP_SIGNED)	{
	display_msg(MSG_WARN, "encode", "Message is already signed by PGP");
	return -1;		}

 if (msg->flags & PGP_ENCRYPTED) {
	display_msg(MSG_WARN, "encode","Message is already encrypted with PGP");
	return -1;		 }

 if ((pgpargs.recp = get_pgp_recp(msg)) == NULL) {
	display_msg(MSG_WARN, "encode", "Must specify at least one recipient");
	return -1;			 }

 if (!msg->mime)
	mime_scan(msg);

 mime = msg->mime;
 while (mime)		  {
  if (mime->flags & MSG_BODY)
	break;
  mime = mime->mime_next; }

 if (!mime)
	return -1;

 strcpy(efile, get_temp_file("pgpencr"));
 if ((efd = fopen(efile, "w")) == NULL) {
	display_msg(MSG_WARN, "encode", "Can not create temp. file %-.64s", efile);
	return -1;			}

 if ((fld = find_field(msg, MIME_C_TYPE)) != NULL)
	print_header_field(fld, efd, 0);
 else
	fprintf(efd, "%s: %s/%s\n", MIME_C_TYPE, mime->mailcap->type_text,
		 mime->mailcap->subtype_text);

 if (mime->encoding->c_trans_enc != CE_7BIT) {
  if ((fld = find_field(msg, MIME_C_ENCR)) != NULL)
	print_header_field(fld, efd, 0);
  else
	fprintf(efd, "%s: %s\n", MIME_C_ENCR, mime->encoding->encoding_name);
					     }

 fputc('\n', efd);
 if (msg->print_body(msg, efd) == -1) {
	display_msg(MSG_WARN, "encode", "Failed to write message");
	fclose(efd);
	unlink(efile);
	return -1;		      }
 fclose(efd);

 if (mode & SIGN)
	pgpargs.passphrase = input_passphrase();
 pgpargs.msg = msg;
 if (pgp_action(efile, mode, &pgpargs) != 0)   	{
	unlink(efile);
	if (pgpargs.passphrase)
		free(pgpargs.passphrase);
	return -1;				 	}
 if (pgpargs.passphrase)
	free(pgpargs.passphrase);

 strcpy(vfile, get_temp_file("pgpvers"));
 if ((efd = fopen(vfile, "w")) == NULL) {
	display_msg(MSG_WARN, "encode", "Can not create temp. file %-.64s", vfile);
	unlink(efile);
	return -1;			}

 fprintf(efd, "Version: 1\n");
 fclose(efd);

 discard_mime(msg->mime);
 mime = msg->mime = create_mime();
 mime->mailcap = &mailcap[PGPENC_MAILCAP];
 mime->encoding = &supp_encodings[TEXT_ENCODING];
 mime->flags |= ATTACHMENT;
 mime->flags &= ~TEXT_PART;
 mime->src_info = strdup(vfile);
 sprintf(buf, "%s/%s", mailcap[PGPENC_MAILCAP].type_text, mailcap[PGPENC_MAILCAP].subtype_text);
 replace_mime_field(mime, MIME_C_TYPE, buf);

 mime->mime_next = create_mime();
 mime = mime->mime_next;
 mime->mailcap = &mailcap[BINARY_MAILCAP];
 mime->encoding = &supp_encodings[TEXT_ENCODING];
 mime->flags |= ATTACHMENT;
 mime->flags &= ~TEXT_PART;
 mime->src_info = strdup(efile);
 sprintf(buf, "%s/%s", mailcap[BINARY_MAILCAP].type_text, mailcap[BINARY_MAILCAP].subtype_text);
 replace_mime_field(mime, MIME_C_TYPE, buf);

 if (update_mime(msg) == -1)	{
	unlink(vfile);
	unlink(efile);
	return -1;		}

 unlink(vfile);
 unlink(efile);
 msg->flags |= PGP_ENCRYPTED;

 return 0;
}

int
pgp_sign_rfc2015(msg)
struct _mail_msg *msg;
{
struct _mime_msg *mime, *mime1, *mbody;
struct _head_field *fld;
char efile[255], vfile[255], buf[255];
FILE *efd;
struct pgpargs pgpargs;

 init_pgpargs(&pgpargs);
 if (msg->flags & PGP_SIGNED)	{
	display_msg(MSG_WARN, "sign", "Message is already signed by PGP");
	return -1;		}

 if (msg->flags & PGP_ENCRYPTED) {
	display_msg(MSG_WARN, "sign","Message is already encrypted with PGP");
	return -1;		 }

 if (!msg->mime)
	mime_scan(msg);

 mbody = msg->mime;
 while (mbody)		    {
  if (mbody->flags & MSG_BODY)
	break;
  mbody = mbody->mime_next; }

 if (!mbody)
	return -1;

 strcpy(efile, get_temp_file("pgpsign"));
 if ((efd = fopen(efile, "w")) == NULL) {
	display_msg(MSG_WARN, "sign","Can not create temp. file %-.64s", efile);
	return -1;			}

 if ((fld = find_field(msg, MIME_C_TYPE)) != NULL)
	print_header_field(fld, efd, 0);
 else
	fprintf(efd, "%s: %s/%s\n", MIME_C_TYPE, mbody->mailcap->type_text,
		 mbody->mailcap->subtype_text);

 if (mbody->encoding->c_trans_enc !=
        supp_encodings[DEFAULT_ENCODING].c_trans_enc)	{
  if ((fld = find_field(msg, MIME_C_ENCR)) != NULL)
	print_header_field(fld, efd, 0);
  else
	fprintf(efd, "%s: %s\n", MIME_C_ENCR, mbody->encoding->encoding_name);
					     		}

 fputc('\n', efd);
 if (msg->print_body(msg, efd) == -1) {
	display_msg(MSG_WARN, "sign", "Failed to write message");
	fclose(efd);
	unlink(efile);
	return -1;		      }
 fclose(efd);

 strcpy(vfile, get_temp_file("pgps"));
 pgpargs.passphrase = input_passphrase();
 pgpargs.recp = vfile;
 pgpargs.msg = msg;
 if (pgp_action(efile, SIGNFL, &pgpargs) != 0)	{
	unlink(efile);
	unlink(vfile);
	if (pgpargs.passphrase)
	   free(pgpargs.passphrase);
	return -1;				}
 if (pgpargs.passphrase)
	free(pgpargs.passphrase);

 if ((efd = fopen(efile, "w")) == NULL) {
	display_msg(MSG_WARN, "sign","Can not create temp. file %-.64s", efile);
	unlink(efile);
	unlink(vfile);
	return -1;			}

 if (msg->print_body(msg, efd) == -1) {
	display_msg(MSG_WARN, "sign", "Failed to write message");
	fclose(efd);
	unlink(efile);
	unlink(vfile);
	return -1;		      }
 fclose(efd);

 mime = create_mime();
 mime->mime_next = NULL;
 mime->mailcap = &mailcap[PGPSIG_MAILCAP];
 mime->encoding = &supp_encodings[NO_ENCODING];
 mime->flags |= ATTACHMENT;
 mime->flags &= ~TEXT_PART;
 mime->src_info = strdup(vfile);
 sprintf(buf, "%s/%s", mailcap[PGPSIG_MAILCAP].type_text, mailcap[PGPSIG_MAILCAP].subtype_text);
 replace_mime_field(mime, MIME_C_TYPE, buf);

 mime1 = create_mime();
 mime1->mime_next = mime;
 mime1->mailcap = find_mailcap(mbody->mailcap->type_text,
	mbody->mailcap->subtype_text, 1);
 mime1->encoding = &supp_encodings[NO_ENCODING];
 mime1->flags |= ATTACHMENT;
 mime1->flags &= ~TEXT_PART;
 mime1->src_info = strdup(efile);
 if ((fld = find_field(msg, MIME_C_TYPE)) != NULL)
	replace_mime_field(mime1, MIME_C_TYPE, fld->f_line);
 else	{
	sprintf(buf, "%s: %s/%s", MIME_C_TYPE, mbody->mailcap->type_text,
		 mbody->mailcap->subtype_text);
	replace_mime_field(mime1, MIME_C_TYPE, buf);
	}

 if (mbody->encoding->c_trans_enc !=
        supp_encodings[DEFAULT_ENCODING].c_trans_enc)	{
  if ((fld = find_field(msg, MIME_C_ENCR)) != NULL)
	replace_mime_field(mime1, MIME_C_ENCR, fld->f_line);
  else	{
	sprintf(buf, "%s: %s\n", MIME_C_ENCR, mbody->encoding->encoding_name);
	replace_mime_field(mime1, MIME_C_ENCR, buf);
	}
							}

 discard_mime(msg->mime);
 msg->mime = mime1;

 if (update_mime(msg) == -1)	{
	unlink(vfile);
	unlink(efile);
	return -1;		}

 unlink(vfile);
 unlink(efile);
 msg->flags |= PGP_SIGNED;

 return 0;
}
