PROG        = xfmail
XFDATE      = `date "+%m%d%y"`				# release date
XFDIST	    = ${PROG}-${XFDATE}				# distribution name
FTPDIR      = /usr/home_local/ftp/pub/xfmail/work	# ftp home
FTPDIST     = ${XFDIST}.tar.gz				# source tarball
PATCHDIST   = ${XFDIST}.diff				# patches
COMMITLOG   = $(CVSROOT)/CVSROOT/commitlog		# CVS commit log
MAILTMP     = /tmp/xfmail.msg				# temp file for mail

design:
	@rm -f dialogs.c.bak
	@fdesign -I newobjs.h dialogs.fd
	@if [ -f dialogs.c.bak ]; then \
	rm -f config.o faces.o inc.o int_conf.o mime_conf.o misc.o \
	pgp.o pop_smtp.o rep_fwd.o sort.o spellchecker.o view_edit.o \
	imap_conf.o font.o ; \
	fi

dist:
	@sed "s/@XFRELDATE@/${XFDATE}/g" version.src > version.h.in
	@if [ -f ${PROG} ]; then \
	rm -f ${FTPDIR}/bin/${PROG}-*.`uname` ; \
	${INSTALL} ${COPY} ${STRIP} -m ${BINMODE} \
	${INSTALLFLAGS} ${PROG} ${FTPDIR}/bin/${PROG}-${XFDATE}.`uname` ; \
	fi
	${INSTALL} ${COPY} -m 644 \
	${INSTALLFLAGS} ../Changelog ${FTPDIR}
	${INSTALL} ${COPY} -m 644 \
	${INSTALLFLAGS} ../README ${FTPDIR}
	${INSTALL} ${COPY} -m 644 \
	${INSTALLFLAGS} ../TODO ${FTPDIR}
	${INSTALL} ${COPY} -m 644 \
	${INSTALLFLAGS} ../KNOWNBUGS ${FTPDIR}
	${MAKE} clean
	-@(cd ..;/usr/bin/cvs diff -c -N > ${FTPDIR}/${PATCHDIST})
	@(cd ..;/usr/bin/cvs commit)
	@rm -f ../Makefile ../config.log ../config.cache ../config.status \
	config.h version.h Makefile ../compface/Makefile ../regex/Makefile
	@(cd ../..;tar -zcf ${FTPDIST} ${PROG};mv ${FTPDIST} ${FTPDIR})
	@rm -f ${FTPDIR}/xfmail-current.tar.gz
	@(cd ${FTPDIR}; ln -s ${FTPDIST} xfmail-current.tar.gz)
	@rm -f ${MAILTMP}
	@echo New XFMail development release is available > ${MAILTMP} 2>&1
	@echo It can be downloaded from ftp://burka.netvision.net.il/pub/xfmail/work/${FTPDIST} >> ${MAILTMP} 2>&1
	@echo >> ${MAILTMP} 2>&1
	@echo Changes since previous development release \(CVS log\): >> ${MAILTMP} 2>&1
	@cat ${COMMITLOG} >> ${MAILTMP} 2>&1
	@echo >> ${MAILTMP} 2>&1
	@echo ----------- context diff since previous release ------- >> ${MAILTMP} 2>&1
	@gzip -c ${FTPDIR}/${PATCHDIST} | uuencode ${PATCHDIST}.gz >> ${MAILTMP} 2>&1
	@/usr/bin/mail -s "Announce: ${FTPDIST}" xfmail-dev@burka.netvision.net.il < ${MAILTMP}
	@gzip ${FTPDIR}/${PATCHDIST}
	@rm -f ${MAILTMP}
	@rm -f ${COMMITLOG}
	@touch ${COMMITLOG}
