/* mainw.c -- create and handle main window				*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */

#include "xdatplot.h"

typedef	void	MENU_CB();
typedef	struct MENU_CB_LIST {
    int		ni;			/* number items			*/
    MENU_CB	**cbs;			/* callbacks for each		*/
}		MENU_CB_LIST;

#ifdef	__STDC__
static	Widget	create_menubar(Widget);
static	void	menu_cb(MENU_CB_LIST *, int);
static	void	file_cb(Widget, int, XmAnyCallbackStruct *);
static	void	analyze_cb(Widget, int, XmAnyCallbackStruct *);
static	void	marks_cb(Widget, int, XmAnyCallbackStruct *);
static	void	windows_cb(Widget, int, XmAnyCallbackStruct *);
static	void	help_cb(Widget, int, XmAnyCallbackStruct *);
static	void	file_open_cb(void);
static	void	file_open_ok(Widget, XtPointer,
			     XmFileSelectionBoxCallbackStruct *);
static	void	unmap_cancel(Widget, Widget,
				 XmFileSelectionBoxCallbackStruct *);
static	void	file_print_cb(void);
static	void	print_format_choice_cb(Widget, int,
				       XmToggleButtonCallbackStruct *);
static	void	file_print_ok(void);
static	void	file_save_cb(void);
static	void	file_save_ok(Widget, XtPointer,
			     XmFileSelectionBoxCallbackStruct *);
static	void	file_save_help(Widget, XtPointer,
			       XmFileSelectionBoxCallbackStruct *);
static	void	file_mif_cb(void);
static	void	file_mif_ok(Widget, XtPointer,
			     XmFileSelectionBoxCallbackStruct *);
static	void	file_ps_cb(void);
static	void	ps_format_choice_cb(Widget, int,
				       XmToggleButtonCallbackStruct *);
static	void	file_ps_ok(Widget, XtPointer,
			     XmFileSelectionBoxCallbackStruct *);
static	void	file_quit_cb(void);
static	void	analyze_cb(Widget, int, XmAnyCallbackStruct *);
static	void	analyze_template_cb(void);
static	void	analyze_peaks_cb(void);
static	void	analyze_filter_cb(void);
static	void	analyze_units_cb(void);
static	void	marks_save_cb(void);
static	void	marks_save_ok(Widget, XtPointer,
			      XmFileSelectionBoxCallbackStruct *);
static	void	marks_read_cb(void);
static	void	marks_read_ok(Widget, XtPointer,
			      XmFileSelectionBoxCallbackStruct *);
static	void	marks_filter_cb(void);
static	void	windows_newwin_cb(void);
static	void	help_cb(Widget, int, XmAnyCallbackStruct *);
static	void	help_about_cb(void);
static	void	help_manual_cb(void);
static	void	help_keys_cb(void);
static	void	help_files_cb(void);
#else	__STDC__
static	Widget	create_menubar();
static	void	menu_cb();
static	void	file_cb();
static	void	analyze_cb();
static	void	marks_cb();
static	void	windows_cb();
static	void	help_cb();
static	void	file_open_cb();
static	void	file_open_ok();
static	void	unmap_cancel();
static	void	file_print_cb();
static	void	print_format_choice_cb();
static	void	file_print_ok();
static	void	file_save_cb();
static	void	file_save_ok();
static	void	file_save_help();
static	void	file_mif_cb();
static	void	file_mif_ok();
static	void	file_ps_cb();
static	void	ps_format_choice_cb();
static	void	file_ps_ok();
static	void	file_quit_cb();
static	void	analyze_cb();
static	void	analyze_template_cb();
static	void	analyze_peaks_cb();
static	void	analyze_filter_cb();
static	void	analyze_units_cb();
static	void	marks_save_cb();
static	void	marks_save_ok();
static	void	marks_read_cb();
static	void	marks_read_ok();
static	void	marks_filter_cb();
static	void	windows_newwin_cb();
static	void	help_cb();
static	void	help_about_cb();
static	void	help_manual_cb();
static	void	help_keys_cb();
static	void	help_files_cb();
#endif	__STDC__

/*
 * where we store the menus
 */
MENU_CB_LIST	file_cbs;
MENU_CB_LIST	analyze_cbs;
MENU_CB_LIST	marks_cbs;
MENU_CB_LIST	windows_cbs;
MENU_CB_LIST	help_cbs;

/*
 * Popup widgets
 */
static	Widget	file_open_pu = NO_WIDGET;
static	Widget	file_save_pu = NO_WIDGET;
static	Widget	file_mif_pu = NO_WIDGET;
static	Widget	file_ps_pu = NO_WIDGET;
static	Widget	file_print_pu = NO_WIDGET;
static	Widget	analyze_filter_sh = NO_WIDGET;
static	Widget	analyze_units_sh = NO_WIDGET;
static	Widget	analyze_peaks_sh = NO_WIDGET;
static	Widget	analyze_template_sh = NO_WIDGET;
static	Widget	marks_save_pu = NO_WIDGET;
static	Widget	marks_read_pu = NO_WIDGET;
static	Widget	marks_filter_pu = NO_WIDGET;

void
create_main_window(toplevel)
Widget		toplevel;
{
    Widget		main_w;
    Widget		menubar;
    Widget		control;

    main_w = XtVaCreateManagedWidget("main",
	xmMainWindowWidgetClass, toplevel,
	XmNscrollingPolicy, XmAPPLICATION_DEFINED,
    NULL);
    AddCallback(main_w, XmNdestroyCallback, exit_program, NULL);
    create_plot_window(main_w);
    menubar = create_menubar(main_w);
    control = create_control(main_w);
    XmMainWindowSetAreas(main_w, menubar, control, hsb, vsb, plot);
    XtVaSetValues(main_w,
/*	XmNmenuBar, menubar,
	XmNcommandWindow, control, */
	XmNcommandWindowLocation, XmCOMMAND_BELOW_WORKSPACE,
    NULL);
}

/* create_menubar -- create menu bar for main window			*/
static Widget
create_menubar(main_w)
Widget		main_w;
{
    register int	i;
    Widget		menubar;
    Widget		help_button;
    Widget		file_menu;
    Widget		help_menu;
    XmString		file = XmStringCreateSimple("File");
    XmString		    open = XmStringCreateSimple("Open...");
    XmString		    save = XmStringCreateSimple("Save...");
    XmString		    print = XmStringCreateSimple("Print...");
    XmString		    mif = XmStringCreateSimple("Export MIF...");
    XmString		    ps = XmStringCreateSimple("Export PostScript...");
    XmString		    quit = XmStringCreateSimple("Quit");
    XmString		analyze = XmStringCreateSimple("Analyze");
    XmString		    filter = XmStringCreateSimple("Filter...");
    XmString		    units = XmStringCreateSimple("Units...");
    XmString		    peaks = XmStringCreateSimple("Peaks...");
    XmString		    template = XmStringCreateSimple("Create Template...");
    XmString		marks = XmStringCreateSimple("Marks");
    XmString		    read = XmStringCreateSimple("Read...");
    XmString		windows = XmStringCreateSimple("Windows");
    XmString		    newwin = XmStringCreateSimple("New Window");
    XmString		help = XmStringCreateSimple("Help");
    XmString		    about = XmStringCreateSimple("About xdatplot...");
    XmString		    keys = XmStringCreateSimple("Cursor and Keys...");
    XmString		    manual = XmStringCreateSimple("xdatplot Manual...");
    XmString		    files = XmStringCreateSimple("Files...");

    menubar = XmVaCreateSimpleMenuBar(main_w, "menubar",
	XmVaCASCADEBUTTON, file, 'F',
	XmVaCASCADEBUTTON, analyze, 'A',
	XmVaCASCADEBUTTON, marks, 'M',
	XmVaCASCADEBUTTON, windows, 'W',
	XmVaCASCADEBUTTON, help, 'H',
    NULL);
    if (NULL != (help_button = XtNameToWidget(menubar, "button_4")))
	XtVaSetValues(menubar, XmNmenuHelpWidget, help_button, NULL);
    file_menu = XmVaCreateSimplePulldownMenu(menubar, "fileMenu", 0,
	(XtCallbackProc) file_cb,
	XmVaPUSHBUTTON, open, 'O', NULL, NULL,
	XmVaPUSHBUTTON, save, 'S', NULL, NULL,
	XmVaPUSHBUTTON, print, 'P', NULL, NULL,
	XmVaPUSHBUTTON, mif, 'M', NULL, NULL,
	XmVaPUSHBUTTON, ps, 'x', NULL, NULL,
	XmVaSEPARATOR, 
	XmVaPUSHBUTTON, quit, 'Q', NULL, NULL,
    NULL);
    {
	/*
	 * Workaround for bug in XmVaCreateSimplePulldownMenu: loses
	 * info about buttons below separator
	 */
	Widget	quit_button = XtNameToWidget(file_menu, "button_5");

	XtVaSetValues(quit_button,
	    XmNlabelString, quit,
	    XmNmnemonic, 'Q',
	NULL);
    }
    file_cbs.ni = 6;
    file_cbs.cbs = (MENU_CB **) XtCalloc(file_cbs.ni, sizeof(MENU_CB *));
    i = 0;
    file_cbs.cbs[i++] = &file_open_cb;
    file_cbs.cbs[i++] = &file_save_cb;
    file_cbs.cbs[i++] = &file_print_cb;
    file_cbs.cbs[i++] = &file_mif_cb;
    file_cbs.cbs[i++] = &file_ps_cb;
    file_cbs.cbs[i++] = &file_quit_cb;
    XmVaCreateSimplePulldownMenu(menubar, "analyzeMenu", 1,
	(XtCallbackProc) analyze_cb,
	XmVaPUSHBUTTON, filter, 'F', NULL, NULL,
	XmVaPUSHBUTTON, units, 'U', NULL, NULL,
	XmVaPUSHBUTTON, peaks, 'P', NULL, NULL,
	XmVaPUSHBUTTON, template, 'T', NULL, NULL,
    NULL);
    analyze_cbs.ni = 4;
    analyze_cbs.cbs = (MENU_CB **) XtCalloc(analyze_cbs.ni, sizeof(MENU_CB *));
    i = 0;
    analyze_cbs.cbs[i++] = &analyze_filter_cb;
    analyze_cbs.cbs[i++] = &analyze_units_cb;
    analyze_cbs.cbs[i++] = &analyze_peaks_cb;
    analyze_cbs.cbs[i++] = &analyze_template_cb;
    XmVaCreateSimplePulldownMenu(menubar, "marksMenu", 2,
	(XtCallbackProc) marks_cb,
	XmVaPUSHBUTTON, save, 'S', NULL, NULL,
	XmVaPUSHBUTTON, read, 'R', NULL, NULL,
	XmVaPUSHBUTTON, filter, 'F', NULL, NULL,
    NULL);
    marks_cbs.ni = 3;
    marks_cbs.cbs = (MENU_CB **) XtCalloc(marks_cbs.ni, sizeof(MENU_CB *));
    i = 0;
    marks_cbs.cbs[i++] = &marks_save_cb;
    marks_cbs.cbs[i++] = &marks_read_cb;
    marks_cbs.cbs[i++] = &marks_filter_cb;
    XmVaCreateSimplePulldownMenu(menubar, "windowsMenu", 3,
	(XtCallbackProc) windows_cb,
	XmVaPUSHBUTTON, newwin, 'N', NULL, NULL,
    NULL);
    windows_cbs.ni = 1;
    windows_cbs.cbs = (MENU_CB **) XtCalloc(windows_cbs.ni, sizeof(MENU_CB *));
    i = 0;
    windows_cbs.cbs[i++] = &windows_newwin_cb;
    help_menu = XmVaCreateSimplePulldownMenu(menubar, "helpMenu", 4,
	(XtCallbackProc) help_cb,
	XmVaPUSHBUTTON, about, 'A', NULL, NULL,
	XmVaSEPARATOR,
	XmVaPUSHBUTTON, manual, 'M', NULL, NULL,
	XmVaPUSHBUTTON, keys, 'K', NULL, NULL,
	XmVaPUSHBUTTON, files, 'F', NULL, NULL,
    NULL);
    {
	/*
	 * Workaround for bug in XmVaCreateSimplePulldownMenu: loses
	 * info about buttons below separator
	 */
	Widget	button;

	button = XtNameToWidget(help_menu, "button_1");
	XtVaSetValues(button, XmNlabelString, manual, XmNmnemonic, 'M', NULL);
	button = XtNameToWidget(help_menu, "button_2");
	XtVaSetValues(button, XmNlabelString, keys, XmNmnemonic, 'K', NULL);
	button = XtNameToWidget(help_menu, "button_3");
	XtVaSetValues(button, XmNlabelString, files, XmNmnemonic, 'F', NULL);
    }
    help_cbs.ni = 4;
    help_cbs.cbs = (MENU_CB **) XtCalloc(help_cbs.ni, sizeof(MENU_CB *));
    i = 0;
    help_cbs.cbs[i++] = &help_about_cb;
    help_cbs.cbs[i++] = &help_manual_cb;
    help_cbs.cbs[i++] = &help_keys_cb;
    help_cbs.cbs[i++] = &help_files_cb;
    XmStringFree(file);
        XmStringFree(open);
        XmStringFree(save);
        XmStringFree(print);
        XmStringFree(mif);
        XmStringFree(ps);
        XmStringFree(quit);
    XmStringFree(analyze);
        XmStringFree(filter);
        XmStringFree(units);
        XmStringFree(peaks);
    XmStringFree(help);
        XmStringFree(about);
        XmStringFree(manual);
        XmStringFree(keys);
        XmStringFree(files);
    XtManageChild(menubar);
    return(menubar);
}

static void
file_cb(widget, item, cbs)
Widget			widget;
int			item;
XmAnyCallbackStruct	*cbs;
{
    menu_cb(&file_cbs, item);
}

static void
analyze_cb(widget, item, cbs)
Widget			widget;
int			item;
XmAnyCallbackStruct	*cbs;
{
    menu_cb(&analyze_cbs, item);
}

static void
help_cb(widget, item, cbs)
Widget			widget;
int			item;
XmAnyCallbackStruct	*cbs;
{
    menu_cb(&help_cbs, item);
}

static void
menu_cb(cbsp, item)
MENU_CB_LIST	*cbsp;
int		item;
{
    if (item >= cbsp->ni) error("menu_cb: can't happen");
    (*cbsp->cbs[item])();
}

static void
file_open_cb()
{
    char		lbuf[LLEN];
    String		s;
    XmString		xms;
    Widget		help_button;
    Arg			args[1];

    dprintf("file_open\n");
    if (NO_WIDGET == file_open_pu) {
	XtSetArg(args[0], XmNautoUnmanage, True);
	file_open_pu = XmCreateFileSelectionDialog(toplevel,
						   "fileSB", args, 1);
	AddCallback(file_open_pu, XmNokCallback, file_open_ok, NULL);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s File Open", s);
	xms = XmStringCreateSimple(lbuf);
	XtVaSetValues(file_open_pu,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdialogTitle, xms,
	NULL);
	XmStringFree(xms);
	XtSetSensitive(XmSelectionBoxGetChild(file_open_pu,
					      XmDIALOG_HELP_BUTTON),
		       FALSE);
    }
    XtManageChild(file_open_pu);
    XtPopup(XtParent(file_open_pu), XtGrabNone);
}

static void
file_open_ok(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    String		fname;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
	error("file_open_ok: can't happen");
    dprintf1("file_open_ok: %s\n", fname);
    new_file(fname, True);
    Free(fname);
    XtUnmanageChild(widget);
    XtPopdown(XtParent(widget));
}

static void
unmap_cancel(widget, dialog, cbs)
Widget					widget;
Widget					dialog;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    XtUnmanageChild(dialog);
    XtPopdown(XtParent(dialog));
}

static void
file_print_cb()
{
    int			i;
    char		lbuf[LLEN];
    String		s;
    String		msg = "Choose print format:";
    Widget		ok_button;
    Widget		cancel_button;
    Widget		radio;
    Widget		toggle;
    XmString		title;
    Arg			args[1];

    dprintf("file_print_cb\n");
    if (
	(0 != app_data.print_limit) &&
	(TR - app_data.tl > app_data.print_limit)
    ) {
	sprintf(lbuf,
		"More than %d points in window: do you really want to print?",
		app_data.print_limit);
	if (!ask_user(lbuf)) return;
    }
    if (NO_WIDGET == file_print_pu) {
	XtSetArg(args[0], XmNautoUnmanage, True);
	file_print_pu = XmCreateFormDialog(toplevel,
					   "filePrintFormat", args, 1);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s File Print", s);
	title = XmStringCreateSimple(lbuf);
	XtVaSetValues(file_print_pu,
	    XmNdialogTitle, title,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdeleteResponse, XmUNMAP,
	    XmNuserData, 0,
	NULL);
	XmStringFree(title);
	ok_button = XtVaCreateManagedWidget("okButton",
	    xmPushButtonWidgetClass, file_print_pu,
	    XtVaTypedArg, XmNlabelString, XmRString,
	    "Ok", strlen("Ok")+1,
	NULL);
	AddCallback(ok_button, XmNactivateCallback, file_print_ok, NULL);
	cancel_button = XtVaCreateManagedWidget("cancelButton",
	    xmPushButtonWidgetClass, file_print_pu,
	    XtVaTypedArg, XmNlabelString, XmRString,
	    "Cancel", strlen("Cancel")+1,
	NULL);
	radio = XmCreateRadioBox(file_print_pu, "printFormatBox", NULL, 0);
	for(i=0; i<num_ps_formats; i++) {
	    sprintf(lbuf, "filePrintFormat%d", i+1);
	    toggle = XtVaCreateManagedWidget(lbuf,
		xmToggleButtonWidgetClass, radio,
		XtVaTypedArg, XmNlabelString, XmRString,
		ps_formats[i], strlen(ps_formats[i])+1,
	    NULL);
	    AddCallback(toggle, XmNvalueChangedCallback,
			print_format_choice_cb, i);
	}
	XtVaSetValues(radio,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, ok_button,
	NULL);
	XtManageChild(radio);
    }
    XtManageChild(file_print_pu);
    XtPopup(XtParent(file_print_pu), XtGrabNone);
}

static void
print_format_choice_cb(button, format, cbs)
Widget				button;
int				format;
XmToggleButtonCallbackStruct	*cbs;
{
    if (cbs->set) {
	XtVaSetValues(file_print_pu, XmNuserData, format, NULL);
    }
}

static void
file_print_ok()
{
    FILE		*ps;
    int			format;

    dprintf("file_print_format_ok\n");
    XtVaGetValues(file_print_pu, XmNuserData, &format, NULL);
    if (NULL == (ps = popen(PRINT_CMD, "w"))) {
	PU_error("Unable to open printer", "file.html#PRINT");
	return;
    }
    PSplot_stream(ps, format, FALSE);
    fclose(ps);
}

static void
file_save_cb()
{
    char		lbuf[LLEN];
    String		s;
    Widget		help_button;
    XmString		title;
    Arg			args[1];

    dprintf("file_save\n");
    if (NO_WIDGET == file_save_pu) {
	XtSetArg(args[0], XmNautoUnmanage, True);
	file_save_pu = XmCreateFileSelectionDialog(toplevel,
						   "save_SB", args, 1);
	AddCallback(file_save_pu, XmNokCallback, file_save_ok, NULL);
	AddCallback(file_save_pu, XmNhelpCallback, file_save_help, NULL);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s File Save", s);
	title = XmStringCreateSimple(lbuf);
	XtVaSetValues(file_save_pu,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdialogTitle, title,
	NULL);
	XmStringFree(title);
    }
    s = default_xdp_file();
    XtVaSetValues(XmSelectionBoxGetChild(file_save_pu, XmDIALOG_TEXT),
	XtVaTypedArg, XmNvalue, XmRString,
	s, strlen(s)+1,
    NULL);
    Free(s);
    XtManageChild(file_save_pu);
    XtPopup(XtParent(file_save_pu), XtGrabNone);
}

static void
file_save_ok(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    char		lbuf[LLEN];
    String		fname;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
	error("file_save_ok: can't happen");
    dprintf1("file_save_ok: %s\n", fname);
    if (write_xdp(fname, app_data.save_list)) {
	/* write_xdp already reported error */
    }
    Free(fname);
    XtUnmanageChild(widget);
    XtPopdown(XtParent(widget));
}

static void
file_mif_cb()
{
    char		lbuf[LLEN];
    String		s;
    XmString		xms;
    Widget		help_button;
    Arg			args[1];

    dprintf("file_mif\n");
    if (
	(0 != app_data.print_limit) &&
	(TR - app_data.tl > app_data.print_limit)
    ) {
	sprintf(lbuf,
		"More than %d points in window: do you really want to export?",
		app_data.print_limit);
	if (!ask_user(lbuf)) return;
    }
    if (NO_WIDGET == file_mif_pu) {
	XtSetArg(args[0], XmNautoUnmanage, True);
	file_mif_pu = XmCreateFileSelectionDialog(toplevel,
						  "MIF_SB", args, 1);
	AddCallback(file_mif_pu, XmNokCallback, file_mif_ok, NULL);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s Export MIF", s);
	xms = XmStringCreateSimple(lbuf);
	XtVaSetValues(file_mif_pu,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdialogTitle, xms,
	NULL);
	XmStringFree(xms);
	XtSetSensitive(XmSelectionBoxGetChild(file_mif_pu,
					      XmDIALOG_HELP_BUTTON),
		       FALSE);
    }
    XtManageChild(file_mif_pu);
    XtPopup(XtParent(file_mif_pu), XtGrabNone);
}

static void
file_mif_ok(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    String		fname;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
	error("file_mif_ok: can't happen");
    dprintf1("file_mif_ok: %s\n", fname);
    MIFplot(fname);
    Free(fname);
    XtUnmanageChild(widget);
    XtPopdown(XtParent(widget));
}

static void
file_ps_cb()
{
    int			i;
    char		lbuf[LLEN];
    String		s;
    XmString		xms;
    Widget		help_button;
    Widget		radio;
    Widget		toggle;
    Arg			args[1];

    dprintf("file_ps\n");
    if (
	(0 != app_data.print_limit) &&
	(TR - app_data.tl > app_data.print_limit)
    ) {
	sprintf(lbuf,
		"More than %d points in window: do you really want to export?",
		app_data.print_limit);
	if (!ask_user(lbuf)) return;
    }
    if (NO_WIDGET == file_ps_pu) {
	XtSetArg(args[0], XmNautoUnmanage, True);
	file_ps_pu = XmCreateFileSelectionDialog(toplevel,
						  "PS_SB", args, 1);
	AddCallback(file_ps_pu, XmNokCallback, file_ps_ok, NULL);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s Export PostScript", s);
	xms = XmStringCreateSimple(lbuf);
	XtVaSetValues(file_ps_pu,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdialogTitle, xms,
	    XmNuserData, 0,
	NULL);
	XmStringFree(xms);
	radio = XmCreateRadioBox(file_ps_pu, "psFormatBox", NULL, 0);
	for(i=0; i<num_ps_formats; i++) {
	    sprintf(lbuf, "filePsFormat%d", i+1);
	    toggle = XtVaCreateManagedWidget(lbuf,
		xmToggleButtonWidgetClass, radio,
		XtVaTypedArg, XmNlabelString, XmRString,
		ps_formats[i], strlen(ps_formats[i])+1,
	    NULL);
	    AddCallback(toggle, XmNvalueChangedCallback,
			  ps_format_choice_cb, i);
	}
	XtManageChild(radio);
	XtSetSensitive(XmSelectionBoxGetChild(file_ps_pu,
					      XmDIALOG_HELP_BUTTON),
		       FALSE);
    }
    XtManageChild(file_ps_pu);
    XtPopup(XtParent(file_ps_pu), XtGrabNone);
}

static void
ps_format_choice_cb(button, format, cbs)
Widget				button;
int				format;
XmToggleButtonCallbackStruct	*cbs;
{
    if (cbs->set) {
	XtVaSetValues(file_ps_pu, XmNuserData, format, NULL);
    }
}

static void
file_ps_ok(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    int			format;
    String		fname;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
	error("file_ps_ok: can't happen");
    dprintf1("file_ps_ok: %s\n", fname);
    XtVaGetValues(file_ps_pu, XmNuserData, &format, NULL);
    PSplot(fname, format, FALSE);
    Free(fname);
    XtUnmanageChild(widget);
    XtPopdown(XtParent(widget));
}

static void
file_quit_cb()
{
    dprintf("file_quit\n");
    exit_program();
}

static void
analyze_template_cb()
{
    dprintf("analyze_template\n");
    if (NO_WIDGET == analyze_template_sh) {
	analyze_template_sh = make_template_dialog();
    }
    XtPopup(analyze_template_sh, XtGrabNone);
/*  XMapRaised(XtDisplay(analyze_template_sh), XtWindow(analyze_template_sh)); */
}

static void
analyze_peaks_cb()
{
    dprintf("analyze_peaks\n");
    if (NO_WIDGET == analyze_peaks_sh) {
	analyze_peaks_sh = make_peaks_dialog();
    }
    XtPopup(analyze_peaks_sh, XtGrabNone);
/*  XMapRaised(XtDisplay(analyze_peaks_sh), XtWindow(analyze_peaks_sh)); */
}

static void
analyze_filter_cb()
{
    dprintf("analyze_filter\n");
    if (NO_WIDGET == analyze_filter_sh) {
	analyze_filter_sh = make_filter_dialog();
    }
    XtPopup(analyze_filter_sh, XtGrabNone);
    XMapRaised(XtDisplay(analyze_filter_sh), XtWindow(analyze_filter_sh));
}

static void
analyze_units_cb()
{
    dprintf("analyze_units\n");
    if (NO_WIDGET == analyze_units_sh) {
	analyze_units_sh = make_units_dialog();
    }
    XtPopup(analyze_units_sh, XtGrabNone);
    XMapRaised(XtDisplay(analyze_units_sh), XtWindow(analyze_units_sh));
}

static void
marks_cb(widget, item, cbs)
Widget			widget;
int			item;
XmAnyCallbackStruct	*cbs;
{
    menu_cb(&marks_cbs, item);
}

static void
marks_save_cb()
{
    char		lbuf[LLEN];
    XmString		title;
    String		s;

    dprintf("marks_save\n");
    if (NO_WIDGET == marks_save_pu) {
	marks_save_pu = XmCreateFileSelectionDialog(toplevel,
						    "marksSaveSB", NULL, 0);
	AddCallback(marks_save_pu, XmNokCallback, marks_save_ok, NULL);
	XtSetSensitive(
	    XmSelectionBoxGetChild(marks_save_pu, XmDIALOG_HELP_BUTTON),
	    FALSE
	);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s Marks Save", s);
	title = XmStringCreateSimple(lbuf);
	XtVaSetValues(marks_save_pu,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdialogTitle, title,
	NULL);
	XmStringFree(title);
    }
    XtManageChild(marks_save_pu);
    XtPopup(XtParent(marks_save_pu), XtGrabNone);
}

static void
marks_save_ok(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    char		lbuf[LLEN];
    String		fname;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
	error("marks_save_ok: can't happen");
    dprintf1("marks_save_ok: %s\n", fname);
    if (write_marks(fname)) {
	sprintf(lbuf, "Unable to save marks in file %s", fname);
	PU_error(lbuf, "marks.html#SAVE");
    }
    Free(fname);
    XtUnmanageChild(widget);
    XtPopdown(XtParent(widget));
}

static void
marks_read_cb()
{
    char		lbuf[LLEN];
    XmString		title;
    String		s;

    dprintf("marks_read\n");
    if (NO_WIDGET == marks_read_pu) {
	marks_read_pu = XmCreateFileSelectionDialog(toplevel,
						    "marksReadSB", NULL, 0);
	AddCallback(marks_read_pu, XmNokCallback, marks_read_ok, NULL);
	XtSetSensitive(
	    XmSelectionBoxGetChild(marks_read_pu, XmDIALOG_HELP_BUTTON),
	    FALSE
	);
	XtVaGetValues(toplevel, XmNtitle, &s, NULL);
	sprintf(lbuf, "%s Marks Read", s);
	title = XmStringCreateSimple(lbuf);
	XtVaSetValues(marks_read_pu,
	    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
	    XmNdialogTitle, title,
	NULL);
	XmStringFree(title);
    }
    XtManageChild(marks_read_pu);
    XtPopup(XtParent(marks_read_pu), XtGrabNone);
}

static void
marks_read_ok(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    char		lbuf[LLEN];
    String		fname;

    if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname))
	error("marks_read_ok: can't happen");
    dprintf1("marks_read_ok: %s\n", fname);
    if (read_marks(fname)) {
	sprintf(lbuf, "Unable to read marks from file %s", fname);
	PU_error(lbuf, "marks.html#READ");
    }
    Free(fname);
    replot_whole();
    XtUnmanageChild(widget);
    XtPopdown(XtParent(widget));
}

static void
marks_filter_cb()
{
    char		lbuf[LLEN];
    String		s;

    if (NO_WIDGET == marks_filter_pu) {
	marks_filter_pu = make_marks_filter_dialog();
    }
    XtManageChild(marks_filter_pu);
    XtPopup(XtParent(marks_filter_pu), XtGrabNone);
}

static void
windows_cb(widget, item, cbs)
Widget			widget;
int			item;
XmAnyCallbackStruct	*cbs;
{
    menu_cb(&windows_cbs, item);
}

static void
windows_newwin_cb()
{
    String		msg;

    dprintf("windows_newwin_cb\n");
    if (NULL != (msg = start_child())) {
	PU_error(msg, "children.html");
    }
}

static void
help_about_cb()
{
    help_window("about.html");
}

static void
help_manual_cb()
{
    help_window("index.html");
}

static void
help_keys_cb()
{
    help_window("keys.html");
}

static void
help_files_cb()
{
    help_window("formats.html");
}

static void
file_save_help(widget, data, cbs)
Widget					widget;
XtPointer				data;
XmFileSelectionBoxCallbackStruct	*cbs;
{
    help_window("formats.html#XDP");
}
