#include <stdio.h>
#include <stdlib.h>
#include <audio/Alib.h>
#include <audio/Play.h>

#include "xbiff-proto.h"

extern Widget playWidget;

int
AAplay(filename)
const char *filename;
{
  const char *fullname;
  Arg args[1];

  if (playWidget == NULL)
    return(1);

  fullname = findSoundFile(filename);
  if (fullname == NULL) {
    fprintf(stderr, "can't find audio file \"%s\".\n", filename);
    return(1);
  }

  XtSetArg(args[0], AuNfileName, fullname);
  XtSetValues(playWidget, args, 1);

  AuInvokePlay(playWidget);
  return(0);
}

#ifdef AAPLAY_MAIN

/* needed by findSound() */
char *sound_path = NULL;

Widget playWidget;

int
main(argc, argv)
int argc;
char *argv[];
{
  Audio *audio;
  Widget topLevel;
  XtAppContext app_context;
  Arg args[3];
  int i;
  long status;

  audio = AOpenAudio(NULL, &status);
  if (audio == NULL) {
    fprintf(stderr, "can't open Audio connection.\n");
    return(1);
  }

  AtInitialize(audio);

  topLevel = XtVaAppInitialize(&app_context, "AAPlay", NULL, 0, &argc, argv,
			     NULL, NULL);

  i = 0;
  XtSetArg(args[i], AuNgain, 100); i++;
  XtSetArg(args[i], AuNaudioConnection, audio); i++;
  XtSetArg(args[i], AuNpriority, AuUrgent); i++;
  playWidget = AuCreatePlay(topLevel, "play", args, i);

  for (i = 1; i < argc; i++) {
    AAplay(argv[i]);
    sleep(2);
  }

  exit(0);
}
#endif /* AAPLAY_MAIN */
