/*
 * xtypes.h : A few types for files that don't include X11/Intrinsic.h
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#ifndef _XTYPES_H
#define _XTYPES_H

#include "config.h"

#ifdef CRAY
typedef long Boolean;
#else
typedef char Boolean;
#endif

#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif
#ifndef NULL
#define NULL 0
#endif

typedef char *String;
typedef char *XtPointer;
typedef char *XtInputId;
typedef char *XtIntervalId;
typedef char XFontStruct;
typedef char *Pixmap;

#ifdef HAVE_MEMORY_H
#include "memory.h"
#endif

#define XtMalloc(SIZE)		malloc(SIZE)
#define XtCalloc(NUM,SIZE)	calloc(NUM,SIZE)
#define XtFree(PTR)		if (PTR) free(PTR)
#define XtNew(TYPE)		((TYPE *)malloc(sizeof(TYPE)))
#define XtNewString(STR)	(STR ? strcpy(malloc(strlen(STR)+1),STR) \
				     : NULL)
#endif
