/*
 * types.h : Definitions of SearchType and SortType
 *
 * George Ferguson, ferguson@cs.rochester.edu, 4 Sep 1991.
 * Version 2.0: 23 Apr 1993.
 */

#ifndef TYPES_H
#define TYPES_H

/* These codes correspond to Prospero key letters */
#define GfExact		'='
#define GfSubstr	'S'
#define GfSubcase	'C'
#define GfRegexp	'R'
#define GfExactSubstr	's'
#define GfExactSubcase	'c'
#define GfExactRegexp	'r'

typedef char SearchType;

#define GfRSearchType	"SearchType"
#define GfNExact	"exact"
#define GfNSubstr	"substr"
#define GfNSubcase	"subcase"
#define GfNRegexp	"regexp"
#define GfNExactSubstr	"exactsubstr"
#define GfNExactSubcase	"exactsubcase"
#define GfNExactRegexp	"exactregexp"

/* This puke is so the bloody converters work. Argh! */
#define GfName		'\001'
#define GfDate		'\002'
#define GfWeight	'\003'

typedef char SortType;

#define GfRSortType	"SortType"
#define GfNName		"name"
#define GfNDate		"date"
#define GfNWeight	"weight"

/* Since these are both char's we can use one constant for errors */
#define GfError		'\0'

extern void initConverters();
extern SearchType stringToSearchType();
extern SortType stringToSortType();
extern char *searchTypeToString(),*sortTypeToString();

#endif /* TYPES_H */
