/*
 * Copyright (c) 1994 by Gregory P. Ward.
 * All rights reserved.
 * 
 * This file is part of the MNI front end of the Berkeley MPEG decoder.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
 * UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER
 * IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.  
 */
/*
 * Portions of this software Copyright (c) 1995 Brown University.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is hereby granted, provided that the above copyright notice and the
 * following two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT 
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BROWN
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * BROWN UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND BROWN UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/* ----------------------------- MNI Header -----------------------------------
@NAME       : mpeg.h
@INPUT      : 
@OUTPUT     : 
@RETURNS    : 
@DESCRIPTION: Types and function prototypes needed for applications to
              use the Berkely MPEG decoding engine via the MNI front
              end.
@METHOD     : 
@GLOBALS    : Types defined:
                 ImageDesc  - structure giving height, width, etc.
                 DitherEnum - the different dither types supported by
                              the decoding engine
@CALLS      : 
@CREATED    : Greg Ward, 94/6/16.
@MODIFIED   : Greg Ward, 94/9/12 (based on John Cristy's fixes): made
              more amenable to use with other libraries that also
	      happen to define TRUE, FALSE, [Bb]oolean, and added
	      PROTO macro
---------------------------------------------------------------------------- */

#ifndef __MPEG_H
#define __MPEG_H

#include <stdio.h>

/* The ooMPEG version needs video.h... */
#ifdef JPEG /* conflict with JPEG defs */
#undef GLOBAL
#endif
#include "video.h"

/* An attempt at a portable and integrable boolean type... */

#if (!defined(TRUE) || !defined(FALSE))
# define TRUE (char) 1
# define FALSE (char) 0
#endif

#ifndef BOOLEAN_TYPE_EXISTS
typedef char Boolean;
#define BOOLEAN_TYPE_EXISTS
#endif

typedef struct
{
   short red, green, blue;
} ColormapEntry;

typedef struct
{
   int	Height;			/* in pixels */
   int  Width;
   int  Depth;			/* image depth (bits) */
   int  PixelSize;              /* bits actually stored per pixel */
   int  Size;			/* bytes for whole image */
   int  BitmapPad;              /* "quantum" of a scanline -- each scanline */
				/* starts on an even interval of this */
                                /* many bits */
   int  PictureRate;		/* required number of frames/sec [?] */
   int  BitRate;		/* ??? */

   VidStream *vid_stream;       /* Pointer to the vid stream itself */
   
   int  ColormapSize;
   ColormapEntry *Colormap;	/* an array of ColormapSize entries */
} ImageDesc;

#define DitherEnum int

typedef enum
{
   MPEG_DITHER,
   MPEG_QUIET,
   MPEG_LUM_RANGE,
   MPEG_CR_RANGE,
   MPEG_CB_RANGE,
   MPEG_CMAP_INDEX
} MPEGOptionEnum;

/* Kludge so we can compile under ANSI or K&R */

#undef PROTO
#if defined(__STDC__) || defined(__cplusplus)
#define PROTO(formal_parameters) formal_parameters
#else
#define const
#define PROTO(formal_parameters) ()
#endif

/* Function prototypes (all are defined in wrapper.c) */

Boolean OpenMPEG PROTO((FILE *MPEGfile, ImageDesc *ImgInfo));
void    CloseMPEG PROTO((ImageDesc *ImgInfo));
void    RewindMPEG PROTO((FILE *MPEGfile, ImageDesc *Image));
void    SetMPEGOption PROTO((ImageDesc *Info, MPEGOptionEnum Option, int value));
Boolean GetMPEGFrame PROTO((ImageDesc *image, char *Frame));

#endif   /* __MPEG_H */
