.de Id
..
.Id $Id: xa.man,v 1.6 1996/05/04 20:02:51 richards Exp $
.TH xa n "2 May 1996" "Ver: 1.2beta"
.SH NAME
xa \- animate images in an \fBX11\fR window
.SH SYNOPSIS
\fBxa\fR [ \fIgeneric_options\fR ] [ \fIother_options\fR ] [
\fIfilename\fR... ]
.SH DESCRIPTION
\fBxa\fR is an animation package with an \fBXView\fR Graphical User
Interface (GUI) for use on workstations and terminals running the
\fBX11\fR window system.  The following image formats are supported:
Sun rasterfile (8-bit RGB only), portable gray map, portable pixel
map, raw gray bytes, graphics interchange format (GIF, including
anims), JPEG, and MPEG. Many other formats can be converted to one of
the supported formats using such utilities as the \fBNetpbm\fR
library, \fBxv\fR, and \fBImageMagick\fR.  The .Z (\fBcompress\fR) and
.gz (\fBgzip\fR) compression formats are also recognized.  \fBxa\fR
provides the user with an \fBXView\fR panel interface for convenient
access to animation, display, and colormap functions.  There are a
number of options to help maximize the display rate.  On a typical
high-end workstation a display rate of 50 frames/sec or better can be
achieved with 400x400 8-bit images.  These speeds are obtained by
first loading the images into client-resident Ximages then
transferring them to server-resident pixmaps.  Consequently, the
maximum number of frames displayable (and hence the duration of the
animation for a given frame rate) is limited only by the core memory
available to the server.
.SH LAYOUT
\fBxa\fR consists of two panels and a canvas frame for displaying
images.  There is also a popup info window and a window to handle
insertion requests.  When invoked without any options or filenames
specified, \fBxa\fR displays the Main Panel in its default state.  If
any images were specified and at least one was loaded successfully,
the first will be displayed in the Canvas frame, also in the default
state.  The cursor is moved automatically to point to the
\fBMore...\fR button (see below) on the Main Panel for convenience.
This also ensures that the colormap is displayed correctly for the
first image by forcing the window manager to load \fBxa\fR's colormap
segment.  The Sub Panel and Info window can be called up from the Main
Panel.  The following two sections describe the control panels in
detail.
.SH Section 1: The Main Panel
The Main Panel contains all the controls needed to prepare and run an
animation.  Features include image loading facilities, sizing
controls, timer controls, and cycling buttons.  All the controls are
described in detail below.  Note that any equivalent command-line
options are given in parentheses beside the control name (see Section
4).
.IP "\fBImage #\fR (\fB-start\fR \fIindex\fR)"
The current image number is shown here and may be modified, either
using the text field or the incremental buttons.  Only numbers in the
range 1 to N, where N is the number of images loaded, are accepted as
input, although the value N + 1 may be displayed prior to loading a
new image (see \fBNew\fR button).  The option \fB-visualload\fR
overrides \fB-start\fR.
.IP "\fBNew\fR"
Click on this button to clear the image filename field and set the
image number to N + 1 in preparation for a new image.  Any displayed
image will be replaced with the current background.

.IP "\fBLoad\fR"
Clicking this button will cause \fBxa\fR to load the image shown in
the \fBImage\fR field.  The image will be assigned the image number
shown in the \fBImage #\fR field, so \fBLoad\fR can be used to replace
existing images if desired.  Note that if there is insufficient server
memory to store the image, the functions XCreateImage() or
XCreatePixmap() function may abort with an error.  In such an event,
or if a different loading error occurs, \fBxa\fR will attempt to
recover the previous image if it existed, if possible.
.IP "\fBDel\fR"
Use this button to delete the current image. Clicking on \fBDel\fR has
no effect if there is only one image left.
.IP "\fBIns\fR"
Click on this button to insert an image in the position immediately
following the current image. A popup appears requesting the
filename. No other input to \fBxa\fR is accepted until a filename is
entered, or until either the \fBOK\fR or \fBCancel\fR button in the
insert frame is selected.
.IP "\fBOp\fR Menu"
The selections in this pull-down menu are used to change the logical
function of the main Graphics Context (GC).  The logical function is
applied to the next image and all subsequent images to be displayed on
the Canvas.  Use \fBRefresh\fR to apply the function to the current
image.  Choices are:
.RS
.IP "\fB+ (SRC)\fR (\fB-op\fR SRC)"
This applies the GXcopy function to the images so that any existing
image (destination) is entirely replaced with each new image (source).
This is the default behavior.
.IP "\fB| (OR)\fR (\fB-op\fR OR)"
This applies GXor between the source and destination images,
effectively merging them together.  Note that because of internal
remapping of pixels for color compression, the color resulting from an
GXor operation may be surprising.
.IP "\fB& (AND)\fR (\fB-op\fR AND)"
Applies GXand between the source and destination.
.IP "\fBx (XOR)\fR (\fB-op\fR XOR)"
Applies GXxor.  Two invocations of GXxor on the same image returns the
original image.
.IP "\fBe (ERA)\fR (\fB-op\fR ERA)"
Applies GXandInverted.
.IP "\fB- (INV)\fR (\fB-op\fR NEG)"
Applies GXcopyInverted, giving the negative of the image.
.RE
.IP "\fBImage\fR"
The filename of the current image is displayed in the text field.
Typing a new filename and pressing RETURN or clicking on \fBLoad\fR
instructs \fBxa\fR to replace the current image with the contents of
the specified file.  Use \fBNew\fR or \fBIns\fR to avoid overwriting
the current image.  Note that images that are part of a multi-image
file, such as an MPEG movie, have their frame number appended to the
end of the filename.  Individual frames from such multi-image files
can be requested out of sequence using this nomenclature.
.IP "\fBW\fR (\fB-w\fR \fIwidth\fR)"
This is the image width field.  Changing this number either using the
text field or the incremental buttons causes the current \fBSizing\fR
option to change to \fBFixed\fR.  Any existing image will have its
frame adjusted to accommodate the new size.
.IP "\fBH\fp (\fB-h\fR \fIheight\fR)"
The height of the Canvas frame can be adjusted with this control, in
the same way as the width (\fBW\fR).

.IP "\fBSizing\fR"
There are three sizing options that can be used for displaying images.
.RS
.IP "\fBAuto\fR (\fB-auto\fR)"
With this option, images are displayed up to a specified maximum size,
by default 640x480.  The maximum size can be changed by first setting
\fBW\fR and \fBH\fR, then clicking on \fBAuto\fR.  The display frame
will shrink to accommodate images with dimensions smaller than the
maximum dimensions.  For larger images, the scrollbars can be used to
view hidden portions of the image.
.IP "\fBFull\fR (\fB-full\fR)"
With this option, the entire image is displayed as long as it can be
accommodated on the default screen.  The \fBW\fR and \fBH\fR fields
show the displayed image dimensions.
.IP "\fBFixed\fR (\fB-fixed\fR)"
This option fixes the image size to the current values displayed in
the \fBW\fR and \fBH\fR fields.  Fixed canvases are the fastest to
draw, so this is the preferred option when maximizing display rates.
Hidden portions of images can still be viewed with the scrollbars.
Images that are smaller than the fixed size are padded with the
current background (see the \fBBackdrops\fR item in the Sub Panel) and
may be centered in the frame by choosing \fBCentering\fR from the Sub
Panel.
.RE
.IP "\fBSet\fR"
This button is used to set the \fBW\fR and \fBH\fR fields to the
currently displayed size.  This means the frame size can be adjusted
by first using the mouse (e.g. by dragging the resize corners) and
then clicking on \fBSet\fR.  This button also causes \fBFixed\fR to be
selected automatically.
.IP "\fBTimer Scale\fR"
The MINIMUM delay between displaying one frame and the next during
animation is set by the \fBTimer Scale\fR and \fBTimer Slider\fR.  The
former is a coarse adjustment and the latter a fine adjustment.  It is
possible to select delay ranges between 1 microsecond and 999 seconds
(about 15 minutes), though in practice millisecond values are
typically the best achievable on most workstations.  Note that at the
fastest speeds, the \fBxa\fR controls may become very sluggish -- be
patient!  Ideally, all display options should be set PRIOR to
animating at top speed.
.RS
.IP "\fBus\fR (\fB-timerscale\fR us)"
This control selects the microseconds timer scale.
.IP "\fBms\fR (\fB-timerscale\fR ms)"
Use this for the milliseconds timer scale, which is the practical
range for animations.
.IP "\fBsec\fR (\fB-timerscale\fR sec)"
The seconds scale can be used for slideshows.
.RE
.IP "\fBTimer Slider\fR (\fB-timervalue\fR \fItimer\fR)"
This slider is used for fine adjustments of the delay timer for
animations.  The range is 1 to 999 in the units selected on the
\fBTimer Scale\fR.  The value can be set using the text field or by
dragging the slider control.  Unit increments or decrements can be
performed by clicking either side of the control.
.IP "\fbFast\fR (\fB-fast\fR)"
Fast mode can be selected by pressing this button.  This sets
\fBFixed\fR sizing, 30 ms frame delay (configurable in
\fBconfig.h\fR), and many of the options on the Sub Panel.  In this
mode, \fBxa\fR will display frames at close to the fastest possible
rate.  Any default fast setting can be overridden by adjusting the
appropriate control in the usual way.
.IP "\fbDirection\fR (\fB-fwd\fR|\fB-rev\fR)"
Cycling direction can be toggled between forward (FWD) and reverse
(REV) using this control.  \fBBlink\fR mode and the \fBLoop Back\fR
and \fBOne Way\fR cycling options will take over direction control
when invoked.
.IP "\fbStep\fR"
Clicking on this button will display either the next or previous image
depending on the current \fBDirection\fR.  The step function is called
internally when animating.
.IP "\fBBlink\fR (\fB-[no]blink\fR)"
This button toggles blinking on and off.  The current image and the
next or previous image are blinked at the current display rate.
.IP "\fBCycle\fR (\fB-[no]cycle\fR)"
This button displays the stored images in sequence, subject to the
current \fBDirection\fR, \fBCycling Option\fR, and display rate.  The
animation can be stopped by clicking on \fBCycle\fR again.
.IP "\fBCycling Option\fR"
There are three choices of cycling option:
.RS
.IP "\fBLoop\fR (\fB-loop\fR)"
This is the default.  When the end of the current sequence of images
is reached, cycling continues from the beginning ad infinitum.
.IP "\fBLoop Back\fR (\fB-loopback\fR)"
When the end of the current sequence of images is reached, the current
\fBDirection\fR is reversed and cycling continues.
.IP "\fBOne Way\fR (\fB-oneway\fR)"
When the end of the current sequence of images is reached, cycling is
terminated.  Clicking on \fBCycle\fR again will repeat the sequence,
starting with the first or last image depending on the current
\fBDirection\fR.
.RE
.IP "\fBRefresh\fR"
Clicking here redisplays the current image.  This can be used on an
image to apply a logical function (\fBOp\fR) to itself.  It is also
useful if the window manager has corrupted the image display for
whatever reason.
.IP "\fBRescan\fR"
This button causes \fBxa\fR to rescan all the image files and reload
any that have been updated on disk since they were last loaded. Note
that NFS file cacheing may defeat this feature.
.IP "\fBMore...\fR (\fB-[no]subpanel\fR)"
This pops up the Sub Panel.
.IP "\fBInfo...\fR"
Use this button for info relating to the author and copyright.
.IP "\fBQuit\fR"
Clicking here terminates the \fBxa\fR session.
.SH Section 2: The Sub Panel
When selected using \fBMore...\fR on the Main Panel or by including
the \fB-subpanel\fR option on the command line, the Sub Panel is
displayed.  The user can perform various fine-tuning operations,
including colormap manipulation, using the Sub Panel.
.IP "\fBNo Scrolling\fR (\fB-[no]scrolling\fR)"
Selecting this removes the scrollbars from the image.  Deselecting
replaces them.
.IP "\fBNo Resizing\fR (\fB-[no]resizing\fR)"
This option overrides all sizing requests.  The frame size can still
be adjusted manually using the mouse, but a new size cannot be
\fBSet\fR until \fBNo Resizing\fR is deselected.
.IP "\fBNo Moving\fR (\fB-[no]moving\fR)"
When an image is to be displayed, \fBxa\fR attempts to reposition the
frame so that no part of the image will be off-screen.  Selecting
\fBNo Moving\fR disables this behavior.
.IP "\fBNo Scaling\fR (\fB-[no]scaling\fR)"
Selecting this option disables all color \fBScaling\fR effects.
.IP "\fBNo Updates\fR (\fB-[no]updates\fR)"
Normally when cycling, the \fBImage #\fR and \fBImage\fR fields, as
well the size fields and Main Panel footer, are updated between
images.  Selecting \fBNo Updates\fR disables this behavior when
cycling.  Updates when using \fBStep\fR manually cannot be suppressed.
.IP "\fBNo Backdrops\fR (\fB-[no]backdrops\fR)"
By default when cycling, images smaller than a \fBFixed\fR frame will
have undefined regions painted with the current backdrop.  \fBNo
Backdrops\fR disables this feature when cycling.
.IP "\fBLock Colors\fR (\fB-[no]lockcolors\fR)"
Selecting this locks the current image colormap so that all
subsequently displayed images use the locked colormap rather than
their own.  This feature results in interesting effects between images
with very different colormaps, but significantly improves the display
rate for images with identical or nearly identical colormaps.  If the
command line options \fB-newcmap\fR or \fB-onecmap\fR are used, the
\fBLock Colors\fR control is selected automatically.
.IP "\fBCentering\fR (\fB-[no]centering\fR)"
When selected, and if the \fBSizing\fR is \fBFixed\fR, the current
image and all subsequently displayed images will be centered in the
display frame.  Any gaps will be filled with the current backdrop
unless \fBNo Backdrops\fR is selected.
.IP "\fBLive Cursor\fR (\fB-[no]livecursor\fR)"
With a live cursor, the mouse can be used to examine the current color
\fBScaling\fR of an image.  Simply moving the mouse across the image
will display the cursor coordinates with respect to the top left
corner of the image, the value of the pixel at that location, the
original color RGB triad to which the pixel value corresponded (after
compression -- see below), and the current color at that location.
For example:
.RS
.IP "(122,36) = 53 (96,96,96) --> (255,0,0)"
.RE
.IP
shows that the pixel at x = 122, y = 36 on the image has a value of 53,
which originally corresponded to the gray-scale value (96,96,96) but
has since been mapped into the color red (255,0,0).  The coordinates
and mapping information are displayed in the footer of the Canvas frame.
.IP "\fBBackdrops\fR (\fB-backdrop\fR \fIindex\fR)"
Various bitmap backdrops can be selected for filling gaps left when an
image is smaller than its frame.  The patterns available are displayed
on the choice buttons (blank means white).
.IP "\fBScaling\fR"
There are seven color scaling options available with \fBxa\fR.  The
RGB color sliders below the options allow fine tuning of the scaling.
If the code was compiled with LIVE_SLIDERS, changing one color slider
may instantaneously affect the other sliders, depending on the option.
Otherwise the other sliders will be updated after the slider control
of the first is released.  The \fBx\fR and \fB/\fR buttons to the
right of each slider provide additional functionality, depending on
the option.  For some options, the "padlock" symbol to the right of
the scaling options can be used to lock the slider controls so they
move in sync.  Each scaling option has a default slider setting built
in which is used when the option is first selected.
.RS
.IP "\fBBW\fR (\fB-bw\fR)"
The slider controls a fractional cutoff: colormap entries with a total
intensity greater than 1 - (slider/100) of the maximum are mapped to
white while the remainder are mapped to black.  The default setting is
50.  Any slider can be used to change the setting.
.IP "\fBGray\fR (\fB-gray\fR)"
The sliders control the fractional contributions of each color in the
image to a gray scale map R_new = (R/100) * R_old + (G/100) * G_old +
(B/100) * B_old, B_new = G_new = R_new.  The sum of the slider values
R + G + B is fixed at 100.  The default setting is R = 30, G = 59, B =
11 which is the map used by \fBppmtopgm\fR in the \fBNetpbm\fR
package.
.IP "\fBColor\fR (\fB-color\fR)"
This is the default scaling option.  With this option, the sliders
control the fractional intensity of their respective colors in the
image.  Selecting \fBx\fR or \fB/\fR for each slider determines
whether the color contribution is diminished (former) or enhanced
(latter).
.IP "\fBGamma\fR (\fB-gamma\fR)"
The standard gamma correction can be applied to the image with this
option.  With \fBx\fR selected, units are in tenths; with \fB/\fR,
units are in hundredths.
.IP "\fBCutoff\fR (\fB-cutoff\fR)"
With this option, component colors with an intensity greater (\fBx\fR)
or less (\fB/\fR) than the slider value in percent times 255 are set
to zero.
.IP "\fBContour\fR (\fB-contour\fR)"
This option maps the image colors by intensity into 10 repeating
colors, with the total number of contours controlled by the sliders
(from 1 to 100, default 25).  The contour colors have been selected in
order of intensity so that the brightest colors in the image get the
brightest contours.
.IP "\fBRandom\fR (\fB-random\fR)"
This option simply maps the image colors into random values.  The values
can be changed with the sliders.
.SH Section 3: Keyboard Accelerators
Limited keyboard support is provided on the Canvas window.  Pressing
the spacebar while the cursor is on the Canvas is equivalent to
pushing the \fBStep\fR button.  Use 'b' to move one image in the
opposite \fBDirection\fR.  Pressing RETURN performs a \fBSet\fR
operation.  Press 'c' to toggle cycling, and 'q' to quit the program.
In addition, 'h', 'j', 'k', and 'l' can be used (in the manner of
\fBvi\fR) for precise positioning of the cursor on the canvas.
.SH Section 4: Command Line Options
Most of the panel controls have command-line equivalents so that an
\fBxa\fR session can be started with various options already
set.  The usage is:
.IP "\fBxa\fR"
[-fast] [-[no]newcmap] [-[no]onecmap] [-[no]fastquant] [-[no]subpanel]
.ti +0.5
[-[no]blink|-[no]cycle] [-[no]scrolling] [-[no]resizing] [-[no]moving]
.ti +0.5
[-[no]scaling] [-[no]updates] [-[no]backdrops] [-[no]lockcolors]
.ti +0.5
[-[no]centering] [-[no]livecursor] [-[no]raw] [-[no]query]
.ti +0.5
[-[no]serverimages|-[no]clientimages] [-[no]visualload] [-[no]1]
.ti +0.5
[-[no]oneatatime] [-[no]verbose|-[no]quiet] [-start \fIindex\fR]
.ti +0.5
[-private|-hist|-pair] [-copy (num)] [-op SRC|OR|AND|XOR|ERA|NEG]
.ti +0.5
[-w \fIwidth\fR] [-h \fIheight\fR] [-auto|-full|-fixed] [-timerscale us|ms|sec]
.ti +0.5
[-timervalue \fItimer\fR] [-fwd|-rev] [-loop|-loopback|-oneway]
.ti +0.5
[-backdrop \fIindex\fR] [-bw|-gray|-color|-gamma|-cutoff|-contour|-random]
.ti +0.5
[-red \fIvalue\fR] [-green \fIvalue\fR] [-blue \fIvalue\fR] [-rw \fIwidth\fR] [-rh \fIheight\fR]
.ti +0.5
[\fIfilename\fR...].

Many of these options have been described in the previous sections.
Toggle options have an optional "no" prefix for flexibility.  Note
that some options invoke others.  For example, \fB-fast\fR invokes
many of the Sub Panel options, such as No Scrolling. To retain the
scrollbars, place \fB-scrolling\fR after \fB-fast\fR on the command
line.  Options appearing last take precedence over those appearing
first.  The options that have not yet been described are:
.IP "\fB-[no]newcmap\fR"
When enabled, \fBxa\fR attempts to find a single optimal colormap
suitable for all loaded images.  Depending on the number and size of
the images, this function can take some time to perform.  \fBLock
Colors\fR is automatically invoked with this option (and cannot be
overridden).  This option cannot be used with \fB-visualload\fR or
\fB-oneatatime\fR.
.IP "\fB-[no]onecmap\fR"
Instructs \fBxa\fR to store only the first image's colormap and
automatically \fBLock Colors\fR to it.  This speeds up the image
loading considerably as it bypasses any colormap compression (see
below).  Of course, the colormaps of all the images loaded should be
similar, or, ideally, the same.  The \fB-fast\fR option automatically
invokes \fB-onecmap\fR.
.IP "\fB-[no]fastquant\fR"
When set, forces \fBxa\fR to use a faster quantization method for 24
bit images and for computing the \fB-newcmap\fR option.  Image quality
will generally not be as good as with the default.
.IP "\fB-[no]raw\fR"
The \fB-raw\fR flag signals to \fBxa\fR that any unrecognized file
types should be assumed to be raw gray bytes.  If the width
(\fB-rw\fR) and/or height (\fB-rh\fR) of such files are not specified
in advance, the user will be asked to supply them.  Once supplied, the
user will not be prompted again unless \fB-query\fR is set or if the
file size is inconsistent with the supplied dimensions.
.IP "\fB-[no]query\fR"
If set, and if raw files are expected, \fBxa\fR will prompt for the
width and height of each raw file encountered, regardless of the
\fB-rw\fR and \fB-rh\fR settings.  This option has no effect if
\fB-raw\fR is not set.
.IP "\fB-[no]serverimages|-[no]clientimages\fR"
These mutually exclusive options control whether images are
transferred to the server after loading (default) or left on the
client.  The former results in much faster animations but a slower
initial load.  It also requires that the server have sufficient memory
to accommodate all the images.  On an X terminal it might be better to
use \fB-clientimages\fR.
.IP "\fB-[no]visualload\fR"
When enabled, this option instructs \fBxa\fR to display each frame as
it is loaded.  There is no display rate control during this initial
load (all panel functions are locked out), but it can make startup
more interesting.
.IP "\fB-[no]1\fR and \fB-[no]oneatatime\fR"
These equivalent options instruct \fBxa\fR to keep the data of only
one image in memory at a time.  This means each image in the display
sequence will be read off disk as required.  Naturally this will
drastically reduce the maximum frame rate for animations, but this
option can be very helpful for browsing through a lot of images on
disk, or for viewing an MPEG of unknown size.  Note that \fBxa\fR must
preprocess the file list in advance to check for multi-image files and
to allocate sufficient space.  As a result this option works well in
combination with \fB-visuaload\fR for multi-image files.
.IP "\fB-[no]verbose|-[no]quiet\fR"
These mutually exclusive options control whether information about
each file is displayed during loading (the default).
.IP "\fB-private\fR"
Instructs \fBxa\fR to use a private colormap for each image
so that no attempt at colormap compression is made.  Window colors,
including those of the \fBxa\fR control panels, may be severely
affected when viewing these images.
.IP "\fB-hist\fR"
Constructs a histogram of color usage for each image (or just the
first in the case of \fB-onecmap\fR), and compresses the colors on the
basis of usage and uniqueness until they fit in the available
allocated read-write space of the display colormap.
.IP "\fB-pair\fR"
Determines which colors are most alike in pair-wise fashion for each
image until the colors fit in the display colormap.  This method is
faster than \fB-hist\fR but sometimes results in poorer-quality
images.  This is the default compression option.
.IP "\fB-copy\fR \fInum\fR"
Instructs \fBxa\fR to construct a private colormap for image display
but to copy the first \fInum\fR read-only color cells from the default
colormap.  This has the advantage of reducing the severity of the
color flashing over \fB-private\fR when changing focus.  \fB-copy\fR 0
is equivalent to \fB-private\fR.
.IP "\fB-red\fR \fIvalue\fR \fB-green\fR \fIvalue\fR \fB-blue\fR \fIvalue\fR"
These options allow the user to override the initial default color
\fBScaling\fR settings.  For \fBGray\fR scale, the images may be
"burned out": it is up to the user to ensure R + G + B = 100 if
desired.  Changing the color sliders, however, will restore the
constraint.  For those options that recognize the \fBx\fR and \fB/\fR
qualifiers, the corresponding choices can be selected by supplying
positive or negative color values, respectively.
.IP "\fB-rw\fR \fIwidth\fR \fB-rh\fR \fIheight\fR"
These parameters control the default assumed width and height of raw
files.  See \fB-raw\fR and \fB-query\fR above.
.SH HINTS
For best results, never exceed the core memory of the server when
loading images (see the MAX_IMAGE_MEM macro in \fBconfig.h\fR).
Swapping will make the animator painfully slow.  Even with more
careful use of memory, \fBxa\fR may need to perform one or even two
cycles through the images before the animation becomes smooth.  Once
everything is up to speed, the animator controls should respond better
as well.  Also, to load animations that consist of a large number of
files, it is best to use the Unix wildcard facility (e.g. \fBxa\fR
-fast movie*.ras), so be sure that the image sequence is the same
chronologically as alphabetically.
.SH HISTORY
\fBxa\fR replaces its Sunview predecessor \fBrastool\fR (which was
never officially released) and the subsequent \fBX11\fR version
\fBxrastool\fR.  These tools were designed to aid in visualization of
gravitational N-body problems carried out at the Institute of
Astronomy, Cambridge in partial fulfillment of the author's
Ph.D. thesis.
.SH COPYRIGHT
\fBxa\fR is Copyright (C) 1993, 1996 by Derek C. Richardson under the
terms and conditions of the GNU General Public License (included with
the source distribution).
.SH AUTHOR
Derek C. Richardson, Canadian Institute for Theoretical Astrophysics,
Toronto, CANADA.
.SH BUGS
All bug reports, comments, praise, and criticism should be e-mailed to
richards@cita.utoronto.ca.  Enjoy!
