/* xa.c -- main xa initialization and miscellaneous functions */

/* $Id: xa.c,v 1.12 1996/05/04 20:02:02 richards Exp $ */

/*
 * $Log: xa.c,v $
 * Revision 1.12  1996/05/04 20:02:02  richards
 * added include for MAXHOSTNAMELEN under Solaris
 *
 * Revision 1.11  1996/04/19 22:23:19  richards
 * added -oneatatime support
 * moved StartCycling test from ShowNewImage() to main()
 *
 * Revision 1.10  1996/04/05 16:36:37  richards
 * helpful message if client and server are same machine
 * other minor changes
 *
 * Revision 1.9  1996/03/16 17:10:02  richards
 * renamed xrastool to xa
 * fixed indenting
 *
 * Revision 1.8  1996/03/14 22:14:17  richards
 * minor changes, mostly to comments
 *
 * Revision 1.7  1996/03/08 21:05:02  richards
 * added NumDelayedFiles and DelayedFilenames globals, with accompanying
 *    changes to -visualload procedure
 * replaced srandom() with srand48() (Cf. config.h)
 *
 * Revision 1.6  1996/02/08 01:47:56  richards
 * implemented Verbose flag
 * added line to show subpanel at the correct time, if requested
 *
 * Revision 1.5  1996/01/30 20:31:57  richards
 * added random seeding of random number generator (Cf. srandom())
 * replaced MakeCms() with InitColors() in color.c
 * added WaitingForImages flag to delay image loading
 *
 * Revision 1.4  1996/01/27 22:40:54  richards
 * changed some comment formats
 * added COPYRIGHT string
 *
 * Revision 1.3  1996/01/21 21:36:09  richards
 * prototyping
 *
 * Revision 1.2  1996/01/18 18:17:17  richards
 * multiple visual handling
 * XView 3.0 support
 *
 * Revision 1.1  1996/01/18 16:56:55  richards
 * Initial revision
 *
 */

#ifdef SOLARIS
#  include <netdb.h>
#else
#  include <sys/param.h> /* For MAXHOSTNAMELEN */
#endif

#include "xa.h"
#include <X11/Xutil.h> /* for XVisualInfo */

/* Global variables */

Display *MainDisplay;
int MainScreen, ScreenWidth, ScreenHeight, ScreenDepth;
Visual *MainVisual;
GC MainGC;
int NumDelayedFiles = 0;
char **DelayedFilenames;
Bool Preprocessing = FALSE;
IMAGE_T *Image[MAX_NUM_IMAGES];

/* Dummy code needed for SGIs using Xview 3.0 */

#ifdef SGI
fd_set svc_fdset;
void svc_getreqset(){}
#endif
     
/*** END OF PREAMBLE ***/
     
int main(int argc, char *argv[])
{
  /* Main program initialization and window loop start. */

  int files_start; /* Location of first filename in argv, if any */

  /* Disable all output buffering (not essential) */

  setbuf(stdout, NULL);

  /* Initialize random number generator */

  srand48(time(NULL) ^ getpid());

  /* Friendly message */

  (void) printf("%s %s\n", VERSION, COPYRIGHT);
  { /* Underscore VERSION string, just for fun */
    int i;

    for (i = 0; i < strlen(VERSION); i++)
      (void) printf("-");
    (void) printf("\n");
  }
  (void) printf("xa comes with ABSOLUTELY NO WARRANTY. This is free\n");
  (void) printf("software, and you are welcome to redistribute it under\n");
  (void) printf("the conditions of the GNU General Public License.\n");
  (void) printf("See the LICENSE included with the source for details.\n\n");

  /* Initialize XView and strip XView options */

  (void) xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

  /* Create simple frame now to get display parameters */

  BaseFrame = (Frame) xv_create(XV_NULL, FRAME, NULL);

  /* Get the default display, screen, size, depth, GC, and visual */

  MainDisplay  = (Display *) xv_get(BaseFrame, XV_DISPLAY);
  MainScreen   = DefaultScreen(MainDisplay);
  ScreenWidth  = WidthOfScreen(ScreenOfDisplay(MainDisplay, MainScreen));
  ScreenHeight = HeightOfScreen(ScreenOfDisplay(MainDisplay, MainScreen));
  ScreenDepth  = DefaultDepth(MainDisplay, MainScreen);
  MainGC       = DefaultGC(MainDisplay, MainScreen);

  {
    XVisualInfo visual_info;

    if (XMatchVisualInfo(MainDisplay, MainScreen, ScreenDepth, PseudoColor,
			 &visual_info)) {
      MainVisual = visual_info.visual;
    }
    else {
      MainVisual = DefaultVisual(MainDisplay, MainScreen);
      Warning("PseudoColor visual not found!");
    }
    (void) xv_set(BaseFrame, XV_VISUAL, MainVisual, NULL);
  }

  /* Error check */

  if (ScreenDepth != 8)
    Error("Need 8 bit display for viewing -- sorry!");

  /* Interpret any remaining command line options and get files_start */

  ReadCmdLine(argc, argv, &files_start);

  /* Print some fluff now, if allowed */

  if (Verbose)
    (void) printf("PseudoColor visual found and selected.\n"
		  "Default display %ix%i with %i bit plane%s.\n",
		  ScreenWidth, ScreenHeight, ScreenDepth, PLURAL(ScreenDepth));

#ifndef SOLARIS /* Doesn't work unless you have Solaris 2.5 or later... */

  /* Check if client images might be better */

  if (Verbose && UsePixmaps) {
    char servername[MAXHOSTNAMELEN], hostname[MAXHOSTNAMELEN], *ptr;

    /* Get server name (no name implies client is server) */

    (void) strncpy(servername, (char *) xv_get(xv_default_server, XV_NAME),
		   MAXHOSTNAMELEN - 1);

    /* Truncate at ':' */

    if ((ptr = strchr(servername, ':')) != NULL)
      *ptr = '\0';

    /* Get host name */

    (void) gethostname(hostname, MAXHOSTNAMELEN - 1);

    /* Truncate at '.' */

    if ((ptr = strchr(hostname, '.')) != NULL)
      *ptr = '\0';

    /* Let user know if we have a match */

    if (strlen(servername) == 0 || strcmp(servername, hostname) == 0)
      (void) printf("Client and server are same machine: "
		    "could speed loading with -clientimages.\n");
  } /* if (UsePixmaps) */

#endif /* !SOLARIS */

  /* Construct windows and icons */

  MakeBaseFrame();
  MakeMainPanel();
  MakeSubWindow();
  MakeCanvas();

  /*
   * Allocate read/write color cells (performed AFTER window creation to
   * allow for any color assignments made by the window manager for the
   * widgets).
   *
   */

  InitColors();

  /* Apply defaults and any command line options */

  Initialize();

  /*
   * If visual loading is desired, just store filenames for later read once
   * the main panel has been displayed. Otherwise (default), load any
   * specified images and display the first one.
   *
   */

  if (files_start < argc)
    if (VisualLoad) {
      NumDelayedFiles = argc - files_start;
      DelayedFilenames = argv + files_start;
      (void) notify_interpose_event_func(MainPanel, DynamicLoad, NOTIFY_SAFE);
    }
    else {
      if (Verbose)
	if (OneAtATime)
	  (void) printf("Preprocessing...\n");
	else
	  (void) printf("Loading initial frames...\n");
      if (OneAtATime)
	Preprocessing = TRUE;
      (void) LoadData(argc - files_start, argv + files_start, 0);
      if (OneAtATime)
	Preprocessing = FALSE;
      if (Verbose)
	(void) printf("Done!\n");
      if (Current < 0 || Current >= NumImages) { /* if -start out of range */
	Current = 0;
	if (!NO_IMAGES && Verbose)
	  (void) printf("Starting at first image.\n");
      }
      ShowNewImage();
    }

  /* Attempt to move cursor onto main panel and position main panel caret */

  MoveCursorAndCaret();

  /* Show the subpanel now, if requested */

  (void) xv_set(SubFrame, XV_SHOW, ShowSubPanel, NULL);

  /* Enable cycling if there was a command line request */

  if (StartCycling) {
    StartCycling = FALSE;
    Timer.it_value.tv_sec = 1; /* Wait 1 sec before starting */
    KeyPressed(CYCLE_KEY);     /* Simulate key press */
    Timer.it_value.tv_sec = 0; /* Remove delay */
  }

  /* Enter main XView loop */

  xv_main_loop(BaseFrame);

  /* Termination */

  if (Verbose)
    (void) printf("xa done.\n");

  /* Successful completion */

  return OK;
}

void PointToItem(Frame frame, Rect *item_rect)
{
  /* Moves cursor to center of item_rect relative to frame */

  Rect *frame_rect;
  int x, y;

  /* Get position and size of frame */

  frame_rect = (Rect *) xv_get(frame, XV_RECT);

  /* Get new cursor position, allowing for frame borders and margins */

  x = frame_rect->r_left + item_rect->r_left + item_rect->r_width / 2 +
    FRAME_BORDER;

  y = frame_rect->r_top + item_rect->r_top + item_rect->r_height / 2 +
    FRAME_BORDER + HEADER_MARGIN;

  /* Move cursor */

  (void) xv_set(xv_get(frame, XV_ROOT), WIN_MOUSE_XY, x, y, NULL);
}

void Warning(char *msg)
{
  /* Sends msg to stderr */

  (void) fprintf(stderr, "xa warning: %s\n", msg);
}

void Error(char *msg)
{
  /* Sends msg to stderr and aborts with error status 1 */

  (void) fprintf(stderr, "\007xa error: %s\n", msg);

  exit(1);
}

/*** xa.c ***/
