/* config.h -- user configurable definitions and macros for xa */

#define CONFIG_H_ID "$Id: config.h,v 1.6 1996/05/04 19:57:31 richards Exp $"

/*
 * $Log: config.h,v $
 * Revision 1.6  1996/05/04 19:57:31  richards
 * moved FAST_MODE macro from xa.h to here
 *
 * Revision 1.5  1996/04/19 22:13:52  richards
 * increased MAX_NUM_IMAGES to 1000
 *
 * Revision 1.4  1996/03/16 16:57:10  richards
 * renamed xrastool to xa
 * fixed indenting
 *
 * Revision 1.3  1996/03/14 21:59:39  richards
 * added HAVE_BASENAME and MAX_IMAGE_MEM
 * replaced memmove() with memcpy()
 *
 * Revision 1.2  1996/03/08 20:53:22  richards
 * removed absolute paths in ZCAT_FORMAT
 * replaced srandom with srand48, random with lrand48, bcopy with
 *    memmove, bzero with memset; added #define's to restore original
 * added typedef's for u_char, u_short, u_int, and u_long
 *
 * Revision 1.1  1996/02/21 20:48:25  richards
 * Initial revision
 *
 */

/* Format for favorite uncompression utility */

#define ZCAT_FORMAT "gunzip -c -q" /* Handles .Z and .gz */

/* Here's a version with the complete pathname */

/*#define ZCAT_FORMAT "/local/bin/gunzip -c -q"*/

/* Here are some other possibilities */

#ifndef ZCAT_FORMAT
#  if defined(SGI) || defined(SUN)
#    define ZCAT_FORMAT "/usr/bsd/uncompress"
#  else
#    define ZCAT_FORMAT "/usr/bin/uncompress"
#  endif
#endif

/*
#ifndef ZCAT_FORMAT
#  define ZCAT_FORMAT "uncompress"
#endif
*/

/* Uncomment the following if basename() is available */

/*#define HAVE_BASENAME*/

/* Global definitions */

#define LIVE_SLIDERS TRUE /* Set FALSE if dynamic color sliders too slow */

#define FAST_MODE (NO_SCROLLING | NO_RESIZING | NO_MOVING | NO_SCALING |\
		   NO_UPDATES | NO_BACKDROPS | LOCK_COLORS)

#define DFLT_FAST_TIMER_SCALE TIMER_MS /* Use 30 ms scale by dflt if -fast */
#define DFLT_FAST_TIMER_VALUE 30

#define MAX_NUM_IMAGES 1000 /* Adjust as needed */

/*
 * Use the following macro to limit the total allocation for image data.
 * A good rule of thumb is that MAX_IMAGE_MEM should be no more than half
 * the core memory of the server for best performance. Use 0 for no limit.
 *
 */

#define MAX_IMAGE_MEM 32 /* In megabytes */

/* If srand48() and lrand48() are not available, try these #define's */

/*
#define srand48 srandom
#define lrand48 random
*/

/*
 * If memcpy() and memset() are not available, try these #define's.
 * Note that memset() is only called with val equal to zero.
 *
 */

/*
#define memcpy(dest,src,len) bcopy((src),(dest),(len))
#define memset(dest,val,len) bzero((dest),(len))
*/

/* Uncomment the following if not defined */

/*
typedef unsigned char  u_char;
typedef unsigned short u_short;
typedef unsigned int   u_int;
typedef unsigned long  u_long;
*/

/* Keyboard accelerators */

#define CURSOR_LEFT  'h'
#define CURSOR_DOWN  'j'
#define CURSOR_UP    'k'
#define CURSOR_RIGHT 'l'

#define SET_KEY   '\015' /* Carriage return */
#define STEP_KEY  ' '    /* Space */
#define BACK_KEY  'b'
#define CYCLE_KEY 'c'
#define QUIT_KEY  'q'

/*
 * Marker for multi-frame images to indicate a single frame.
 * (e.g. :1 indicates the first frame, :2 the second, and so on).
 *
 */

#define FRAME_MARKER ':'

/* Window geometry */

#define HEADER_MARGIN 20 /* How can we determine these automatically? */
#define FOOTER_MARGIN 20
#define FRAME_BORDER   5

#define MIN_IMAGE_WIDTH  100 /* Could be smaller, depending on window mgr */
#define MIN_IMAGE_HEIGHT 100

#define MAX_IMAGE_WIDTH (ScreenWidth - 2 * FRAME_BORDER - ScrollMargin)

#define MAX_IMAGE_HEIGHT (ScreenHeight - HEADER_MARGIN  - 2 * FRAME_BORDER -\
			  ScrollMargin - ((Options & LIVE_CURSOR) ?\
					  FOOTER_MARGIN : 0))

#define FRAME_GAP 10
#define DFLT_BASE_FRAME_XV_X 50
#define DFLT_BASE_FRAME_XV_Y 50
#define DFLT_SUB_FRAME_XV_X DFLT_BASE_FRAME_XV_X
#define DFLT_SUB_FRAME_XV_Y\
          (DFLT_BASE_FRAME_XV_Y + FRAME_BORDER + HEADER_MARGIN +\
	  (int) xv_get(BaseFrame, XV_HEIGHT) + FOOTER_MARGIN + FRAME_BORDER +\
	  FRAME_GAP)
#define DFLT_CANVAS_FRAME_XV_X\
	  (DFLT_BASE_FRAME_XV_X + FRAME_BORDER + (int) xv_get(BaseFrame,\
	  XV_WIDTH) + FRAME_BORDER + FRAME_GAP)
#define DFLT_CANVAS_FRAME_XV_Y DFLT_BASE_FRAME_XV_Y

/*** config.h ***/
