;;
;; Exercise the drawing primatives for the map
;;

(define hostname "localhost")

;; marker drawing
(define gc-args (list gc:foreground "white"
		      gc:fill-style fill-solid))
(rmap-change-gc hostname gc-args)

(rmap-draw-strings hostname (list '(20 -110 "markers")))

(rmap-change-gc hostname (list gc:foreground "red"))
(rmap-draw-markers hostname marker-circle 15 '((30 -120)))
(rmap-change-gc hostname (list gc:foreground "green"))
(rmap-draw-markers hostname marker-square 15 '((20 -120)))
(rmap-change-gc hostname (list gc:foreground "blue"))
(rmap-draw-markers hostname marker-triangle 15 '((10 -120)))

;; line drawing
(rmap-change-gc hostname (list
			  gc:foreground "yellow"
			  gc:background "cyan"
			  gc:line-style line-on-off-dash
			  gc:line-width 4))
(rmap-draw-lines hostname '((-25 -100) (-20 -90) (20 -70) (25 -60)))
(rmap-change-gc hostname (list gc:foreground "white"))
(rmap-draw-strings hostname '((0 -70 "line")))

; polygon fill with stipple
(rmap-change-gc hostname (list
			  gc:foreground "white"
			  gc:background "light blue"))

;			  gc:fill-style fill-stippled
;			  gc:stipple gray-stipple))

(rmap-fill-polygon hostname (list
			     '(30 -30) '(30 10)
			     '(-30 10) '(-30 -30)))

(rmap-change-gc hostname (list gc:fill-style fill-solid))
(rmap-draw-strings hostname (list '(0 15 "stippled polygon fill")))

;; string drawing
(rmap-change-gc hostname (list
			  gc:foreground "hot pink"
			  gc:font "-*-times-*"))
(rmap-draw-strings hostname (list '(50 40 "This is a string!")))

