/*
 * rmapxdr.c
 */

#include <rpc/rpc.h>
#include "rmap.h"

bool_t
xdr_RMapGPoint(register XDR *xdrs, RMapGPoint *objp)
{
  if (!xdr_float(xdrs, &objp->lat))
    return FALSE;
  if (!xdr_float(xdrs, &objp->lon))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapGPointArray(register XDR *xdrs, RMapGPointArray *objp)
{
  if (!xdr_array(xdrs, (char **) &objp->pts, (unsigned int *) &objp->npts,
		 (unsigned int) ~0, sizeof(RMapGPoint),
		 (xdrproc_t) xdr_RMapGPoint))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapMarkerArray(register XDR *xdrs, RMapMarkerArray *objp)
{
  if (!xdr_enum(xdrs, (enum_t *) &objp->marker_type))
    return FALSE;

  if (!xdr_u_int(xdrs, (unsigned int *) &objp->marker_width))
    return FALSE;

  if (!xdr_array(xdrs, (char **) &objp->pts, (unsigned int *) &objp->npts,
		 (unsigned int) ~0, sizeof(RMapGPoint),
		 (xdrproc_t) xdr_RMapGPoint))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapString(register XDR *xdrs, RMapString *objp)
{
  if (!xdr_string(xdrs, (char **) &objp, (unsigned int) RMAP_STRING_LEN))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapStringArray(register XDR *xdrs, RMapStringArray *objp)
{
  if (!xdr_array(xdrs, (char **) &objp->pts, (unsigned int *) &objp->npts,
		 (unsigned int) ~0, sizeof(RMapGPoint),
		 (xdrproc_t) xdr_RMapGPoint))
    return FALSE;

  if (!xdr_array(xdrs, (char **) &objp->str, (unsigned int *) &objp->npts,
		 (unsigned int) ~0, sizeof(RMapString),
		 (xdrproc_t) xdr_RMapString))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapStipple(register XDR *xdrs, RMapStipple *objp)
{
  if (!xdr_u_int(xdrs, &objp->width))
    return FALSE;

  if (!xdr_u_int(xdrs, &objp->height))
    return FALSE;

  if (!xdr_RMapString(xdrs, &objp->bits))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapGCValues(register XDR *xdrs, RMapGCValues *objp)
{
  if (!xdr_int(xdrs, &objp->function))
    return FALSE;
  if (!xdr_u_long(xdrs, &objp->plane_mask))
    return FALSE;
  if (!xdr_RMapString(xdrs, &objp->foreground))
    return FALSE;
  if (!xdr_RMapString(xdrs, &objp->background))
    return FALSE;
  if (!xdr_int(xdrs, &objp->line_width))
    return FALSE;
  if (!xdr_int(xdrs, &objp->line_style))
    return FALSE;
  if (!xdr_int(xdrs, &objp->cap_style))
    return FALSE;
  if (!xdr_int(xdrs, &objp->join_style))
    return FALSE;
  if (!xdr_int(xdrs, &objp->fill_style))
    return FALSE;
  if (!xdr_int(xdrs, &objp->fill_rule))
    return FALSE;
  if (!xdr_int(xdrs, &objp->arc_mode))
    return FALSE;
  if (!xdr_RMapString(xdrs, &objp->tile))
    return FALSE;
  if (!xdr_RMapString(xdrs, &objp->stipple))
    return FALSE;
  if (!xdr_int(xdrs, &objp->ts_x_origin))
    return FALSE;
  if (!xdr_int(xdrs, &objp->ts_y_origin))
    return FALSE;
  if (!xdr_RMapString(xdrs, &objp->font))
    return FALSE;
  if (!xdr_int(xdrs, &objp->subwindow_mode))
    return FALSE;
  if (!xdr_bool(xdrs, &objp->graphics_exposures))
    return FALSE;
  if (!xdr_int(xdrs, &objp->clip_x_origin))
    return FALSE;
  if (!xdr_int(xdrs, &objp->clip_y_origin))
    return FALSE;
  if (!xdr_RMapString(xdrs, &objp->clip_mask))
    return FALSE;
  if (!xdr_int(xdrs, &objp->dash_offset))
    return FALSE;
  if (!xdr_char(xdrs, &objp->dashes))
    return FALSE;

  return TRUE;
}

bool_t
xdr_RMapGCDesc(register XDR *xdrs, RMapGCDesc *objp)
{
  if (!xdr_u_long(xdrs, &objp->mask))
    return FALSE;
  if (!xdr_RMapGCValues(xdrs, &objp->values))
    return FALSE;

  return TRUE;
}

