/* worldmap - a world map display program
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * rmapclnt.c
 */

#include <rpc/rpc.h>
#include "rmap.h"
#include "rmapxdr.h"

#define LOCALHOST "localhost"

enum clnt_stat
RMapClear(char *host)
{
  char *ret;

  return callrpc(host, PROGNUM, VERSION, CLEAR,
		 (xdrproc_t) xdr_void, (char *) NULL,
		 (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapFreeze(char *host)
{
  char *ret;

  return callrpc(host, PROGNUM, VERSION, FREEZE,
		 (xdrproc_t) xdr_void, (char *) NULL,
		 (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapDrawPoints(char *host, RMapGPoint *gp, unsigned int npts)
{
  RMapGPointArray gpa;
  char *ret;

  gpa.npts = npts;
  gpa.pts = gp;

  return callrpc(host, PROGNUM, VERSION, DRAW_POINTS,
		 (xdrproc_t) xdr_RMapGPointArray, (char *) &gpa,
		 (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapDrawMarkers(char *host, RMapGPoint *gp, unsigned int npts,
		RMapMarkerType marker_type, unsigned int marker_width)
{
  RMapMarkerArray ma;
  char *ret;

  ma.marker_type = marker_type;
  ma.marker_width = marker_width;
  ma.npts = npts;
  ma.pts = gp;

  return callrpc(host, PROGNUM, VERSION, DRAW_MARKERS,
		 (xdrproc_t) xdr_RMapMarkerArray, (char *) &ma,
		 (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapDrawLines(char *host, RMapGPoint *gp, unsigned int npts)
{
  RMapGPointArray gpa;
  char *ret;

  gpa.npts = npts;
  gpa.pts = gp;

  return callrpc(host, PROGNUM, VERSION, DRAW_LINES,
		      (xdrproc_t) xdr_RMapGPointArray, (char *) &gpa,
		      (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapFillPolygon(char *host, RMapGPoint *gp, unsigned int npts)
{
  RMapGPointArray gpa;
  char *ret;

  gpa.npts = npts;
  gpa.pts = gp;

  return callrpc(host, PROGNUM, VERSION, FILL_POLYGON,
		 (xdrproc_t) xdr_RMapGPointArray, (char *) &gpa,
		 (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapDrawStrings(char *host, RMapGPoint *gp, RMapString *s, unsigned int npts)
{
  RMapStringArray sa;
  char *ret;

  sa.npts = npts;
  sa.pts = gp;
  sa.str = s;

  return callrpc(host, PROGNUM, VERSION, DRAW_STRINGS,
		 (xdrproc_t) xdr_RMapStringArray, (char *) &sa,
		 (xdrproc_t) xdr_void, (char *) &ret);
}

enum clnt_stat
RMapChangeGC(char *host, RMapGCValues values, unsigned int mask)
{
  RMapGCDesc gcd;
  char *ret;

  gcd.mask = mask;
  gcd.values = values;

  return callrpc(host, PROGNUM, VERSION, CHANGE_GC,
		 (xdrproc_t) xdr_RMapGCDesc, (char *) &gcd,
		 (xdrproc_t) xdr_void, (char *) &ret);
}




