/* worldmap - a world map display program
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * menubar.c - create functions and callbacks
 */

#include <stdio.h>
#include <assert.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include "Map.h"

#include "help.h"
#include "message.h"
#include "xtutil.h"

static void Map(Widget w, XtPointer client_data, XtPointer call_data);
static void Help(Widget w, XtPointer client_data, XtPointer call_data);

Widget
CreateMenubar(Widget main_window)
{
  Widget menubar, menu, widget;
  XmString file, map, help;
  XmString open, save, save_as, egzit;
  XmString clear, freeze, unzoom, reset, resources, limits, grid, basemap;

  void File(Widget w, XtPointer client_data, XtPointer call_data);

  /* Create a simple MenuBar that contains three menus */
  file     = XmStringCreateSimple("File");
  map      = XmStringCreateSimple("Map");
  help     = XmStringCreateSimple("Help");
  menubar = \
    XmVaCreateSimpleMenuBar(main_window, "menubar",
			    XmVaCASCADEBUTTON, file,     'F',
			    XmVaCASCADEBUTTON, map,      'M',
			    XmVaCASCADEBUTTON, help,     'H',
			    NULL);
  assert(XmIsRowColumn(menubar));

  XmStringFree(file);
  XmStringFree(map);
  /* don't free "help" compound string yet -- reuse it later */
	
  /* Tell the menubar which button is the help menu  */
  if ((widget = XtNameToWidget(menubar, "button_2")) != NULL)
    XtVaSetValues(menubar, XmNmenuHelpWidget, widget, NULL);

  /* First menu is the File menu -- callback is File() */
  open    = XmStringCreateSimple("Open...");
  save    = XmStringCreateSimple("Save");
  save_as = XmStringCreateSimple("Save As...");
  egzit  = XmStringCreateSimple("Exit");
  XmVaCreateSimplePulldownMenu(menubar, "fileMenu", 0,
			       (XtCallbackProc) File,
			       XmVaPUSHBUTTON, open,    'O', NULL, NULL,
			       XmVaPUSHBUTTON, save,    'S', NULL, NULL,
			       XmVaPUSHBUTTON, save_as, 'A', NULL, NULL,
			       XmVaPUSHBUTTON, egzit,   'x', NULL, NULL,
			       NULL);
  XmStringFree(open);
  XmStringFree(save);
  XmStringFree(save_as);
  XmStringFree(egzit);

  /* Third menu is the Query menu */
  clear = XmStringCreateSimple("Clear");
  freeze = XmStringCreateSimple("Freeze");
  reset = XmStringCreateSimple("Reset");
  unzoom = XmStringCreateSimple("Unzoom");
  resources = XmStringCreateSimple("Resources...");
  limits  = XmStringCreateSimple("Limits...");
  grid = XmStringCreateSimple("Grid...");
  basemap = XmStringCreateSimple("Basemap...");
  menu = \
    XmVaCreateSimplePulldownMenu(menubar, "mapMenu", 1,
				 (XtCallbackProc) Map,
				 XmVaPUSHBUTTON, clear,  'C', NULL, NULL,
				 XmVaPUSHBUTTON, freeze,  'F', NULL, NULL,
				 XmVaPUSHBUTTON, reset, 'R', NULL, NULL,
				 XmVaPUSHBUTTON, unzoom, 'U', NULL, NULL,
				 XmVaPUSHBUTTON, resources, 'E', NULL, NULL,
				 NULL);
  XmStringFree(clear);
  XmStringFree(freeze);
  XmStringFree(reset);
  XmStringFree(unzoom);
  XmStringFree(resources);
  XmStringFree(limits);
  XmStringFree(basemap);

  /* This is the help menu -- callback is Help() */
  XmVaCreateSimplePulldownMenu(menubar, "help_menu", 2,
			       Help,
			       XmVaPUSHBUTTON, help, 'H', NULL, NULL,
			       NULL);

  XmStringFree(help);		/* we're done with it; now we can free it */
  XtManageChild(menubar);

  return menubar;
}

static void
Map(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int item_no = (int) client_data;
  static Widget draw_dialog = NULL;
  Widget map = (Widget) XtNameToWidget(TopLevel(widget), "*map");

  Widget CreateProjectionDialog(Widget widget);
  Widget CreateLimitsDialog(Widget widget);
  Widget CreateBasemapDialog(Widget widget);

  assert(XmIsMap(map));

  switch (item_no)
    {
    case 0:
      XmMapClear(map);
      SetMessageArea("Map cleared");
      break;

    case 1:
      XmMapFreeze(map);
      SetMessageArea("New base map applied");
      break;

    case 2:
      XmMapReset(map);
      SetMessageArea("New base map applied");
      break;

    case 3:
      XmMapUnzoom(map);
      SetMessageArea("Map unzoomed");
      break;

    case 4:
      if (!draw_dialog)
	  draw_dialog = CreateBasemapDialog(widget);

      XtManageChild(draw_dialog);
      XtPopup(draw_dialog, XtGrabNone);
      break;

    default:
      break;
    }
}

#define MSG "This is where help text should go"

static void
Help(Widget widget, XtPointer client_data, XtPointer call_data)
{
  PopupHelp(widget, MSG, NULL);
}
