/*
 * MapResCvt.c - type converter for XmRString to XmMapProjection
 */

#include <X11/Intrinsic.h>
#include <X11/Xmu/Xmu.h>

#include "Map.h"

#define done(address, type)                             \
    {                                                   \
        if(to->addr)                     	        \
        {                                               \
            if(to->size < sizeof(type))                 \
            {                                           \
                to->size = sizeof(type);                \
                return( FALSE) ;                        \
            }                                           \
            else                                        \
            {   *((type *) (to->addr)) = *address;      \
            }                                           \
        }                                               \
        else                                            \
        {                                               \
            to->addr = (XPointer) address;              \
        }                                               \
        to->size = sizeof(type);                        \
    }

/* instead for comparing "from" to the enumeration strings, "miller"
   etc., we will convert the enum strings to quarks, save them in
   static vars, and compare them to the quark of the incoming string.
   This is faster if the function gets called frequently */
Boolean
CvtStringToProjection(Display *display, XrmValuePtr args, Cardinal
		      num_args, XrmValuePtr from, XrmValuePtr to,
		      XtPointer *converter_data)
{
  static XmProjection p;
  static XrmQuark qe_eqdist, qe_eckert, qe_hammer, qe_mercator, qe_miller;
  static XrmQuark qe_mollweide, qe_orthographic, qe_sinusoidal;
  static Boolean have_quarks = False;
  XrmQuark q;
  char *s = (char *) from->addr;
  char lower_name[60];

  if (s == NULL) return False;

  if (!have_quarks)
    {
      /* the allowable strings */
      qe_eqdist       = XrmPermStringToQuark("eqdist");
      qe_eckert       = XrmPermStringToQuark("eckert");
      qe_hammer       = XrmPermStringToQuark("hammer");
      qe_mercator     = XrmPermStringToQuark("mercator");
      qe_miller       = XrmPermStringToQuark("miller");
      qe_mollweide    = XrmPermStringToQuark("mollweide");
      qe_orthographic = XrmPermStringToQuark("orthographic");
      qe_sinusoidal   = XrmPermStringToQuark("sinusoidal");

      have_quarks = True;
    }

  /* cause the quarks are lowered */
  XmuCopyISOLatin1Lowered(lower_name, s);

  q = XrmStringToQuark(lower_name);

  if (q == qe_eqdist)
    p = XmCYL_EQDIST_PROJECTION;
  else if (q == qe_eckert)
    p = XmECKERT_VI_PROJECTION;
  else if (q == qe_hammer)
    p = XmHAMMER_PROJECTION;
  else if (q == qe_mercator)
    p = XmMERCATOR_PROJECTION;
  else if (q == qe_miller)
    p = XmMILLER_PROJECTION;
  else if (q == qe_mollweide)
    p = XmMOLLWEIDE_PROJECTION;
  else if (q == qe_orthographic)
    p = XmORTHOGRAPHIC_PROJECTION;
  else if (q == qe_sinusoidal)
    p = XmSINUSOIDAL_PROJECTION;
  else
    {
      XtDisplayStringConversionWarning(display, (char *) from->addr,
				       XmRMapProjection);
      return False;
    }

  done(&p, XmProjection);

  return True;
}

Boolean
CvtStringToMarkerType(Display *display, XrmValuePtr args, Cardinal
		      num_args, XrmValuePtr from, XrmValuePtr to,
		      XtPointer *converter_data)
{
  static XmMarkerType t;
  static XrmQuark XrmQEcircle, XrmQEsquare, XrmQEtriangle;
  static Boolean have_quarks = False;
  XrmQuark q;
  char *s = (char *) from->addr;
  char lower_name[60];

  if (s == NULL) return False;

  if (!have_quarks)
    {
      /* the allowable strings */
      XrmQEcircle   = XrmPermStringToQuark("circle");
      XrmQEsquare   = XrmPermStringToQuark("square");
      XrmQEtriangle = XrmPermStringToQuark("triangle");

      have_quarks = True;
    }

  /* cause the quarks are lowered */
  XmuCopyISOLatin1Lowered(lower_name, s);

  q = XrmStringToQuark(lower_name);

  if (q == XrmQEcircle)
      t = XmCIRCLE;
  else if (q == XrmQEsquare)
      t = XmSQUARE;
  else if (q == XrmQEtriangle)
      t = XmTRIANGLE;
  else
    {
      XtDisplayStringConversionWarning(display, (char *) from->addr,
				       XmRMapMarkerType);
      return False;
    }

  done(&t, XmMarkerType);

  return True;
}
