/*--------------------------------*-C-*---------------------------------*
 * File:	screen.h
 *
 * This module is all new by Robert Nation
 * <nation@rocket.sanders.lockheed.com>
 *
 * Additional modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _SCREEN_H
#define _SCREEN_H

typedef struct {
   int width, height;	/* window size [pixels] */
   int fwidth, fheight;	/* font width and height [pixels] */
   int ncol, nrow;	/* window size [characters] */
   int hist_size;	/* # lines to save in scrollback buffer */
   int hist_start;	/* how far back into the scrollback buffer */
   int hist_count;	/* how many scrolled lines saved */
   Window parent;	/* parent/main window */
   Window vt;		/* vt100 window */
} TermWin_t;
extern TermWin_t TermWin;
#define MARGIN 2		/* gap between the text and window edges */

/* Screen refresh methods */
#define NO_REFRESH	2	/* Window not visible at all! */
#define SLOW_REFRESH	1	/* No Bitblt */
#define FAST_REFRESH	0

#define IGNORE	0
#define SAVE	's'
#define RESTORE	'r'

/*  flags for scr_gotorc() */
#define C_RELATIVE	1	/* col movement is relative */
#define R_RELATIVE	2	/* row movement is relative */
#define RELATIVE (R_RELATIVE|C_RELATIVE)	/* move row/col relative */

/* modes for scr_erase_line() scr_erase_screen() */
#define DEL_END		0	/* don't change these values */
#define DEL_START	1
#define DEL_ENTIRE	2

/* modes for scr_insdel_chars(), scr_insdel_lines() */
#define INSERT	-1		/* don't change these values */
#define DELETE	+1
#define ERASE	+2

/* modes for scr_page() */
#define UP	+1		/* don't change these values */
#define DOWN	-1

/* arguments for scr_change_screen() */
#define PRIMARY		0
#define SECONDARY	1

/* rendition style flags */
#define RS_NONE		(0)	/* Normal */
#define RS_FONTMASK	(0x03)	/* occupy two bits */
#define RS_ASCII	(0)	/* ASCII character set */
#define RS_GRFONT	(0x01)	/* graphics character set */
#define RS_GBFONT	(0x02)	/* UK character set */
#define RS_CURSOR	(0x04)	/* cursor location */
#define RS_SELECTED	(0x08)	/* selected text */
#define RS_BOLD		(0x10)	/* bold */
#define RS_ULINE	(0x20)	/* underline */
#define RS_BLINK	(0x40)	/* blink */
#define RS_RVID		(0x80)	/* reverse video */

#define RS_FGMASK	0x0000FF00
#define RS_BGMASK	0x00FF0000
#define RS_ATTRMASK	0x000000FF

#ifdef KANJI
# define RL_KANJI1	0x02000000	/* kanji 1st byte */
# define RL_KANJI2	0x06000000	/* kanji 2nd byte */
# define RL_KANJI0	0x04000000	/* only kanji */
#endif

/* how to build & extract colors and attributes */
#define GET_FG_COLOR(r)		((r & RS_FGMASK)>>8)
#define GET_BG_COLOR(r)		((r & RS_BGMASK)>>16)
#define GET_ATTR(r)		((r & RS_ATTRMASK))

#define SET_FG_COLOR(r,fg)  (((r) & ~RS_FGMASK)  | ((fg)<<8))
#define SET_BG_COLOR(r,bg)  (((r) & ~RS_BGMASK)  | ((bg)<<16))
#define SET_RSTYLE(r,fg,bg) (((r) & RS_ATTRMASK) | ((fg)<<8) | ((bg)<<16))
#define SET_ATTR(r,a)	    (((r) & ~RS_ATTRMASK)| (a))

#ifdef __cplusplus
extern "C" {
#endif
   extern void	scr_reset (void);
   extern void	scr_poweron (void);
   extern void	scr_backspace (void);
   extern void	scr_bell (void);
   extern int	scr_change_screen (int scrn);
   extern void	scr_rendition (int set, int style);
   extern void	scr_focus (int in_focus);
   extern void	scr_add_lines (unsigned char *c, int nl_count, int n);
   extern void	scr_tab (int count);
   extern void	scr_gotorc (int row, int col, int relative);
   extern void	scr_index (int direction);
   extern void	scr_cursor (int mode);
   extern void	scr_erase_line (int mode);
   extern void	scr_erase_screen (int mode);
   extern void	scr_insdel_lines (int count, int insdel);
   extern void	scr_insdel_chars (int count, int insdel);
   extern void	scr_scroll_region (int top, int bot);
   extern void	scr_move_to (int y);
   extern void	scr_page (int dirn, int n);
   extern void	scr_selection_make (Time time);
   extern void	scr_selection_send (XSelectionRequestEvent *rq);
   extern void	scr_selection_request (Time time, int x, int y);
   extern void	scr_paste_primary (Window win, int prop, int Delete);
   extern void	scr_selection_clear (void);
   extern void	scr_selection_delete (void);
   extern void	scr_selection_extend (int hilite, int x, int y);
   extern void	scr_selection_start (int x, int y);
   extern void	scr_selection_click (int clicks, int x, int y);
   extern void	scr_report_position (void);
   extern void	scr_touch (int x, int y, int width, int height);
   extern void	scr_charset_set (int set, unsigned char a);
   extern void	scr_charset_choose (int set);
   extern void	scr_refresh_region (int startr, int endr, int type);
   extern void	scr_refresh (int type);
   extern void	scr_set_tab (int mode);
   extern void	scr_E (void);
   extern void	scr_fgcolor (int color);
   extern void	scr_bgcolor (int color);
   extern void	mouse_report (XButtonEvent *ev);
   /* mode selections */
   extern void	scr_autowrap (int mode);
   extern void	scr_relative_origin (int mode);
   extern void	scr_insert_mode (int mode);
   extern void	scr_rvideo_mode (int mode);
#ifdef PRINTPIPE
   extern void	scr_printscreen (int fullhist);
#endif
#ifdef KANJI
   extern void	set_kanji_encoding (const char *str);
#endif
#ifdef __cplusplus
}
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
