/*--------------------------------*-C-*---------------------------------*
 * File:	defaults.h
 *
 * Some wired-in defaults so we can run without external resources.
 * Split from configure.h so fiddling won't require a full rebuild.
 *
 * These values are only used in xsetup.c
 * ----------------------------------------------------------------------
 * Copyright 1995, 1996
 * mj olesen <olesen@me.queensu.ca> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _DEFAULTS_H
#define _DEFAULTS_H

/* various Keysym(s), self-explanatory */

/* these are recognized only with the HOTKEY combination */
#define DEF_KS_BIGFONT		XK_greater
#define DEF_KS_SMALLFONT	XK_less
#define DEF_KS_PAGEUP		XK_Prior
#define DEF_KS_PAGEDOWN		XK_Next
#define DEF_KS_ALERT		XK_I	/* note upper-case */

/* these are recognized on their own */
#define DEF_KS_PRINTSCREEN	XK_Print
#define DEF_KS_GREEKTOGGLE	XK_Mode_switch

/* window size */
#define DEF_GEOMETRY	"80x24"

#define DEF_CURSOR      "xterm"		/* default cursor name (not yet) */

/* default Kanji font names, roman fonts sized to match */
#ifdef KANJI
# define DEF_KFONT0	"k14"
# define DEF_FONT0	"7x14"
# if (NFONTS > 1)
#  define DEF_KFONT1	"jiskan16"
#  define DEF_KFONT2	"jiskan18"
#  define DEF_KFONT3	"jiskan24"
#  define DEF_KFONT4	"jiskan26"
#  define DEF_FONT1	"8x16"
#  define DEF_FONT2	"9x18"
#  define DEF_FONT3	"12x24"
#  define DEF_FONT4	"13x26"
# endif
#else
# if (NFONTS > 1)		/* multi-font mode */
#  define DEF_FONT0	"8x13"
#  define DEF_FONT1	"5x8"
#  define DEF_FONT2	"7x14"
#  define DEF_FONT3	"9x15"
#  define DEF_FONT4	"10x20"
# else				/* single font mode */
#  define DEF_FONT0	"fixed"
# endif
#endif

#define NORM_FONT	1	/* font position in list (multi-font mode) */
#define DEF_SCROLLBACK	64	/* scrollback size [lines] */
#define DEF_MAPALERT	0	/* initial map alert state [0,1]*/
#define DEF_VISUALBELL	0	/* initial visual bell state [0,1]*/

/* character class of separating chars for multiple-click selection */
#define DEF_CUTCHARS	"\t [](){|}<=>\"`,'*?;&"

/* default scrollbar type (choose 1) */
#define DEF_SCROLLBAR	SBAR_XTERM	/* XTerm-style (without arrows) */
/*#define DEF_SCROLLBAR	SBAR_ARROWS*/	/* add arrows */
/*#define DEF_SCROLLBAR	SBAR_NONE*/	/* no scrollbar */

/* normal foreground/background colors */
#define DEF_COLORFG	"black"
#define DEF_COLORBG	"white"

#ifndef NO_COLOR
#ifdef USE_FAKE_BOLD
#  define DEF_COLOR0	"black"		/* black	(#000000) */
#  define DEF_COLOR1	"red"		/* red		(#FF0000) */
#  define DEF_COLOR2	"green"		/* green	(#00FF00) */
#  define DEF_COLOR3	"yellow"	/* yellow	(#FFFF00) */
#  define DEF_COLOR4	"blue"		/* blue		(#0000FF) */
#  define DEF_COLOR5	"magenta"	/* magenta	(#FF00FF) */
#  define DEF_COLOR6	"cyan"		/* cyan		(#00FFFF) */
#  define DEF_COLOR7	"white"		/* white	(#FFFFFF) */
#elif defined (DOS_VGA_COLORS)
#  define DEF_COLOR0	"black"		/* black	(#000000) */
#  define DEF_COLOR1	"#A80000"	/* red		(#) */
#  define DEF_COLOR2	"#00A800"	/* green	(#) */
#  define DEF_COLOR3	"#A8A800"	/* yellow	(#) */
#  define DEF_COLOR4	"#0000A8"	/* blue		(#) */
#  define DEF_COLOR5	"#A800A8"	/* magenta	(#) */
#  define DEF_COLOR6	"#00A8A8"	/* cyan		(#) */
#  define DEF_COLOR7	"#A8A8A8"	/* white	(#) */
/* bold foreground, blink background colors */
#  define DEF_COLOR10	"#000054"	/* Bold black	(#) */
#  define DEF_COLOR11	"#FF0054"	/* Bold red	(#) */
#  define DEF_COLOR12	"#00FF54"	/* Bold green	(#) */
#  define DEF_COLOR13	"#FFFF54"	/* Bold yellow	(#) */
#  define DEF_COLOR14	"blue"		/* Bold blue	(#0000FF) */
#  define DEF_COLOR15	"magenta"	/* Bold magenta (#FF00FF) */
#  define DEF_COLOR16	"cyan"		/* Bold cyan	(#00FFFF)*/
#  define DEF_COLOR17	"white"		/* Bold white	(#FFFFFF) */
#else	/* DOS_VGA_COLORS */
#  define DEF_COLOR0	"black"		/* black	(#000000) */
#  define DEF_COLOR1	"red3"		/* red		(#CD0000) */
#  define DEF_COLOR2	"green3"	/* green	(#00CD00) */
#  define DEF_COLOR3	"yellow3"	/* yellow	(#CDCD00) */
#  define DEF_COLOR4	"blue3"		/* blue		(#0000CD) */
#  define DEF_COLOR5	"magenta3"	/* magenta	(#CD00CD) */
#  define DEF_COLOR6	"cyan3"		/* cyan		(#00CDCD) */
#  define DEF_COLOR7	"LightGrey"	/* white	(#D3D3D3) */
/* bold foreground, blink background colors */
#  define DEF_COLOR10	"grey25"	/* Bold black	(#404040) */
#  define DEF_COLOR11	"red"		/* Bold red	(#FF0000) */
#  define DEF_COLOR12	"green"		/* Bold green	(#00FF00) */
#  define DEF_COLOR13	"yellow"	/* Bold yellow	(#FFFF00) */
#  define DEF_COLOR14	"blue"		/* Bold blue	(#0000FF) */
#  define DEF_COLOR15	"magenta"	/* Bold magenta (#FF00FF) */
#  define DEF_COLOR16	"cyan"		/* Bold cyan	(#00FFFF) */
#  define DEF_COLOR17	"white"		/* Bold white	(#FFFFFF) */
#endif	/* USE_FAKE_BOLD */
#endif	/* NO_COLOR */

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
