static char rcsid[] = "$Id: panel.c,v 1.5 1995/05/10 09:11:52 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* panel.c

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_PANEL

static void rtcPostPanel(
#if NeedFunctionPrototypes
			 Widget		button,
			 RTCObject	*object,
			 XtPointer	call
#endif
			 );

static void rtcPanelDefaults(
#if NeedFunctionPrototypes
			     Widget	button,
			     RTCObject	*object,
			     XtPointer	call
#endif
			 );

static void rtcExecuteCommand(
#if NeedFunctionPrototypes
			     Widget	button,
			     RTCObject	*object,
			     XtPointer	call
#endif
			 );


#if NeedFunctionPrototypes
ObjectReturnType RtcParsePanelDef(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParsePanelDef(master, parent, object, line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{

      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars;
      char	*ptr;
      
      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

      sscanf(ptr,"%s",keyword);

      object->name = XtNewString(keyword);


      return ( Parent );
      
}


#if NeedFunctionPrototypes
ObjectReturnType RtcParseEndPanel(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParseEndPanel(master, parent, object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{

      return( Reset );
      
}


#if NeedFunctionPrototypes
ObjectReturnType RtcParsePanel(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParsePanel(master, parent, object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				     object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }
 
	    ptr += num_chars;

      }

      sscanf(ptr,"%s",keyword);
 
      object->data = XtNewString(keyword);

      object->parent = parent;
 
      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc(	sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

       object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;

      return( Child );
      
}

#if NeedFunctionPrototypes
void RtcCreatePanel(RTCObject *object)
#else
void RtcCreatePanel(object)
RTCObject	*object;
#endif
{

      XmString	xmstr = NULL;
      Widget	button;
      Pixmap	pixmap;
      Boolean	good_pixmap = False;
      Arg	args[5];
      int	n;
      
      
     n=0;
      
      if ( object->option_mask & IconFileMask ) 
	    good_pixmap = RtcGetPixmap(object,&pixmap);

      if ( good_pixmap ) {
	    XtSetArg( args[n], XmNlabelType, XmPIXMAP);n++;
	    XtSetArg( args[n], XmNlabelPixmap, pixmap);n++;
      }
      else {	 
	    xmstr = XmStringCreateLtoR(object->name,"menu-buttons");

	    XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
	    XtSetArg( args[n], XmNlabelString, xmstr);n++;
      }


      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "panel",
					   args,
					   n);

      XtAddCallback(button, 
		    XmNactivateCallback, 
		    (XtCallbackProc) rtcPostPanel,
		    (XtPointer) object);

#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayHelp,
			  (XtPointer) object);
      }
#endif      
	    
      XtManageChild( button );

/* will be testing this soon... */
      object->widget = NULL;
      
      if ( xmstr ) 
	    XmStringFree(xmstr);
      

 
}


#if NeedFunctionPrototypes
static void rtcPostPanel(Widget button, RTCObject *object, XtPointer call)
#else
static void rtcPostPanel(button,object,call)
Widget	button;
RTCObject *object;
XtPointer call;
#endif
{

      Widget	dialog,dialogshell,rowcol,feedback=NULL,widget,ok,cancel,help,separator,action_form;
      char	title[64];
      Arg	args[10];
      int	i,n=0;
      RTCPanel	*panel;
      
      extern Widget TopLevel;
      
      

      if ( object->widget == NULL )  { 

	    panel = (RTCPanel *) XtMalloc(sizeof(RTCPanel));

	    sprintf(title,"%s Panel",object->name);

	    XtSetArg(args[n], XmNtitle,title );n++;
#ifndef WANT_BROKEN_FORM_WORKAROUND
	    dialog = XmCreateInformationDialog(TopLevel,
					       "panel",
					       args,
					       n);

	    XtAddCallback(dialog, XmNokCallback, 
			  (XtCallbackProc) RtcExecuteCommand,
			  (XtPointer) object);

	    XtAddCallback(dialog, XmNcancelCallback, 
			  (XtCallbackProc) RtcUnmanageDialog,
			  (XtPointer) dialog);


	    XtAddCallback(dialog, XmNhelpCallback, 
			  (XtCallbackProc) rtcPanelDefaults,
			  (XtPointer) object->children[0]);

#else      	
	    dialogshell = XmCreateDialogShell(TopLevel,
					      "panel-shell",
					      args,
					      n);

	    dialog = XtVaCreateWidget("panel",
				      xmFormWidgetClass,
				      dialogshell,
				      NULL);

	    action_form = XtVaCreateWidget("action-form",
					   xmFormWidgetClass,
					   dialog,
/*					   XmNtopAttachment,XmATTACH_WIDGET,
					   XmNtopWidget, separator, */
					   XmNleftAttachment,XmATTACH_FORM,
					   XmNrightAttachment,XmATTACH_FORM,
					   XmNbottomAttachment,XmATTACH_FORM,
					   XmNfractionBase,7,
					   NULL);
      
	    separator = XtVaCreateManagedWidget("sep",
						xmSeparatorGadgetClass,
						dialog,
						XmNleftAttachment,XmATTACH_FORM,
						XmNrightAttachment,XmATTACH_FORM,
						XmNbottomAttachment,XmATTACH_WIDGET,
						XmNbottomWidget, action_form,
						NULL);

	    ok = XtVaCreateManagedWidget("OK",
				   xmPushButtonGadgetClass,
				   action_form,
				   XmNtopAttachment,XmATTACH_FORM,
				   XmNleftAttachment,XmATTACH_POSITION,
				   XmNleftPosition,1,
				   XmNrightAttachment,XmATTACH_POSITION,
				   XmNrightPosition,2,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNshowAsDefault, True,
				   NULL);

      
	    cancel = XtVaCreateManagedWidget("Cancel",
				       xmPushButtonGadgetClass,
				       action_form,
				       XmNtopAttachment,XmATTACH_FORM,
				       XmNleftAttachment,XmATTACH_POSITION,
				       XmNleftPosition,3,
				       XmNrightAttachment,XmATTACH_POSITION,
				       XmNrightPosition,4,
				       XmNbottomAttachment, XmATTACH_FORM,
				       NULL);

	    help = XtVaCreateManagedWidget("Help",
				       xmPushButtonGadgetClass,
				       action_form,
				       XmNtopAttachment,XmATTACH_FORM,
				       XmNleftAttachment,XmATTACH_POSITION,
				       XmNleftPosition,5,
				       XmNrightAttachment,XmATTACH_POSITION,
				       XmNrightPosition,6,
				       XmNbottomAttachment, XmATTACH_FORM,
				       NULL);
      
	    XtAddCallback(cancel,XmNactivateCallback, (XtCallbackProc) RtcUnmanageDialog, (XtPointer) dialogshell);
	    XtAddCallback(ok,XmNactivateCallback, (XtCallbackProc) rtcExecuteCommand, (XtPointer) object);
	    XtAddCallback(cancel,XmNactivateCallback, (XtCallbackProc) rtcPanelDefaults, (XtPointer) object->children[0]);

	    XtManageChild( action_form );
      
#endif

	    rowcol= XtVaCreateWidget("rowcol",
				     xmRowColumnWidgetClass,
				     dialog,
				     XmNrightAttachment,  XmATTACH_FORM,
				     XmNleftAttachment,  XmATTACH_FORM,
				     XmNtopAttachment,  XmATTACH_FORM,
#ifdef WANT_BROKEN_FORM_WORKAROUND
				     XmNbottomAttachment,XmATTACH_WIDGET,
				     XmNbottomWidget,separator,
#endif
				     NULL);
	    
	    object->widget = dialog;

	    

/* object->children[0] is the Panel Def. */
	    object->children[0]->data = (char *) panel;
	    

	    object->children[0]->widget = rowcol;

	    for ( i=0; i < object->children[0]->num_children ; i++ )  { 

		  if ( object->children[0]->children[i]->create ) 
			object->children[0]->children[i]->create( object->children[0]->children[i] );
	    }

	    if ( object->master->resources.msgLevel > Warning ) { 

		  n=0;
 		  XtSetArg( args[n] , XmNeditable, False );n++;
		  XtSetArg( args[n] , XmNcursorPositionVisible, False );n++;
		  XtSetArg( args[n] , XmNhighlightThickness, 0 );n++;
		  XtSetArg( args[n] , XmNeditMode,  XmSINGLE_LINE_EDIT);n++;

		  feedback = XmCreateScrolledText(rowcol,
						  "cmd-feedback",
						  args,
						  n);
		  
		  
		  XtVaGetValues(XtParent(feedback), XmNhorizontalScrollBar, &widget,NULL);
		  XtVaSetValues(widget, 
				XmNheight,15,
				XmNshowArrows,  False,
				NULL); 

		  XtManageChild( feedback );
		  
	    }
	       
	    panel->statuslabel = feedback;
#ifdef WANT_BROKEN_FORM_WORKAROUND
	    panel->ok = cancel;
	    panel->def = help;
	    panel->execute = ok;
#else
	    panel->ok = XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON) ;
	    panel->def = XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON);
	    panel->execute = XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON);
	    
	    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL));
	    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_SYMBOL_LABEL));
#endif

	    XtManageChild( rowcol );


	    RtcUpdatePanelStatus(object->children[0]);

#ifdef WANT_BROKEN_FORM_WORKAROUND
	    XtManageChild(dialog);
#endif	    
      }

    
#ifndef WANT_BROKEN_FORM_WORKAROUND
      XtManageChild(object->widget);
#else
      XtPopup(XtParent(object->widget), XtGrabNone);
#endif
      

}

#if NeedFunctionPrototypes
static void rtcPanelDefaults(Widget button, RTCObject *object, XtPointer call)
#else
static void rtcPanelDefaults(button,object,call)
Widget	button;
RTCObject *object;
XtPointer call;
#endif
{

      int	i;
      

      for (i=0;i< object->num_children;i++) {

	    if ( object->children[i]->config ) 

		  (void) object->children[i]->config(object->children[i],ResetToDefault);
      }
      
      
      RtcUpdatePanelStatus(object);

}

/* 
   private function to popdown the panel before calling execute cmd
   ONLY used if WANT_BROKEN_FORM_WORKAROUND is used (no messagebox)
*/
#if NeedFunctionPrototypes
static void rtcExecuteCommand(Widget button, RTCObject *object, XtPointer call)
#else
static void rtcExecuteComand(button,object,call)
Widget	button;
RTCObject *object;
XtPointer call;
#endif
{

      XtPopdown(XtParent(XtParent(XtParent(button))));
      
      RtcExecuteCommand(button,object,call);

}


#if NeedFunctionPrototypes
void RtcUpdatePanelStatus(RTCObject *panel)
#else
void RtcUpdatePanelStatus(panel)
RTCObject *panel;
#endif
{

      char 	*ptr;

      ptr = RtcMakeCmdString(panel);

      RtcMsg(panel->master,Diagnostics,"panel cmd %s\n",ptr);

      if ( ((RTCPanel *) panel->data)->statuslabel != NULL )
	    XtVaSetValues(((RTCPanel *) panel->data)->statuslabel,
			  XmNvalue,ptr,
			  NULL);
      


/* update the command, ready for execution */

      if ( panel->parent->command )
	    XtFree(panel->parent->command);
      
      panel->parent->command = ptr;
      
}

#if NeedFunctionPrototypes
char *RtcMakeCmdString(RTCObject *panel)
#else
char *RtcMakeCmdString(panel)
RTCObject *panel;
#endif
{

      char	*new,*str,word[127], *res, *name;
      int	i,j,k,l;
      

      str = panel->command;
      
      new = (char *) malloc(MAX_LINE_LEN);

      new[0]= '\0';

      for (i=0,j=0; i < strlen(str); i++ ) { 
	    if ( str[i] != '@' ) { 
		  new[j] = str[i];
		  j++;
		  new[j] = '\0';
	    }
	    else {

		  sscanf(&str[i+1],"%s",word);
		  
		  k=0;
		  while( word[k] && isalpha(word[k]) )
			k++;
		  
		  word[k] = '\0';
		  
		  for ( l=0; l< panel->num_children;l++) { 
			
			if ( panel->children[l]->config )  {
			      if ( ! strncmp(word,panel->children[l]->command, strlen(word))) {
			      
				    res = panel->children[l]->config(panel->children[l],GetResultValue);
				    name = panel->children[l]->config(panel->children[l],GetResultName);

				    strcat( new, res);

				    j += strlen( res );
				    i += strlen( name ) ;
			      
				    break;
			      }
			}
			
		  }
	    }
      }
      
      return ( new );

}



#endif /* WANT_PANEL */
