static char rcsid[] = "$Id: panel-toggle.c,v 1.5 1995/03/17 13:43:05 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* panel-toggle.c

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_PANEL

static void rtcToggleCallback(
#if NeedFunctionPrototypes
			    Widget	widget,
			    RTCObject	*object,
			    XtPointer	call
#endif
			    );


#if NeedFunctionPrototypes
ObjectReturnType RtcParseToggle(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParseToggle(master, parent, object, line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*result,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;
      
      result = strchr(ptr,'=');
      
      if ( result ) {
	    result++;
	    sscanf(result,"%s",keyword);
	    object->command = XtNewString(keyword);

	    result += strlen(keyword);

	    object->data = XtNewString(result);

      }
      else { 
	    RtcMsg(object->master,Error,"No result indicator (=) in line %s\n",line);
	    return ( Child );
	    
      }
      
      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return ( Child );
      
}


#if NeedFunctionPrototypes
void RtcCreateToggle(RTCObject *object)
#else
void RtcCreateToggle(object)
RTCObject	*object;
#endif
{

      Widget	frame,form,label,radio,toggle;
      XmString	xmstr;
      int	i=0;
      int	n;
      Arg	args[6];
      char	*line,*item,**items=NULL,*user,*def=NULL;
      int	num_chars;
      

      frame = XtVaCreateWidget("panel-entry-frame",
			       xmFrameWidgetClass,
			       object->parent->widget,
			       NULL);
      
#ifdef HAVE_MOTIF_1_1
      form = XtVaCreateWidget("panel-entry-form",
			      xmFormWidgetClass,
			      frame,
			      NULL);
#else
      form = frame;
#endif

      xmstr = XmStringCreateLtoR(object->name,"panel-prompt");
	    
      label = XtVaCreateManagedWidget("panel-entry-label",
				      xmLabelGadgetClass,
				      form,
				      XmNtopAttachment, XmATTACH_FORM,
				      XmNleftAttachment, XmATTACH_FORM,
				      XmNbottomAttachment, XmATTACH_FORM,
#ifndef HAVE_MOTIF_1_1
				      XmNchildType, XmFRAME_TITLE_CHILD,
#endif
				      XmNlabelString, xmstr,
				      NULL);
      
      XmStringFree(xmstr);


      n=0;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;

#ifdef HAVE_MOTIF_1_1
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);n++;
      XtSetArg(args[n], XmNleftWidget, label);n++;
#else
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
#endif
      XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
      XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
      XtSetArg(args[n], XmNnumColumns, 2);n++;
      
      radio = XmCreateRadioBox(form,
			      "panel-entry-radio",
			      args,
			      n);


      object->widget =radio;

      line = object->data;

      if ( object->option_mask & DefaultMask ) {
	    while( object->options[i] ) { 
		  if ( object->options[i]->type == DefaultMask )
			def = object->options[i]->value;
		  break;
	    }
      }
      
      
      while( (num_chars=RtcExtractString(&item,line,"{}")) != 0 ) { 

	    line += num_chars;

	    items = RtcSplitString(item,',',&n);

	    if ( n == 2 ) {

		  user = XtNewString(items[1]);

		  xmstr = XmStringCreateLtoR(items[0],"panel-toggle");
		
		  toggle = XtVaCreateManagedWidget("panel-entry-toggle",
						   xmToggleButtonGadgetClass,
						   radio,
						   XmNlabelString, xmstr,
						   XmNuserData,user,
						   NULL);

		  XmStringFree(xmstr);

		  if ( def && !strcmp(def,user) )
		      XmToggleButtonGadgetSetState(toggle,True,True);


		  XtAddCallback(toggle,
				XmNvalueChangedCallback,
				(XtCallbackProc) rtcToggleCallback,
				(XtPointer) object);
		  

	    }
	    else
		  RtcMsg(object->master,Error,"Internal Error parsing Toggle Definition %s\n",line);

	    if ( n ) {
		  for (i=0; i< n; i++ )
			XtFree(items[i]);
		  
		  XtFree( (char *) items );
	    }
	    
		  
      }

#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(radio, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      
      
      XtManageChild(radio);

#ifdef HAVE_MOTIF_1_1
      XtManageChild(form);
#endif

      XtManageChild(frame);

}

#if NeedFunctionPrototypes
char *RtcToggleConfig(RTCObject *object, ConfigMaskType what)
#else
char *RtcToggleConfig(object,what)
RTCObject	*object;
ConfigMaskType	what;
#endif
{
      char 	*def,*user;
      int	i=0,j,num;
      Widget	toggle;
      WidgetList	alltoggles;
      
      

      switch ( what ) {

	 case GetResultValue:
	
	    XtVaGetValues(object->widget,
			  XmNmenuHistory, &toggle,
			  NULL);
	    
	    if ( toggle != (Widget) NULL ) { 
		  XtVaGetValues(toggle,
				XmNuserData, &def,
				NULL);

		  return ( def );
	    }
	    else
		  return ( "" );
	    
	    break;
	    
	 case GetResultName:

	    return( object->command );
	    break;
	
	 case ResetToDefault:

	    XtVaGetValues(object->widget,
			  XmNchildren, &alltoggles,
			  XmNnumChildren,&num,
			  NULL);

	    if ( object->option_mask & DefaultMask ) {
		  while( object->options[i] ) { 
			if ( object->options[i]->type == DefaultMask ) {
			      def = object->options[i]->value;	    
			      
			      for ( j=0; j < num; j++ )  {
				    XtVaGetValues(alltoggles[j],XmNuserData,&user,NULL);
		  
				    if ( !strcmp(def,user) ) 
					  XmToggleButtonGadgetSetState(alltoggles[j],True,True);
				    else
					 XmToggleButtonGadgetSetState(alltoggles[j],False,True); 
			      }
			}
			i++;
		  }
	    }
	    else { 

		  for ( i=0; i < num; i++ )  {
			XmToggleButtonGadgetSetState(toggle,False,False);
		  }	
	    }

	    return (NULL );
	    break;
    
	 default:
	    break;
      }
      

      return NULL;

}


#if NeedFunctionPrototypes
static void rtcToggleCallback(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcToggleCallback(widget,object,call)
Widget		widget;
RTCObject	*object;
XtPointer	call;
#endif
{

      if ( ((XmToggleButtonCallbackStruct *) call)->set)

	    RtcUpdatePanelStatus(object->parent);

}

#endif /* WANT_PANEL */
