static char rcsid[] = "$Id: object.c,v 1.6 1995/05/10 09:11:47 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* object.c for rtc --- object handling make/free

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#if NeedFunctionPrototypes
RTCMaster *RtcInit( void )
#else
RTCMaster *RtcInit()
#endif
{
      
      RTCMaster	*new;
      
      new = (RTCMaster *) XtMalloc( sizeof(RTCMaster) );
      
      new->objects = NULL;
      new->num_objects = 0;
      new->argv = NULL;
      new->argc = 0;
      new->display = NULL;
      
      return (new);

}



#if NeedFunctionPrototypes
void RtcFixupObjectHierarchy(RTCMaster *master)
#else
void RtcFixupObjectHierarchy(master)
RTCMaster	*master;
#endif
{

      register	int	i;
      

      for ( i =0; i < master->num_objects; i++ ) {

	    switch ( master->objects[i]->type )  {

	       case MenuDefType:
	       case PanelDefType:	
	    
		  master->objects[i]->parent = RtcGetObjectByData(master,
								  master->objects[i]->name, 
								  MenuType | PanelType 
#ifdef WANT_HELP
								  | HelpMenuType
#endif 
								  );
      
		  if ( master->objects[i]->parent == NULL ) {

			if ( strcasecmp(master->objects[i]->name,"Top") ) 
			      RtcMsg(master,Error,"Cannot find parent for %s\n",master->objects[i]->name);

		  }
		  else {

			if ( master->objects[i]->parent->children == NULL )
			      master->objects[i]->parent->children = (RTCObject **) XtMalloc(sizeof(RTCObject *) * (master->objects[i]->parent->num_children+1));
			else
			      master->objects[i]->parent->children = (RTCObject **) XtRealloc(( char *)master->objects[i]->parent->children,
											      sizeof(RTCObject *) * (master->objects[i]->parent->num_children+1));
			
			master->objects[i]->parent->children[master->objects[i]->parent->num_children] = master->objects[i];
      
			master->objects[i]->parent->num_children++;
		  }
		  

		  break;

	       default:
		  break;
		  
	    }
      }
      
}


#if NeedFunctionPrototypes
RTCObject *RtcGetObjectByName(RTCMaster *master, char *name, ObjectType type)
#else
RTCObject *RtcGetObjectByName(master,name,type)
RTCMaster	*master;
char		*name;
ObjectType	type;
#endif
{


      register int i;
      

      for ( i=0; i< master->num_objects; i++ ) { 

	    if ( master->objects[i]->type & type ) {

		  if ( !strcasecmp(master->objects[i]->name, name) )
			return ( master->objects[i] );
	    }
      }
      
      return ( (RTCObject *) NULL );
      
}



#if NeedFunctionPrototypes
RTCObject *RtcGetObjectByData(RTCMaster *master, char *data, ObjectType type)
#else
RTCObject *RtcGetObjectByData(master,data,type)
RTCMaster	*master;
char		*data;
ObjectType	type;
#endif
{

      register int i;
      
      

      for ( i=0; i< master->num_objects; i++ ) { 

	    if ( (master->objects[i]->type & type) && master->objects[i]->data != NULL ) {

		  if ( !strcasecmp(master->objects[i]->data, data) )
			return ( master->objects[i] );
	    }
      }
      
      return ( (RTCObject *) NULL );

}


#if NeedFunctionPrototypes
void RtcFreeObject(RTCObject *object)
#else
void RtcFreeObject(object)
RTCObject	*object;
#endif
{
    int	i=0;

    if ( object->name )
	XtFree(object->name);

    if ( object->data )
	XtFree(object->data);

    if ( object->command)
	XtFree(object->command);


    if ( object->option_mask)  {

	while (object->options && object->options[i]) {

	    if ( object->options[i]->value ) 
		XtFree(object->options[i]->value);

	    if ( object->options[i]->data ) 
		XtFree(object->options[i]->data);


	    XtFree( (char *) object->options[i]);

	    i++;

	}
    }	    

		


}
