static char rcsid[] = "$Id: misc.c,v 1.9 1995/07/03 09:25:07 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* misc.c for rtc --- misc. functions

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#if NeedFunctionPrototypes
int RtcExtractString( char **out, char *in, char *delim)
#else
int RtcExtractString(out,in,delim)
char	*in,**out,*delim;
#endif
{

      int	j = 0;
      int	start = -1;
      int	end = -1;

      if ( strlen(delim) != 2 ) {
	    fprintf(stderr,"Rtc :Interal Error---deliminator string (%s) is incorrect length (2)\n",delim);
	    return 0;
      }
	    
      while ( in[j] && (start == -1 || end == -1) ) { 
	    
	    if ( in[j] == delim[0] && start == -1) 	{ /* extra condition is in case the same char is used for both delim's */
		  start = j+1;
	    }
	    else 
		  if ( in[j] == delim[1] && start != -1 )
			end = j;
	    j++;
      }
      
      if ( (start == -1 || end == -1) )
	    return 0;
      else {

	    *out = RtcExpandShellVariable(&in[start],end-start);
	    
      }

      return ( end+1 );

}

#if NeedFunctionPrototypes
char **RtcSplitString( char *string, char sep, int *nitems)
#else
char **RtcSplitString(string,sep,nitems)
char	*string;
char	sep;
int	*nitems;
#endif
{

      char	**new=NULL;
      char	*ptr,*start;
      int	n=0;

      *nitems = n;

      if ( strchr(string,sep) == NULL )
	    return ( NULL );
      
      ptr = start = string;
      
      while( *ptr ) {
	    
	    if ( *ptr == sep ) {
		  
		  if ( new == NULL ) {
			new = (char **) XtMalloc( sizeof(char *) * (n+1) );
		  }
		  else {
			new = (char **) XtRealloc( (char *) new,sizeof(char *) * (n+1));
		  }
		  
		  new[n] = (char *) XtCalloc(((ptr-start)+1), sizeof(char) );
		  
		  strncpy(new[n],start, ptr-start);
		
		  start = ptr;
		  start++;
		  
		  n++;
		  
	    }
	    
	    ptr++;
      }

      
      if ( new == NULL ) {
	    new = (char **) XtMalloc( sizeof(char *) * (n+1));
      }
      else {
	    new = (char **) XtRealloc( (char *) new,sizeof(char *) * (n+1));
      }

      new[n] = (char *) XtCalloc(((ptr-start)+1), sizeof(char)  );
      
      if ( ptr-start )
	    strncpy(new[n],start, ptr-start);
      else
	  *new[n] = '\0';
 
      n++;

      *nitems = n;
      
      return( new );

} 

#if NeedFunctionPrototypes
void RtcParseOptionsList(RTCObject *object, char *string)
#else
void RtcParseOptionsList(object,string)
RTCObject	*object;
char		*string;
#endif
{

      char	*ptr,*temp;
      int	num_options = 0;
      int	num_chars;
      int	n;

      ptr = string;

      while ( *ptr ) { 

	    while ( *ptr && isspace(*ptr) )
		  ptr++;

	    switch ( *ptr ) {

	       case 'F':

		  if ( object->options == NULL )
			object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
		  else
			object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
	    
		  object->options[num_options] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    	    
		  object->options[num_options]->type = HelpFileMask;
	    
		  num_chars = RtcExtractString(&temp,ptr,"= ");

/* don't ask why its 3, but it just is ( =^^ is  3 ) */
		  if ( num_chars == 3 ) {
			XtFree(temp);
			temp = XtNewString(object->name);
		  }

		  if ( num_chars == 0 ) {
		      RtcMsg(object->master,Error,"rtc: parse error inside `F` option at line %d (possibly no trailing space)\n",line_num);
		      ptr++;
		      break;
		  }

		  object->options[num_options]->value = temp;
		  object->options[num_options]->data = NULL;

		  ptr += num_chars;

		  num_options++; 

		  object->option_mask  =  object->option_mask | HelpFileMask ;

		  break;

	       case 'H':
	    
		  if ( object->options == NULL )
			object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
		  else
			object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
	    
		  object->options[num_options] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    	    
		  object->options[num_options]->type = HelpMask;
		  object->options[num_options]->data = NULL;
	    
		  num_chars = RtcExtractString(&object->options[num_options]->value,ptr,"= ");
	    

		  if ( num_chars == 0 ) {
		      RtcMsg(object->master,Error,"rtc: parse error inside `H` option at line %d (possibly no trailing space)\n",line_num);
		      ptr++;
		      break;
		  }

		  ptr += num_chars;

		  num_options++; 

		  object->option_mask  =  object->option_mask | HelpMask ;

		  break;
	    
	       case 'I':

		  if ( object->options == NULL )
			object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
		  else
			object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
	    
		  object->options[num_options] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    	    
		  object->options[num_options]->type = IconFileMask;
		  object->options[num_options]->data = NULL;
	    
		  num_chars = RtcExtractString(&object->options[num_options]->value,ptr,"= ");

		  if ( num_chars == 0 ) {
		      RtcMsg(object->master,Error,"rtc: parse error inside `I` option at line %d (possibly no trailing space)\n",line_num);
		      ptr++;
		      break;
		  }
	    
		  ptr += num_chars;

		  num_options++; 

		  object->option_mask  =  object->option_mask | IconFileMask ;

		  break;

	       case 'T':

		  if ( object->options == NULL )
			object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
		  else
			object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
	    
		  object->options[num_options] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    	    
		  object->options[num_options]->data = NULL;
		  object->options[num_options]->type = TimeMask;
	    
		  num_chars = RtcExtractString(&object->options[num_options]->value,ptr,"= ");

		  if ( num_chars == 0 ) {
		      RtcMsg(object->master,Error,"rtc: parse error inside `T` option at line %d (possibly no trailing space)\n",line_num);
		      ptr++;
		      break;
		  }
		  
		  if ( object->options[num_options]->value[strlen(object->options[num_options]->value)-1] == 's' ) {
			object->options[num_options]->value[strlen(object->options[num_options]->value)-1] = '\0';
		  }
		  else {
			int	tmp;
			char	newtime[32];
					   
			tmp = atoi(object->options[num_options]->value);
			tmp *= 60;
			sprintf(newtime,"%d",tmp);
			XtFree(object->options[num_options]->value);
			object->options[num_options]->value = XtNewString(newtime);
		  }
		  
		  ptr += num_chars;

		  num_options++; 

		  object->option_mask  =  object->option_mask | TimeMask ;

		  break;

	       case 'N':

		  if ( object->options == NULL )
			object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
		  else
			object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
	    
		  object->options[num_options] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    	    
		  object->options[num_options]->type = NumExecMask;
	    
		  num_chars = RtcExtractString(&object->options[num_options]->value,ptr,"= ");


		  if ( num_chars == 0 ) {
		      RtcMsg(object->master,Error,"rtc: parse error inside `N` option at line %d (possibly no trailing space)\n",line_num);
		      ptr++;
		      break;
		  }

		  n = atoi(object->options[num_options]->value);

		  object->options[num_options]->data = (char *) XtCalloc(n, sizeof(int) );
	    
		  ptr += num_chars;

		  num_options++; 

		  object->option_mask  =  object->option_mask | NumExecMask ;

		  break;
	    
	       case 'D':

		  if ( object->options == NULL )
			object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
		  else
			object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
	    
		  object->options[num_options] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    	    
		  object->options[num_options]->type = DefaultMask;
		  object->options[num_options]->data = NULL;
	    
		  num_chars = RtcExtractString(&object->options[num_options]->value,ptr,"= ");

		  if ( num_chars == 0 ) {
		      RtcMsg(object->master,Error,"rtc: parse error inside `D` option at line %d (possibly no trailing space)\n",line_num);
		      ptr++;
		      break;
		  }
	    
		  ptr += num_chars;

		  num_options++; 

		  object->option_mask  =  object->option_mask | DefaultMask ;

		  break;

	    default:
		ptr++;
		  
	    }

	    
      }
      
	    
      if ( object->options == NULL )
	    object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) * (num_options+1));
      else
	    object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (num_options+1));
      
      object->options[num_options] = NULL;
      

}


#if NeedFunctionPrototypes
char *RtcFindFileInPath(char *path, char *filename)
#else
char *RtcFindFileInPath(path,filename)
char	*path;
char	*filename;
#endif
{
      Boolean	found=False;
      int		i=0,j=0;
      char	pathname[256],dir[256];
      struct	stat buf;
      

      while( path[j] && ! found ) {
	    
	    if ( path[j] == ':' ) {
		  sprintf(pathname,"%s%s",dir,filename);
		  
		  if ( stat(pathname,&buf) == 0 )
			found = True;

		  i=0;

	    }
	    else {
		  dir[i] = path[j];
		  dir[i+1] = '\0';
		  i++;
		  
	    }	

	    j++;
	    
      }

      if ( ! found ) { 
	    
	    sprintf(pathname,"%s%s",dir,filename);

	    if ( stat(pathname,&buf) == 0 )
		  found = True;
      }
      
      if ( found ) 
	    return( XtNewString( pathname ));
      else
	    return ( NULL );
      

}


#if NeedFunctionPrototypes
char * RtcExpandShellVariable(char *line, int stop)
#else
char * RtcExpandShellVariable(line, stop)
char	*line;
int	stop;
#endif
{
      char    new[256],*variable, word[64];
      int     i,j,k;
      Boolean in_word = False;
      
      new[0] = '\0';

      i=0;
      j=0;
      k=0;
      
      while ( line[i] && i < stop) { 

	    switch ( line[i] ) { 
	    
	       case '$':
		  if ( i > 0 ) {
			if ( line[i-1] != '\\' ) {
			      if ( line[i+1] && line[i+1] != '{' ) {
				    sscanf(&line[i+1],"%s",word);
				    i += strlen(word);
				    variable = getenv(word);
				    if ( variable != NULL ) { 
					  strcat(new,variable);
					  j += strlen(variable);
				    }
			      }
			}
		  }
		  else {
			if ( line[i+1] && line[i+1] != '{' ) {
			      sscanf(&line[i+1],"%s",word);
			      i += strlen(word);
			      variable = getenv(word);
			      if ( variable != NULL ) { 
				    strcat(new,variable);
				    j += strlen(variable);
			      }
			}
		  }
		  i++;
		  
		  break;
		  
	       case '{':
		  in_word = True;
		  k=0;
		  i++;
		  
		  break;
		  
	       case '}':
		  in_word = False;
		  variable = getenv(word);
		  if ( variable != NULL ) { 
			strcat(new,variable);
			j += strlen(variable);
		  }
		  i++;
		  
		  break;
		  
	       default:
		  if ( in_word ) { 
			word[k] = line[i];
			k++;
			word[k] = '\0';
		  }
		  else {
			new[j] = line[i];
			j++;
			new[j] = '\0';
		  }
		  
		  i++;
			      
		  break;
		  
	    }
	    
      }

      return( XtNewString(new) );


}

#if NeedVarargsPrototypes && !defined(sco) /* don`t ask: ODT defines this but still needs va_alist */
void RtcMsg(RTCMaster *master, ErrorType type, char *format, ...)
#else
void RtcMsg(master, type, format, va_alist)
RTCMaster	*master;
ErrorType	type;
char		*format;
va_dcl
#endif
{

      extern Widget	MsgArea,TopLevel;
      char	buffer[256];
      va_list	v;
      static XmTextPosition	pos=0;
      XmString	xmstr;
      Arg	args[5];
      int	n=0;
      Widget	dialog = NULL;
      
      if ( master->resources.msgLevel < (unsigned char) type )
	    return;
      
#ifndef HAVE_STDARG      
      va_start(v);
#else
      va_start(v,format);
#endif      

      vsprintf(buffer,format,v);
       
      va_end(v);

      switch (master->resources.msgStyle ) {
	 case StatusArea:
	    
	    if ( ! MsgArea  ) { 
		  
		  xmstr = XmStringCreateLtoR(buffer,"message");
		  
		  switch ( type ) {

		     case Error:
			
/* error messags at this stage are likely to be fatal, so write to stderr */

			fprintf(stderr,buffer);
			break;
			
		     case Warning:
			
			n=0;
			XtSetArg(args[n],XmNmessageString,xmstr);n++;
			XtSetArg(args[n],XmNtitle,"Rtc Warning Dialog");n++;
			
			dialog = XmCreateWarningDialog(TopLevel,
						     "warning-dialog",
						     args,
						     n);
			break;
			
		     case Diagnostics:

			fprintf(stderr,buffer);
			break;
			
		     default:
			/* ignore startup and other less imprortant levels */
			break;
			
		  }

		  XmStringFree(xmstr);
	  
		  if ( dialog ) {
			XtUnmanageChild( XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
			XtUnmanageChild( XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
			XtManageChild(dialog);
			XtPopup(XtParent(dialog),XtGrabNone);
			
			XtAddCallback(dialog, XmNokCallback,
				      (XtCallbackProc) RtcDestroyDialog,
				      (XtPointer) dialog);
			

		  }
		  
/* too early for msg area use a dialog */
	    }
	    else { 
		  XmTextInsert(MsgArea,pos,buffer);
		  pos += strlen(buffer);
		  XtVaSetValues(MsgArea,XmNcursorPosition,pos,NULL);
		  XmTextShowPosition(MsgArea,pos);
	    }
	    
	    break;
	    
	 case Dialogs:
	    xmstr = XmStringCreateLtoR(buffer,"message");

	    switch ( type ) {
		  
	       case Error:
		  
		  n=0;
		  XtSetArg(args[n],XmNmessageString,xmstr);n++;
		  XtSetArg(args[n],XmNtitle,"Rtc Error Dialog");n++;

		  dialog = XmCreateErrorDialog(TopLevel,
					       "error-dialog",
					       args,
					       n);
		  break;	
		  
	       case Warning:
			
		  n=0;
		  XtSetArg(args[n],XmNmessageString,xmstr);n++;
		  XtSetArg(args[n],XmNtitle,"Rtc Warning Dialog");n++;
		  
		  dialog = XmCreateWarningDialog(TopLevel,
					       "warning-dialog",
					       args,
					       n);
		  break;
		  
	       case Info:
			
		  n=0;
		  XtSetArg(args[n],XmNmessageString,xmstr);n++;
		  XtSetArg(args[n],XmNtitle,"Rtc Info Dialog");n++;

		  dialog = XmCreateInformationDialog(TopLevel,
						     "info-dialog",
						     args,
						     n);
		  break;
	
	       case Diagnostics:
		  fprintf(stderr,"%s",buffer);
		  break;
		  
	       case StartUp:
		  break;
		  
	    }	

	    XmStringFree(xmstr);
	    
	    if ( dialog ) {
		  XtUnmanageChild( XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
		  XtUnmanageChild( XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
		  XtManageChild(dialog);
		  XtPopup(XtParent(dialog),XtGrabNone);
		
		  XtAddCallback(dialog, XmNokCallback,
				(XtCallbackProc) RtcDestroyDialog,
				(XtPointer) dialog);

	    }
	    
	    break;
	    

	 case Console:
	    
	    fprintf(stdout,buffer);
	    
	    fflush(stdout);
	    
	    break;
	    
      }


      if ( master->resources.messageBeep ) { 


	    RtcBeep(master,master->resources.messageBeepVolume, master->resources.messageBeepDuration );

      } 


}




#if NeedFunctionPrototypes
void RtcBeep(RTCMaster *master, int volume, int duration)
#else
void RtcBeep(master, volume, duration)
RTCMaster	*master;
int		volume;
int		duration;
#endif
{

      XKeyboardControl	kcontrol;
      XKeyboardState	kstate;
      int	       	belld;
      extern Widget 	TopLevel;
      
      XGetKeyboardControl(XtDisplay(TopLevel),&kstate);
	  
      belld = kstate.bell_duration;
      kcontrol.bell_duration = duration;

      XChangeKeyboardControl(XtDisplay(TopLevel), KBBellDuration, &kcontrol);

      XBell(XtDisplay(TopLevel),volume);

      kcontrol.bell_duration = belld;
      XChangeKeyboardControl(XtDisplay(TopLevel), KBBellDuration, &kcontrol);

}
