static char rcsid[] = "$Id: help.c,v 1.8 1995/07/03 09:25:03 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* help.c --- general functions to deal with the help subsystem

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>
#ifdef WANT_HELP
#include <rtc-author.xbm>

static char *rtcReadHelpFile(
#if NeedFunctionPrototypes
			     RTCObject *object,
			     char	*filename
#endif
			     );

static void rtcDisplayHelp(
#if NeedFunctionPrototypes
			   RTCObject	*object,
			     char	*help_text
#endif
			     );

#ifdef WANT_HTML
static void rtcFollowHTMLLink(
#if NeedFunctionPrototypes
			      Widget	widget,
			      RTCObject	*object,
			      WbAnchorCallbackData	*call
#endif
			     );

static void rtcHomeDocument(
#if NeedFunctionPrototypes
			    Widget widget, 
			    char *text, 
			    XtPointer call
#endif
			    );

static ImageInfo *rtcLoadImage(
#if NeedFunctionPrototypes
			       Widget	widget,
			       char 	*filename,
			       int	dont_load
#endif
			     );

#endif

static void rtcPostMoreInfo(
#if NeedFunctionPrototypes
			       Widget	widget,
			       XtPointer client,
			       XtPointer call
#endif
			     );

RTCMaster	*master=NULL;


#if NeedFunctionPrototypes
void RtcDisplayHelp(Widget widget, XtPointer client, XtPointer call)
#else
void RtcDisplayHelp(widget,client,call)
Widget	widget;
XtPointer	client;
XtPointer	call;
#endif
{

      RTCObject *object = (RTCObject *) client;
      RTCObject	*help;
      char	*help_text;
      
      int	i=0;

      if ( master == NULL ) 
	master = object->master;

      switch (object->type) {

      case HelpTextType:

	  help = RtcGetObjectByName(object->master,object->data,HelpTextDefType );
		  
	  if ( help != (RTCObject *) NULL )
	      rtcDisplayHelp(help, help->data);

	  return;
	  break;
		  
      case HelpFileType:
	  help_text = rtcReadHelpFile(object,object->data);

	  if ( help_text != NULL ) {
	      rtcDisplayHelp(object,help_text);
	  }
		  
	  return;
	  break;

      default:
	  break;
		  
      }	    
}


#if NeedFunctionPrototypes
void RtcDisplayContextHelp(Widget widget, XtPointer client, XtPointer call)
#else
void RtcDisplayContextHelp(widget,client,call)
Widget	widget;
XtPointer	client;
XtPointer	call;
#endif
{

      RTCObject *object = (RTCObject *) client;
      RTCObject	*help;
      char	*help_text;
      
      int	i=0;

      if ( master == NULL ) 
	master = object->master;

      while ( object->options && object->options[i] != NULL ) {

	    switch (object->options[i]->type) {

	       case HelpMask:

		  help = RtcGetObjectByName(object->master,object->options[i]->value,HelpTextDefType );
		  
		  if ( help != (RTCObject *) NULL )
			rtcDisplayHelp(help, help->data);

		  return;
		  break;
		  
	       case HelpFileMask:
		  help_text = rtcReadHelpFile(object,object->options[i]->value);

		  if ( help_text != NULL ) {
			rtcDisplayHelp(object,help_text);
		  }
		  
		  return;
		  break;

	       default:
		  break;
		  
		  
	    }
	    
	    i++;
	    
      }
      
	    
}

#if NeedFunctionPrototypes
static char *rtcReadHelpFile(RTCObject *object, char *filename)
#else
static char *rtcReadHelpFile(object, filename)
RTCObject	*object;
char	*filename;
#endif
{

      FILE	*help;
      char	*text,*pathname;
      struct	stat buff;
      

      pathname = RtcFindFileInPath(object->master->resources.helpFilePath,filename);

      if ( pathname == NULL ) {
	    RtcMsg(object->master, Error, "Cannot find filename %s in HelpFilePath %s\n",filename,object->master->resources.helpFilePath);
	    return ( NULL );
      }
      else { 

	    if ( (help=fopen(pathname,"r")) != NULL ) {
/* get size of file */
		  stat(pathname,&buff);
      
		  text = ( char *) XtMalloc( buff.st_size +1 );
      
		  fread(text, buff.st_size, 1, help);

		  text[buff.st_size + 1] = '\0';

		  fclose(help);

		  XtFree( pathname );
		  
		  return ( text );
	    }
	    else {
		  RtcMsg(object->master, Error, "Cannot open filename %s. Probable Permission mis-match\n",pathname);
	    
		  XtFree(pathname);
	    }
	    
      }
      
/* return NULL else gcc wil complain */
      return ( NULL );
      
}

#if NeedFunctionPrototypes
static void	rtcDisplayHelp(RTCObject *object, char *help_text)
#else
static void	rtcDisplayHelp(object,help_text)
RTCObject	*object;
char	*help_text;
#endif
{
      
      Widget	dialog,dialogshell,text,action_form,separator,ok,cancel;
      Arg	args[10];
      int	n;
      extern	Widget	TopLevel;
      char      *ptr;

      n=0;
      XtSetArg(args[n], XmNtitle, "RTC Help");n++;
      XtSetArg(args[n], XmNdeleteResponse, XmDESTROY);n++;

#ifndef WANT_BROKEN_FORM_WORKAROUND
      dialog = XmCreateInformationDialog(TopLevel,
					 "help-display",
					 args,
					 n);
#else      	
      dialogshell = XmCreateDialogShell(TopLevel,
					"help-shell",
					args,
					n);

      dialog = XtVaCreateWidget("help-display",
				xmFormWidgetClass,
				dialogshell,
				NULL);
      
#endif


      ptr = help_text;
      while( *ptr && isspace(*ptr)) {
	  ptr++;
      }
      if (  *ptr== '<'  ) {		/* this is a very lose spec for a HTML doc, but not every one puts <HTML>, bummer */

#ifdef WANT_HTML

	    text = XtVaCreateWidget("help-html",
				    htmlWidgetClass,
				    dialog,
				    XmNtopAttachment,  XmATTACH_FORM,
				    XmNleftAttachment,  XmATTACH_FORM,
				    XmNrightAttachment,  XmATTACH_FORM,
#ifndef WANT_BROKEN_FORM_WORKAROUND 
				    XmNbottomAttachment,  XmATTACH_FORM,
#endif
				    WbNtext,  help_text,
                                    WbNresolveImageFunction, (long) rtcLoadImage, 
				    NULL);

	    XtAddCallback(text, 
			  WbNanchorCallback,
			  (XtCallbackProc) rtcFollowHTMLLink,
			  (XtPointer) object);
#else
	    RtcMsg(object->master, Error,"\nSupport for the HTML viewer is not compiled in. Viewing as Source");
	    n=0;
	    XtSetArg(args[n], XmNeditMode,  XmMULTI_LINE_EDIT);n++;
	    XtSetArg(args[n], XmNeditable, False);n++;
	    XtSetArg(args[n], XmNcursorPositionVisible,  False);n++;
	    XtSetArg(args[n], XmNvalue,  help_text);n++;
	    XtSetArg(args[n], XmNtopAttachment,  XmATTACH_FORM);n++;
	    XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM);n++;
	    XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM);n++;
	    XtSetArg(args[n], XmNbottomAttachment,  XmATTACH_FORM);n++;
	    
	    text = XmCreateScrolledText(dialog,
					"help-text",
					args,
					n);

/* this has to be done separatley so that the scroll-bars shadows don't get set as well */
 
	     XtVaSetValues(text,
			   XmNshadowThickness, 0,
			   XmNhighlightThickness, 0,
			   NULL);
#endif
	}    
      else { 
	     n=0;
	     XtSetArg(args[n], XmNeditMode,  XmMULTI_LINE_EDIT);n++;
	     XtSetArg(args[n], XmNeditable, False);n++;
	     XtSetArg(args[n], XmNcursorPositionVisible,  False);n++;
	     XtSetArg(args[n], XmNvalue,  help_text);n++;
	     XtSetArg(args[n], XmNtopAttachment,  XmATTACH_FORM);n++;
	     XtSetArg(args[n], XmNleftAttachment,  XmATTACH_FORM);n++;
	     XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM);n++;
	     XtSetArg(args[n], XmNbottomAttachment,  XmATTACH_FORM);n++;
	     
	     text = XmCreateScrolledText(dialog,
					 "help-text",
					 args,
					 n);

/* this has to be done separatley so that the scroll-bars shadows don't get set as well */
 
	     XtVaSetValues(text,
			   XmNshadowThickness, 0,
			   XmNhighlightThickness, 0,
			   NULL);

       }

      XtManageChild(text);

#ifndef WANT_BROKEN_FORM_WORKAROUND
      XtAddCallback(dialog, XmNokCallback, 
		    (XtCallbackProc) RtcDestroyDialog,
		    (XtPointer) dialog);


/* don't unmanage the two buttons if its a HTML doc, use them to navigate around */
#ifndef WANT_HTML

      XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

#else
      XtAddCallback(dialog, XmNhelpCallback, 
		    (XtCallbackProc) rtcHomeDocument,
		    (XtPointer) help_text);
#endif      

      XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_SYMBOL_LABEL));
      XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL));

#else /* else we have a broken form so..*/
      separator = XtVaCreateManagedWidget("sep",
					  xmSeparatorGadgetClass,
					  dialog,
					  XmNtopAttachment,XmATTACH_WIDGET,
					  XmNtopWidget,text,
					  XmNleftAttachment,XmATTACH_FORM,
					  XmNrightAttachment,XmATTACH_FORM,
					  NULL);
      
      action_form = XtVaCreateWidget("action-form",
				     xmFormWidgetClass,
				     dialog,
				     XmNtopAttachment,XmATTACH_WIDGET,
				     XmNtopWidget, separator,
				     XmNleftAttachment,XmATTACH_FORM,
				     XmNrightAttachment,XmATTACH_FORM,
				     XmNfractionBase,5,
				     NULL);
      
      ok = XtVaCreateManagedWidget("OK",
				   xmPushButtonGadgetClass,
				   action_form,
				   XmNtopAttachment,XmATTACH_FORM,
				   XmNleftAttachment,XmATTACH_POSITION,
				   XmNleftPosition,1,
				   XmNrightAttachment,XmATTACH_POSITION,
				   XmNrightPosition,2,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNshowAsDefault, True,
				   NULL);

      
      cancel = XtVaCreateManagedWidget("Help",
				       xmPushButtonGadgetClass,
				       action_form,
				       XmNtopAttachment,XmATTACH_FORM,
				       XmNleftAttachment,XmATTACH_POSITION,
				       XmNleftPosition,3,
				       XmNrightAttachment,XmATTACH_POSITION,
				       XmNrightPosition,4,
				       XmNbottomAttachment, XmATTACH_FORM,
				       NULL);
      
      XtAddCallback(cancel,XmNactivateCallback, (XtCallbackProc) rtcHomeDocument, (XtPointer) help_text);
      XtAddCallback(ok,XmNactivateCallback, (XtCallbackProc) RtcDestroyDialog, (XtPointer) dialogshell);
      
     
      XtManageChild( action_form );
#endif



#ifndef WANT_BROKEN_FORM_WORKAROUND
      XtManageChild(dialog);
#else
      XtManageChild(dialog);
      XtPopup(dialogshell, XtGrabNone);
#endif

}


#ifdef WANT_HTML
#if NeedFunctionProtoTypes
static void rtcFollowHTMLLink(Widget widget, RTCObject *object, WbAnchorCallbackData *call)
#else
static void rtcFollowHTMLLink(widget,object,call)
Widget	widget;
RTCObject	*object;
WbAnchorCallbackData	*call;
#endif
{
      char	*help_text=NULL;
      char	*anchor=NULL;
      int	id=0;
      WidgetInfo       *info;
      char	*back;
      
      if ( ! call->href ) 
	    return;

      if ( *call->href != '#' ) {
	    
	    anchor = strchr(call->href,'#');
	    
	    if (anchor ) {
		  *anchor ='\0';
		  anchor++;

		  id = HTMLAnchorToId(widget,anchor);

	    }
	    
	    help_text = rtcReadHelpFile( object,
					call->href);

      }
      else {
	    anchor = &call->href[1];
	    id = HTMLAnchorToId(widget,anchor);
      }

      info = HTMLGetWidgetInfo(widget);
      
      XtVaGetValues(widget,WbNtext,&back,NULL);
      XtVaSetValues(widget,XmNuserData,XtNewString(back),NULL);
 
      HTMLSetText(widget,help_text,"\0","\0",id,anchor,info);

      if ( help_text )
	    XtFree(help_text);
      
      
}

#if NeedFunctionProtoTypes
static void rtcHomeDocument(Widget widget, char *text, XtPointer call)
#else
static void rtcHomeDocument(widget,text, call)
Widget	widget;
char 	*text;
XtPointer      call;
#endif
{

      Widget html=NULL;
 
#ifdef  WANT_BROKEN_FORM_WORKAROUND    
      html = XtNameToWidget(XtParent(XtParent(widget)),"*help-html");
#else
      html = XtNameToWidget(XtParent(widget),"*help-html");
#endif      
      if ( html != NULL )
	    XtVaSetValues(html,WbNtext, text, NULL);
      
}

/* the next routine is a direct rip-off from Mosiac, I'm sorry guys...*/

#if NeedFunctionProtoTypes
static ImageInfo *rtcLoadImage(Widget widget, char *src, int dont_load)
#else
static ImageInfo *rtcLoadImage(widget,src,dont_load)
Widget	widget;
char	*src;
int	dont_load;
#endif
{
      int 	width, height;
      int 	Used[256];
      XColor 	colrs[256];
      ImageInfo *image=NULL;
      FILE	*fp;
      unsigned char *bitdata;
      unsigned char *bg_map;
      unsigned char *bgptr;
      unsigned char *ptr;
      int 	widthbyheight = 0;
      int 	bg, bg_red, bg_green, bg_blue;
      int	i,cnt;
      char	*image_file;
      
      
      image_file = RtcFindFileInPath(master->resources.helpFilePath,src);

      
      if ( ! image_file ) { 
	    return NULL;
      }

      if ( (fp=fopen(image_file,"r")) == NULL ) {
	    return NULL;
      }
      
      XtFree(image_file);
      

      bitdata = ReadGIF(fp, &width, &height, colrs, &bg);

      if (bitdata == NULL ) {
	    return NULL;
      }
      
      if ( (bg >= 0) && (bitdata != NULL) ) {
	    unsigned long bg_pixel;
	    XColor tmpcolr;

          /* This code copied from xpmread.c.  I could almost
           * delete the code from there, but I suppose an XPM
           * file could pathalogially have multiple transparent
           * colour indicies. -- GWP
           */
	    XtVaGetValues(widget, XtNbackground, &bg_pixel, NULL);
	  
	    tmpcolr.pixel = bg_pixel;
          
	    XQueryColor(XtDisplay(widget),
			DefaultColormap(XtDisplay(widget), 
				      DefaultScreen(XtDisplay(widget))),
			&tmpcolr);

	    bg_red = colrs[bg].red = tmpcolr.red;

	    bg_green = colrs[bg].green = tmpcolr.green;

	    bg_blue = colrs[bg].blue = tmpcolr.blue;

	    colrs[bg].flags = DoRed|DoGreen|DoBlue;

	    bg_map = (unsigned char *)malloc(width * height);
      }

      image = (ImageInfo *)malloc(sizeof(ImageInfo));
      image->width = width;
      image->height = height;
      image->image_data = bitdata;
      image->image = (Pixmap) NULL;
      /* Bandaid for bug afflicting Eric's code, apparently. */
      image->internal = 0;

      widthbyheight = image->width * image->height;

  /* Fill out used array. */
      for (i=0; i < 256; i++) {
	    Used[i] = 0;
      }
      cnt = 1;
      bgptr = bg_map;
      ptr = image->image_data;
      for (i=0; i < widthbyheight; i++) {
	    if (Used[(int)*ptr] == 0) {
		  Used[(int)*ptr] = cnt;
		  cnt++;
	    }
	    if (bg >= 0) {
		  if (*ptr == bg) {
			*bgptr = (unsigned char)1;
		  }
		  else {
			*bgptr = (unsigned char)0;
		  }
		  bgptr++;
	    }
	    ptr++;
      }
      cnt--;

      image->num_colors = cnt;

      image->reds = (int *)malloc(sizeof(int) * cnt);
      image->greens = (int *)malloc(sizeof(int) * cnt);
      image->blues = (int *)malloc(sizeof(int) * cnt);

      for (i=0; i < 256; i++) {

	    int indx;
      
	    if (Used[i] != 0) {
		  indx = Used[i] - 1;
		  image->reds[indx] = colrs[i].red;
		  image->greens[indx] = colrs[i].green;
		  image->blues[indx] = colrs[i].blue;
	  /* squeegee in the background color */
		  if ((bg >= 0)&&(i == bg)) {
			image->reds[indx] = bg_red;
			image->greens[indx] = bg_green;
			image->blues[indx] = bg_blue;
		  }
	    }
      }

    /* if MedianCut ate our background, add the new one now. */
      if (bg == 256) {
	    image->reds[cnt - 1] = bg_red;
	    image->greens[cnt - 1] = bg_green;
	    image->blues[cnt - 1] = bg_blue;
      }
  
      bgptr = bg_map;
      ptr = image->image_data;
      for (i=0; i < widthbyheight; i++) {
	    *ptr = (unsigned char)(Used[(int)*ptr] - 1);
      /* if MedianCut ate the background, enforce it here */
	    if (bg == 256) {
		  if ((int)*bgptr == 1) {
			*ptr = (unsigned char)(cnt - 1);
		  }
		  bgptr++;
	    }
	    ptr++;
      }


      fclose(fp);
      
      return image;
      
      
}
#endif /* WANT_HTML */

#if NeedFunctionPrototypes
void RtcPostInfoPanel(Widget widget, RTCObject *object, XtPointer call)
#else
void RtcPostInfoPanel(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{


      static Widget dialog=NULL;
      XmString	xmstr;
      Arg	args[3];
      int	n;
      Pixmap	pixmap;
      Pixel	fg,bg;
      Screen	*screen;
      extern Widget	TopLevel;

      if ( dialog ) { 
	    XtManageChild(dialog);
	    return ;
      }
      

      xmstr = XmStringConcat( XmStringCreateLtoR(RTC_COPYRIGHT,"copyright-info"),
			     XmStringCreateLtoR(RTC_VERSION,"version-info"));

      xmstr = XmStringConcat( xmstr,
			     XmStringCreateLtoR(SITE_SUPPORT,"copyright-info"));
      
      
      n=0;

      XtSetArg(args[n], XmNmessageString, xmstr);n++;
      XtSetArg(args[n], XmNtitle, "About Rtc");n++;
      
      dialog = XmCreateMessageDialog(TopLevel,
				     "info-dialog",
				     args,
				     n);
      
      XtVaGetValues(dialog,
		    XmNforeground, &fg,
		    XmNbackground, &bg,
		    NULL);
	    
      screen = XtScreen( dialog );
		  
      pixmap = XCreatePixmapFromBitmapData(XtDisplay(dialog),
					   RootWindowOfScreen( screen) ,
					   (char *) author_bits,author_width,author_height,
					   fg,
					   bg,
					   DefaultDepthOfScreen(screen));

      XtVaSetValues(dialog,
		    XmNsymbolPixmap, pixmap,
		    NULL); 
      
      XtAddCallback(dialog,
		    XmNhelpCallback,
		    (XtCallbackProc) rtcPostMoreInfo,
		    (XtPointer) object ); 

      XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));



      XmStringFree(xmstr);
      XtManageChild(dialog);
      
}

#if NeedFunctionPrototypes
static void rtcPostMoreInfo(Widget widget, XtPointer client, XtPointer call)
#else
static void rtcPostMoreInfo(widget,client,call)
Widget	widget;
XtPointer	client;
XtPointer	call;
#endif
{

      static Widget	dialog=NULL;
      Widget	label;
      XmString	xmstr;
      Arg	args[3];
      int	n=0;
      extern Widget	TopLevel;
      RTCObject	*object = (RTCObject *) client;
      

      if ( dialog != NULL ) {
	    XtManageChild(dialog);
	    return ;
      }

	    
      xmstr = XmStringCreateLtoR("Compiled with  ","option-info");


#ifdef HAVE_X11R6
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("X11R6 ","option-info"));
#endif
#ifdef HAVE_X11R5
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("X11R5 ","option-info"));
#endif
#ifdef HAVE_X11R4
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("X11R4 ","option-info"));
#endif

#ifdef HAVE_MOTIF_1_1
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("/ Motif 1.1 Libraries.\n","option-info"));
#endif
#ifdef HAVE_MOTIF_1_2
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("/ Motif 1.2 Libraries.\n","option-info"));
#endif
#ifdef HAVE_MOTIF_2
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("/ Motif 2.0 Libraries.\n","option-info"));
#endif	

#ifdef COMPILED_BY
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR("\nCompiled by " ,"option-info"));
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR(COMPILED_BY ,"option-info"));
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR(" on " ,"option-info"));
#ifdef COMPILED_AT
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR(COMPILED_AT ,"option-info"));
#else
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR("(unknown) " ,"option-info"));
#endif
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR(" using\n" ,"option-info"));
#ifdef COMPILED_MACHINE
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR(COMPILED_MACHINE ,"option-info"));
#else
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR("(unknown) " ,"option-info"));
#endif
	    xmstr = XmStringConcat( xmstr,
				   XmStringCreateLtoR("\n" ,"option-info"));
#endif	    

      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\nDefault User Description File :\t","option-info"));
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR(SITE_USER_FILE,"option-info"));

      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\nUsing User Description File :\t","option-info"));
      
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR(object->master->resources.userFile,"option-info"));


#ifdef WANT_SYSTEM_FILE
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nDefault System Description File :\t","option-info"));
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR(SITE_SYSTEM_FILE,"option-info"));
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\nUsing System Description File :\t","option-info"));
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR(object->master->resources.systemFile,"option-info"));
#endif


#ifdef WANT_COLOUR_ICONS	    
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nColour Icons","option-info"));
#endif

#ifdef WANT_CLOCK
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nClock and Reminder","option-info"));
#endif

#ifdef WANT_MAILBOX_WATCHER
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nMail box Watcher","option-info"));
#endif
#ifdef WANT_DISK_WATCHER
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nDisk Space Watcher","option-info"));
#endif

#ifdef WANT_HELP
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nHelp Facility (plain text)","option-info"));
#endif
		
#ifdef WANT_HTML
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nHelp Facility (HTML text)","option-info"));
#endif		

#ifdef WANT_PANEL
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nPanels","option-info"));
#ifdef WANT_FILE
      xmstr = XmStringConcat( xmstr,
			      XmStringCreateLtoR("\n\nRichard's Super Sexy File Widget","option-info"));
#endif
#endif		

	    
      XtSetArg(args[n], XmNmessageString, xmstr );n++;
      XtSetArg(args[n], XmNtitle, "RTC Configuration Info");n++;

      dialog = XmCreateInformationDialog(TopLevel,
					 "config",
					 args,
					 n);

      XmStringFree(xmstr);

      XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

      
      XtManageChild(dialog);

      

}

#endif /* WANT_HELP */
