static char rcsid[] = "$Id: (c) Richard M. Offer 1993, 1994, 1995";
/* functions to handle Helptext operator

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/


#include <Rtc.h>
#ifdef WANT_HELP

#if NeedFunctionPrototypes
ObjectReturnType RtcParseHelpText(RTCMaster *master, RTCObject *parent, RTCObject *object, char *line)
#else
ObjectReturnType RtcParseHelpText(master,parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel >= (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;

      object->data = XtNewString(ptr);

      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;



      return ( Child );
      
}

#if NeedFunctionPrototypes
void	RtcCreateHelpText(RTCObject *object)
#else
void RtcCreateHelpText(object)
RTCObject	*object;
#endif
{
      XmString	xmstr = NULL;
      Widget	button;
      Pixmap	pixmap;
      Boolean	good_pixmap = False;
      Arg	args[5];
      int	n;
      
      
     n=0;
      
      if ( object->option_mask & IconFileMask ) 
	    good_pixmap = RtcGetPixmap(object,&pixmap);

      if ( good_pixmap ) {
	    XtSetArg( args[n], XmNlabelType, XmPIXMAP);n++;
	    XtSetArg( args[n], XmNlabelPixmap, pixmap);n++;
      }
      else {	 
	    xmstr = XmStringCreateLtoR(object->name,"menu-buttons");

	    XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
	    XtSetArg( args[n], XmNlabelString, xmstr);n++;
      }


      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "help-text",
					   args,
					   n);

      XtAddCallback(button, 
		    XmNactivateCallback, 
		    (XtCallbackProc) RtcDisplayHelp,
		    (XtPointer) object);
      
#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      
	    
      XtManageChild( button );

      object->widget = button;
      
      if ( xmstr ) 
	    XmStringFree(xmstr);
      

  
}

#if NeedFunctionPrototypes
ObjectReturnType RtcParseHelpFile(RTCMaster *master, RTCObject *parent, RTCObject *object, char *line)
#else
ObjectReturnType RtcParseHelpFile(master,parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel >= (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;

      object->data = XtNewString(ptr);

      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;



      return ( Child );
      
}

#if NeedFunctionPrototypes
void	RtcCreateHelpFile(RTCObject *object)
#else
void RtcCreateHelpFile(object)
RTCObject	*object;
#endif
{
      XmString	xmstr = NULL;
      Widget	button;
      Pixmap	pixmap;
      Boolean	good_pixmap = False;
      Arg	args[5];
      int	n;
      
      
     n=0;
      
      if ( object->option_mask & IconFileMask ) 
	    good_pixmap = RtcGetPixmap(object,&pixmap);

      if ( good_pixmap ) {
	    XtSetArg( args[n], XmNlabelType, XmPIXMAP);n++;
	    XtSetArg( args[n], XmNlabelPixmap, pixmap);n++;
      }
      else {	 
	    xmstr = XmStringCreateLtoR(object->name,"menu-buttons");

	    XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
	    XtSetArg( args[n], XmNlabelString, xmstr);n++;
      }


      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "help-text",
					   args,
					   n);

      XtAddCallback(button,
		    XmNactivateCallback,
		    (XtCallbackProc) RtcDisplayHelp,
		    (XtPointer) object);

#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      
	    
      XtManageChild( button );

      object->widget = button;
      
      if ( xmstr ) 
	    XmStringFree(xmstr);
      

  
}

#endif
