static char rcsid[] = "$Id (c) Richard M. Offer 1993, 1994,1995";
/* help-context.c for rtc --- functions to make a cascade button that executes help context handles

Copyright (c) 1993,1994,1995 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_HELP

#include <X11/cursorfont.h>

static void rtcContextHelpCallback(
#if NeedFunctionPrototypes
						Widget w,
						XtPointer	client,
						XtPointer	call
#endif
);

#if NeedFunctionprototypes
ObjectReturnType RtcParseHelpContext(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseHelpContext(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel >= (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;

      object->command = NULL;

      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return( Child );
      
}

#if NeedFunctionprototypes
void RtcCreateHelpContext(RTCObject *object)
#else
void RtcCreateHelpContext(object)
RTCObject	*object;
#endif
{

      XmString	xmstr = NULL;
      Widget	button;
      Pixmap	pixmap;
      Boolean	good_pixmap = False;
      Arg	args[5];
      int	n;
      
      
     n=0;
      
      if ( object->option_mask & IconFileMask ) 
	    good_pixmap = RtcGetPixmap(object,&pixmap);

      if ( good_pixmap ) {
	    XtSetArg( args[n], XmNlabelType, XmPIXMAP);n++;
	    XtSetArg( args[n], XmNlabelPixmap, pixmap);n++;
      }
      else {	 
	    xmstr = XmStringCreateLtoR(object->name,"menu-buttons");

	    XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
	    XtSetArg( args[n], XmNlabelString, xmstr);n++;
      }


      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "button",
					   args,
					   n);

      XtAddCallback(button, 
		    XmNactivateCallback, 
		    (XtCallbackProc) rtcContextHelpCallback,
		    (XtPointer) object);

#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      
	    
      XtManageChild( button );

      object->widget = button;
      
      if ( xmstr ) 
	    XmStringFree(xmstr);
      

      
}

#if NeedFunctionPrototypes
static void rtcContextHelpCallback(Widget button, XtPointer client, XtPointer call)
#else
static void rtcContextHelpCallback(button,client,call)
Widget      button;                             
XtPointer   client;
XtPointer   call;
#endif
{

#ifndef MOTIF_1_1
      XEvent      event;
#endif
      Widget      on_widget;
      extern Widget TopLevel;
      Cursor      cursor;
                                    

      cursor = XCreateFontCursor(XtDisplay(TopLevel),XC_question_arrow);

#ifdef HAVE_MOTIF_1_1
      on_widget = XmTrackingLocate(TopLevel,
                           cursor,
                           False);
#else
      on_widget = XmTrackingEvent(TopLevel,
                          cursor,
                          False,
                          &event);
#endif
      
      XFreeCursor(XtDisplay(TopLevel),cursor);

      if ( on_widget == NULL )
          return;

      XtCallCallbacks(on_widget,XmNhelpCallback,NULL);
      
                                   
}

#endif /* WANT_HELP */
