static char rcsid[] = "$Id: execute.c,v 1.7 1995/07/03 09:24:59 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* execute.c for rtc --- functions to execute a command

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

/* this is a hack, since we have no way of passing client data into a signal handler */

static RTCMaster	*mas = NULL;
static RTCProcess	*process = NULL;
static Boolean	diag= False;

static void rtcChildDied(
#if NeedFunctionPrototypes
			 int	sig
#endif
			 );


static void  rtcReadBuffer(
#if NeedFunctionPrototypes
			   XtPointer	client,
			   int		*pp,
			   XtInputId	*id
#endif
			   );

static int rtcGetAvailProcess(
#if NeedFunctionPrototypes
  RTCObject *object
#endif
  );


#if NeedFunctionPrototypes
void RtcExecuteCommand(Widget button, RTCObject *object, XtPointer call)
#else
void  RtcExecuteCommand(button,object,call)
Widget	button;
RTCObject	*object;
XtPointer	call;
#endif
{

      char	*shell,*shell_cmd, *cmd[5];
      int	c_stderr[2];	/* child process stderr pipe */ 
      int	c_stdout[2];	/* child process stdout pipe */					
      int	p_stderr;	/* parent stderr */
      extern XtAppContext	AppContext;
      extern	Widget	TopLevel;
      extern char	**environ;
      int	i=0,n;
      Arg	args[5];
      RTCProcess  *ptr;
      int	pid;
      
      if ( mas == NULL )
	    mas = object->master;

      RtcMsg(object->master,Diagnostics,"exec %s %s\n",object->name,object->command);
      

/* get a process slot */

      n = rtcGetAvailProcess(object);

      if ( n == -1) {
	    RtcMsg(object->master,Error,"Exceeded # of times %s may be run.\n",object->name);
	    return;
      }
	    
/* if pause option is set put up a watch */
      if ( object->option_mask & TimeMask ) {
	    int	timeout = 0,nargs;
	    XmString	xmstr,tmp;
	    Widget	dialog;
	    i=0;


	    while ( object->options && object->options[i] != NULL ) {

		  if ( object->options[i]->type &  TimeMask ) {
		  
			timeout = atoi(object->options[i]->value);
			 
			break;
		  }	
		  
		  i++;
	    }
	    nargs=0;

	    tmp = XmStringCreateLtoR("Please wait,\n\nstarting...","message");
	    xmstr = XmStringConcat(tmp,
				   XmStringCreateLtoR(object->name,"message"));
	    
	    XtSetArg(args[nargs], XmNtitle, "Starting...");nargs++;
	    XtSetArg(args[nargs], XmNmessageString, xmstr);nargs++;
	    
	    dialog = XmCreateWorkingDialog(TopLevel,
					   "working-dialog",
					   args,
					   nargs);
	    
	    XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
	    XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
	    XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_OK_BUTTON));
	    XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_SEPARATOR));

	    XtAppAddTimeOut(AppContext,
			    timeout * 1000,
			    (XtTimerCallbackProc) RtcDestroyDialog,
			    (XtPointer) dialog);

	    XmStringFree(xmstr);
	    XmStringFree(tmp);

	    XtManageChild(dialog);
	    
       }

      if ( (shell = getenv("SHELL")) == NULL )
	    shell = "/bin/sh";
      
      shell_cmd = strrchr(shell,'/');
      shell_cmd++;
      
      if ( object->master->resources.msgLevel > (unsigned char) Warning) {
	    diag = True;
#ifdef DOESNT_WORK
	    ptr = (RTCProcess *) malloc( sizeof (RTCProcess));
	    ptr->next = NULL;
	    ptr->pid = -1;
	    ptr->out = -1;
	    ptr->err = -1;
	    ptr->parent = -1;
	    
	    if (process == NULL)	  
		  process = ptr;
	    else {
		  ptr->next = process->next;
		  process->next = ptr;
	    }
#endif	    
	    
	    pipe(c_stdout);
	    pipe(c_stderr);

#ifdef DOESNT_WORK
	    ptr->out = c_stdout[0];
	    ptr->err = c_stderr[0];
#endif	    

	    (void) XtAppAddInput(AppContext,
				 c_stderr[0],
				 (XtPointer) XtInputReadMask,
				 (XtInputCallbackProc) rtcReadBuffer,
				 (XtPointer) object);
      
	    (void) XtAppAddInput(AppContext,
				 c_stdout[0],
				 (XtPointer) XtInputReadMask,
				 (XtInputCallbackProc) rtcReadBuffer,
				 (XtPointer) object);
      }
      
      signal(SIGCLD,rtcChildDied);
      
      pid = fork();

      if ( n > -1 ) {
	    i=0;

	    while ( object->options && object->options[i] != NULL ) {

		  if ( object->options[i]->type &  NumExecMask && pid ) {
		  
			((int *) object->options[i]->data)[n] = pid;

			break;
		  }	
		  
		  i++;
	    }		
      }

      if ( diag ) {
	    p_stderr = dup(2);
#ifdef DOESNT_WORK
	    if ( pid > 0 ) {
		  ptr->parent = p_stderr;
		  ptr->pid = pid;
	    }
#endif	
      }
      
      if ( pid == 0 ) { 
	   
	    if ( diag ) { 
		  
		  dup2(c_stdout[1],1);
		  close(c_stdout[0]);
		  close(c_stdout[1]);
	    
		  dup2(c_stderr[1],2);
		  close(c_stderr[0]);
		  close(c_stderr[1]);
	    }
	    

	    cmd[0] = shell_cmd;
	    cmd[1] = "-c";
	    cmd[2] = object->command;
	    cmd[3] = "&";
	    cmd[4] = NULL;
	    
	    execve(shell,cmd,environ);

/* if we get here then the exec failed */	    

	    if ( diag ) {
		  dup2(p_stderr,2);
		  close(p_stderr);
	    }
	    

	    RtcMsg(object->master,Error,"Internal Error---exec() failed while executing %s\n",object->command);
	    
	    exit(1);
      }
      else {
	    if ( pid < 0 ) { 
		  RtcMsg(object->master,Error,"Internal Error---fork() failed while executing %s\n",object->command);
	    }
	    else { 

		  if ( object->master->resources.executeBeep ) 
			RtcBeep(object->master,object->master->resources.executeBeepVolume,object->master->resources.executeBeepDuration);
		  
		  if ( diag) {
			close(c_stdout[1]);
			close(c_stderr[1]);
		  }
	    }
      }

}

#if NeedFunctionPrototypes
static int rtcGetAvailProcess(RTCObject *object)
#else
static int rtcGetAvailProcess(object)
RTCObject 	*object;
#endif
{

      int	i=0,j,n;

#ifdef WANT_LIMIT_EXEC

      if ( object->option_mask & NumExecMask ) {
	    
	    while ( object->options && object->options[i] != NULL ) {

		  if ( object->options[i]->type &  NumExecMask ) {
		  
			n = atoi ( object->options[i]->value );

			for ( j =0; j < n; j++ ) {
			      
			      if ( ((int *)object->options[i]->data)[j]== 0 )
				    return ( j );
			}

			return -1;
			 
			break;
		  }
		  
		  i++;
	    }

      }
      else

	    return -2;
#endif

      return -2;
      
}


#if NeedFunctionPrototypes
static void rtcChildDied(int sig)
#else
static void rtcChildDied(sig)
int	sig;
#endif
{
      
      int	pid;
#ifdef WANT_LIMIT_EXEC
      int 	i,j,k,n;
#endif
      RTCProcess *ptr;
      

      pid = wait(0);
      
#ifdef WANT_LIMIT_EXEC

      for (i=0; i < mas->num_objects; i++ ) { 
	    
	    if ( mas->objects[i]->option_mask & NumExecMask) {
		  j=0;

		  while ( mas->objects[i]->options && mas->objects[i]->options[j] != NULL ) {

			if ( mas->objects[i]->options[j]->type &  NumExecMask ) {
		  
			      n = atoi ( mas->objects[i]->options[j]->value );

			      for ( k =0; k < n; k++ ) {
			      
				    if ( ((int *) mas->objects[i]->options[j]->data)[k] == pid ) {
					  ((int *) mas->objects[i]->options[j]->data)[k] = 0 ;
#ifdef DOESNT_WORK
					  goto close_fd; /* for efficiency */
#else
					return;
#endif
				    }
			      }

			}
		  
			j++;
		  }
	    }	

      }
#endif

#ifdef DOESNT_WORK      
   close_fd:
      if ( diag ) {
	    ptr = process;
	    
	    while ( ptr ) {
		  if ( ptr->pid == pid ) {
			close(ptr->err); 
			close(ptr->out); 
			close(ptr->parent); 
			return;
			
		  }

		  ptr = ptr->next;
	    }
      }
#endif      
}

#if NeedFunctionPrototypes
static void rtcReadBuffer(XtPointer object, int *pp, XtInputId *id)
#else
static void rtcReadBuffer(object,pp,id)
XtPointer	object;
int	*pp;
XtInputId	*id;
#endif
{

      int	status;
      char	buffer[MAX_LINE_LEN];
      
      status = read(*pp,buffer,MAX_LINE_LEN);
      
      if ( status > 0 ) {
	    buffer[status] = '\0';
	    
	    RtcMsg(((RTCObject *) object)->master,Info,"%s",buffer);
	    
	    return  ;
      }
      
      if ( status == 0 )
	    XtRemoveInput( *id );

      return ;
      

}

