/* typedefs/structure defintions used in rtc

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

$Id: rtc-struct.h,v 1.2 1995/07/03 09:24:45 richardo Exp $

*/

#ifndef RTC_STRUCT_H
#define RTC_STRUCT_H

typedef struct _RTCObject {

/* data */      
      char		*name;
      ObjectType	type;
      struct _RTCObject	*parent;
      struct _RTCObject	**children;
      int		num_children;
      
      struct _RTCMaster	*master;
      
      char		*data;

      char		*command;
      
      Widget		widget;

      struct _RTCOption	**options;

      long		option_mask;
      
      Boolean		create_asap;
      

/* methods */

      void		(*create)();
      ObjectReturnType	(*parse)();
      char		*(*config)();

} RTCObject;

typedef struct _RTCOption {
      OptionType	type;
      char		*value;
      char		*data;
} RTCOption;

typedef struct _RTCProcess {
      int	pid;
      int	err;
      int	out;
      int	parent;
      struct _RTCProcess * next;
} RTCProcess;
	  


typedef struct _functions {
      char	*keyword;
      int	real_object;
      RTCObject	object;
} RTCFunctions;



typedef struct _resources {
#ifdef WANT_SYSTEM_FILE
      char	*systemFile;
#endif
      char	*userFile;
      Boolean	vertical;
      Boolean	maximumSize;
      Boolean	singleScreen;
      Boolean	usage;
      Boolean	messageBeep;
      int	messageBeepVolume;
      int	messageBeepDuration;
      Boolean	executeBeep;
      int	executeBeepVolume;
      int	executeBeepDuration;

#ifdef WANT_CLOCK
      char	*reminderFile;
#endif
#ifdef WANT_HELP
      char	*helpFilePath;
#endif
      char	*iconFilePath;

      unsigned char	msgStyle;
      unsigned char	msgLevel;
      unsigned char	userType;

} RTCResources;




typedef struct _RTCMaster {
      
      RTCObject	**objects;
      int	num_objects;

      RTCResources	resources;

    char	**argv;
    int		argc;

    char	*display;
      
} RTCMaster;


#endif /* RTC_STRUCT_H */
