/* private header file for the file functions

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

$Id: rtc-parseP.h,v 1.2 1995/07/03 09:24:43 richardo Exp $

*/

#ifndef RTC_PARSEP_H
#define RTC_PARSEP_H

RTCFunctions function_lookup[] = 
{

      { 
      "Menu",		
      True,				/* a real object ? */
            {
	          NULL,			/* name */
		  MenuDefType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,			/* create asap */
		  NULL,     		/* create() */
		  RtcParseMenuDef,	/* parse() */
		  NULL,     		/* get() */
	    } ,
      },
      { 
      "EndMenu",		
      False,				/* a real object ? */
	    {
		  NULL,			/* name */
		  EndMenuType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,	       	/* create asap */
		  NULL,			/* create() */
		  RtcParseEndMenu,     	/* parse() */
		  NULL,     		/* get() */
	    } ,
      },
      { 
	  "Panel",		
#ifdef WANT_PANEL
	  True,				/* a real object ? */
	  {
	      NULL,			/* name */
	      PanelDefType,		/* type */
	      NULL,			/* parent */
	      NULL,			/* children */
	      0,			/* num_children */
	      NULL,			/* master */
	      NULL,			/* data */
	      NULL,			/* command */
	      NULL,			/* widget */
	      NULL,			/* options */
	      0,			/* option mask */
	      False,	       	/* create asap */
	      NULL,		        /* create() */
	      RtcParsePanelDef,	/* parse() */
	      NULL,     		/* get() */
	  } ,
#else
	  -1,		
	  NULL,
#endif      
      },
      { 
      "EndPanel",		
#ifdef WANT_PANEL
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  EndPanelType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  NULL,			/* create() */
		  RtcParseEndPanel,    	/* parse() */
		  NULL,     		/* get() */
	    } ,
#else
      -1,
		 NULL,
#endif
      },
      { 
	  "f.button",		
	  True,				/* a real object ? */
	  {
	      NULL,			/* name */
	      ButtonType,		/* type */
	      NULL,			/* parent */
	      NULL,			/* children */
	      0,			/* num_children */
	      NULL,			/* master */
	      NULL,			/* data */
	      NULL,			/* command */
	      NULL,			/* widget */
	      NULL,			/* options */
	      0,			/* option mask */
	      True,       		/* create asap */
	      RtcCreateButton,    	/* create() */
	      RtcParseButton,	/* parse() */
	      NULL,     		/* get() */
	  } ,
      },
      {
	  "f.menu",		
	  True,				/* a real object ? */
	  {
	      NULL,			/* name */
	      MenuType,		        /* type */
	      NULL,			/* parent */
	      NULL,			/* children */
	      0,			/* num_children */
	      NULL,			/* master */
	      NULL,			/* data */
	      NULL,			/* command */
	      NULL,			/* widget */
	      NULL,			/* options */
	      0,			/* option mask */
	      True,       		/* creat	e asap */
	      RtcCreateMenu,    	/* create() */
	      RtcParseMenu,		/* parse() */
	      NULL,     		/* get() */
	  } ,
      },
      {
       "f.help-menu",
#ifdef WANT_HELP
      True,                             /* a real object ? */
          {
              NULL,                 /* name */   
              HelpMenuType,         /* type */   
              NULL,                 /* parent */
              NULL,                 /* children */
              0,                    /* num_children */
              NULL,                 /* master */
              NULL,                 /* data */
              NULL,                 /* command */
              NULL,                 /* widget */
              NULL,                 /* options */
              0,                    /* option mask */
              True,                 /* create asap */
              RtcCreateMenu,        /* create() generic MenuCreate + setting HelpWidget*/
              RtcParseMenu,         /* parse()  generic MenuCreate */
              NULL,                 /* get() */ 
          } ,
#else
	-1,
	NULL,
#endif
      },
      {
       "f.panel",		
#ifdef WANT_PANEL
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  PanelType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreatePanel,    	/* create() */
		  RtcParsePanel,       	/* parse() */
		  NULL,     		/* get() */
	    } ,
#else
      -1,
	     NULL,
#endif       
      },
      {
       "f.label",		
     True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  LabelType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateLabel,    	/* create() */
		  RtcParseLabel,        /* parse() */
		  NULL,     		/* get() */
	    } ,
      },
      {
       "f.separator",		
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  SeparatorType,	/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateSeparator,   /* create() */
		  RtcParseSeparator,    /* parse() */
		  NULL,     		/* get() */
	    } ,
      },
      {
       "f.exit",		
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  ExitType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateExit,    	/* create() */
		  RtcParseExit,         /* parse() */
		  NULL,     		/* get() */
	    } ,
      },
      {
       "f.clock",		
#ifdef WANT_CLOCK
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  ClockType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateClock,    	/* create() */
		  RtcParseClock,       /* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "HelpText",		
#ifdef WANT_HELP      
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  HelpTextDefType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  NULL, 		/* create() */
		  RtcParseHelpTextDef,  /* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL
#endif
      },
      {
       "EndHelp",		
#ifdef WANT_HELP      
       False,				/* a real object ? */
       NULL,
#else
       -1,
       NULL
#endif
      },
      {
       "f.help-text",		
#ifdef WANT_HELP      
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  HelpTextType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* options */
		  NULL,			/* widget */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateHelpText,    /* create() */
		  RtcParseHelpText,     /* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.help-file",		
#ifdef WANT_HELP      
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  HelpFileType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* options */
		  NULL,			/* widget */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateHelpFile,    /* create() */
		  RtcParseHelpFile,     /* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.help-on-context",
#ifdef WANT_HELP
      True,                             /* a real object ? */
            {
                  NULL,                 /* name */
                  HelpContextType,      /* type */
                  NULL,                 /* parent */
                  NULL,                 /* children */
                  0,                    /* num_children */
                  NULL,                 /* master */
                  NULL,                 /* data */
                  NULL,                 /* command */
                  NULL,                 /* options */
                  NULL,                 /* widget */
                  0,                    /* option mask */
                  True,                 /* create asap */
                  RtcCreateHelpContext, /* create() */
                  RtcParseHelpContext,  /* parse() */
                  NULL,                 /* get() */
            } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.mail-box",		
#ifdef WANT_MAILBOX_WATCHER      
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  MailBoxType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateMailBox, 	/* create() */
		  RtcParseMailBox,      /* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif       
      },
      {
       "f.disk-space",		
#ifdef WANT_DISK_WATCHER
       True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  DiskSpaceType,	/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateDiskUsage, 	/* create() */
		  RtcParseDiskUsage,    /* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.text",		
#ifdef WANT_PANEL       
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  TextType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  RtcCreateText, 	/* create() */
		  RtcParseText,    	/* parse() */
		  RtcTextConfig,        /* get() */
	    } ,
#else
      -1,
      NULL,
#endif
      },
      {
       "f.list",		
#ifdef WANT_PANEL
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  ListType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  RtcCreateList, 	/* create() */
		  RtcParseList,    	/* parse() */
		  RtcListConfig,        /* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.file",		
#if defined(WANT_PANEL) && defined(WANT_FILE) 
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  FileType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  RtcCreateFile, 	/* create() */
		  RtcParseFile,    	/* parse() */
		  RtcFileConfig,     	/* get() */
	    } ,

#else
      -1,
      NULL,
#endif
      },
      {
      "f.toggle",		
#ifdef WANT_PANEL      
       True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  ToggleType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  RtcCreateToggle, 	/* create() */
		  RtcParseToggle,    	/* parse() */
		  RtcToggleConfig,     	/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.command",
#ifdef WANT_PANEL		
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  CommandType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  NULL,		 	/* create() */
		  RtcParseCommand,    	/* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
       "f.scale",		
#ifdef WANT_PANEL 
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  ScaleType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  RtcCreateScale, 	/* create() */
		  RtcParseScale,    	/* parse() */
		  RtcScaleConfig,     	/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
     {
       "AddToMenu",		
       True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  AddToMenuType,	/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  NULL,		 	/* create() */
		  RtcParseAddToMenu,    /* parse() */
		  NULL,     		/* get() */
	    } ,
      },
      {
       "DeleteFromMenu",		
#ifdef WANT_SYSTEM_FILE
       False,				/* a real object ? */
	    {
		  NULL,			/* name */
		  DeleteFromMenuType,	/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  NULL, 		/* create() */
		  RtcParseDeleteFromMenu,/* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
	    "#",
	    False,
	    {
		  NULL,			/* name */
		  CommentType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  False,       		/* create asap */
		  NULL, 		/* create() */
		  NULL,			/* parse() */
		  NULL,     		/* get() */
	    } ,

      },
      {
       "f.url",		
#ifdef WANT_URL 
      True,				/* a real object ? */
	    {
		  NULL,			/* name */
		  UrlType,		/* type */
		  NULL,			/* parent */
		  NULL,			/* children */
		  0,			/* num_children */
		  NULL,			/* master */
		  NULL,			/* data */
		  NULL,			/* command */
		  NULL,			/* widget */
		  NULL,			/* options */
		  0,			/* option mask */
		  True,       		/* create asap */
		  RtcCreateUrl, 	/* create() */
		  RtcParseUrl,    	/* parse() */
		  NULL,     		/* get() */
	    } ,
#else
       -1,
       NULL,
#endif
      },
      {
	    NULL, 
	    False,
	    NULL, 
      },

	    
};





#endif /* RTC_FILEP_H */
