/* main header file  for rtc

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

$Id: Rtc.h,v 1.9 1995/07/03 09:24:35 richardo Exp $

*/


/* 
   The methods used to increase portability in the code have been
   based on the article "Writing Portable X Code" by Stephen Gildea in
   Issue 11 of the X Resource, A Practical Journal of the X Window
   System; by O'Reilly & Associates.

   Subscribe Today.

   End of Advert.

*/

#ifndef RTC_RTC_H
#define RTC_RTC_H


#include <X11/Xos.h>
#include <X11/Xfuncs.h>

#include <stdio.h>
#include <values.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/stat.h>
#if __STDC__
#include <stdarg.h>
#define HAVE_STDARG
#else
#include <varargs.h>
#undef HAVE_STDARG
#endif

#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#else
extern int errno;
extern char *getenv();
#endif

extern char **environ;

#include <Xm/Xm.h>

#if XtSpecificationRelease == 4
#define HAVE_X11R4
#endif 

#if XtSpecificationRelease == 5
#define HAVE_X11R5
#endif 

#if XtSpecificationRelease == 6
#define HAVE_X11R6
#endif


#if XmVERSION == 1
#if XmREVISION == 1
#define HAVE_MOTIF_1_1
#else /* ! revision 1 */
#define HAVE_MOTIF_1_2
#endif /* revision 1 */
#else /* ! version 1 */ 
#define HAVE_MOTIF_2
#endif /* version 1 */

#include <Xm/CascadeBG.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrolledW.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>
#ifdef HAVE_MOTIF_1_1
#include <Xm/VaSimple.h>
#include <Xm/VendorE.h>
#endif
#include <Xm/VirtKeys.h>

/* first pull in the configuration file */
#include <rtc-config.h>

/* holds info about the person/machine its compiled on */
#include <rtc-make.h>

#ifndef HAVE_X11R6
#undef WANT_SESSION_MANAGER
#endif

#ifdef WANT_COLOUR_ICONS
#include <X11/xpm.h>
#endif

#ifdef WANT_EDITRES
#include <X11/Xmu/Editres.h>
#endif

#ifdef WANT_HTML
#include <../libhtmlw/HTML.h>
#endif

/* version info */
#include <rtc-version.h>

/* defines/enums */
#include <rtc-defines.h>

/* resource management */
#include <rtc-resources.h>

/* the typedefs/structures */
#include <rtc-struct.h>

/* functions to read the description fie */
#include <rtc-parse.h>

/* object handling functions */
#include <rtc-object.h> 

/* misc functions */
#include <rtc-misc.h>

/* the gui functions */
#include <rtc-gui.h>

/* execute functions */
#include <rtc-execute.h>

/* all the objects public header file */
#include <rtc-menu-def.h>
#include <rtc-button.h>
#include <rtc-menu.h>
#include <rtc-label.h>
#include <rtc-separator.h>
#include <rtc-exit.h>

#ifdef WANT_CLOCK
#include <rtc-clock.h>
#endif

#ifdef WANT_HELP
#include <rtc-help-def.h>
#include <rtc-help.h>
#include <rtc-help-context.h>
#ifdef WANT_HTML
#include <rtc-gifread.h>
#endif
#endif

#ifdef WANT_MAILBOX_WATCHER
#include <rtc-mail-box.h>
#endif

#ifdef WANT_DISK_WATCHER

#if __sgi
#include <sys/types.h>
#include <sys/statfs.h>
#endif

#if SVR4 /* ie. Solaris 2.x */
#include <sys/types.h>
#include <sys/statvfs.h>
#define statfs(a,b,c,d) statvfs(a,b)
#define HAVE_STATVFS 1
#endif


#if sun
#if ! SVR4 /* ie. not Solaris 2.x */
#include <sys/vfs.h>
#endif
#endif


/* Linux wants the next include for the statfs() call */
#if linux
#include <sys/vfs.h>
#define statfs(a,b,c,d) statfs(a,b)
#endif


#if hpux
#include <sys/vfs.h>
#define statfs(a,b,c,d) statfs(a,b)
#endif

/* supplied by Steve McCoole mccoole@acd4.acd.com */
#if _IBMR2
#include <sys/statfs.h>
#define statfs(a,b,c,d) statfs(a,b)
#endif


/* supplied by Mark Davis mark@taylor.infi.net for ODT 3.0 */
#if sco
#include  <sys/types.h>
#include  <sys/statfs.h>
#endif

/* add any other systems here, please protect any includes with the
   correct cpp token and mail me the changes.
*/

#include <rtc-disk.h>
#endif /* WANT_DISK_WATCHER */

#ifdef WANT_PANEL
#include <rtc-panel.h>
#include <rtc-text.h>
#include <rtc-list.h>

#ifdef WANT_FILE
#include <Rws/File.h>
#endif

#include <rtc-file.h>
#include <rtc-toggle.h>
#include <rtc-command.h>
#include <rtc-scale.h>
#endif

#ifdef WANT_URL
#include <rtc-url.h>
#endif

extern int line_num;


#endif /* RTC_RTC_H */
