/*
 * defines.h -- #defines for X interface to the Problem Tracking System
 * (PTS) database.
 * Dean Collins -- Mon Feb  8 21:27:40 PST 1993
 *
 * Modified: Dean Collins Sat Feb 12 20:21:08 PST 1994
 * Updated Info text.
 *
 * Modified: Dean Collins Wed Feb 23 18:27:05 1994
 * Changed def of PRINTER_NOTICE due to PRINTER (a constant) being changed
 * to PrinterCmd (a variable).  It's now less informative but more flexible.
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */


/* IMPORTANT NOTE:
 *   Most of the defines here can be overridden at compile time on
 *   the command line.  This is the preferred way to change the
 *   defaults, rather than modifying this file.
 */


/* This string is displayed in two cases:
 *
 * 	1.  If xpts is installed set-uid root, and
 *
 *	2.  If xpts is executed by root.
 *
 * You do NOT want to run xpts as root.  It is a security risk.
 * If you disable this feature of xpts and manage to run xpts as root
 * you are foolish.  DO NOT RUN XPTS AS ROOT.  
 * Zombie software and all parties involved disclaim any and all damages
 * that result as a direct or indirect consequence of running xpts as root.
 * See the full disclaimer above.
 * 
 * If you do try to run xpts as root (DONT!) this string will be displayed
 * and xpts will immediatly exit.
 * 
 * If you have a problem with this contact the authors via e-mail.
 *
 * AGAIN, DO NOT DISABLE THIS.
 */
#ifndef NO_ROOTUSERS
#define NO_ROOTUSERS \
"\n\nXpts cannot be executed by root, nor can it be installed setuid root.\n"\
"Sorry.\n\n\n"
#endif /*NO_ROOTUSERS*/


/* Do you want xpts to keep a log of who uses it? Comment this define
 * out if you don't.  No attempt is made to trim the logfile.
 * This was used primarily in the testing phase.  You probably
 * won't need it.  Is is up to you to assure you do not violate
 * your user's privacy concerns if you enable this.
 */
/*#define USERLOG */

#ifdef USERLOG
#ifndef LOGFILE
#define LOGFILE "/usr/local/pts/log/xpts.log"
#endif /* LOGFILE */
#endif /* USERLOG */


/* The full path for the message-of-the-day file, in quotes. */
#ifndef MOTDFILE
#define MOTDFILE "/etc/motd"
#endif


/* This should be edited so that it informs the user that they
 * can delete problems that they themselves are editing.  (A glitch
 * in the current zdbm.)  
 */
#ifndef DELETE_WARNING
#define DELETE_WARNING "\n\
WARNING:  Once deleted, this problem will be permanently removed \n\
from the database.  If you are not sure you want to do this, \n\
Press the [Cancel] button below.  Otherwise, to delete the problem \n\
Press the [Continue] button below. \n"
#endif


#ifndef EMPTY_LOG_WARNING
#define EMPTY_LOG_WARNING "\n\
WARNING:  You have supplied an empty problem log.  Are you sure\n\
you want to make an empty log entry?  If not, press the [Cancel]\n\
button below.  Otherwise, to add the empty log entry to the\n\
problem log, press the [Continue] button below. \n"
#endif


#ifndef EMPTY_REQ_WARNING
#define EMPTY_REQ_WARNING "\n\
WARNING:  You have supplied an empty reopen request.  Are you sure\n\
you want to make an empty request?  If not, press the [Cancel]\n\
button below.  Otherwise, to add the empty reopen request to the\n\
database, press the [Continue] button below. \n"
#endif


#ifndef EMPTY_DESC_WARNING
#define EMPTY_DESC_WARNING "\n\
WARNING:  You have supplied an empty problem summary.  Are you sure\n\
you want to make an empty summary entry?  If not, press the [Cancel]\n\
button below.  Otherwise, to add problem with the empty problem\n\
summary to the problem log, press the [Continue] button below.\n"
#endif


#ifndef EMPTY_NODE_WARNING
#define EMPTY_NODE_WARNING "\n\
WARNING:  You have supplied an empty problem node value.  Are you\n\
sure you want to give an empty node entry?  If not, press the [Cancel]\n\
button below.  Otherwise, to add problem with the empty node\n\
value to the problem log, press the [Continue] button below.\n"
#endif


#ifndef REOPEN_NOTICE
#define REOPEN_NOTICE "\n\
NOTICE:  You have made a request to reopen this problem.\n\
Appropriate support personnel will be notified of your request.\n "
#endif

#ifndef DENY_REOP_NOTICE
#define DENY_REOP_NOTICE "\n\
NOTICE:  You have denied a request to reopen this problem.\n\
The problem reporter will be notified by E-mail of your denial.\n "
#endif


#ifndef PRINTING_NOTICE
#define PRINTING_NOTICE "\n\
NOTICE:  This problem log has been queued to the printer.\n"
#endif

#ifndef SOLVED_NOTICE
#define SOLVED_NOTICE "\n\
NOTICE:  The reporters of this problem have been notified via E-mail\n\
of your problem solution.\n"
#endif

#ifdef DEBUG
#define DEBUG_NOTICE "\n\
NOTICE:  This software is in the beta testing phase.  Any data you\n\
enter may be deleted or mangled by the software development team.\n\
If you are a system user who has discovered this program on your own,\n\
please quit Xpts immediatly.  There will be an announcement made when\n\
Xpts becomes generally available.  If you are officially participating\n\
in the beta testing of Xpts or are otherwise authorized by the\n\
software development team to use this software, please excuse this\n\
annoying notice.\n"
#else
#define DEBUG_NOTICE ""
#endif /*DEBUG*/

#ifndef STARTUP_NOTICE
#define STARTUP_NOTICE "\n"\
VERSION "\n" COPYRIGHT "\n\n" DEBUG_NOTICE
#endif /*STARTUP_NOTICE*/

#ifndef EMPTY_UNSOLVED
#define EMPTY_UNSOLVED "No Unsolved Problems and no Reopen Requests found"
#endif

#ifndef EMPTY_SUMMARIES
#define EMPTY_SUMMARIES "No problems found"
#endif


      /* Pretty generic definitions, used in various places.
       */

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif


#define QUERY (-1) 		/* Flag used to check if a problem is locked */



/* MAXTEXT is the maximum length of a problem record that can be displayed
 * in the problem viewer.  This will be eliminated in favor of dynamic
 * memory allocation (soon).
 */
#ifndef MAXTEXT
#define MAXTEXT 99999
#endif

/* MAXERROR is the maximum length of an error message.
 */
#ifndef MAXERROR
#define MAXERROR 1000
#endif

/* ReadProblem() takes one of two flags:
 *	UNSOLVEDPROB	-- Read the i'th unsolved problem.
 *	ANYPROB		-- Read the i'th problem, solved or not.
 *
 * "i" is the index into the list of summaries being shown.  
 * The first (top) element in the list is 0.
 */
#define UNSOLVEDPROB	69
#define ANYPROB		70


#define PTS_INFO_STR \
"______________________________________________________________________	\n" \
"      Problem Tracking System						\n" \
"      PTS/Xpts Version 1.1a2	 					\n" \
"      Brought to you by Dean Collins					\n" \
"									\n" \
"      PTS is a database tool which is used to improve communication	\n" \
"between system users and support personnel about problems encountered	\n" \
"with the system.  Xpts is an X Window System application used to	\n" \
"access the PTS database in an X environment.				\n" \
"									\n" \
"NOTE:  There is a World-Wide-Web user-interface for PTS now!		\n" \
"									\n" \
"Copyright (c) 1995,1994,1993,1992 Dean Collins and Chris Hyde.		\n" \
"Copyright (c) 1992 Luke Sheneman, Brian Goff, and John Hunter.		\n" \
"Copyright (c) 1992 University of Idaho, Moscow, Idaho.			\n" \
"Copyright (c) 1985, 1986, 1987, 1988, 1989 Massachusetts		\n" \
"      Institute of Technology, Cambridge, Massachusetts, and		\n" \
"      Digital Equipment Corporation, Maynard, Massachusetts.		\n" \
"The X Window System is a trademark of MIT.				\n" \
"This product includes software developed by the University of		\n" \
"California, Berkeley and its contributors.				\n" \
"______________________________________________________________________	\n" \
"									\n" \
"The Problem Tracking System was initially designed by Zombie Software	\n" \
"while at the University of Idaho.					\n" \
"									\n" \
"Zombie Software is/was:						\n" \
"									\n" \
"      Project Leader:							\n" \
"									\n" \
"            Dean Collins, Network Engineer, Conjungi Corporation	\n" \
"                  X11 user-interface design and implementation,	\n" \
"                  World-Wide-Web user-interface design/implementation	\n" \
"                  using HTTP, CGI and WAIS.				\n" \
"                  Configuration file parser design and implementation.	\n" \
"                  (e-mail: dean@halcyon.com)				\n" \
"									\n" \
"      Design Team Members:						\n" \
"									\n" \
"            Chris Hyde							\n" \
"                  zdbm database design/implementation.			\n" \
"                  (e-mail: chyde@acm.org)				\n" \
"									\n" \
"            Luke Sheneman						\n" \
"                  High-level database interface.			\n" \
"                  Configuration file parser design and implementation.	\n" \
"                  All-around miracle worker.				\n" \
"                  (e-mail: sheneman@cs.uidaho.edu)			\n" \
"									\n" \
"            Brian Goff							\n" \
"                  cron sub-system design and implementation.		\n" \
"									\n" \
"            John Hunter						\n" \
"                  Software Requirements Document and Software		\n" \
"                  Design Document coordination.			\n" \
"                  (Do you have that final SDD draft yet, John?)	\n" \
"									\n" \
"Special thanks to: 							\n" \
"       Prof. John Dickinson, Chair, Computer Science Department,	\n" \
"            (for the idea);						\n" \
"	Mike Simon, President, Conjungi Corporation, (for the patience	\n" \
"            and guidance while he was our systems administrator	\n" \
"            at the U. of I.);						\n" \
"	Prof. Karen Van Houten, (for the suggestions);			\n" \
"	Brent Heikkilia (for help with the Requirements Analysis);	\n" \
"	and Dayne Steed (for early Requirements and Design work).	\n" \
"									\n" \
"Please direct E-mail to one of the following Internet addresses:	\n" \
"	dean@halcyon.com						\n" \
"	chyde@delphi.com						\n" \
"									\n" \
"See the PTS homepage at:						\n" \
"      http://www.halcyon.com/dean/pts/pts.html				\n" \
"									\n" \
"THANK YOU FOR USING XPTS!						\n" \
" 									\n" \
"______________________________________________________________________	\n" \
"DISCLAIMER:								\n" \
"      The University of Idaho, M.I.T. and the Zombie Software team	\n" \
"members make no representations about the suitability of this software	\n" \
"for any purpose.  It is provided 'as is' without express or implied	\n" \
"warranty.  Conjungi Corporation is in no way associated with the	\n" \
"design or development of PTS.						\n" \
"______________________________________________________________________	\n" 


/* end of defines.h */
