/*
 * pts-report.c -- PTS CGI utility to process a form for reporting a problem.
 *
 * Dean Collins
 * created: Sat Mar 11 10:29:11 PST 1995
 */

/*
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <errno.h>		/* Error utilities header file */
#include <sys/param.h>          /* System parameters header file */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "patchlevel.h"         /* For version info. */
#include "html.h"		/* A couple of HTML-related routines */



/******************** MODULES *************************************/

/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

     This function is the main routine for this program.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
main (int   argc,
      char *argv[])

     /* Interface description:
         INPUT:
          argc  - The number of command-line arguments.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  Non-zero is error.
     */
{
     /* Internal variables: */

          /* Major */
    post_entry entries[MAX_ENTRIES];
    int count=0;
    char *Path=NULL ;
    char *Summary=NULL ;
    char *Desc=NULL ;
    char *Node=NULL ;
    char *Reporter=NULL ;
    char *Priority=NULL ;
    signed char Priority_Value=0 ;
    FILE *fp=NULL ;
    char hostname[MAXHOSTNAMELEN];
    ProblemTree *ProbTree = NULL ;	/* The tree of problem types. */
    UserInfo UserInfoRec ;		/* Information about the user. */
    struct Full_path pathlist ;

          /* Minor */
    int x=0;
    char *tdesc=NULL ;
    int Status = 0 ;			/* A return value */

   /*----------------- Start of main() routine ------------------*/

#   ifdef DEBUG
    freopen ("/tmp/debug", "w", stderr) ;
    zdebug1("Debug output for: %s\n\n", argv[0]) ;
#   endif

    pathlist.next = NULL ;


    count = PostQuery (stdout, entries, MAX_ENTRIES) ;

    for(x=0; x < count; x++)
    {  if (strcmp("Type",	 entries[x].name) == 0)         Path = entries[x].value ;
       if (strcmp("Summary",	 entries[x].name) == 0)      Summary = entries[x].value ;
       if (strcmp("Description", entries[x].name) == 0)         Desc = entries[x].value ;
       if (strcmp("Host",	 entries[x].name) == 0)         Node = entries[x].value ;
       if (strcmp("Email",	 entries[x].name) == 0)     Reporter = entries[x].value ;
       if (strcmp("Priority",	 entries[x].name) == 0)     Priority = entries[x].value ;
    }

    HTMLHeader(stdout, "Problem Tracking System", "Problem Submission Results", "") ;

    printf("You submitted the following information:<p>%c",10);
    printf("<ul>%c",10);

    for(x=0; x < count; x++)
        printf("<li> <code>%s = %s</code>%c",entries[x].name,
               entries[x].value,10);
    printf("</ul>%c",10);

	/* Desc. seems to get "^M" characters in it, so nuke them.... */
    if (Desc)
    {   tdesc = malloc(strlen(Desc)+1) ;
        for (x=0; x<strlen(Desc); ++x)
        {   if (Desc[x] == '\r')
                 tdesc[x] = ' ' ;
            else tdesc[x] = Desc[x] ;
        }
        Desc = tdesc ;
    }

    if (strlen(Priority))
    {
        if (strcmp(Priority,"High Priority") == 0)    Priority_Value =  1 ;
        if (strcmp(Priority,"Normal Priority") == 0)  Priority_Value =  0 ;
        if (strcmp(Priority,"Low Priority") == 0)     Priority_Value = -1 ;
        printf("<!Priority=%s(%d)>%c", Priority, Priority_Value,10) ;
    }

		/* Were some of the fields not provided??? */
    if (Path==NULL || Summary==NULL  || Desc==NULL || 
        Node==NULL || Reporter==NULL /*|| Priority==NULL*/)
    {   	/* This will cause a little extra space to appear between
		 * the items listed above and these.  Oh well, good enough.
		 */
        printf("<ul>%c",10);
        if (Path==NULL)     printf("<li> <code>Type =        </code>%c",10);
        if (Summary==NULL)  printf("<li> <code>Summary =     </code>%c",10);
        if (Desc==NULL)     printf("<li> <code>Description = </code>%c",10);
        if (Node==NULL)     printf("<li> <code>Node =        </code>%c",10);
        if (Reporter==NULL) printf("<li> <code>Email =       </code>%c",10);
/*      if (Priority==NULL) printf("<li> <code>Priority =    </code>%c",10);*/
        printf("</ul><p>%c",10);
        printf("ERROR -- not all required fields were provided.%c",10) ;    
    }

		/* Else do another similar check before adding problem...*/
    else if (strlen(Path) && strlen(Summary)  && strlen(Desc) && 
             strlen(Node) && strlen(Reporter) /*&& strlen(Priority)*/)
    {

          /* Get information about the user and read the problem hierarchy
           * from the config file.
           */
        zdebug("calling Setup()...\n") ;

/*CLD*/ if (Setup(&UserInfoRec, &ProbTree) == False)
        {  fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
           exit(1);
        }
        zdebug("returned from Setup()...\n") ;
        zdebug1("\tUserInfoRec.sysopflag = %d\n", UserInfoRec.sysopflag);
        zdebug1("\tUserInfoRec.username  = %s\n", UserInfoRec.username) ;
        zdebug1("\tUserInfoRec.realname  = %s\n", UserInfoRec.realname) ;


           /* Get the problem tree into a list of leaves more easily printed.*/
/*CLD*/ TraverseLeaves(ProbTree, &pathlist) ;

        zdebug("Problem:\n") ;
        zdebug1("\tPath: %s\n", Path) ;
        zdebug1("\tSummary: %s\n", Summary) ;
        zdebug1("\tReporter: %s\n", Reporter) ;
        zdebug1("\tNode: %s\n", Node) ;
        zdebug1("\tDesc: %s\n", Desc) ;
        zdebug1("<p>%c",10);

/*
 * A BIT OF A HACK... (In case we're not who we are.)
 *	This is necessary since this is not actually being executed by
 *	the person reporting the problem.  Your web server needs to help
 *	make sure this is not abused.
 */
        strcpy(UserInfoRec.username,Reporter) ;


       
/*CLD*/ Status = WriteProblem(ProbTree, FixPath(Path), &UserInfoRec, 
			      Desc, Summary, Node, Priority_Value);

      if (Status == (int)NULL)  /* Error! */
      {  fprintf(stderr,
                "Error writing problem!\n\nPossible error cause:\n%s\n", 
/*CLD*/         CloudStrerror(cld_errno)) ;
                printf("Error writing problem!%c%cPossible error cause:%c%s%c", 
/*CLD*/         10, 10, 10, CloudStrerror(cld_errno), 10) ;
      }
      else printf("Your problem was successfully added to the PTS database.%c",10) ;
 
    }
    else printf("ERROR -- not all required fields were provided.%c",10) ;    

    HTMLFooter(stdout) ;

}  /*--------------------- End of main() ------------------------*/


/* end of pts-report.c */

