/* html.h -- A couple of HTML-related routines.
 *
 * Dean Collins
 */

/*
 *
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

		/* Macro #defines */
#ifndef MAX_ENTRIES
#define MAX_ENTRIES 500
#endif /*MAX_ENTRIES*/

		/* Type definitions */
typedef struct {
   char *name;
   char *value;
} post_entry;

typedef struct {
   char name[128];
   char value[128];
} get_entry;

		/* Function Prototyes */
/* In util.c */
char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *len);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);

/* In html.c */
void HTMLHeader (FILE *fp, char *title, char *header, char *refresh) ;
void HTMLFooter (FILE *fp) ;
int PostQuery (FILE *fp, post_entry entries[], int max_entries) ;
int GetQuery (FILE *fp, get_entry entries[], int max_entries) ;

/* End of html.h */
