/* util.h -- Several low-level utilities.
 *
 * Created: Dean Collins Fri Mar 11 14:16:07 1994
 *
 * Copyright (c) 1994 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the University of Idaho
 * not be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  The University
 * of Idaho makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE UNIVERSITY OF IDAHO BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

	/* Make sure this is only included once. */
#ifndef UTIL_INCLUDED
#define UTIL_INCLUDED


/********************** Prototypes for str.c ********************************/

char *FixStr(char *str) ;
char *StripLeading(char *str) ;
char *StripTrailing(char *str) ;
char *StrTail(char *s, int n) ;

/******************* Prototypes for various .c files **********************/

int SendMail(char *Prog, char *Opts, char *Subject,	/* sendmail.c */
             char *User, char *Host, char *Filename);
int WriteBuf(int fd, char *buf, int count) ;		/* writebuf.c */


#ifdef NEED_STRERROR
char *strerror(int num) ;				/* strerror.c */
#endif

#ifdef NEED_STRFTIME
int strftime(char *s, size_t maxsize, const char *format,
	     const struct tm *timeptr);			/* strftime.c */
#endif

#ifdef NEED_TRUNCATE
int truncate(char  *filenam, char  *filesize);		/* truncate.c */
#endif

/* HP-UX 9.x uses setresuid() instead of seteuid(). */
#ifdef __hppa
#   define SETEUID(u) setresuid(-1,(u),-1)
#else /*not defined __hppa*/
#   define SETEUID(u) seteuid(u)
#endif /* __hppa */



char *sctoa(int Num) ;

#endif /*UTIL_INCLUDED*/
/* end of util.h */
