#include <stdlib.h>
#include <stdio.h>

#include "CURcurses.h"
#include "text.h"


int WinTitle(CursesObj *cur,
	 WINDOW *win,
         char *LeftStr,
         char *CenterStr,
         char *RightStr)
{
  mvwaddstr(win,0,0,LeftStr) ;
  wstandout(win) ;
  CURwcenterline(win,CenterStr, 0) ;
  wstandend(win) ;
  mvwaddstr(win,0,cur->COLS-strlen(RightStr),RightStr) ;
}


int ListWin(CursesObj *cur,
        WINDOW *win,	/* The window (presumably full-screen) */
	char *ltitle,	/* The title in the top-left corner. */
	char *ctitle,	/* The title in the top-center corner. */
	char *rtitle,	/* The title in the top-right corner. */
	char **list,	/* The array of strings. */
	char **help,	/* The help text */
	int userlevel)	/* The expert level of the user --> help screen? */
	
{
   int HelpHeight, ListHeight, TitleHeight=1, i ;
   int HelpTop ;

	/* Figure out the height of the help text */
   for (HelpHeight=0; help[HelpHeight]!=NULL; ++HelpHeight)
   {	/* Nothing */
   } 
   HelpTop=cur->ROWS - HelpHeight - 1 ;

	/* The Window Title */
   WinTitle(cur,win,ltitle,ctitle,rtitle) ;


	/* The 'thang in the middle'... */
   for (i=0; TitleHeight+2+i<HelpTop-1 && list[i]!=NULL && list[i][0] !='\0'; ++i)
   {  
      wmove(win, TitleHeight+2+i, 10) ;
      wprintw(win, "%3d.  ",i+1) ;
      waddstr(win, list[i]) ;
   }

	/* The help at the bottom. */
   for (i=0; i<HelpHeight; ++i)
   {  
      wmove(win, HelpTop+i, (cur->COLS-strlen(help[i]))/2) ;
      waddstr(win, help[i]) ;
   }
}


int MoreWin(CursesObj *cur,
        WINDOW *win,	/* The window (presumably full-screen) */
	char *ltitle,	/* The title in the top-left corner. */
	char *ctitle,	/* The title in the top-center corner. */
	char *rtitle,	/* The title in the top-right corner. */
	char **text,	/* The array of strings. */
	char **help,	/* The help text */
	int userlevel)	/* The expert level of the user --> help screen? */
	
{
   int HelpHeight, ListHeight, TitleHeight=1, i ;
   int HelpTop ;

#ifdef DEBUG
      fprintf(stderr,"Entering MoreWin()\n") ;
#endif
	/* Figure out the height of the help text */
   for (HelpHeight=0; help[HelpHeight]!=NULL; ++HelpHeight)
   {	/* Nothing */
   } 
   HelpTop=cur->ROWS - HelpHeight - 1 ;

	/* The Window Title */
   WinTitle(cur,win,ltitle,ctitle,rtitle) ;

#ifdef DEBUG
fprintf(stderr,"'%s'\n",text[0]) ;
#endif

	/* The 'thang in the middle'... */
   for (i=0; TitleHeight+2+i<HelpTop-1 && text[i]!=NULL; ++i)
   {  
      wmove(win, TitleHeight+2+i, 0) ;
      waddstr(win, text[i]) ;
#ifdef DEBUG
      fprintf(stderr,"text[%d]=%s\n", i, text[i]) ;
#endif
   }

	/* The help at the bottom. */
   for (i=0; i<HelpHeight; ++i)
   {  
      wmove(win, HelpTop+i, (cur->COLS-strlen(help[i]))/2) ;
      waddstr(win, help[i]) ;
   }

#ifdef DEBUG
      fprintf(stderr,"Leaving MoreWin()\n") ;
#endif
}
