/*
 * formatprob.c --  A couple of utilities needed for formatting
 *             problems for the X Problem Tracking System (PTS) database.
 *
 * Dean Collins 
 * created: Tue Oct 20 10:13:14 PDT 1992
 *
 * Modified: Dean Collins Sat Feb 12 17:31:48 1994
 * Modifications recommended by Jaap Haalboom (haalboom@prl.philips.nl).
 * Fixed a couple of minor malloc problems; Fixed return value for FixStr().
 * 
 * Modified: Dean Collins Thu Feb 24 09:18:31 1994
 * Moved FixStr, StripTrailing & StripLeading into the cloud.
 *
 * Modified: Dean Collins Fri Mar 11 17:24:18 PST 1994
 * Renamed to xutil.c to reduce confusion with ../util/util.c.  sigh.
 *
 * Modified: Dean Collins Fri Mar 18 18:29:22 1994
 * Finally switched to using dynamic memory in FormatProblem.
 * 
 * Modified: Dean Collins Wed Mar 15 10:16:04 PDT 1995
 * Somewhere along the way I pulled FormatProblem() from
 * xutil.c and placed here in formatprob.c.
 */

/*
 * Copyright (c) 1992,1993,1994,1995 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <sys/types.h>          /* Common data types */
#include <sys/stat.h>           /* File status utilities */
#include <errno.h>              /* Error utilities header file */

#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */




/******************** MODULES *************************************/
/*
______________________________________________________________________
FormatProblem()

FUNCTION DESCRIPTION:

     This function will format a problem_record into a single string
There's still a duplicate of this function in the cloud for printing.
[Egads...]
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date:  9/07/92
     Version 1.0 finalized: Dean Collins	Date: 1/9/93
     Modified: Dean Collins			Date: 3/18/94
	Finally removed the huge static array and started using
	dynamic memory for the buffer.
     Modified: Dean Collins			Date: 11/21/94
	Added priority field.
     Modified: Dean Collins			Date: 1/15/95
	Moved to neb_cld from Xpts.
______________________________________________________________________
*/


char *
FormatProblem(problem_record *problem, char *path)

     /* Interface description:
         INPUT:
          problem	- The problem to format.
         OUTPUT:
          None.
         RETURN:
          char *	- The formatted problem.
     */
{
     /* Internal variables: */
          /* Major */
      /* NONE */
          /* Minor */
      reporter_record *reporter=NULL ;
      int num_rep ;
      int i,j,buflen ;
      char tempstr[DBPATHLEN] ;
      static char *probtext=NULL ;
      int status ;
      reopened_record *ReopenedRec=NULL ;


   /*------------ Start of FormatProblem() routine -------------*/
   zdebug("Entering FormatProblem()\n") ;

   if (problem==NULL)
      return(NULL) ;

   status = problem->status ;

   if (status == REOPENED)
   {  /* Assign ReopenedRec and fill in path from it */
      ReopenedRec=(reopened_record *)(problem->reop_rec) ;
      strcpy(path, ReopenedRec->db_path) ;
   }

   zdebug1("FormatProblem() -- problem->status = %d\n", status) ;

     /* Zero out the probtext string. */

	/* Allocate a new buffer.   Why 1024 and 256?  It assumes the headers
	 * (the Type:, the Status:, etc. lines, not counting the reporters
	 * list) will be less than 1K (should be _much_ less).  Each reporter
	 * line is assumed to take less than 256 characters (They're probably
	 * about 60 chars.)
	 * So... The memory needed is the length of the log plus the
	 * the max size of the headers (not counting reporters) plus
	 * the number of reporters times the maximum length of a reporter line.
	 * Are you confused yet?   :-)  Adjust these values as necessary.
	 */
   if (probtext) free(probtext) ;
   probtext = malloc(strlen(problem->log_file) + 1024 + 
                     256 * (problem->num_old_rep + problem->num_rep)) ;
   if (probtext == NULL) return NULL; /* Abort if malloc failed */
   probtext[0] = '\0' ;

     /* Show the problem type */

   strcat(probtext, "PROBLEM TYPE:\t") ;
   if (strncmp(ROOTSTR,path,strlen(ROOTSTR)) == 0)
/*CLD*/      strcat(probtext, FixPath(path)) ;
   else strcat(probtext, path) ;

     /* Show the problem status */
   strcat(probtext, "\nSTATUS:\t\t") ;
   if      (status == SOLVED)   strcat(probtext, "Solved\n") ;
   else if (status == UNSOLVED) strcat(probtext, "Unsolved\n") ;
   else if (status == REOPENED) strcat(probtext, "Reopen Request\n") ;
   else
   {
      zdebug("FormatProblem(): Error in problem status!\n") ;
      strcat(probtext, "(Unknown)\n") ;
   }

#  ifdef DO_PRIORITY
   strcat(probtext, "PRIORITY:\t") ;		/* DC 11/21/94 */
   strcat(probtext, sctoa(problem->priority)) ;
#  endif

     /* Add summary */
   strcat(probtext, "\n\nSUMMARY:\n") ;
   strcat(probtext, problem->short_description) ;
   strcat(probtext, "\n\n") ;

     /* Add the reporters */
	/* Add column headers */
   sprintf(tempstr, "%-*s%-*s%s\n", NAMELEN, "REPORTER", NODELEN, "NODE",
          "DATE/TIME") ;
   strcat(probtext, tempstr) ;
   sprintf(tempstr, "%-*s%-*s%s\n", NAMELEN, "--------", NODELEN, "----",
          "---------") ;
   strcat(probtext, tempstr) ;

	/* Add reporters list */
   if (status == SOLVED)
   {  reporter = problem->old_reporter_list ;
      num_rep = problem->num_old_rep ;
   }
   else if (status == UNSOLVED)
   {  reporter = problem->reporter_list ;
      num_rep = problem->num_rep ;
   }
   else if (status == REOPENED)
   {  reporter = &(ReopenedRec->rep_rec) ;
      num_rep = 1 ;
   }

   if (reporter != NULL)
      for (i=0; i<num_rep; ++i)
      {  /* Add the reporter name */
         zdebug("FormatProblem(): appending reporter record:\n") ;
         zdebug1("\treporter\t- %s\n", (reporter[i]).account_name) ;
         zdebug1("\tnode\t- %s\n", (reporter[i]).node_name) ;
         zdebug1("\tdate\t- %s\n", (reporter[i]).date_time) ;

         strncat(probtext, (reporter[i]).account_name, NAMELEN) ;
         buflen=strlen((reporter[i]).account_name) ;
         for (j=buflen; j<NAMELEN; ++j)
            strcat(probtext, " ") ;

         /* Add the reporter's node */
         strncat(probtext, (reporter[i]).node_name, NODELEN) ;
         buflen=strlen((reporter[i]).node_name) ;
         for (j=buflen; j<NODELEN; ++j)
            strcat(probtext, " ") ;
   
         /* Add the reporting date */
         strcat(probtext, (reporter[i]).date_time) ;
         j=strlen((reporter[i]).date_time) ;
         if (j)
            if (((reporter[i]).date_time)[j-1] == '\n')
               probtext[strlen(probtext)-1] = '\0' ;


         /* Add EOL */
         strcat(probtext, "\n") ;
      }
#ifdef DEBUG
   else zdebug("FormatProblem():  reporters list was NULL!\n") ;
#endif
   strcat(probtext, "\n") ;

     /* Add problem log */
   if (status == REOPENED)
   {  strcat(probtext, REOPEN_REQ_STR) ;
      strcat(probtext, ReopenedRec->reasons_log) ;
      strcat(probtext, REOPEN_REQ_STR2) ;
   }
   strcat(probtext, PROBLEM_STR) ;
   strcat(probtext, problem->log_file) ;
   strcat(probtext, "\n") ;

   zdebug("---------------------FORMATTED PROBLEM---------------------\n") ;
   zdebug1("%s", probtext);
   zdebug("-----------------END-FORMATTED PROBLEM---------------------\n") ;
   zdebug("Leaving FormatProblem()\n") ;

   return(probtext) ;

}  /*-------- End of FormatProblem() ---------------------------*/



/* end of formatprob.c */
