/* Author:  Luke Sheneman  */


/*
 * Copyright (c) 1992 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of the University of Idaho
 * Dean Collins and Luke Sheneman not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The University of Idaho, Luke Sheneman and Dean Collins
 * make no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO, LUKE SHENEMAN, AND DEAN COLLINS  DISCLAIM ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * LUKE SHENEMAN OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */


#include "pts.h"



extern int cld_errno; 	/* our global variable */

char *CloudStrerror();	/* A prototype */

#define MAXERRORSTRING 2500



/* For setup.c */

#define CLD_ERR1 	400	/* getpwuid could not get information */
#define CLD_ERR2	401	/* could not parse config file info   */



/* For summaries.c */

#define CLD_ERR3	402	/* could not read next unsolved problem           */
#define CLD_ERR4	403	/* could not read next reopened requested problem */
#define CLD_ERR5	404	/* could not read next solved problem 	   	  */
#define CLD_ERR6	405 	/* could not read particular unsolved problem     */
#define CLD_ERR7	406 	/* could not read particular reopened problem     */
#define CLD_ERR8	407 	/* invalid problem status in ReadUnsolved()       */
#define CLD_ERR9	408 	/* empty summary list passed into ReadUnsolved()  */



/* For problems.c */

#define CLD_ERR10	409 	/* invalid path in problem tree			  */
#define CLD_ERR11	410 	/* branch has no children in problem tree.	  */
#define CLD_ERR12	411 	/* non-existant branch in problem tree.		  */
#define CLD_ERR13	412 	/* generic difficulty moving to desired branch    */
#define CLD_ERR14	413 	/* requested problem does not exist (cloud fault) */
#define CLD_ERR15	414 	/* requested problem does not exist (zdbm fault)  */
#define CLD_ERR16	415 	/* error locking problem			  */
#define CLD_ERR17	416 	/* error unlocking problem			  */
#define CLD_ERR18	417 	/* error solving problem			  */
#define CLD_ERR19	418 	/* error reopening problem			  */
#define CLD_ERR20	419 	/* error requesting the reopening of a problem	  */
#define CLD_ERR21	420 	/* error opening temp mail file for deny letter   */
#define CLD_ERR22	421 	/* error denying the reopen of a problem 	  */
#define CLD_ERR23	422 	/* error adding reporter to reporter list	  */
#define CLD_ERR24	423 	/* error deleting file from database		  */
#define CLD_ERR25	424 	/* source path invalid for moving problem	  */
#define CLD_ERR26	425 	/* destination path invalid for moving problem	  */
#define CLD_ERR27	426 	/* error moving problem	  		          */
#define CLD_ERR28	427 	/* source path invalid for linking a problem	  */
#define CLD_ERR29	428 	/* destination path invalid for linking a problem */
#define CLD_ERR30	429 	/* error linking problem	  		  */
#define CLD_ERR31	430 	/* error opening temp file for printing a problem */
#define CLD_ERR32	431 	/* error adding problem to database 		  */
#define CLD_ERR33 	432     /* error appending a problem log to a problem     */
#define CLD_ERR35	434	/* Error Reopening Problem 			  */




/* For subtree.c */

#define CLD_ERR34	433	/* SubTree not found in Tree with specified path  */ 


