#include <stdio.h>
#include <errno.h>
#include <string.h>

#define PTSROOT "/usr/tmp"

#include "../zdbm/zdbm.h"

main(int argc, char *argv[])
{
 index_record index;
 FILE *index_file;
 int count=1;
 char path[COMPLETEPATHLEN], *cp;

 if (argc<2)
 {
    fprintf(stderr, "You Must Give the Pathlist To A Problem Leaf.|n");
    exit(1);
 }
 cp=rindex(argv[1], '/');
 if (cp==NULL)
    cp=argv[1];
 else
    cp++;
 sprintf(path, "%s/%s/%s.index", PTSROOT, argv[1], cp);

 if ((index_file=fopen(path, "r"))==NULL)
 {
    fprintf(stderr, "Could Not Open %s.\n", path);
    perror(NULL);
    exit(errno);
 }
 printf("Index records from the %s file.\n\n", path);
 while (fread(&index, sizeof(index_record), 1, index_file)!=NULL)
 {
    printf("Index record %d:\n", count++);
    printf("\tPrid - %s\n\tMRD - %03d\tSF - %03d\tEF - %03d\n", index.prid, 
		index.mrd, index.sf, index.ef);
    printf("\tAccount_name - %s\n", index.account_name);
    printf("\tNode_name - %s\n", index.node_name);
    printf("\tPid - %d\n", index.pid);
    printf("\tLn_prid - %s\n\tSD - %s\n\tFR - %s\n\n", index.ln_prid, index.sd,
		index.fr);
 }
}
 
