%{
/* config.yacc -- config file parser.
 * Dean Collins
 * created: Mon Aug 24 23:45:28 PDT 1992
 *
 * modified: Dean Collins Wed Feb 23 16:45:40 1994
 *   Added parsing for dbtop, printer, printer_opts, and mailprog lines.
 *
 * Modified: Dean Collins Wed Mar 01 17:28:12 1994
 *   Added parsing for pathlist for mail lines.  Can now do
 *		user	days	path1,path2,path3...
 *   to send mail to user only about problems below the specified paths.
 *   The paths don't need to be leaves.
 *
 * Modified: Dean Collins Wed Mar 02 18:08:20 1994
 *   Replaced error handler with a call to yyerror().
 *
 * Modified: Dean Collins Mon Jan  2 17:15:11 PST 1995
 *   Modified so that all DEBUG output goes to stderr.
 *
 * Modified: Dean Collins Thu Jun  8 13:31:27 PDT 1995
 *   Replaced "#ifdef DEBUG" and "if (debug)" method of debug output
 *   with calls to the zdebug macros.
 *
 */

/*
 * Copyright (c) 1995,1994,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

/* Includes here */
#include <stdio.h>
#include "zdbm.h"
#include "cloud.h"
#include "config.h"
#ifdef DEBUG
#include "errno.h"
#endif

/* OK, they really aren't the same. Should work anyhow. This is done since
 * our version of bison on our HP-UX machines was generating a y.tab.c file
 * with calls to alloca().  Probably means our bison is screwy.  Oh, well.
 * This will work until bison is fixed.  The regular yacc works ok, too.
 */
#if defined(HPUX) || defined(NO_ALLOCA)
#define alloca(s) malloc(s)
#endif


/* variable decs. here. */
extern char ParserPath[] ;	/* A file path */
extern char ParserName[] ;	/* Something that looks like a usename */
extern int ParserDays ;		/* An integer value */
extern FILE *yyin ; 		/* From lex.yy.c - input file */
extern int yylineno ; 		/* From lex.yy.c - current line number */
extern char *yytext ; 		/* From lex.yy.c - current text */
extern parse_error ;		/* How many errors have occured? */

	/* The rest should only be used by config.yacc */
int parsetype=0 ;		/* See config.h for valid values */
struct Full_path *CfgTree=NULL ;/* A problem tree being constructed */
MailInfo *CfgMailList=NULL ;	/* A mail list being constructed */
int InMailLine=FALSE;		/* Are we in a mail-list line ? */
StringListRec *ParserStringList=NULL ; /* A list of paths for a mail list line*/

%}

/* List of all possible tokens... */
%token EOL WS INT NAME RELPATH ABSPATH DBTOP PRNTOK PRNOPTOK MAILTOK LEAFTOK MAILERTOK MAILOPTOK SYSOPTOK COMMA

%%
configfile	: validline { zdebug("<configfile>") ; }
		| validline configfile

validline	: pathline        { zdebug("<validline>\n") ; }
		| mailline        { zdebug("<validline>\n") ; }
		| eol             { zdebug("<validline>\n") ; }
		| badline         { zdebug("<validline>\n") ; }
		| dbtopline       { zdebug("<validline>\n") ; }
		| printerline     { zdebug("<validline>\n") ; }
		| printeroptline  { zdebug("<validline>\n") ; }
		| mailerline      { zdebug("<validline>\n") ; }
		| maileroptline   { zdebug("<validline>\n") ; }
		| sysopsline	  { zdebug("<validline>\n") ; }

pathline1	:         path eol
		| LEAFTOK path eol
		| name eol { strcpy (ParserPath, ParserName) ; }
			/*The last one is needed for paths like "Other", */
			/*with no slashes.  If it's the only thing on the */
			/*line it must be a leaf. */

pathline	: pathline1
			{   zdebug("<pathline>") ;
			    if(parsetype & PARSEPATH)
			    { zdebug1("\n\tCalling AddPath(CfgTree,\"%s\");\n",
				       ParserPath) ;
			      CfgTree = AddPath(CfgTree,ParserPath) ;
			    }
		        }

path		:    RELPATH { zdebug("<path>") ; }
		| ws RELPATH { zdebug("<path>") ; }
		|    ABSPATH { zdebug("<path>") ; }
		| ws ABSPATH { zdebug("<path>") ; }

pathlist	: path eol
		  {  zdebug("<pathlist>") ;
		     if(parsetype & PARSEMAIL && InMailLine)
		        if (ParserPath[0] == '/') /* Strip leading '/' */
                           AddToStringList(&(ParserPath[1]),&ParserStringList);
                        else AddToStringList(ParserPath, &ParserStringList) ;
		  }
		| path COMMA
		  {  zdebug("<pathlist>") ;
		     if (parsetype & PARSEMAIL && InMailLine) 
		        if (ParserPath[0] == '/') /* Strip leading '/' */
                           AddToStringList(&(ParserPath[1]),&ParserStringList);
                        else AddToStringList(ParserPath, &ParserStringList) ;
		  }
		  pathlist
		| eol  /* An empty pathlist for a mail line. */

mailline1	:         name ws INT {InMailLine=TRUE; } pathlist
		  {  zdebug("<mailline1>") ;
                  }
		| MAILTOK name ws INT {InMailLine=TRUE; } pathlist
		  {  zdebug("mailline1>") ;
                  }


mailline	: mailline1
		  { zdebug("<mailline>") ;
		    if(parsetype & PARSEMAIL)
		    {   zdebug3("\n\tCalling AddMail(CfgMailList,\"%s\",%d,%p)\n",
		                ParserName, ParserDays, ParserStringList) ;
			CfgMailList = AddMail(CfgMailList,ParserName,
					      ParserDays, ParserStringList) ;
			ParserStringList = NULL ;
		    }
                    InMailLine=FALSE;
		  }

name		:    NAME { zdebug("<name>") ; }
		| ws NAME { zdebug("<name>") ; }
		
namelist	: name          
		  {  zdebug("<namelist>") ;
		     if (parsetype & PARSEMISC)
			AddToSysopList(ParserName, &SysopList) ;
		  }
		| namelist name
		  {  zdebug("<namelist>") ;
		     if (parsetype & PARSEMISC)
		     	AddToSysopList(ParserName, &SysopList) ;
		  }

eol		:    EOL { zdebug("<eol>") ; }
		| ws EOL { zdebug("<eol>") ; }

ws		: WS    { zdebug("<ws>") ; }
		| WS ws { zdebug("<ws>") ; }

dbtopline	: DBTOP path eol
		  	{  zdebug("<dbtopline>") ;
			   if(parsetype & PARSEMISC)
			   {  strcpy(PtsRoot, ParserPath) ;
			      if (PtsRoot[strlen(PtsRoot)-1] != '/')
				  strcat(PtsRoot,"/") ;
                              zdebug1("\n\tPtsRoot set to \"%s\"\n", PtsRoot) ;
			   }
			}
		| DBTOP      eol
		  	{  zdebug("<dbtopline(empty)>") ;
			}

printerline	: PRNTOK path eol
		  	{  zdebug("<printerline>") ;
			   if(parsetype & PARSEMISC)
			   {  strcpy(PrinterCmd, ParserPath) ;
                              zdebug1("\n\tPrinterCmd set to \"%s\"\n", 
				      PrinterCmd) ;
			   }
			}
		| PRNTOK      eol
		  	{  zdebug("<printer(empty)>") ;
			}

printeroptline	: PRNOPTOK eol 
		  	{  zdebug("<printeroptline>") ;
			   if(parsetype & PARSEMISC)
			   {  strcpy(PrinterOpts, ParserPath) ;
                              zdebug1("\n\tPrinterOpts set to \"%s\"\n", 
				      PrinterOpts) ;
			   }
			}

mailerline	: MAILERTOK path eol
		  	{  zdebug("<mailerline>") ;
			   if(parsetype & PARSEMISC)
			   {  strcpy(Mailer, ParserPath) ;
                              zdebug1("\n\tMailer set to \"%s\"\n", Mailer) ;
			   }
			}
		| MAILERTOK      eol
		  	{  zdebug("<mailerline(empty)>") ;
			}

maileroptline	: MAILOPTOK eol 
		  	{  zdebug("<maileroptline>") ;
			   if(parsetype & PARSEMISC)
			      if (strlen(ParserPath)) /* not empty string? */
			      {  strcpy(MailerOpts, ParserPath) ;
                                 zdebug1("\n\tMailerOpts set to \"%s\"\n", 
				           MailerOpts) ;
			      }
			}

sysopsline	: SYSOPTOK namelist eol
		  	{  zdebug("<sysopsline>") ;
			}
		| SYSOPTOK eol
		  	{  zdebug("<sysopsline(empty)>") ;
			}

badline		: error EOL
		  {  if (!parse_error) /* No errors found yet */
		        yyerror("parser syntax error") ;
		  }

%%
/* Function defs here. */


/*
______________________________________________________________________
config_tree()

FUNCTION DESCRIPTION:

	Read the problem tree hierarchy.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins            Date:  6/92
______________________________________________________________________
*/


int
config_tree(struct Full_path **pathlist)

     /* Interface description:
         INPUT/OUTPUT:
          pathlist	- Ptr to ptr to head of Full_path linked list.
         RETURN VALUE:
          int		- Zero means success, non-zero means error.
     */

{ 
     /* Internal variables: */
          /* Major */
          /* NONE  */
          /* Minor */
     FILE *fp ;

   /*-------------- Start of config_tree() routine ---------------*/

	/* Open the configuration file for reading. */
   fp = fopen(CONFIGFILE, "r") ;
   if (fp == NULL)
   {   fprintf(stderr, "Error opening config file %s !\n", CONFIGFILE) ;
       return (-1) ;
   }

#  ifdef FLEX
	/* Flex buffers it's yyin, so unpredictable results may occur
	 * if yyin is simply assigned a new value.  The "correct" way
	 * is to use yyrestart().  This probably does not apply if you're
	 * not using GNU's Flex (or older versions of Flex?).
	 * On the other hand, there are cases when, for some reason,
	 * yyrestart() won't work.  In that case try just doing
	 * the normal "yyin = fp".
	 */ 
   yyrestart(fp) ;
#  else
   yyin = fp ;
#  endif /*FLEX*/

	/* Call the parser and have it build the tree. */
   parsetype     = PARSEPATH ;
   parse_error   = 0 ;
   ParserPath[0] = '\0' ;
   ParserName[0] = '\0' ;
   ParserDays    = 0 ;
   zdebug("Beginning config file parse [PATH phase]...\n") ;

   yyparse() ;

   zdebug("\nEnding config file parse [PATH phase]...\n") ;
   *pathlist = CfgTree ;

#ifdef DEBUG
	  zdebug("\n") ;
/*CLD*/   TraverseList(stderr,CfgTree) ;
	  zdebug("\n") ;
#endif

	/* Close the configuration file. */
   fclose(yyin) ;

   return(parse_error) ;

}  /*------------------ End of config_tree() ---------------------*/


/*
______________________________________________________________________
config_mail()

FUNCTION DESCRIPTION:

     Read the list of people to send mail to when problems are old.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  6/92
______________________________________________________________________
*/

int
config_mail(MailInfo **maillist)

     /* Interface description:
         INPUT/OUTPUT:
	  maillist	- ptr to ptr to head of MailInfo linked list.
         RETURN VALUE:
          int           - Zero means success, non-zero means error.
     */

{
     /* Internal variables: */
          /* Major */
          /* NONE  */
          /* Minor */
    FILE *fp ;


   /*----------------- Start of config_mail() routine ------------------*/

   zdebug("Entered config_mail()\n") ;

	/* Open the configuration file for reading. */
   fp = fopen(CONFIGFILE, "r") ;
   if (fp == NULL)
   {   fprintf(stderr, "Error opening config file %s !\n", CONFIGFILE) ;
       return (-1) ;
   }

#  ifdef FLEX
	/* Flex buffers it's yyin, so unpredictable results may occur
	 * if yyin is simply assigned a new value.  The "correct" way
	 * is to use yyrestart().  This probably does not apply if you're
	 * not using GNU's Flex (or older versions of Flex?).
	 */ 
   yyrestart(fp) ;
#  else
   yyin = fp ;
#  endif

	/* Call the parser and have it build the mail list. */
   parsetype     = PARSEMAIL ;
   parse_error   = 0 ;
   ParserPath[0] = '\0' ;
   ParserName[0] = '\0' ;
   ParserDays    = 0 ;
   zdebug("Beginning config file parse [MAIL phase]...\n") ;

   yyparse() ;

   zdebug("\nEnding config file parse [MAIL phase]...\n") ;
   *maillist = CfgMailList ;


	/* Close the configuration file. */
   fclose(yyin) ;

   zdebug1("Leaving config_mail(), list=%p\n",*maillist) ;

   return(parse_error) ;

}  /*--------------------- End of config_mail() ------------------------*/



/*
______________________________________________________________________
config_misc()

FUNCTION DESCRIPTION:

	Read miscellanious information from config file.
(Everything but the tree and the mail list).
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins            Date:  Wed Feb 23 17:45:27 1994
______________________________________________________________________
*/


int
config_misc(void)

     /* Interface description:
         INPUT/OUTPUT:
          None.
         RETURN VALUE:
          int		- Zero means success, non-zero means error.
     */

{ 
     /* Internal variables: */
          /* Major */
          /* NONE  */
          /* Minor */
   FILE *fp ;

   /*-------------- Start of config_misc() routine ---------------*/

	/* Open the configuration file for reading. */
   fp = fopen(CONFIGFILE, "r") ;
   if (fp == NULL)
   {   fprintf(stderr, "Error opening config file %s !\n", CONFIGFILE) ;
       return (-1) ;
   }

#  ifdef FLEX
	/* Flex buffers it's yyin, so unpredictable results may occur
	 * if yyin is simply assigned a new value.  The "correct" way
	 * is to use yyrestart().  This probably does not apply if you're
	 * not using GNU's Flex (or older versions of Flex?).
	 */ 
   yyrestart(fp) ;
#  else
   yyin = fp ;
#  endif

	/* Call the parser and have it build the tree. */
   parsetype     = PARSEMISC ;
   parse_error   = 0 ;
   ParserPath[0] = '\0' ;
   ParserName[0] = '\0' ;
   ParserDays    = 0 ;
   zdebug("Beginning config file parse [MISC phase]...\n") ;

   yyparse() ;

   zdebug("\nEnding config file parse [MISC phase]...\n") ;

	/* Close the configuration file. */
   fclose(yyin) ;

   return(parse_error) ;

}  /*------------------ End of config_misc() ---------------------*/
/* end of config.yacc */

