/*config.c - By Luke Sheneman 1992 and Dean Collins 1994-1995

Modified: Dean Collins Wed Mar 02 18:18:37 1994
  Added AddToStringList(), InStringList() and FreeStringList().
  AddToStringList() should eventually replace AddPath(), since
  they're almost the same.

Modified: Dean Collins Fri Apr 08 18:16:06 1994
  Fixed a problem with using p->next in InStringList().

Modified: Dean Collins Sat Oct 08 20:24:38 1994
  Added another check to make sure that doing a strncmp() with an
  zero-length string returns false in InStringList, as recommended
  by Devin Hooker.  

Modified: Dean Collins Sat Oct 08 21:17:49 1994
  Rewrote AddToStringList() so it wasn't so bizarre.

Modified: Dean Collins Mon Jan  2 17:06:39 PST 1995
  Changed so that DEBUG output goes to stderr.

Modified: Dean Collins Sat Mar  4 20:16:06 PST 1995
  Fixed a stooopid typo (unterminated comment) in AddToStringList() causing
  grief.  Ugh.

Modified: Dean Collins Thu Jun  8 13:31:27 PDT 1995
  Replaced #ifdef DEBUG method of debug output with calls to
  the zdebug macros.



Copyright (c) 1994,1995 Dean Collins
Copyright (c) 1992 Luke Sheneman
Copyright (c) 1992 University of Idaho, Moscow, Idaho.

Permission to use, copy, modify, and distribute this software and its
documentation free of charge for any purpose is hereby granted without
fee, provided that the above copyright notices appear in all copies and
that both those copyright notices and this permission notice appear in
supporting documentation, and that neither the name of the University of
Idaho nor the name of Luke Sheneman be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission from both parties.  Neither The University of Idaho
nor Luke Sheneman make any representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

THE UNIVERSITY OF IDAHO AND LUKE SHENEMAN DISCLAIM ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
*/

#include <stdio.h>
#include "zdbm.h"
#include "cloud.h"
#include "config.h"



/*
______________________________________________________________________
AddPath()

FUNCTION DESCRIPTION:
	This function adds a problem path (aka problem types) to a
linked list of paths.
______________________________________________________________________
REVISION HISTORY:
     Author:  Luke Sheneman 			Date:
     Documentation Enhancement: Dean Collins	Date: 3/27/93
______________________________________________________________________
*/



struct Full_path *AddPath(struct Full_path *head, char *path)

     /* Interface description:
         INPUT:
	  head - head of problem types linked list (NULL if empty)
	  path - path to add to list
         OUTPUT:
          None.
         RETURN VALUE:
          struct Full_path * - head of (possibly new) list.
     */
      
{
     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
          /* NONE */



   /*------------------ Start of AddPath() routine -------------------*/

		/* if head is NULL, allocate memory for a Full_path element,
                 * put path in head->path, and set head->next to be NULL.
                 */
        if(!head)
        {
                head=(struct Full_path *)malloc(sizeof(struct Full_path));
                strcpy(head->path,path);
                head->next=NULL;
		zdebug2("AddPath(): pathA='%s' =? '%s'\n",path,head->path) ;
        }

		/* Otherwise, find the end of the list, allocate memory
		 * for a Full_path element, put path in its path field
		 * set its next field to be NULL, and set the next
		 * field of the last element in the list to be the
		 * new element.
                 */
	else
	{
		struct Full_path *t,*temp;
		
		t=head;
		while(t->next)
			t=t->next;
		temp=(struct Full_path *)malloc(sizeof(struct Full_path));
		strcpy(temp->path,path);
		temp->next=NULL;
		t->next=temp;	
		zdebug2("AddPath(): pathB='%s' =? '%s'\n",path,t->path) ;
	}
	return(head);
}  /*---------------------- End of AddPath() -------------------------*/


/*
______________________________________________________________________
AddMail()

FUNCTION DESCRIPTION:
        This function adds a mail record to a linked list of these
records.
______________________________________________________________________
REVISION HISTORY:
     Author:  Luke Sheneman			Date:
     Documentation Enhancement: Dean Collins	Date: 3/27/93
     Modification: Dean Collins			Date: 3/1/94
	Added pathlist.
______________________________________________________________________
*/



MailInfo *AddMail(MailInfo      *head,
                  char          *useraddr,
                  int            days,
                  StringListRec *pathlist)

     /* Interface description:
         INPUT:
          head	   - The head of the linked list of mail records.
	  useraddr - The user e-mail address to add to the list.
	  days     - The corresponding number of days to add.
	  pathlist - A linked list of problem tree paths.
         OUTPUT:
          None.
         RETURN VALUE:
          MailInfo * - head of (possibly new) list.
     */
      
{
     /* Internal variables: */
          /* Major */

          /* Minor */


   /*----------------- Start of MailInfo() routine ------------------*/

  	zdebug("Entering MailInfo()\n") ;

                /* if head is NULL, allocate memory for a MailInfo element,
                 * put useraddr in head->useraddr, days in head->days,
                 * set head->pathlist to pathlist,
		 * and set head->next to be NULL.
                 */
	if(!head)
        {
                head=(MailInfo *)malloc(sizeof(MailInfo));
		strcpy(head->useraddr,useraddr);
		head->days=days;
		head->pathlist=pathlist; /*Added 3/1/94 DC*/
                head->next=NULL;
        }
                /* Otherwise, find the end of the list, allocate memory
                 * for a MailInfo element, put useraddr in its useraddr field,
                 * days in its days field, set its next field to be NULL,
		 * set it's pathlist to be pathlist,
		 * and set the next field of the last element in the list
		 * to be the new element.
                 */
        else
        {
                MailInfo *t,*temp;

                t=head;
                while(t->next)
                        t=t->next;
                temp=(MailInfo *)malloc(sizeof(MailInfo));
                strcpy(temp->useraddr,useraddr);
		temp->days=days;
		temp->pathlist=pathlist ; /*Added 3/1/94 DC*/
                temp->next=NULL;
		t->next=temp;
        }

  	zdebug("Leaving MailInfo()\n") ;
        return(head);

}  /*--------------------- End of MailInfo() ------------------------*/


/*
______________________________________________________________________
AddToStringList()

FUNCTION DESCRIPTION:
        This function adds a string to a linked list of strings.
This is almost the same as AddPath().
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date: 3/1/94

     Modified: Dean Collins			Date: 10/8/94
	Long-needed rewrite.  Now works like you'd expect.
     Modified: Dean Collins			Date: 3/4/95
	err... except for that typo (unterminated comment)
	which was short-circuiting an if check.  :-P
______________________________________________________________________
*/



int AddToStringList(char           *string,
                    StringListRec **headp)

     /* Interface description:
         INPUT:
	  string 	- The string to add to the list.
          headp 	- Ptr to the ptr to the head of the string list.
			  If not equal to NULL this points to the address
			  that points to the linked list.  It it is NULL
			  it is invalid.
         OUTPUT:
          None.
         RETURN VALUE:
          Status.	- TRUE/FALSE 
     */
      
{
     /* Internal variables: */
          /* Major */

          /* Minor */
     StringListRec *new ;      /* New head of linked list */
     StringListRec *p ;	       /* Temporary pointer into linked list. */
     int StringExists=FALSE ;  /* Flag: TRUE --> string is in list already. */


   /*----------------- Start of AddToStringList() routine ------------------*/

   zdebug1("\nentering AddToStringList() -- string='%s'\n", string) ;
   zdebug2("\theadp=%p, *headp=%p\n",headp, *headp) ;

   if (strlen(string) == 0)
   {
      zdebug1("string not added, length=%d\n", strlen(string)) ;
      zdebug("leaving AddToStringList()\n") ;
      return FALSE ;
   }

   if (headp == NULL)	/* Ptr to address of ptr. to list start. */
   {                    /* If NULL we have nothing to work with. */

      zdebug("string not added, headp=NULL\n") ;
      zdebug("leaving AddToStringList()\n") ;

      return FALSE ;
   }

	/* Create new record */
   new = (StringListRec *)malloc(sizeof(StringListRec)) ;
   strncpy(new->string,string,COMPLETEPATHLEN) ;
   ((new)->string)[COMPLETEPATHLEN-1] = '\0';/* Ensure NULL termination */
   new->next = NULL ;


   if ((*headp) == NULL)  /* Empty list? */
   {  *headp = new ;  /* we're done.*/
   }
   else
   {     /* Search through list for string */
      p = *headp ;
      StringExists = InStringList(string, p, EXACTCMP) ;

      zdebug1("StringExists = %d\n", StringExists) ;

	/* If name not found in list, add it. */
      if (!StringExists)
      {  new->next = *headp ;
         *headp = new ;
      }
      else free (new) ;  /* Don't need the record we created */

   }



#ifdef DEBUG
   zdebug("\tList: ") ;
   p=*headp ;
   do
   {  zdebug1("%s ", p->string) ;
      p = p->next ;
   } while (p != NULL) ;  /*MOD 3/4/95 DC*/

   if (StringExists) zdebug1(" [ignored '%s']\n", string) ;
   else              zdebug("\n") ;

   zdebug("leaving AddToStringList()\n") ;
#endif

   return TRUE ;

}  /*--------------------- End of AddToStringList() ------------------------*/


/*
______________________________________________________________________
InStringList()

FUNCTION DESCRIPTION:
        This function decides if a string is in a linked list of strings.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date: 3/1/94
     Modified: Dean Collins			Date: 4/8/94
	Removed some fluff with p->next. 
     Modified: Dean Collins			Date: 10/8/94
	Added an extra check for a strncmp() string comparison.
______________________________________________________________________
*/



int InStringList(char *string, StringListRec *p, int type)

     /* Interface description:
         INPUT:
	  name 		- The string to look for in the list.
          p 		- The head of the string list.
			  If not equal to NULL this points to the linked list.
	  type		- Type of comparison (PREFIXCMP or EXACTCMP)
			  PREFIXCMP will cause searches to succeed if
			  string is the first part of a string in p.
			  ie: if string is "abc/def" and p->string is 
			  "abc/def/ghi" the search will succeed.
			  EXACTCMP requires that they match exactly.
			  If type is invalid EXACTCMP is assumed.
         OUTPUT:
          None.
         RETURN VALUE:
          Status.	- TRUE/FALSE 
     */
      
{
     /* Internal variables: */
          /* Major */

          /* Minor */
     int StringExists ;	/* Flag: TRUE --> string is in list. */


   /*----------------- Start of InStringList() routine ------------------*/

   zdebug1("\nentering InStringList() -- string='%s'\n", string) ;

   if (strlen(string) == 0)
   {
      zdebug("leaving InStringList() -- string is empty!\n") ;

      return FALSE ; /* No empty strings allowed! */
   }

   StringExists = FALSE ;

   	/* Search through list for string */
   while (p != NULL && !StringExists)
   {    
		/* Found name in list already? */
      if (type == PREFIXCMP)
      {
         zdebug2("PREFIXCMP: %s prefix of %s ?\n", p->string, string) ;
	 
	 if (strlen(p->string) && /*Only do this if there's actually a string.*/
             strncmp(string, p->string, (int)strlen(p->string)) == 0)
            StringExists = TRUE ;
      }
      else /* EXACTCMP or invalid */
      {
         zdebug2("EXACTCMP: %s =? %s\n", p->string, string) ;

         if (strcmp(string, p->string) == 0)
            StringExists = TRUE ;
      }

      p = p->next ;
   }

   zdebug1("leaving InStringList() with %d\n", StringExists) ;

   return (StringExists) ;

}  /*--------------------- End of InStringList() ------------------------*/


/*
______________________________________________________________________
FreeStringList()

FUNCTION DESCRIPTION:
        This function frees up the memory associated with a linked list
of strings.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date: 3/1/94
______________________________________________________________________
*/



int FreeStringList(StringListRec **headp)

     /* Interface description:
         INPUT:
          headp 	- The ptr to the head of the string list.
			  If not equal to NULL this points to the linked list.
         OUTPUT:
          None.
         RETURN VALUE:
          Status.	- TRUE/FALSE  (Success/Failure)
     */
      
{
     /* Internal variables: */
          /* Major */

          /* Minor */
     StringListRec *p, *prev ; /* Temporary pointer */
     int error=0 ;


   /*----------------- Start of FreeStringList() routine ------------------*/

   zdebug("\nentering FreeStringList()\n") ;

   	/* Search through list for string */
   p = *headp ;
   while (p != NULL)
   {  prev = p ;
      p = p->next ;
      free(prev) ;
   }

   *headp = NULL ;

   zdebug1("leaving FreeStringList(), error=%d\n", error) ;

   return (!error) ;

}  /*--------------------- End of FreeStringList() ------------------------*/


/* End of config.c */
