#include <string>
#include <cstdio>
#include <ctype.h>
#include <iostream>
#include <fstream>
#include <sys/stat.h>
#include <sys/types.h>
#include "mxMsgSummary.h"

////////////////////////////////////////////////////////////////////////////////
//
//	Copy Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMsgSummary::mxMsgSummary(const mxMsgSummary& msg)
{
	_author		  = msg._author;
	_organisation = msg._organisation;
	_date		  = msg._date;
	_toAddressee  = msg._toAddressee;
	_ccAddressee  = msg._ccAddressee;
	_bccAddressee = msg._bccAddressee;
	_mailid		  = msg._mailid;
	_messageId	  = msg._messageId;
	_subject	  = msg._subject;
	_actualText   = msg._actualText;
	_status		  = msg._status;
	_position	  = msg._position;
	_length		  = msg._length;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Assignment operator
//
////////////////////////////////////////////////////////////////////////////////
mxMsgSummary&
mxMsgSummary::operator=(const mxMsgSummary& msg)
{
	if (this != &msg)
	{
		_author		  = msg._author;
		_organisation = msg._organisation;
		_date		  = msg._date;
		_toAddressee  = msg._toAddressee;
		_ccAddressee  = msg._ccAddressee;
		_bccAddressee = msg._bccAddressee;
		_mailid		  = msg._mailid;
		_messageId	  = msg._messageId;
		_subject	  = msg._subject;
		_actualText   = msg._actualText;
		_status		  = msg._status;
		_position	  = msg._position;
		_length		  = msg._length;
	}
	return *this;
}
////////////////////////////////////////////////////////////////////////////////
//
//	set Message Headers - from passed message text
//
////////////////////////////////////////////////////////////////////////////////
void
mxMsgSummary::setMessageHeaders(string msg_text)
{
	int	pos1,pos2;
	string	temp;

//	Set length of message since got whole of message passed in

	_length = msg_text.size();

//	Find author ("From: ")

	temp = tagValue(msg_text,"From");
	if (temp.size() > 0)
	{
		// Check for mail-address of the form
		// "name <mailid>" and "mailid (name)"
		pos1 = temp.find("<");
		pos2 = temp.find(">");
		if (pos1 >= 0 && pos2 >= 0 && pos1 < pos2)
		{
			_author.assign(temp,0,pos1-1);
			_mailid.assign(temp,pos1+1,pos2-pos1-1);
		}
		else
		{
			// Not of the form "name <mailid>", so try "mailid (name)"
			pos1 = temp.find("(");
			pos2 = temp.find(")");
			if (pos1 >= 0 && pos2 >= 0 && pos1 < pos2)
			{
				_mailid.assign(temp,0,pos1-1);
				_author.assign(temp,pos1+1,pos2-pos1-1);
			}
			else
			{
				_author = temp;
				_mailid = temp;
			}
		}
	}
	else
	{
		_author.erase();
		_mailid.erase();
	}

//	Find subject ("Subject: ")

	_subject = tagValue(msg_text,"Subject");

//	Find 'to' addressee(s) ("To: ")

	_toAddressee = tagValue(msg_text,"To");
	if (_toAddressee.size() > 0)
	{
		int	pos_comma;
		int	pos=_toAddressee.size()-1;

		// Find commas - remove all spaces and end-of-lines after it
		while ((pos_comma=_toAddressee.rfind(",",pos)) >= 0)
		{
			if (pos_comma+1 < _toAddressee.size())
			{
				while (_toAddressee[pos_comma+1] == '\n' ||
				 	   _toAddressee[pos_comma+1] == ' ')
				   	   _toAddressee.erase(pos_comma+1,1);
			}
			pos = pos_comma-1;
		}
	}
	else
	  _toAddressee.erase();

//	Find 'cc' addressee(s) ("Cc: ")

	_ccAddressee = tagValue(msg_text,"Cc");
	if (_ccAddressee.size() > 0)
	{
		int	pos_comma;
		int	pos=_ccAddressee.size()-1;

		// Find commas - remove all spaces and end-of-lines after it
		while ((pos_comma=_ccAddressee.rfind(",",pos)) >= 0)
		{
			if (pos_comma+1 < _ccAddressee.size())
			{
				while (_ccAddressee[pos_comma+1] == '\n' ||
					   _ccAddressee[pos_comma+1] == ' ')
					   _ccAddressee.erase(pos_comma+1,1);
			}
			pos = pos_comma-1;
		}
	}
	else
	  _ccAddressee.erase();

//	Find 'bcc' addressee(s) ("Bcc: ")

	_bccAddressee = tagValue(msg_text,"Bcc");
	if (_bccAddressee.size() > 0)
	{
		int	pos_comma;
		int	pos=_bccAddressee.size()-1;

		// Find commas - remove all spaces and end-of-lines after it
		while ((pos_comma=_bccAddressee.rfind(",",pos)) >= 0)
		{
			if (pos_comma+1 < _bccAddressee.size())
			{
				while (_bccAddressee[pos_comma+1] == '\n' ||
					   _bccAddressee[pos_comma+1] == ' ')
					   _bccAddressee.erase(pos_comma+1,1);
			}
			pos = pos_comma-1;
		}
	}
	else
	  _bccAddressee.erase();

//	Find date ("Date: ")

	_date = tagValue(msg_text,"Date");

//	Find organisation ("Organization: ")

	_organisation = tagValue(msg_text,"Organization");

//	Find message-id ("Message-Id: " or "Message-ID")

	_messageId = tagValue(msg_text,"Message-Id");
	if (_messageId.size() == 0)
	  _messageId = tagValue(msg_text,"Message-ID");
	pos1 = _messageId.find("<");
	pos2 = _messageId.find(">");
	if (pos1 >= 0 && pos2 >= 0 && pos2 > pos1)
	{
		_messageId.erase(pos2,_messageId.size()-pos2);
		_messageId.erase(0,pos1+1);
	}

//	Find date ("Status: ")

	temp = tagValue(msg_text,"Status");
	if (temp == "RO")
	  _status = true;
	else
	  _status = false;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return a tags value
//	NB. A tag is split into 'Prefix: Value'
//
////////////////////////////////////////////////////////////////////////////////
string
mxMsgSummary::tagValue(string msg,string tag)
{
	string	temp_tag;
	string	tag_string;
	int	tag_start,tag_end;
	int	next_eol;

//	Check if tag exists

	// a). Check if at very start of msg
	temp_tag   = tag + ": ";	// The tag 'prefix'
	tag_start  = msg.find(temp_tag);
	if (tag_start != 0)
	{
		// b). Check if later in message (at start of a line)
		temp_tag   = "\n" + tag + ": ";
		tag_start  = msg.find(temp_tag);
		if (tag_start < 0)
		  return "";
	}

//	Find end of tag (may use several lines !!)

	if ((next_eol=msg.find("\n",tag_start+1)) < 0)
	  return "";
	tag_end = next_eol;

	// If a blank or tab in first character on next line, then continuation
	while (msg[next_eol+1] == ' ' || msg[next_eol+1] == '\t')
	{
		if ((next_eol = msg.find("\n",next_eol+1)) < 0)
		  break;
		tag_end = next_eol;
	}
	tag_string.assign(msg,
			tag_start+temp_tag.size(),
			tag_end-(tag_start+temp_tag.size()));

//	Remove all end-of-lines

	int	eol_pos = 0;
	while ((eol_pos=tag_string.find("\n",eol_pos)) >= 0)
	  tag_string.erase(eol_pos,1);

	return tag_string;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Find start of message body
//
////////////////////////////////////////////////////////////////////////////////
int
mxMsgSummary::bodyStart(string msg)
{
	int	body_start=0;

//	Find first blank line - that is the start of the message body

	body_start = msg.find("\n\n");
	if (body_start < 0)
	  return -1;
	else
	  body_start += 2;

	return body_start;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Find next occurence of specifed tag and return start position
//
////////////////////////////////////////////////////////////////////////////////
int
mxMsgSummary::nextTagStart(string msg,string tag,int pos)
{
	string	temp_tag;
	int	tag_start;

//	Note : Tag must be at start of a line

	// a). Check if at very start of msg (at 'pos') at start of a line
	temp_tag   = tag + ": ";
	tag_start  = msg.find(temp_tag);
	if (tag_start != pos || msg[pos-1] != '\n')
	   {
		// b). Check if later in message (at start of a line)
		temp_tag   = "\n" + tag + ": ";
		tag_start  = msg.find(temp_tag);
		if (tag_start < 0)
		  return -1;
		else
		  return tag_start+1;
	   }
	else
	  return tag_start;
}
