#include <cstdio>
#include <ctype.h>
#include <iostream>
#include <fstream>
#include <pwd.h>
#include <cstdlib>
#include <sys/types.h>

#include "mxMailSpamBook.h"
#include "mxSetup.h"

////////////////////////////////////////////////////////////////////////////////
//
//	Default Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailSpamBook::mxMailSpamBook()
	:_filename("")
{
	string	home;
	if (getenv("HOME"))
	  home = getenv("HOME");
	else
	  home = ".";

	_filename = home + "/.mxMail_SpamList";

	read();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Default Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailSpamBook::mxMailSpamBook(string filename)
	:_filename(filename)
{
	read();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailSpamBook::~mxMailSpamBook()
{
	write();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Assignment operator
//
////////////////////////////////////////////////////////////////////////////////
mxMailSpamBook&	mxMailSpamBook::operator=(const mxMailSpamBook& book)
{
	if (this != &book)
	  {
	   _filename = book._filename;
	   _spammers = book._spammers;
	  }
	return *this;
}
////////////////////////////////////////////////////////////////////////////////
//
//	write - Write spam list back to file
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailSpamBook::write()
{
	ofstream			outfile;
	vector<string>::iterator	iter;

//	Write the addressbook

	outfile.open(_filename.c_str());
	if (outfile)
	  {
	   for (iter=_spammers.begin();iter<_spammers.end();iter++)
	     outfile << (*iter) << endl;
	   outfile.close();
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	read - Read spam list from file
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailSpamBook::read()
{
	ifstream	infile;
	char		line[BUFSIZ];
	string		new_spammer;

//	Delete existing spammers

	while (_spammers.size() > 0)
	  _spammers.pop_back();

//	Open the spam book file for reading

	infile.open(_filename.c_str());
	if (infile)
	   {
	    while (infile.getline(line,BUFSIZ,'\n'))
	       {
		if (strlen(line) > 0)
		   {
		    new_spammer = line;
		    add(new_spammer);
		   }
	       }
	    infile.close();
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	iostream function
//
////////////////////////////////////////////////////////////////////////////////
ostream&	operator<<(ostream& s,mxMailSpamBook& book)
{
	return s <<
		"mxMailSpamBook" << endl <<
		"  Filename:       " << book._filename << endl <<
		"  No of spammers: " << book._spammers.size() << endl;
}
