#include <string>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <cstdio>
#include <ctime>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <X11/Xmu/Editres.h>

#include "akFileDialogMgr.h"
#include "mxMailMsgViewer.h"
#include "mxMailMsgDisplay.h"
#include "mxSetup.h"
#include "mxMailMsgViewerIcon.xpm"
#include "mxButtons.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailMsgViewer::mxMailMsgViewer(char *name,
			   const mxMailMsg& msg,
			   XtCallbackProc callback,
			   XtPointer clientData)
	:akWindow(name),
	 _msg(msg),
	 _display((mxMailMsgDisplay *)0),
	 _closeButton((akButton *)0),
	 _userCB(callback),
	 _userData(clientData)
{
//	Create the panel

	initialize();

	installWMClose();

	setIcon("mxMailMsgViewer",mxMailMsgViewerIcon_xpm);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailMsgViewer::~mxMailMsgViewer()
{
	if (_display)
	  delete _display;
	if (_closeButton)
	  delete _closeButton;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Manage function
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgViewer::manage()
{
	akWindow::manage();

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function	- (re)reads the file and updates the display
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgViewer::update()
{
	string	title;

//	Set display title

	title = "Message from ";
	title += _msg.author() + " '";
	title += _msg.subject() + "'";
	setTitle(title);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Panel creation function
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMailMsgViewer::createWorkArea(Widget parent)
{
	Arg		args[10];
	Widget		form,messagebox;

//	Add editres support

	XtAddEventHandler(parent,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach everything to

	form =
		XtVaCreateManagedWidget("ViewForm",
					xmFormWidgetClass,
					parent,
					NULL);
	
//	Add messagebox to hold buttons

	messagebox =
		XtVaCreateWidget("ButtonBar",
				xmMessageBoxWidgetClass,
				form,
			 	XmNleftAttachment,XmATTACH_FORM,
			 	XmNrightAttachment,XmATTACH_FORM,
			 	XmNbottomAttachment,XmATTACH_FORM,
			 	XmNtopAttachment,XmATTACH_FORM,
				NULL);

//	Set up option buttons

	_closeButton =
	  new akButton(messagebox,"Close",mxClose_xpm,
		       &mxMailMsgViewer::closeCB,(XtPointer)this);
	_closeButton->installHelp("Close the viewer panel");
	_closeButton->manage();
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_MESSAGE_LABEL));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_SYMBOL_LABEL));
	XtManageChild(messagebox);
	XtVaSetValues(messagebox,XmNdefaultButton,_closeButton->baseWidget(),0);

//	Add Message display

	_display =
	  new mxMailMsgDisplay(messagebox,
			       "mxMailMsgDisplay",
			       MX_MSG_DISPLAY,_msg,0);
	_display->manage();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Close Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgViewer::closeCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailMsgViewer	*obj = (mxMailMsgViewer *)clientData;

	obj->busy();
	obj->unmanage();
	obj->ready();

	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,(XtPointer)obj);
}
